<?php
/*
API Specs
*/
require '../app/start_session.php';
header( 'Content-Type: application/json; charset=utf-8' );
$response['status']='EMPTY';
$response['picked']=false;
if (($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET') && isset($_SESSION['user']['consumer']['csm_id'])){
//----------------------------------------------------------------------------------
// Function to clean POST, GET, and REQUEST data
//----------------------------------------------------------------------------------
function _appCleanData( $data ){return htmlspecialchars( stripslashes( trim( $data ) ) );}

//----------------------------------------------------------------------------------
// Function to Process the Post array: $_REQUEST
//----------------------------------------------------------------------------------
function _appProcessRequest( $data , &$errors)
{ 	//init arrays 	
	//Sanitize data request array. 
	$numeric = array();$required=array();$positive=array();
	foreach( $data as $key => $val ) $data[$key] = _appCleanData($val);	
	// array for what is required
	if (isset($data['loaded_id_list'])){
     $numeric = explode(',',$data["loaded_id_list"]);	 
	 $required = array('loaded_id_list'=>$data["loaded_id_list"]);	 
	}	
	
	if (isset($data['ltm_id'], $data['lfv_order'], $data['csm_id'])){
     $numeric = array( 'csm_id'=>$data["csm_id"]
	                 , 'lfv_order'=>$data["lfv_order"]
					 , 'csm_id'=>$data["csm_id"]);
	 $required = array('csm_id'=>$data["csm_id"]
	                 , 'lfv_order'=>$data["lfv_order"]
					 , 'csm_id'=>$data["csm_id"]);
     $positive = array( 'csm_id'=>$data["csm_id"]);					 
	}	
    $errors=array();
	
	foreach( $positive as $key => $val ) {
		if( is_int($val) && $val > 1) 
			array_push( $errors, "$key can only be a positive integer." );
	}
	
	foreach( $numeric as $key => $val ) {
		if( !preg_match( '/^[-+]?\d+$/', $val ) ) 
			array_push( $errors, "$key can only have numeric characters." );
	}
	
	foreach( $required as $key => $val ) {
		if(  $val === '' ) 
			array_push( $errors, "$key is required." );
	}	
	//if no errors in array.
	if( empty( $errors ) ) {		
		$data['success'] = true;	
	}	
	return $data;
 }//end of the _appProcessRequest function
 $request = _appProcessRequest( $_REQUEST , $errors);
 require '../app/function.connect.php';
 if ($request['success']){ 
 function merchant_exists($ltm_id, $dbo) {
  if ($stmt = $dbo->prepare("
	SELECT ltm_id
	FROM lt_merchants
	WHERE ltm_id=:merchid")){     
	 $stmt->bindValue(":merchid", $ltm_id, PDO::PARAM_INT);		 
	 $stmt->execute();	 
     if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){	 
	  return true;
	 }	 
	}
  return false;
 }
 
 function consumer_exists($csm_id, $dbo) {
  if ($stmt = $dbo->prepare("
	SELECT ltm_id FROM tbl_consumer WHERE csm_id=:customerid")){
     $stmt->bindValue(":customerid", $csm_id, PDO::PARAM_INT);		 	 
	 $stmt->execute();	  	 
     if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){
	  return true;
	 }	 
	}
  return true;
 }
  if(isset($request["loaded_id_list"], $request["csm_id"])){
   $response['status']='OK';
   if ($stmt = $dbo->prepare("
	SELECT DISTINCT FAV.lfv_order, MRC.*, MMC.*, CSM.ltm_pick_id
	FROM lt_favorites FAV	
	INNER JOIN lt_merchants MRC ON FAV.ltm_id=MRC.ltm_id	
	INNER JOIN lt_member_merchants MMC ON MRC.ltb_id=MMC.ltb_id		
	INNER JOIN tbl_consumer CSM ON CSM.csm_id=FAV.csm_id		
	WHERE MMC.ltb_active 
	AND MRC.ltm_active	
	AND MRC.ltm_id NOT IN ({$request['loaded_id_list']})
	AND FAV.csm_id=:customerid	
	ORDER BY lfv_order LIMIT 5
	")){//AND CSM.ltm_pick_id <> MRC.ltm_id
     $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		 
	 $stmt->execute();	  
     while ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){
	  foreach ($_result as $Key=>$Value){	   
	   $response[$_result['lfv_order']][$Key]=$Value;
	  }
     }
	}
   
   if ($stmt = $dbo->prepare("
	SELECT DISTINCT PRM.*, PRT.*, MRC.ltm_id, FAV.lfv_order, CSM.ltm_pick_id
	FROM lt_favorites FAV	
	
	INNER JOIN lt_merchants MRC ON FAV.ltm_id=MRC.ltm_id	
	INNER JOIN lt_member_merchants MMC ON MRC.ltb_id=MMC.ltb_id
    INNER JOIN tbl_consumer CSM ON CSM.csm_id=FAV.csm_id	
	
	LEFT JOIN lt_promos PRM ON PRM.ltb_id=MMC.ltb_id
	LEFT JOIN lt_promo_types PRT ON PRM.ltp_promo_type=PRT.lpt_id
	LEFT JOIN lt_merchant_hours MRH ON MRC.ltm_id=MRH.ltm_id
	WHERE MMC.ltb_active 
	AND MRC.ltm_active 
	AND NOW() < PRM.ltp_enddate 
	AND NOW() > PRM.ltp_startdate 	
	AND PRM.ltp_active	
	AND MRC.ltm_id NOT IN ({$request['loaded_id_list']})
	AND FAV.csm_id=:customerid	
	ORDER BY lfv_order LIMIT 5
	")){//AND CSM.ltm_pick_id <> MRC.ltm_id
     $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		 
	 $stmt->execute();	  
     while ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){	
	  foreach ($_result as $Key=>$Value){	   
	   $response[$_result['lfv_order']][$Key]=$Value;
	  }
     }
	}
  } 
 elseif(isset($request["ltm_id"], $request["lfv_order"], $request["csm_id"]) && $request["csm_id"] != 1){
  if (consumer_exists($request['csm_id'], $dbo) && merchant_exists($request['ltm_id'], $dbo)){
   $response['status']='OK';
   $response['favorite']=false; 
   if ($stmt = $dbo->prepare("
	SELECT FAV.lfv_id, FAV.lfv_order, CSM.ltm_pick_id, MRC.ltm_id
	FROM lt_favorites FAV
	INNER JOIN tbl_consumer CSM ON CSM.csm_id=FAV.csm_id
	INNER JOIN lt_merchants MRC ON FAV.ltm_id=MRC.ltm_id
	WHERE CSM.csm_id=:customerid
	AND MRC.ltm_id=:merchid")){ 
     $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		 
	 $stmt->bindValue(":merchid", $request['ltm_id'], PDO::PARAM_INT);		 
	 $stmt->execute();	  
     if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){
	   $change_flag=false;
 	   if($request["lfv_order"]>0){
	   //check if is in the right order
	    if ($_result['lfv_order'] != $request["lfv_order"]) {
         $change_flag=true;		
         $response['favorite']=true;	   
	    //then change order of every favorite of this consumer with order bigger or equal than $request["lfv_order"]
	     if ($stmt = $dbo->prepare("
		  UPDATE lt_favorites SET lfv_order=lfv_order+1
		  WHERE csm_id=:customerid
		  AND lfv_order >= :favorder")){		 
		  $stmt->bindValue(":favorder", $request["lfv_order"], PDO::PARAM_INT);		 
		  $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		  
		  $stmt->execute();	  
	     }
	   
	     if ($stmt = $dbo->prepare("
		  UPDATE lt_favorites SET lfv_order=:favorder
		  WHERE lfv_id=:lfvid")){		 
		  $stmt->bindValue(":lfvid", $_result['lfv_id'], PDO::PARAM_INT);	
          $stmt->bindValue(":favorder", $request["lfv_order"], PDO::PARAM_INT);		 
		  $stmt->execute();	  
	     }	   
	     $_result['lfv_order'] > $request["lfv_order"]?$plus_one="+1":$plus_one="";
	    }
	   }
	 
	  
	   if ($request["lfv_order"]==-1){
	    if ($stmt = $dbo->prepare("
		 DELETE FROM lt_favorites WHERE csm_id=:customerid AND ltm_id=:merchid")){
		 $change_flag=true;
		 $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		 
		 $stmt->bindValue(":merchid", $request['ltm_id'], PDO::PARAM_INT);		 
		 $stmt->execute();
	    }
	   }
	   
	   if($request["lfv_order"] != 0 && $change_flag){
	   //if we are not inserting it at the end of the table
	   //we have to move the list of orders back to fill the position
        if ($stmt = $dbo->prepare("
	     UPDATE lt_favorites SET lfv_order=lfv_order-1
	     WHERE csm_id=:customerid
	     AND lfv_order > :favorder{$plus_one} 
	     ")){		 
	     $stmt->bindValue(":favorder", $_result['lfv_order'], PDO::PARAM_INT);		 
	     $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);	    
	     $stmt->execute();	  
	    }	  	  
	  }
	  else{
	   $response['picked']=true;
	  }
     }
	 else{ //it is not a favorites, we are inserting it 
	  $response['favorite']=true;
	  if ($request["lfv_order"]==0){
	   $New_Order=1;
	   //append merchant to favorites
	   if ($stmt = $dbo->prepare("		 
		 SELECT lfv_order FROM lt_favorites
		 WHERE csm_id=:customerid ORDER BY lfv_order DESC LIMIT 1")){
		 $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		 		 
		 $stmt->execute();	  
		 if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){
		  $New_Order=$_result['lfv_order']+1;
		 }		 
	   }	   
	   if ($stmt = $dbo->prepare("
		INSERT INTO lt_favorites (lfv_order, ltm_id, csm_id) VALUES (:favorder, :merchid, :customerid)")){		 		 
		$stmt->bindValue(":favorder", $New_Order, PDO::PARAM_INT);
		$stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		 
		$stmt->bindValue(":merchid", $request['ltm_id'], PDO::PARAM_INT);		 
		$stmt->execute();	  
	   }
	   if ($stmt = $dbo->prepare("		 
		SELECT CSM.ltm_pick_id, MRC.ltm_id
		FROM lt_favorites FAV
		INNER JOIN tbl_consumer CSM ON CSM.csm_id=FAV.csm_id
		INNER JOIN lt_merchants MRC ON FAV.ltm_id=MRC.ltm_id
		WHERE CSM.csm_id=:customerid
		AND MRC.ltm_id=:merchid LIMIT 1")){
		 $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		 
		 $stmt->bindValue(":merchid", $request['ltm_id'], PDO::PARAM_INT);		 
		 $stmt->execute();	  
		 if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){
		  if ($_result['ltm_pick_id']==$_result['ltm_id']){
		   $response['picked']=true;
		  }
		 }
		}
	  }
      else{	  
	   //make space for the merchant
	   if ($stmt = $dbo->prepare("
		UPDATE lt_favorites SET lfv_order=lfv_order+1
		WHERE csm_id=:customerid
		AND lfv_order >= :favorder")){		 
		 $stmt->bindValue(":favorder", $request["lfv_order"], PDO::PARAM_INT);		 
		 $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT); 
		 $stmt->execute();	  
	   }
	  //add favorite on the order lfv_order
	   if ($stmt = $dbo->prepare("
		INSERT INTO lt_favorites (lfv_order, ltm_id, csm_id) VALUES (:favorder, :merchid, :customerid)")){		 
		 $stmt->bindValue(":favorder", $request["lfv_order"], PDO::PARAM_INT);		 
		 $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		 
		 $stmt->bindValue(":merchid", $request['ltm_id'], PDO::PARAM_INT);		 
		 $stmt->execute();	  
	   }
	  } 
	 }
	}
   }	
  }
  elseif(isset($request["ltm_id"], $request["csm_id"])){
   if ($stmt = $dbo->prepare("
    SELECT CSM.ltm_pick_id, MRC.ltm_id
	FROM lt_favorites FAV
	INNER JOIN tbl_consumer CSM ON CSM.csm_id=FAV.csm_id
	INNER JOIN lt_merchants MRC ON FAV.ltm_id=MRC.ltm_id
	WHERE CSM.csm_id=:customerid
	AND MRC.ltm_id=:merchid LIMIT 1")){
     $stmt->bindValue(":customerid", $request['csm_id'], PDO::PARAM_INT);		 
	 $stmt->bindValue(":merchid", $request['ltm_id'], PDO::PARAM_INT);		 
	 $stmt->execute();	  
	 $response['status']='OK';
     if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){
      if ($_result['ltm_pick_id'] == $_result['ltm_id']){
	   $response['picked']=true;
	  }	 
	  $response['favorite']=true;
	 }
	 else{
	  $response['favorite']=false;
	 }
	}
  } 
 }
 else{
  foreach ($errors as $Key=>$Value){
   $response[$Key]=$Value;
  }
 }
}
echo json_encode($response);