<?php
// api.lt.json.form.mystore.php
//---------------------------------------
// start session, connection
//---------------------------------------
// if( session_id() == '' ) 
	// session_start();
// if( !function_exists( 'connect' ) )
	// require_once 'function.connect.php';
//---------------------------------------
// Set up form elements for myStore
//---------------------------------------
$json = array( 
	'form' => array(
		'company' => array(
			'title' => '<span class="glyphicon glyphicon-flag" aria-hidden="true"></span> Company Information',
			'elements' => array(
				'0' => 'ltm_company_name',
				'1' => 'ltm_contact_name',
				'2' => 'ltm_phone_number',
				'3' => 'ltm_lat',
				'4' => 'ltm_long',
				'5' => 'ltm_address',
				'6' => 'ltm_city',
				'7' => 'ltm_state',
				'8' => 'ltm_zipcode'
			)
		),
		'contact' => array(
			'title' => '<span class="glyphicon glyphicon-user" aria-hidden="true"></span> Contact Info',
			'elements' => array(
				'0' => 'ltb_contact_name',
				'1' => 'ltb_phone_number',
				'2' => 'ltb_web_url'
			)
		),
		'categories' => array(
			'title' => '<span class="glyphicon glyphicon-tags" aria-hidden="true"></span> Category & Keywords',
			'elements' => array(
				'0' => 'cat_id',
				'1' => 'cat_name',
				'2' => 'l2c_id'
			)
		),
		'templates' => array(
			'title' => '<span class="glyphicon glyphicon-picture" aria-hidden="true"></span> Site Template',
			'elements' => array(
				'0' => 'tmp_id',
				'1' => 'tmp_name'
			)
		),
		'links' => array(
			'merchant' => array(
				'markup' => '<label>Merchant Page</label><p>reseller.localthanks.com/merchant_page</p>'
			),
			'merchant_admin' => array(
				'markup' => '<label>Merchant Admin</label><p>secure.localthanks.com/mystore</p>'
			),
			'national_mall' => array(
				'markup' => '<label>National Mall</label><p>reseller.com/merchant_page</p>'
			),
			'national_mall_backoffice' => array(
				'markup' => '<label>National Mall Backoffice</label><p>reseller.com/backoffice</p>'
			)
		),
		'promotion' => array(
			'1' => array(
				'title' => 'Coupon Code',
				'elements' => array(
					'0' => 'ltp_id',
					'1' => 'ltp_image',
					'2' => 'ltp_headline',
					'3' => 'ltp_description',
					'4' => 'ltp_promo_code',
					'5' => 'ltp_startdate',
					'6' => 'ltp_enddate',
					'7' => 'ltp_promo_type'
				)
			),
			'2' => array(
				'title' => 'Sale',
				'elements' => array(
					'0' => 'ltp_id',
					'1' => 'ltp_image',
					'2' => 'ltp_headline',
					'3' => 'ltp_description',
					'4' => 'ltp_startdate',
					'5' => 'ltp_enddate',
					'6' => 'ltp_promo_type'
				)
			),
			'3' => array(
				'title' => 'End of Day - Off Day',
				'elements' => array(
					'0' => 'ltp_id',
					'1' => 'ltp_image',
					'2' => 'ltp_headline',
					'3' => 'ltp_description',
					'4' => 'ltp_time_start',
					'5' => 'ltp_time_end',
					'6' => 'ltp_weekday',
					'7' => 'ltp_startdate',
					'8' => 'ltp_enddate',
					'9' => 'ltp_promo_type'
				)
			),
			'4' => array(
				'title' => 'Clearance',
				'elements' => array(
					'0' => 'ltp_id',
					'1' => 'ltp_image',
					'2' => 'ltp_headline',
					'3' => 'ltp_description',
					'4' => 'auto_enddate',
					'5' => 'ltp_promo_type'
				)
			),
			'5' => array(
				'title' => 'Ad',
				'elements' => array(
					'0' => 'ltp_id',
					'1' => 'ltp_image',
					'2' => 'ltp_headline',
					'3' => 'ltp_description',
					'4' => 'ltp_startdate',
					'5' => 'ltp_enddate',
					'6' => 'ltp_promo_type'
				)
			),
			'6' => array(
				'title' => 'Screcial',
				'elements' => array(
					'0' => 'ltp_id',
					'1' => 'ltp_image',
					'2' => 'ltp_headline',
					'3' => 'ltp_description',
					'4' => 'ltp_startdate',
					'5' => 'ltp_enddate',
					'6' => 'ltp_promo_type'
				)
			)
		),
		'button' => array(
			'remove' => '<button type="button" class="btn btn-sm btn-danger deleteBtn"><span class="glyphicon glyphicon-trash aria-hidden="true"></span></button>',
			'edit' => '<button type="button" class="btn btn-sm btn-primary editBtn"><span class="glyphicon glyphicon-wrench" aria-hidden="true"></span></button>',
			'addpromo' => '<button type="button" class="btn btn-success addPromoBtn"><span class="glyphicon glyphicon-star" aria-hidden="true"></span> Add Promotion</button>',
			'activate' => '<button type="button" class="btn btn-sm btn-success ltp_active"><span class="glyphicon glyphicon-star" aria-hidden="true"></span></button>',
			'deactivate' => '<button type="button" class="btn btn-sm btn-default ltp_active"><span class="glyphicon glyphicon-star-empty" aria-hidden="true"></span></button>',
			'expired' => '<button type="button" class="btn btn-sm btn-danger expired"><span class="glyphicon glyphicon-star-empty" aria-hidden="true"></span></button>',
			'viewpromo' => '<button type="button" class="btn btn-primary viewPromoBtn"><span class="glyphicon glyphicon-th-list" aria-hidden="true"></span> View Promotions</button>',
			'dashboard' => '<button id="dashboardBtn" type="button" class="btn btn-default"><span class="glyphicon glyphicon-dashboard" aria-hidden="true"></span> Dashboard</button>',
			'create' => '<button id="createBtn" type="button" class="btn btn-success"><span class="glyphicon glyphicon-plus" aria-hidden="true"></span> Create New</button>',
			'update' => '<button id="updateBtn" type="button" class="btn btn-success" disabled><span class="glyphicon glyphicon-save" aria-hidden="true"></span> Update</button>',
			'save' => '<button id="saveBtn" type="button" class="btn btn-success" disabled><span class="glyphicon glyphicon-ok" aria-hidden="true"></span> Save</button>',
			'addimage' => '<button id="imgBtn" type="button" class="btn btn-primary" disabled><span class="glyphicon glyphicon-plus" aria-hidden="true"></span> Add Image</button>',
			'submit' => '<button id="submitBtn" type="button" class="btn btn-success" disabled><span class="glyphicon glyphicon-save" aria-hidden="true"></span> Submit</button>',
			'cancel' => '<button id="cancelBtn" type="button" class="btn btn-default"><span class="glyphicon glyphicon-remove" aria-hidden="true"></span> Cancel</button>'
		),
		'tmpl' => array(
			'dashboard' => '<h1><span class="glyphicon glyphicon-dashboard" aria-hidden="true"></span> Dashboard</h1>',
			'promomenu' => '<li><a href="#" id="newpromo"><span class="glyphicon glyphicon-star" aria-hidden="true"></span> New Promotion</a></li>',
			'promolist' => '<h1><span class="glyphicon glyphicon-star" aria-hidden="true"></span> My Promotions</h1><table id="tPromo" class="table table-striped"><thead><tr><th style="width:20px"><span class="glyphicon glyphicon-star"></span></th><th>Promotion Details</th><th style="width:20px"><span class="glyphicon glyphicon-trash aria-hidden="true"></span></th></tr></thead><tbody id="myForm" data-id="promotion"></tbody></table>',
			'activation' => '<div class="modal fade" id="activation" tabindex="-1" role="dialog" aria-labelledby="activationLabel" aria-hidden="true"><form id="myActivation"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><button type="button" style="float:right" class="btn btn-primary" data-dismiss="modal">Save</button><h4 class="modal-title" id="activationLabel"><span class="glyphicon glyphicon-star" aria-hidden="true"></span> Promotion Activation</h4></div><div class="modal-body" id="activationBody"></div><!--<div class="modal-footer"></div>--></div></div></form></div>',
			'selectbtn' => '<span class="input-group-btn"><button class="btn btn-default" type="button" data-select2-open="select-promo"><span class="glyphicon glyphicon-th-list"></span></button></span>',
			'keywords' => '<h3>Keywords</h3><div class="input-group select2-bootstrap-prepend"><span class="input-group-btn"><button class="btn btn-default" type="button" data-select2-open="tbl_m2keywords"><span class="glyphicon glyphicon-tag" aria-hidden="true"></span></button></span><select name="tbl_m2keywords" class="form-control tbl_m2keywords select2" multiple></select><span class="tbl_m2keywords error"></span></div>',
			'newpromo' => '<h1><span class="glyphicon glyphicon-star" aria-hidden="true"></span> New Promotion</h1>'
		),
		'ltp_id' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_id',
				'markup' => '<input name="ltp_id" type="hidden" class="ltp_id" value="">'
			),
			'errors' => array()
		),
		'ltp_headline' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltp_headline">Headline</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_headline',
				'markup' => '<input name="ltp_headline" class="form-control ltp_headline" type="text" placeholder="Add your title!" value=""><span class="ltp_headline error"></span>'
			),
			'errors' => array(
				'alphanum' => 'Alpha-numeric and -@,%$?\'.!/#&+ only.',
				'required' => 'Required field.'
			)
		),
		'ltp_description' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltp_description">Description</label>'
			),
			'html' => array(
				'tag' => 'textarea',
				'classid' => 'ltp_description',
				'markup' => '<textarea name="ltp_description" class="form-control ltp_description" placeholder="Add a description here."></textarea><span class="ltp_description error"></span>'
			),
			'errors' => array(
				'alphanum' => 'Alpha-numeric and -@,%$?\'.!/#&+ only.',
				'required' => 'Required field.'
			)
		),
		'ltp_startdate' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltp_startdate">Start Date</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_startdate',
				'markup' => '<input name="ltp_startdate" class="form-control ltp_startdate dateselect" type="text" placeholder="mm/dd/yyyy" value=""><span class="ltp_startdate error"></span>'
			),
			'errors' => array(
				'date' => 'Invalid date format: mm/dd/yyyy',
				'datetime' => 'Cannot start before end.',
				'required' => 'Required field.'
			)
		),
		'ltp_enddate' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltp_enddate">End Date</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_enddate',
				'markup' => '<input name="ltp_enddate" class="form-control ltp_enddate dateselect" type="text" placeholder="mm/dd/yyyy" value=""><span class="ltp_enddate error"></span>'
			),
			'errors' => array(
				'date' => 'Invalid date format: mm/dd/yyyy',
				'datetime' => 'Cannot start before end.',
				'required' => 'Required field.'
			)
		),
		'ltp_dateadded' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_dateadded',
				'markup' => '<input name="ltp_dateadded" type="hidden" class="ltp_dateadded" value="">'
			),
			'errors' => array()
		),
		'ltp_updated' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_updated',
				'markup' => '<input name="ltp_updated" type="hidden" class="ltp_updated" value="">'
			),
			'errors' => array()
		),
		'ltp_promo_code' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltp_promo_code">Promo Code</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_promo_code',
				'markup' => '<input name="ltp_promo_code" class="form-control ltp_promo_code" type="text" placeholder="coupon123" value=""><span class="ltp_promo_code error"></span>'
			),
			'errors' => array(
				'code' => 'Alpha-numeric only, no spaces.',
				'required' => 'Required field.'
			)
		),
		'ltp_promo_type' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_promo_type',
				'markup' => '<input name="ltp_promo_type" type="hidden" id="ltp_promo_type" value="">'
			),
			'errors' => array()
		),
		'ltp_time_start' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltp_time_start">Time Start</label>'
			),
			'html' => array(
				'tag' => 'select',
				'classid' => 'ltp_time_start',
				'options' => array(
					'callback' => 'time'
				),
				'markup' => '<select name="ltp_time_start" class="form-control ltp_time_start select2"></select><span class="ltp_time_start error"></span>'
			),
			'errors' => array(
			    'time' => 'Cannot start before end.',
				'required' => 'Required field.'
			)
		),
		'ltp_time_end' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltp_time_end">Time End</label>'
			),
			'html' => array(
				'tag' => 'select',
				'classid' => 'ltp_time_end',
				'options' => array(
					'callback' => 'time'
				),
				'markup' => '<select name="ltp_time_end" class="form-control ltp_time_end select2"></select><span class="ltp_time_end error"></span>'
			),
			'errors' => array(
				'time' => 'Cannot start before end.',
				'required' => 'Required field.'
			)
		),
		'ltp_weekday' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltp_weekday">Select Days of the Week</label>'
			),
			'html' => array(
				'tag' => 'select',
				'classid' => 'ltp_weekday',
				'options' => array(
					'callback' => 'day'
				),
				'markup' => '<div class="input-group select2-bootstrap-prepend"><span class="input-group-btn"><button class="btn btn-default" type="button" data-select2-open="ltp_weekday"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></button></span><select name="ltp_weekday" class="form-control ltp_weekday select2" multiple></select><span class="ltp_weekday error"></span></div>'
			),
			'errors' => array(
				'required' => 'Required field.'
			)
		),
		'ltp_active' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltp_active">Active</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_active',
				'markup' => '<input name="ltp_active" class="form-control ltp_active" type="checkbox" value="" disabled>'
			),
			'errors' => array()
		),
		'ltp_image' => array(
			'value' => '',
			'label' => array(),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltp_image',
				'markup' => '<div id="imageFile"></div>'
			),
			'errors' => array()
		),
		'auto_enddate' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'auto_enddate',
				'markup' => '<input name="auto_enddate" type="hidden" id="auto_enddate" value="">Auto Expires: <strong id="auto_enddate_display"></strong>'
			),
			'errors' => array()
		),
		'ltm_id' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_id',
				'markup' => '<input name="ltm_id" type="hidden" class="ltm_id" value="">'
			),
			'errors' => array()
		),
		'ltm_company_name' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_company_name">Merchant Name</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_company_name',
				'markup' => '<input name="ltm_company_name" class="form-control ltm_company_name" type="text" placeholder="Enter your business name." value=""><span class="ltm_company_name error"></span>'
			),
			'errors' => array(
				'alphanum' => 'Alpha-numeric and -@,%$?\'.!/#&+ only.',
				'required' => 'Required field.'
			)
		),
		'ltm_categoryid' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_categoryid">Category</label>'
			),
			'html' => array(
				'tag' => 'select',
				'classid' => 'ltm_categoryid',
				'options' => array(
					'callback' => 'category'
				),
				'markup' => '<select name="ltm_categoryid" class="form-control ltm_categoryid select2"></select><span class="ltm_categoryid error"></span>'
			),
			'errors' => array(
				'required' => 'Required field.'
			)
		),
		'ltm_description' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_description">Description</label>'
			),
			'html' => array(
				'tag' => 'textarea',
				'classid' => 'ltm_description',
				'markup' => '<textarea name="ltm_description" class="form-control ltm_description" placeholder="Add a description here."></textarea><span class="ltm_description error"></span>'
			),
			'errors' => array(
				'alphanum' => 'Alpha-numeric and -@,%$?\'.!/#&+ only.',
				'required' => 'Required field.'
			)
		),
		'ltm_lat' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_lat">Latitude</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_lat',
				'markup' => '<input name="ltm_lat" class="form-control ltm_lat" type="text" placeholder="0.0" value="" disabled><span class="ltm_lat error"></span>'
			),
			'errors' => array(
				'required' => 'Required field.'
			)
		),
		'ltm_long' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_long">Longitude</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_long',
				'markup' => '<input name="ltm_long" class="form-control ltm_long" type="text" placeholder="0.0" value="" disabled><span class="ltm_long error"></span>'
			),
			'errors' => array(
				'required' => 'Required field.'
			)
		),
		'ltm_address' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_address">Address</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_address',
				'markup' => '<input name="ltm_address" class="form-control ltm_address" type="text" placeholder="Line 1" value=""><span class="ltm_address error"></span>'
			),
			'errors' => array(
				'alphanum' => 'Alpha-numeric and -@,%$?\'.!/#&+ only.',
				'required' => 'Required field.'
			)
		),
		'ltm_address2' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_address2" style="display:none">Address 2</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_address2',
				'markup' => '<input name="ltm_address2" class="form-control" type="text" placeholder="Line 2" value="">'
			),
			'errors' => array(
				'alphanum' => 'Alpha-numeric and -@,%$?\'.!/#&+ only.',
			)			
		),
		'ltm_city' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_city">City</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_city',
				'markup' => '<input name="ltm_city" class="form-control ltm_city" type="text" placeholder="City" value=""><span class="ltm_city error"></span>'
			),
			'errors' => array(
				'alphanum' => 'Alpha-numeric and -@,%$?\'.!/#&+ only.',
				'required' => 'Required field.'
			)
		),
		'ltm_state' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_state">State</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_state',
				'options' => array(
					'callback' => 'state'
				),
				'markup' => '<select name="ltm_state" class="form-control ltm_state select2"></select><span class="ltm_state error"></span>'
			),
			'errors' => array(
				'required' => 'Required field.'
			)
		),
		'ltm_zipcode' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_zipcode">Zip</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_zipcode',
				'markup' => '<input name="ltm_zipcode" class="form-control ltm_zipcode" type="text" placeholder="Zip Code" value=""><span class="ltm_zipcode error"></span>'
			),
			'errors' => array(
				'zip' => 'Invalid format.',
				'required' => 'Required field.'
			)
		),
		'ltm_contact_name' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_contact_name">Contact Name</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_contact_name',
				'markup' => '<input name="ltm_contact_name" class="form-control ltm_contact_name" type="text" placeholder="Enter main contact name." value=""><span class="ltm_contact_name error"></span>'
			),
			'errors' => array(
				'alphanum' => 'Alpha-numeric and -@,%$?\'.!/#&+ only.',
				'required' => 'Required field.'
			)
		),
		'ltm_title' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_title">Title</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_title',
				'options' => array(
					'callback' => 'title'
				),
				'markup' => '<select name="ltm_title" class="form-control ltm_title select2"></select>'
			),
			'errors' => array()
		),
		'ltm_gender' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_gender">Gender</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_gender',
				'options' => array(
					'callback' => 'gender'
				),
				'markup' => '<select name="ltm_gender" class="form-control ltm_gender select2"></select><span class="ltm_gender error"></span>'
			),
			'errors' => array()
		),
		'ltm_phone_number' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_phone_number">Phone Number</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_phone_number',
				'markup' => '<input name="ltm_phone_number" class="form-control ltm_phone_number" type="text" placeholder="1-800-555-5555" value=""><span class="ltm_phone_number error"></span>'
			),
			'errors' => array(
				'phone' => 'Invalid format.',
				'required' => 'Required field.'
			)
		),
		'ltm_fax_number' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltm_fax_number">Fax Number</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltm_fax_number',
				'markup' => '<input name="ltm_fax_number" class="form-control ltm_fax_number" type="text" placeholder="1-800-555-5555" value=""><span class="ltm_fax_number error"></span>'
			),
			'errors' => array(
				'phone' => 'Invalid format.',
				'required' => 'Required field.'
			)
		),
		'ltb_web_url' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltb_web_url">Website</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltb_web_url',
				'markup' => '<input name="ltb_web_url" class="form-control ltb_web_url" type="text" placeholder="www.yourwebsite.com" value=""><span class="ltb_web_url error"></span>'
			),
			'errors' => array(
				'url' => 'Invalid format.'
			)
		),
		'ltb_id' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltb_id',
				'markup' => '<input name="ltb_id" type="hidden" value="">'
			),
			'errors' => array()
		),
		'ltb_email' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltb_email">Email Address</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltb_email',
				'markup' => '<input name="ltb_email" class="form-control ltb_email" type="text" placeholder="your@email.com" value=""><span class="ltb_email error"></span>'
			),
			'errors' => array(
				'email' => 'Please enter a valid email address.',
				'required' => 'Required field.'
			)
		),
		'ltb_password' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltb_password">Password</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltb_password',
				'markup' => '<input name="ltb_password" class="form-control ltb_password" type="text" placeholder="Add password." value=""><span class="ltb_password error"></span>'
			),
			'errors' => array(
				'password' => 'Please enter a valid password.',
				'required' => 'Required field.',
				'confirm' => 'Passwords do not match.'
			)
		),
		'ltb_password_confirm' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltb_password_confirm">Confirm Password</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltb_password_confirm',
				'markup' => '<input name="ltb_password_confirm" class="form-control ltb_password_confirm" type="text" placeholder="Confirm password." value=""><span class="ltb_password_confirm error"></span>'
			),
			'errors' => array(
				'confirm' => 'Passwords do not match.'
			)
		),
		'ltb_contact_name' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltb_contact_name">Contact Name</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltb_contact_name',
				'markup' => '<input name="ltb_contact_name" class="form-control ltb_contact_name" type="text" placeholder="Enter main contact name." value=""><span class="ltb_contact_name error"></span>'
			),
			'errors' => array(
				'alphanum' => 'Alpha-numeric and -@,%$?\'.!/#&+ only.',
				'required' => 'Required field.'
			)
		),
		'ltb_phone_number' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="ltb_phone_number">Phone Number</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'ltb_phone_number',
				'markup' => '<input name="ltb_phone_number" class="form-control ltb_phone_number" type="text" placeholder="1-800-555-5555" value=""><span class="ltb_phone_number error"></span>'
			),
			'errors' => array(
				'phone' => 'Invalid format.',
				'required' => 'Required field.'
			)
		),
		'cat_id' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'cat_id',
				'markup' => '<input name="cat_id" type="hidden" value="">'
			),
			'errors' => array()
		),
		'cat_parent_id' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'cat_parent_id',
				'markup' => '<input name="cat_parent_id" type="hidden" value="">'
			),
			'errors' => array()
		),
		'cat_slug' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'cat_slug',
				'markup' => '<input name="cat_slug" type="hidden" value="">'
			),
			'errors' => array()
		),
		'cat_name' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="cat_name">Category Name</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'cat_name',
				'options' => array(
					'callback' => 'categories'
				),
				'markup' => '<div class="input-group select2-bootstrap-prepend"><span class="input-group-btn"><button class="btn btn-default" type="button" data-select2-open="cat_name"><span class="glyphicon glyphicon-tags" aria-hidden="true"></span></button></span><select name="cat_name" class="form-control cat_name select2" multiple></select><span class="cat_name error"></span></div>'
			),
			'errors' => array(
				'required' => 'Required field.'
			)
		),
		'l2c_id' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'l2c_id',
				'markup' => '<input name="l2c_id" type="hidden" value="">'
			),
			'errors' => array()
		),
		'tmp_id' => array(
			'value' => '',
			'html' => array(
				'tag' => 'input',
				'classid' => 'tmp_id',
				'markup' => '<input name="tmp_id" type="hidden" value="">'
			),
			'errors' => array()
		),
		'tmp_name' => array(
			'value' => '',
			'label' => array(
				'markup' => '<label for="tmp_name">Template Name</label>'
			),
			'html' => array(
				'tag' => 'input',
				'classid' => 'tmp_name',
				'options' => array(
					'callback' => 'templates'
				),
				'markup' => '<select name="tmp_name" class="form-control tmp_name select2"></select><span class="tmp_name error"></span>'
			),
			'errors' => array(
				'required' => 'Required field.'
			)
		)
	)
);
//---------------------------------------
// set header and echo json
//---------------------------------------
header( 'Content-Type: application/json; charset=utf-8' );
echo json_encode( $json );

/* EOF ?> */