<?php
// api.lt.promos.php
//---------------------------------------
// start session, connection
//---------------------------------------
	require '../app/start_session.php';
	$json=array();
	if (isset($_SESSION["user"]["merchant"]["ltb_id"]) || isset($_SESSION["user"]["consumer"]["csm_id"])){
		require '../app/function.connect.php';

		$p = array(); // init params array
		$n = array( 'notify'=> 'Nothing Found.' );
		//---------------------------------------
		// Function to return promos
		// accepts: sql, params, and notify/null.
		// Runs the query and returns results.
		//---------------------------------------
		function promos( $s, $p, $n )
		{
			$d = connect();
			$q = $d->prepare( $s );
			foreach( $p as $k => $v ) $q->bindValue( $k, $v, PDO::PARAM_STR );
			$q->execute();
			$j = $q->fetchAll( PDO::FETCH_ASSOC );
			if( empty( $j ) ) {
				$j = $n;
			}
			else {
				foreach( $j as $k => $v ) {
					if( $v['ltp_image'] == null ) $j[$k]['ltp_image'] = '';
					$j[$k]['ltp_startdate'] = _appDate( $v['ltp_startdate'] );
					$j[$k]['ltp_enddate']   = _appDate( $v['ltp_enddate'] );
					$j[$k]['ltp_dateadded'] = _appDate( $v['ltp_dateadded'] );
					$j[$k]['ltp_updated']   = _appDate( $v['ltp_updated'] );
				}
			}
			return $j;
		}

		//---------------------------------------
		// Function to format date
		//---------------------------------------
		function _appDate( $d, $l=null ) 
		{
			$n = new DateTime( $d );
			if( $l ) $d = $n->format( 'Y-m-d h:i:s' );
			else	 $d = $n->format( 'm/d/Y' );
			
			if( strpos( $d, '-000' ) ) $d = '00/00/0000';
			
			return $d;
		}

		//---------------------------------------
		// Ajax Form CRUD
		//---------------------------------------
		if( isset( $_SESSION['user']['merchant'],
				   $_REQUEST['ltm_id'], 
				   $_REQUEST['list'],
				   $_REQUEST['ltb_id'] ) ) 
		{
			//-----------------------------------
			// Server side promo check
			// Use vars as a reference
			//-----------------------------------
			// $x = connect();
			// $y = $x->prepare( "SELECT COUNT(LTP.ltp_id), LMP.lmp_max_drafts, LMP.lmp_max_plans
							   // FROM  `lt_merchant_plans` AS LMP
							   // INNER JOIN `lt_member_merchants` AS LMM ON LMP.lmp_id=LMM.lmp_id
							   // INNER JOIN `lt_promos` AS LTP ON LMM.ltb_id=LTP.ltb_id
							   // WHERE LMM.ltb_id=:id 
							   // GROUP BY LMP.lmp_max_drafts" );							   
			// $y->bindValue( ':id', $_REQUEST['ltb_id'], PDO::PARAM_STR );
			// $y->execute();
			// $z = $y->fetchAll( PDO::FETCH_ASSOC );
			// $promo_count    = $z[0]['COUNT(LTP.ltp_id)'];
			// $lmp_max_drafts = $z[0]['lmp_max_drafts'];
			// $lmp_max_promos = $z[0]['lmp_max_promos'];


			//-----------------------------------
			// Delete Promo
			//-----------------------------------

			if( $_REQUEST['list'] == "delete" ) {
				$p[':ltp_id'] = $_POST['ltp_id'];
				$s = "DELETE FROM `lt_promos` WHERE ltp_id=:ltp_id";		
				$_SESSION['user']['merchant']['promo_count'] = $_SESSION['user']['merchant']['promo_count'] - 1;
			}
			
			//-----------------------------------
			// Activation Switch
			//-----------------------------------
			elseif( $_REQUEST['list'] == "active" ){
				$p[':ltp_id']     = $_POST['ltp_id'];
				$p[':ltp_active'] = (int) $_POST['ltp_active'];
				$s = "UPDATE `lt_promos` SET ltp_active=:ltp_active WHERE ltp_id=:ltp_id";
			}
			else {
				//-------------------------------
				// Set Vars
				//-------------------------------
				$a = $w = array();
				$t = date( 'Y-m-d h:i:s' );
				$p = array( ':ltb_id' => $_REQUEST['ltb_id'] );
				
				//-------------------------------
				// Clean, Sanitize, and sort
				//-------------------------------
				foreach( $_REQUEST['list'] as $k => $v ){
					$v['value'] = htmlspecialchars( stripslashes( trim( $v['value'] ) ) );
					if( $v['name'] == 'ltp_weekday' )
						array_push( $w, $v['value'] );
					else if( $v['name'] == 'ltp_time_end' || $v['name'] == 'ltp_time_end' )
						$a[ $v['name'] ] = str_replace( 't', '', wordwrap( $v['value'], 3, ':', true ) ) . ':00';
					else
						$a[ $v['name'] ] = $v['value'];
				}
				if( !empty( $w ) ) $a['ltp_weekday'] = implode( '', $w );
				if( isset( $a['auto_enddate'] ) ) {
					$a['ltp_startdate'] = $t;
					$a['ltp_enddate'] = $a['auto_enddate'];
					unset( $a['auto_enddate'] );
				}
				
				//-------------------------------
				// empty ltp_id: new or update
				//-------------------------------
				if( $_REQUEST['list'][0]['name'] == 'ltp_id' && $_REQUEST['list'][0]['value'] == '' ) {
					// add new promo
					$a['ltp_dateadded'] = $t;		
					unset( $a['ltp_id'] );		
					$field = "ltb_id,";
					$value = ":ltb_id,";		
					foreach( $a as $k => $v ) {
						if( $k == 'ltp_startdate'  || $k == 'ltp_enddate' )  $v = _appDate( $v, true );
						if( $k == 'ltp_time_start' || $k == 'ltp_time_end' ) $v = str_replace( 't', '', wordwrap( $v, 3, ':', true ) );
						$field.= "{$k},";
						$value.= ":{$k},";
						$p[":{$k}"] = $v;
					}
					$field = rtrim( $field, ',' );
					$value = rtrim( $value, ',' );		
					$s = "INSERT INTO `lt_promos`({$field}) VALUES ({$value})";
					$_SESSION['user']['merchant']['promo_count'] = $_SESSION['user']['merchant']['promo_count'] + 1;
				}
				else {
					// update promo
					$a['ltp_updated'] = $t;
					$value = "ltb_id=:ltb_id,";		
					foreach( $a as $k => $v ) {
						if( $k == 'ltp_startdate'  || $k == 'ltp_enddate' )  $v = _appDate( $v, true );
						if( $k == 'ltp_time_start' || $k == 'ltp_time_end' ) $v = str_replace( 't', '', wordwrap( $v, 3, ':', true ) );
						$value.= "{$k}=:{$k},";
						$p[":{$k}"] = $v;
					}
					$value = rtrim( $value, ',' );
					$s = "UPDATE `lt_promos` SET {$value} WHERE ltp_id=:ltp_id";
				}
			}

			$d = connect();
			$q = $d->prepare( $s );
			foreach( $p as $k => $v ){
			 if ($v == 1 or $v == 0){
			  $q->bindValue($k, $v, PDO::PARAM_INT );
			 }
			 else{$q->bindValue( $k, $v, PDO::PARAM_STR );}
			}
			$q->execute();
			
			if( $field ) $id = $d->lastInsertId();
			else $id = $p[":ltp_id"];
			
			echo json_encode( str_replace( '"', '', $id ) );
			return;

		}

		//---------------------------------------
		// All Deals by Merchant ID(s)
		// Comma separated list. 
		//---------------------------------------
		elseif( isset( $_REQUEST['ltb_id'] ) ) 
		{
			//-----------------------------------
			// Format Merchant ID list
			//-----------------------------------
			$l = explode( ',', $_REQUEST['ltb_id'] );
			foreach( $l as $k => $v ) if( !is_numeric( $v ) ) unset( $l[ $k ] );
			if( empty( $l ) )
				$l = 0;
			else
				$l = implode( ',', $l );

			//-----------------------------------
			// Update activations
			//-----------------------------------
			$d = connect();
			$q = $d->prepare( "UPDATE `lt_promos` SET ltp_active=0,ltp_updated=NOW() WHERE ltb_id IN ({$l}) AND ((ltp_enddate < NOW() OR NOW() < ltp_startdate) AND NOT (ltp_startdate IS NULL AND ltp_enddate IS NULL)) AND ltp_active!=0" );
			$q->execute();	
			
			/*
			  $u = $q->fetchAll( PDO::FETCH_ASSOC );
			  if( !empty( $u ) ) {
				$u = implode( ',', array_map( function ( $k ) {  return $k['ltp_id']; }, $u ) );
				$q = $d->prepare( "UPDATE `lt_promos` SET ltp_active=0,ltp_updated=now() WHERE ltp_id IN ({$u})" );
				$q->execute();
			}
			*/	
			$and = ' AND ltp_active AND ((NOW() > ltp_startdate AND NOW() < ltp_enddate) OR (ltp_startdate IS NULL AND ltp_enddate IS NULL))';
			if( isset( $_REQUEST['list'] ) ) $and = '';
			//-----------------------------------
			// Send Promo List
			//-----------------------------------
			$json = promos( "
			 SELECT DISTINCT PRM.*, CROSS_PROM.*
			 FROM lt_promos PRM 
			 LEFT JOIN (
			    SELECT DISTINCT CPR.ltp_id AS cross_ltp_id, LTB.ltb_id AS cross_ltb_id, LTB.ltb_header_image
				FROM lt_merchants LTM 
				INNER JOIN lt_member_merchants LTB ON LTM.ltb_id = LTB.ltb_id 
				INNER JOIN lt_cross_promotions CPR ON LTM.ltm_id = CPR.ltm_id 				
			 ) CROSS_PROM ON CROSS_PROM.cross_ltp_id = PRM.ltp_id
			 WHERE PRM.ltb_id IN ({$l}){$and}", $p, $n );
		}

		//---------------------------------------
		// Individual Deals by ID
		//---------------------------------------
		elseif( isset( $_REQUEST['ltp_id'] ) ) 
		{
			$p[':id'] = $_REQUEST['ltp_id'];
			$json = promos( 'SELECT * FROM `lt_promos` WHERE ltp_id=:id', $p, $n );
		}

		//---------------------------------------
		// Show all records
		//---------------------------------------
		else 
		{ 
			$json = promos( 'SELECT * FROM `lt_promos`', $p, $n );
		}
	}
//---------------------------------------
// Echo Json File
//---------------------------------------
header( 'Content-Type: application/json; charset=utf-8' );
echo json_encode( $json );

/* EOF ?>  */