<?php

/*

API Specs



******Search around current position request******

It could be either $_POST or $_GET



Where 

(Required for the search around current position)

$_POST['longitude'] or $_GET['longitude'] is a double value, current location longitude

$_POST['latitude'] or $_GET['latitude'] is a double value, current location latitude



(optional for the search around current position)

$_POST['amount'] or $_GET['amount'] is an integer between 1 and 100, if not set or is out of that range 1 will be the default value

and is the amount of merchants around the current location (the latitude and longitude set above)



******Search around current position response******

Array with the following format



___ARRAY STATUS___

$response['status']='OK'; The search took place and the response array is built

$response['status']='EMPTY'; For some reason the search didn't took place and the response array is not built



___LIST OF FOUND MERCHANTS ON (lt_merchants) WITH PLATINUM MEMBERSHIP___

FIRST MEERCHANT FOUND 



$response['id'][0] = 1212; id of the first merchant (integer)

$response['merchant'][0] = false; the merchant has not deals (string)

$response['longitude'][0]; longitude of the first merchant (double)

$response['latitude'][0]; latitude of the first merchant (double)



SECOND MEERCHANT FOUND 

 

$response['id'][1] = 1222; id of the second merchant (integer)

$response['merchant'][1]; the merchant company name (string)

$response['longitude'][1]; longitude of the second merchant (double)

$response['latitude'][1]; latitude of the second merchant (double)



and so on...



******Sign up request******

It could be either $_POST or $_GET



(Required for Sign up process)

$_POST['f_name'] or $_GET['f_name']; First name of the consumer that is signing in

$_POST['f_name'] or $_GET['l_name']; Last name of the consumer that is signing in

$_POST['email'] or $_GET['email']; email of the consumer that is signing in

$_POST['password'] or $_GET['password']; password of the consumer that is signing in

$_POST['re_password'] or $_GET['re_password']; retyped password of the consumer that is signing in

$_POST['su_merchant_id'] or $_GET['su_merchant_id']; Id of the merchant under consumer that is signing in

$_POST['cell_phone'] or $_GET['cell_phone']; cell phone number of the consumer that is signing in

$_POST['zip_code'] or $_GET['zip_code']; ZIP code number of the consumer that is signing in

$_POST['csm_lat'] or $_GET['csm_lat']; Latitude of the consumer that is signing in

$_POST['csm_long'] or $_GET['csm_long']; Longitude of the consumer that is signing in





******Sign up response******

Array with the following format



___ARRAY STATUS___

$response['status']='OK'; The sign up took place
$response['status']='EMPTY'; For some reason the sign up didn't took place and the corresponded message is set on $response['notify']
$response['notify']; html message, if $response['status'] is 'EMPTY' otherwise is not set
*/
require '../app/start_session.php';
require '../app/global.php';
function email_exists ($an_Email, $an_Id){
	global $dbo;	
	
	$stmt = $dbo->prepare("SELECT csm_id FROM tbl_consumer WHERE csm_email=:email AND csm_email NOT IN (SELECT csm_email FROM tbl_consumer WHERE csm_id=:id)");    

	$stmt->bindValue(":email", $an_Email, PDO::PARAM_STR);
	
	$stmt->bindValue(":id", $an_Id, PDO::PARAM_INT);

	$stmt->execute();
	
	return $_result = $stmt->fetch( PDO::FETCH_ASSOC );	
}

function _appProcessRequest( $data, &$errors ){
	$errors=array();$clean=array();$checkFlag=false;
	$cv= new _variables(); // new instance
	if (isset(
	   $data['wnu_zip_code_r']
	 , $data['wnu_csm_id_r']
	 , $data['nam64_Last_Name_r']
	 , $data['nam64_First_Name_r']
	 , $data['dec_csm_long_r']
	 , $data['dec_csm_lat_r']
	 , $data['pho_Cell_Phone_Number_r'])){
		$cv_array=array('pho_Cell_Phone_Number_r', 'dec_csm_lat_r', 'dec_csm_long_r', 'nam64_First_Name_r', 'nam64_Last_Name_r', 'wnu_csm_id_r', 'wnu_zip_code_r'); //list all varibles to be check in
		$checkFlag=true;
	 }
	 elseif (isset($data['ema_email_r'], $data['psw32_match_password_r'], $data['wnu_csm_id_r'])){
		$cv_array=array('ema_email_r', 'psw32_match_password_r','wnu_csm_id_r'); //list all varibles to be check in
		$checkFlag=true;
	 }
	 else{
	  array_push( $errors, "Some data in the form are missing" );
	 }
     if ($checkFlag) {
		 foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
		 $clean=$cv->get_cleaned_variables();
		 $errors=$cv->get_bad_variables();
	 }
	// if no errors in array.
	if( empty( $errors ) ) {	
		$clean['success'] = true;
	}
	else {
		$clean['success']=false;
		$clean['notify']='<div class="alert alert-danger alert-error" role="alert"><a href="#" class="close" data-dismiss="alert">&times;</a><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span><span class="sr-only">Error:</span> A problem has been occurred while submitting your data.<ol>';
		foreach( $errors as $val ) $clean['notify'].= "<li>$val</li>"; 
		$clean['notify'].= '</ol></div>';
	}
	return $clean;
 }//end of the _appProcessRequest function 
header( 'Content-Type: application/json; charset=utf-8' );
$response['status']='EMPTY';
require_once '../app/api_keys.php';
if (($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET') && (isset($_SESSION["user"]["consumer"]["csm_id"]) || (isset($_SESSION["api_key"]) && $_SESSION["api_key"]==$API_Keys['localthanks']))){ 
 //if is set latitude and longitude
 require_once '../app/function.connect.php';
 require_once '../app/class.variables.php';
 $request = _appProcessRequest( $_REQUEST, $errors ); 
 if (isset($_REQUEST['latitude'], $_REQUEST['longitude'])
  && preg_match("/[+-]?\\d*\\.?\\d+/", $_REQUEST['longitude'])
  && preg_match("/[+-]?\\d*\\.?\\d+/", $_REQUEST['latitude'])
 ){
  $_amount=1; $_radius=1; $_inner_join=$_keyword_WHERE=''; $_latitude = $_REQUEST['latitude']; $_longitude = $_REQUEST['longitude']; $_keyword='';
  if (isset($_REQUEST['keyword']))
   $_keyword=trim(preg_replace('/\s+/', ' ', $_REQUEST["keyword"]));
  if (!empty($_keyword)) {   
	$search_Array = array_unique(explode(' ',trim(preg_replace('/\s+/', ' ', $_REQUEST["keyword"]))));
    $_keyword = implode(' ',$search_Array);

	if ($stmt = $dbo->prepare("SELECT key_id FROM tbl_keywords WHERE key_word LIKE :output AND key_type='active' LIMIT 1")){
	  $stmt->bindValue(":output", $_keyword, PDO::PARAM_STR);
	  $stmt->execute();
	  if (!($_result = $stmt->fetch( PDO::FETCH_ASSOC ))){
	   //the keyword is not in the dictionary lets try to find in the geo tables
	    if ($stmt = $dbo->prepare("
		 SELECT ZIP.gz_lon, ZIP.gz_lat, STE.gs_abbr, CTY.gcty_city
		 FROM geo_zip ZIP 
		 INNER JOIN geo_city CTY ON CTY.gcty_id=ZIP.gcty_id
		 INNER JOIN geo_state STE ON STE.gs_id=CTY.gs_id
		 INNER JOIN geo_country CNY ON CNY.gc_id=STE.gc_id		 
		 WHERE
		  CTY.gcty_city LIKE :keyword
		  OR ZIP.gz_zip LIKE :keyword 
		  OR STE.gs_state LIKE :keyword 
		  OR CNY.gc_country LIKE :keyword 
		  OR CNY.gc_abr LIKE :keyword 
		  OR STE.gs_abbr LIKE :keyword
		  OR CONCAT(CTY.gcty_city, ', ', STE.gs_abbr) LIKE :keyword
		  OR CONCAT(CTY.gcty_city, ', ', STE.gs_abbr, ', ', CNY.gc_abr) LIKE :keyword
		 LIMIT 1")){
         $stmt->bindValue(":keyword", $_keyword, PDO::PARAM_STR); 		
	     $stmt->execute();
		 if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){
		  
		  $_longitude=$_result["gz_lon"];
		  $_latitude=$_result["gz_lat"];

		  $_keyword='';unset($search_Array);
		 }
		}
	  }
	  else{
		  $_inner_join.="
			 LEFT JOIN tbl_m2keyword M2K ON M2K.ltb_id=MMR.ltb_id
			 LEFT JOIN tbl_keywords KYW ON KYW.key_id=M2K.key_id
			";
		  //the keyword on active in the keyword table
		  $_keyword_WHERE='(';
		  
		  $_OR='';
		  
		  foreach ($search_Array as $_key => $_value){
			  
			$_keyword_WHERE.="{$_OR}KYW.key_word LIKE :word{$_key} OR MRC.ltm_company_name LIKE :word{$_key}";$_OR=' OR ';
			
		  }	
		  $_keyword_WHERE.=') AND ';
		  
	  }
    }
    
  }
  
  if (isset($_REQUEST['amount'])

   && preg_match("/^[0-9]+$/", $_REQUEST['amount'])   

  ){if ($_REQUEST['amount']&&$_REQUEST['amount']>0 && $_REQUEST['amount']<=99) $_amount=$_REQUEST['amount'];}
  
  if (isset($_REQUEST['radius'])   
  
   && preg_match("/^[0-9]+$/", $_REQUEST['radius'])

  ){if ($_REQUEST['radius']&&$_REQUEST['radius']>0 && $_REQUEST['radius']<=30) $_radius=$_REQUEST['radius'];}
  
  if ( NEW_DB_SWITCH ) {
	  $_inner_join .= "
		INNER JOIN tbl_package PACK ON MMR.pk_id = PACK.pk_id
		INNER JOIN tbl_product PROD ON PACK.pk_id = PROD.prod_id
	  ";
	  $sqlWh = '';
  }
  else {
	$_inner_join .= "
		INNER JOIN lt_plan_type AS PTY ON MMR.pty_id=PTY.pty_id
		INNER JOIN lt_merchant_plans AS PTM ON PTM.pty_id=PTY.pty_id
	";
	$sqlWh = 'PTY.pty_id > 1 AND';
  } 
  if ($stmt = $dbo->prepare("
   SELECT DISTINCT MRC.ltm_lat, MRC.ltm_long, MRC.ltm_id, MRC.ltm_company_name 
   FROM lt_merchants AS MRC 
   INNER JOIN lt_member_merchants AS MMR ON MMR.ltb_id=MRC.ltb_id
   {$_inner_join}
   WHERE {$_keyword_WHERE}{$sqlWh} MMR.ltb_active AND (  3959 * acos( cos( radians(:customerlat) ) * cos( radians( MRC.ltm_lat ) ) * cos( radians( MRC.ltm_long ) - radians(:customerlong) ) + sin( radians(:customerlat) ) * sin(radians(MRC.ltm_lat)) ) )  < :radius

   ORDER BY POW(POW((:customerlat-MRC.ltm_lat),2)+(POW((:customerlong-MRC.ltm_long),2)),(1/2)) LIMIT ".$_amount)){

	$stmt->bindValue(":customerlat", $_latitude, PDO::PARAM_STR);	

	$stmt->bindValue(":customerlong", $_longitude, PDO::PARAM_STR);	
	
	$stmt->bindValue(":radius", $_radius, PDO::PARAM_INT);

	if (isset($search_Array)) 
		
		foreach ($search_Array as $_key => $_value)
		
			$stmt->bindValue(':word'.$_key, '%'.$_value.'%', PDO::PARAM_STR);

    $stmt->execute();	

  }

  $_i=0;

  while ($_result = $stmt->fetch(PDO::FETCH_OBJ)){

   $response['status']='OK';

   $response['id'][$_i]=$_result->ltm_id;

   $response['merchant'][$_i]=$_result->ltm_company_name;

   $response['longitude'][$_i]=$_result->ltm_long;

   $response['latitude'][$_i++]=$_result->ltm_lat;

  }

 }

 elseif (isset($_REQUEST['csm_id'],$_REQUEST['ltm_id']) 

  && preg_match("/^[0-9]+$/", $_REQUEST['ltm_id'])

  && preg_match("/^[0-9]+$/", $_REQUEST['csm_id']) && $_REQUEST['csm_id'] > 1){

  if ($stmt = $dbo->prepare("UPDATE tbl_consumer SET ltm_pick_id=:merchantpickid WHERE csm_id=:csmid")){    

   $stmt->bindValue(":merchantpickid", $_REQUEST['ltm_id'], PDO::PARAM_INT);

   $stmt->bindValue(":csmid", $_REQUEST['csm_id'], PDO::PARAM_INT);

   $stmt->execute();

   $response['status']='OK';   

  }

  if ($response['status'] == 'OK'){ 

   if ($stmt = $dbo->prepare("

    SELECT MMR.*, CSM.ltm_pick_id, MRC.ltm_company_name

	FROM lt_merchants MRC

	INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=MRC.ltb_id

	INNER JOIN tbl_consumer CSM ON CSM.ltm_pick_id=MRC.ltm_id

	WHERE MRC.ltm_id=:merchantid AND CSM.csm_id=:csmid")){    

    $stmt->bindValue(":merchantid", $_REQUEST['ltm_id'], PDO::PARAM_INT);    

	$stmt->bindValue(":csmid", $_REQUEST['csm_id'], PDO::PARAM_INT);

    $stmt->execute();

    if ($_result = $stmt->fetch(PDO::FETCH_ASSOC)){	  

	 $_SESSION['user']['consumer']["ltm_company_name"]=$_result["ltm_company_name"];

	 $_SESSION['user']['consumer']["ltb_id"]=$_result["ltb_id"];

	 $_SESSION['user']['consumer']["ltm_id"]=$_REQUEST['ltm_id'];

	 $_SESSION['user']['consumer']["ltb_header_image"]=$_result["ltb_header_image"];	  

	 $_SESSION['user']['consumer']["ltm_pick_id"]=$_REQUEST['ltm_id'];	  

    }

   } 	

  }

 }

 elseif ($request['success']){

  if (isset($request['zip_code'], $request['csm_id'], $request['Last_Name'], $request['First_Name'], $request['csm_long'], $request['csm_lat'], $request['Cell_Phone_Number']) && $request['csm_id'] > 1){

   if ($stmt = $dbo->prepare("UPDATE tbl_consumer SET csm_zip=:zipcode, csm_last_name=:lastname, csm_first_name=:firstname, csm_long=:csmlong, csm_lat=:csmlat, csm_cell_number=:cellphone WHERE csm_id=:csmid")){    

    $stmt->bindValue(":csmlong", $request['csm_long'], PDO::PARAM_STR);

	$stmt->bindValue(":csmlat", $request['csm_lat'], PDO::PARAM_STR);	

	$stmt->bindValue(":cellphone", preg_replace("/[^0-9]/","",$request['Cell_Phone_Number']), PDO::PARAM_STR);

    $stmt->bindValue(":zipcode", $request['zip_code'], PDO::PARAM_STR);

	$stmt->bindValue(":lastname", $request['Last_Name'], PDO::PARAM_STR);

	$stmt->bindValue(":firstname", $request['First_Name'], PDO::PARAM_STR);

    $stmt->bindValue(":csmid", $request['csm_id'], PDO::PARAM_INT);

    $stmt->execute();

    $response['status']='OK';

	$_SESSION['user']['consumer']["csm_lat"]=$request['csm_lat'];

    $_SESSION['user']['consumer']["csm_long"]=$request['csm_long'];

	$_SESSION['user']['consumer']["csm_last_name"]=$request['Last_Name'];

    $_SESSION['user']['consumer']["csm_first_name"]=$request['First_Name'];	

   }

  }

  elseif (isset($request['csm_id'], $request['email'], $request['match_password']) && $request['csm_id'] > 1){
	  
	if ( !email_exists($request['email'], $request['csm_id']) ) {

	   require_once '../app/model/crypt.php';

	   $_crypt = new Crypt( $request['email'] );

	   if ($stmt = $dbo->prepare("UPDATE tbl_consumer SET csm_email=:email, csm_password=:pass  WHERE csm_id=:csmid")){    

		$stmt->bindValue(":pass", $_crypt->encode($request['match_password']), PDO::PARAM_STR);

		$stmt->bindValue(":email", $request['email'], PDO::PARAM_STR);

		$stmt->bindValue(":csmid", $request['csm_id'], PDO::PARAM_INT);

		$stmt->execute();

		$_SESSION['user']['consumer']["csm_email"]=$request['email'];

		$response['status']='OK';	

	   }
    }
	else{
		
		$response['notify']='<div class="alert alert-danger alert-error" role="alert"><a href="#" class="close" data-dismiss="alert">&times;</a><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span><span class="sr-only">Error:</span> A problem has been occurred while submitting your data.<ol><li>The new email is already taken</li></ol></div>';
		
	}
  }

  else{$response=$request;}   

 }

}

echo json_encode($response);