<?php
/*
API Specs
******Google Merchants Request******
It could be $_POST["google_id_list"] or $_GET["google_id_list"]
Where $_POST["google_id_list"] or $_GET["google_id_list"] is an string with a list of google ids separated by comma example: ewcss-dsedfefe_ef, ddeded-efefe-efef, efefef_deeded23dc, edded9feff0-fefef

******Google Merchants Response*******
Array with the following format

___ARRAY STATUS___
$response['status']='OK'; The search took place and the response array is built
$response['status']='EMPTY'; For some reason the search didn't took place and the response array is not built

___LIST OF FOUND MERCHANTS ON (lt_merchants)___
FIRST MEERCHANT FOUND
 
$response['merchant_id'][0] = 1212; id of the first merchant
$response['deals'][0] = false; the merchant has not deals

SECOND MEERCHANT FOUND 
 
$response['merchant_id'][1] = 3232; id of second the merchant
$response['deals'][1] = true; the merchant has deals

and so on...

******Deals Request******
It could be $_POST["deals_id_list"] or $_GET["deals_id_list"]
Where 
$_POST["deals_id_list"] or $_GET["deals_id_list"] is an string with a list of deals ids separated by comma example to be excluded from the response: 1, 12, 4, 5
$_POST["longitude"] or $_GET["longitude"] current location longitude of the customer on the map
$_POST["latitude"] or $_GET["latitude"] current location longitude of the customer on the map

******Deals Response*******
Array with the following format

___ARRAY STATUS___
$response['status']='OK'; The search took place and the response array is built
$response['status']='EMPTY'; For some reason the search didn't took place and the response array is not built

___LIST OF FOUND MERCHANTS ON (lt_merchants)___
FIRST DEAL FOUND
 
$response['deal_id'][0] = 12134; id of the first deal;
$response['deal_headline'][0]; Head line verbiage of the first deal;
$response['deal_description'][0]; Description verbiage of the first deal;
$response['deal_promocode'][0]; Promo code in case it has first one;

SECOND DEAL FOUND 
 
$response['deal_id'][1] = 12134; id of the second deal;
$response['deal_headline'][1]; Head line verbiage of the second deal;
$response['deal_description'][1]; Description verbiage of the second deal;
$response['deal_promocode'][1]; Promo code in case it has second one;

and so on...
*/
require '../app/start_session.php';
header( 'Content-Type: application/json; charset=utf-8' );
$response['status']='EMPTY';
if (($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET') && isset($_SESSION['user']['consumer']['csm_id']) ){
//----------------------------------------------------------------------------------
// Function to clean POST, GET, and REQUEST data
//----------------------------------------------------------------------------------
function _appCleanData( $data ){return htmlspecialchars( stripslashes( trim( $data ) ) );}

//----------------------------------------------------------------------------------
// Function to Process the Post array: $_REQUEST
//----------------------------------------------------------------------------------
function _appProcessRequest( $data )
{ 	//init arrays 	
	//Sanitize data request array. 
	$alphanumeric = array();$numeric = array();$double = array();$address=array();
	foreach( $data as $key => $val ) $data[$key] = _appCleanData($val);	
	// array for what is required
	if (isset($data['google_id_list']) && !empty($data['google_id_list'])){
     $alphanumeric  = explode(',',$data["google_id_list"]);	 
	}
	
	if (isset($data["radius"])){
     $numeric = array('radius'=> $data["radius"]);	 
	}
	
	if (isset($data["cat_id"])){
	 $numeric["cat_id"] = $data["cat_id"];
	}
	
	if (isset($data["promo_type_id"])){
	 $numeric["promo_type_id"] = $data["promo_type_id"];
	}	
	
	if (isset($data['deals_id_list'])){
     $numeric  = explode(',',$data["deals_id_list"]);	 
	}
	
	if (isset($data['merchant_id_list'])){
     
     if (isset($numeric[0])){
	  $_temp=explode(',',$data["merchant_id_list"]);
	  foreach ($_temp as $_tempValue){
	   $numeric[] = $_tempValue;
	  }
	 }
	 else{$numeric  = explode(',',$data["merchant_id_list"]);}
	}
	
	if (isset($data['merchant_id'])){     
     $numeric[] = $data['merchant_id'];
	}	
	
	if (isset($data['promo_id'])){     
     $numeric[] = $data['promo_id'];
	}
	
	if (isset($data['amount'])){     
     $numeric[] = $data['amount'];
	}	
	
	
	if (isset($data["cat_id_list"])){
	 if (isset($numeric[0])){
	  $_temp=explode(',',$data["cat_id_list"]);
	  foreach ($_temp as $_tempValue){
	   $numeric[] = $_tempValue;
	  }
	 }
	 else{$numeric  = explode(',',$data["cat_id_list"]);}
	}
	
	if (isset($data['latitude'], $data['longitude'])){
     $double = array(
	  'longitude'=> $data["longitude"]
	  ,'latitude'=> $data["latitude"]
	 );
	}
	
	if (isset($data["search_point"])){
	 $address['search_point'] = $data["search_point"];
	}
	
	if (isset($data['keywords']) && !empty($data['keywords'])){
	 $output = trim(preg_replace('/\s+/', ' ', $data["keywords"]));
	 if (isset($alphanumeric[0])){
	  $_temp=explode(',',$output);
	  foreach ($_temp as $_tempValue){
	   $alphanumeric[] = $_tempValue;
	  }
	 }
	 else{
      $alphanumeric  = explode(',',$output);
     }	  
	}
	
	if (isset($data['place_types'])){
	 if (isset($alphanumeric[0])){
	  $_temp=explode(',',$data["place_types"]);
	  foreach ($_temp as $_tempValue){
	   $alphanumeric[] = $_tempValue;
	  }
	 }
	 else{
      $alphanumeric = explode(',',$data["place_types"]);
     }	  
	}
	
    $errors=array();
	
	
	foreach( $address as $key => $val ) {
		if( !preg_match( '/[\w\p{L}\p{N}\p{Pd}]/u', $val ) ) 
			array_push( $errors, "$key can only have UTF-8 characters." );
	}
	
	foreach( $alphanumeric as $key => $val ) {
		if( !preg_match( '/^[a-zA-Z0-9_\- ]+$/', $val ) ) 
			array_push( $errors, "$key can only have alpha numeric characters." );
	}	
	
	foreach( $numeric as $key => $val ) {
		if( !preg_match( '/^[0-9]+$/', $val ) )
			array_push( $errors, "$key can only have numeric characters." );
	}
	foreach( $double as $key => $val ) {
		if( !preg_match( '/[+-]?\\d*\\.?\\d+/', $val ) ) 
			array_push( $errors, "$key has an invalid format." );
	}
	//if no errors in array.
	if( empty( $errors ) ) {		
		$data['success'] = true;	
	}
	return $data;
 }//end of the _appProcessRequest function
/*
	require '../app/class.variables.php';	
	$cv= new _variables();
    
    //$_REQUEST['lst5000_google_id_list'] = $_REQUEST['google_id_list'];	in order to change the key
	//$_REQUEST['wnu_su_merchant_id_r'] = $_REQUEST['su_merchant_id'];	in order to change the key
	//$_REQUEST['wnu_su_merchant_id_r'] = $_REQUEST['su_merchant_id'];	in order to change the key
	//$_REQUEST['wnu_su_merchant_id_r'] = $_REQUEST['su_merchant_id'];	in order to change the key
	//$_REQUEST['wnu_su_merchant_id_r'] = $_REQUEST['su_merchant_id'];	in order to change the key
	//$_REQUEST['wnu_su_merchant_id_r'] = $_REQUEST['su_merchant_id'];	in order to change the key
	//$_REQUEST['wnu_su_merchant_id_r'] = $_REQUEST['su_merchant_id'];	in order to change the key
	//$_REQUEST['wnu_su_merchant_id_r'] = $_REQUEST['su_merchant_id'];	in order to change the key
 
    	
	$cv_array=array('wnu_su_merchant_id_r','dec_csm_long','dec_csm_lat','ema64_email_r', 'abc64_f_name_r', 'abc64_l_name_r', 'wnu_zip_code_r', 'pho_cell_phone'); //list all varibles to be check in array
	foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
	$request=$cv->get_cleaned_variables();
	$errors=$cv->get_bad_variables();
	
	if (!empty($errors)){ 
		//Good to go 
	} */
	
 $request = _appProcessRequest( $_REQUEST );
 //require '../app/function.connect.php';
 require '../app/global.php';
// $dbo=connect(  );
 if ($request['success']){
  $_SetSession_Flag=true; 
  if (isset($request["search_point"])){$_SESSION['user']['consumer']['search_point']=$request["search_point"];}
  if(isset($request["google_id_list"], $request["longitude"], $request["latitude"], $request["radius"])){      
   if(!empty($request["keywords"])){
    // ************find categories based in google types returns from search_nearby************
	if (isset($request["place_types"]) && !empty($request["place_types"]) && $stmt = $dbo->prepare("SELECT DISTINCT cat_id FROM tbl_category WHERE cat_slug IN ('".str_replace(",","','",$request["place_types"])."')")){	 
	 $stmt->execute();
	 $_cat_id_List=''; 
	  while ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){       	   
	   $_cat_id_List[] = $_result['cat_id'];
     }	  	
    }	
	
	$search_Array=explode(' ',trim(preg_replace('/\s+/', ' ', $request["keywords"]))); 
	$output_Array=array_unique($search_Array);
	$output = implode(' ',$output_Array);
	
    // ************This is the code that used to add keywords automatically to tbl_keywords based on google types returns form search_nearby************
	if ($stmt = $dbo->prepare("SELECT COUNT(DISTINCT(dic_word)) AS w_Count FROM tbl_dictionary WHERE dic_word IN ('".str_replace(" ","','",$output)."')")){
	 $stmt->execute();
	  if ($_result = $stmt->fetch( PDO::FETCH_ASSOC ) && $_result['w_Count']==count($output_Array)){	    
		//$response['test']=$output;
	    if ($stmt = $dbo->prepare("SELECT key_id FROM tbl_keywords WHERE key_word LIKE :output LIMIT 1")){
		 $stmt->bindValue(":output", $output, PDO::PARAM_STR);
	     $stmt->execute();
		 if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){
		  //increment the count if key_type is suggested
		  if ($stmt = $dbo->prepare("UPDATE tbl_keywords SET key_count = (CASE WHEN key_count IS NULL THEN 1 ELSE key_count +1 END) WHERE key_id=:keyid AND key_type='suggested'")){
		   $stmt->bindValue(":keyid", $_result['key_id'], PDO::PARAM_INT);
		   $stmt->execute();
		  }
		 }
		 else{
		  //insert the new phrase into tbl_keywords and the new_id into tbl_c2keyword
		  if ($stmt = $dbo->prepare("INSERT INTO tbl_keywords (key_word, key_type) VALUES (:output, 'suggested')")){
		   $stmt->bindValue(":output", $output, PDO::PARAM_STR);
	       $stmt->execute();
		  }
		  
		  $_Keyword=$dbo->lastInsertId();
		  
		  if (isset($_cat_id_List) && !empty($_cat_id_List)){
		   foreach ($_cat_id_List as $_cat_id){
	        if ($stmt = $dbo->prepare("SELECT count(c2k_id) AS Counter FROM tbl_c2keyword WHERE key_id=:keyword AND cat_id=:catid")){
		     $stmt->bindValue(":keyword", $_Keyword, PDO::PARAM_INT);
		     $stmt->bindValue(":catid", $_cat_id, PDO::PARAM_INT);
	         $stmt->execute();
	         if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){       	   
	          if (!$_result['Counter'] && $stmt = $dbo->prepare("INSERT INTO tbl_c2keyword (key_id, cat_id) VALUES (:keyword, :catid)")){
		       $stmt->bindValue(":keyword", $_Keyword, PDO::PARAM_INT);
		       $stmt->bindValue(":catid", $_cat_id, PDO::PARAM_INT);
	           $stmt->execute();
		      }		  
             }	  	
            } 
	       }
		  }
		 }
		}
      }
    }
	//End new keywords code
   
    /*
    if ($stmt = $dbo->prepare("SELECT key_id FROM tbl_keywords WHERE key_word LIKE :output AND key_type='active' LIMIT 1")){
	  $stmt->bindValue(":output", $output, PDO::PARAM_STR);
	  $stmt->execute();
	  if (!($_result = $stmt->fetch( PDO::FETCH_ASSOC ))){
	   //the keyword is not in the dictionary lets try to find in the geo tables
	    if ($stmt = $dbo->prepare("
		 SELECT ZIP.gz_lon, ZIP.gz_lat, STE.gs_abbr, CTY.gcty_city
		 FROM geo_zip ZIP 
		 INNER JOIN geo_city CTY ON CTY.gcty_id=ZIP.gcty_id
		 INNER JOIN geo_state STE ON STE.gs_id=CTY.gs_id
		 INNER JOIN geo_country CNY ON CNY.gc_id=STE.gc_id		 
		 WHERE
		  CTY.gcty_city LIKE :keyword
		  OR ZIP.gz_zip LIKE :keyword 
		  OR STE.gs_state LIKE :keyword 
		  OR CNY.gc_country LIKE :keyword 
		  OR CNY.gc_abr LIKE :keyword 
		  OR STE.gs_abbr LIKE :keyword
		  OR CONCAT(CTY.gcty_city, ', ', STE.gs_abbr) LIKE :keyword
		  OR CONCAT(CTY.gcty_city, ', ', STE.gs_abbr, ', ', CNY.gc_abr) LIKE :keyword
		 LIMIT 1")){
         $stmt->bindValue(":keyword", $output, PDO::PARAM_STR); 		
	     $stmt->execute();
		 if ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){
		  //the keyword is in the geo tables its a location
		  $_SetSession_Flag=false;          
		  $response['New_Params']['search_point']= $_result["gcty_city"] . ', ' . $_result["gs_abbr"];
		  $response['New_Params']['csm_long']=$_result["gz_lon"];
		  $response['New_Params']['csm_lat']=$_result["gz_lat"];
		  $request['longitude']=$_result["gz_lon"];
		  $request['latitude']=$_result["gz_lat"];
		  $_SESSION['user']['consumer']['search_string'] = $output;
		  $_SESSION['user']['consumer']['search_point']  = $_result["gcty_city"] . ', ' . $_result["gs_abbr"];
		  $_SESSION['user']['display']['csm_long']=$_result["gz_lon"];
		  $_SESSION['user']['display']['csm_lat']=$_result["gz_lat"];
		  unset($request["keywords"]);unset($output);          
		 }
		}
	  }
    }
	*/
   }
   
   $_inner_join='';$_where='';
   if(isset($request["cat_id_list"])){
    $_inner_join.="
	 INNER JOIN lt_m2cat M2C ON MRC.ltb_id=M2C.ltb_id
	 INNER JOIN tbl_category CAT ON CAT.cat_id=M2C.cat_id
	";	
	$_Cat_Array=explode(",", $request["cat_id_list"]);
	$_flag2=false;
	foreach($_Cat_Array as $Key_Cat => $Value_Cat){
	 if (!$_flag2) {
	  $_flag2=true;
	  $_where.=' AND (';
	  $_where.=" CAT.cat_id =:Categ_$Key_Cat";
	 }
	 else{
	  $_where.=" OR CAT.cat_id =:Categ_$Key_Cat";
	 }
	}
    if ($_flag2) {$_where.=')';}	
   } 
   if(isset($request["promo_type_id"])){
    $_where.=' AND PRT.lpt_id=:promotypeid';
   }
   if ($_SetSession_Flag)
    $_SESSION['user']['consumer']['search_string']='';
   if(isset($output)){
    $_SESSION['user']['consumer']['search_string']=$output;
    $_inner_join.="
	 INNER JOIN tbl_m2keyword M2K ON M2K.ltb_id=MMC.ltb_id
	 INNER JOIN tbl_keywords KYW ON KYW.key_id=M2K.key_id
	";
	$_Key_search_Array=array(':KeyWord' => $output);
	$_where_addon='KYW.key_word LIKE :KeyWord OR MRC.ltm_company_name LIKE :KeyWord';
	if (($temp = strlen($output) - strlen('s')) >= 0 && strpos($output, 's', $temp) !== false){
	 $_Key_search_Array[':KeyWords']=substr($output, 0, -1);
	 $_where_addon.=' OR KYW.key_word LIKE :KeyWords OR MRC.ltm_company_name LIKE :KeyWords';
	}
    if (($temp = strlen($output) - strlen('es')) >= 0 && strpos($output, 'es', $temp) !== false){
	 $_Key_search_Array[':KeyWordes']=substr($output, 0, -2);
	 $_where_addon.=' OR KYW.key_word LIKE :KeyWordes OR MRC.ltm_company_name LIKE :KeyWordes';
	}     
	if (($temp = strlen($output) - strlen('ies')) >= 0 && strpos($output, 'ies', $temp) !== false){
	 $_Key_search_Array[':KeyWordies']=substr($output, 0, -3).'y';
	 $_where_addon.=' OR KYW.key_word LIKE :KeyWordies OR MRC.ltm_company_name LIKE :KeyWordies';
	} 
	if (($temp = strlen($output) - strlen('ves')) >= 0 && strpos($output, 'ves', $temp) !== false){
	 $_Key_search_Array[':KeyWordvesf']=substr($output, 0, -3).'f';
	 $_Key_search_Array[':KeyWordvesff']=substr($output, 0, -3).'ff';
	 
	 $_where_addon.=' OR KYW.key_word LIKE :KeyWordvesf OR MRC.ltm_company_name LIKE :KeyWordvesf OR KYW.key_word LIKE :KeyWordvesff OR MRC.ltm_company_name LIKE :KeyWordvesff';
	 
	}
	$_where.=" AND ({$_where_addon})";	
   }   
   
   if ( NEW_DB_SWITCH ) {
	  $_inner_join .= "
		INNER JOIN tbl_package PACK ON MMC.pk_id = PACK.pk_id
		INNER JOIN tbl_product PROD ON PACK.pk_id = PROD.prod_id
	  ";
	  $sqlOr = '';
   }
   else {
	  $_inner_join .= "
		INNER JOIN lt_plan_type AS PTY ON MMC.pty_id=PTY.pty_id
		INNER JOIN lt_merchant_plans AS PTM ON PTM.pty_id=PTY.pty_id
	  ";
	  $sqlOr = 'PTY.pty_id DESC, ';
   }
   
   if ($stmt = $dbo->prepare("
    SELECT DISTINCT MRH.*, MMC.*, MRC.*
	FROM lt_member_merchants MMC
	INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id
	LEFT JOIN lt_merchant_hours MRH ON MRC.ltm_id=MRH.ltm_id 
	LEFT JOIN lt_promos PRM ON PRM.ltb_id=MMC.ltb_id	
	LEFT JOIN lt_promo_types PRT ON PRM.ltp_promo_type=PRT.lpt_id".
	$_inner_join." WHERE MMC.ltb_active ".$_where." AND (  3959 * acos( cos( radians(:customerlat) ) * cos( radians( MRC.ltm_lat ) ) * cos( radians( MRC.ltm_long ) - radians(:customerlong) ) + sin( radians(:customerlat) ) * sin(radians(MRC.ltm_lat)) ) )  < (:raius/1069) 
	ORDER BY {$sqlOr}POW(POW((:customerlat-MRC.ltm_lat),2)+(POW((:customerlong-MRC.ltm_long),2)),(1/2))".(empty($output)?" LIMIT " . (20+(2*($_SESSION['user']['consumer']['search_range']/1069))):""))){
	 $stmt->bindValue(":raius", $request['radius'], PDO::PARAM_INT);
	 $stmt->bindValue(":customerlat", $request['latitude'], PDO::PARAM_STR);	
	 $stmt->bindValue(":customerlong", $request['longitude'], PDO::PARAM_STR);
	 $_SESSION['user']['consumer']['search_range']=$request['radius'];
	 if(isset($request["promo_type_id"])){
	  $stmt->bindValue(":promotypeid", $request["promo_type_id"], PDO::PARAM_INT);	  
      $_SESSION['user']['consumer']['search_promo_type']=$request["promo_type_id"];
	 }else{$_SESSION['user']['consumer']['search_promo_type']=0;}
	 if(isset($request["cat_id_list"])){
	  foreach($_Cat_Array as $Key_Cat => $Value_Cat){	  	   
	   $stmt->bindValue(":Categ_$Key_Cat", $Value_Cat, PDO::PARAM_INT);	   
	  }	  
	 }
	 
	 if(isset($_Key_search_Array)){	  
	  foreach($_Key_search_Array as $Key_KeyWord => $KeyWord){	  
	   $stmt->bindValue($Key_KeyWord, $KeyWord.'%', PDO::PARAM_STR);	   
	  }	  
	 }	 
	 $stmt->execute();
	 $google_id_Array  = empty($request["google_id_list"])?array():explode(',',$request["google_id_list"]);	 
	 $total_count=count($google_id_Array);
	 if ($total_count > 0)
	  foreach($google_id_Array as $Key => $Value){	  
	   $response['ltb_logo'][$Key] = '';
	   $response['ltm_company_name'][$Key] = '';
	   $response['ltm_id'][$Key] = 0;
	   $response['ltm_lat'][$Key] = 0;
	   $response['ltm_long'][$Key] = 0;
	   $response['lth_end_day_num'][$Key] = 0;
       $response['lth_start_day_num'][$Key] = 0;	  
	   $response['lth_open'][$Key] = '';	  
	   $response['lth_close'][$Key] = 0;	 
       $response['pty_id'][$Key] = 0;
	   $response['ltm_phone_number'][$Key] = '';
	   $response['ltb_id'][$Key] = '';
	   $response['deals'][$Key] = false;	 
	  }
	 while ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){ 	 	  
	  $response['status']='OK';
	  $_flag=false;
	  if ($total_count > 0)
	   foreach($google_id_Array as $Key => $Value){
	    if (strpos($_result['ltm_google_id'], $Value) !== false){	    
	     $_flag=true;
		 foreach ($_result as $DbKey => $DbValue){
		  $response[$DbKey][$Key] = $DbValue;
	     }
	     $response['deals'][$Key] = true;
		 break;
	    }	   
	   }
      if (!$_flag){
	    foreach ($_result as $DbKey => $DbValue){
		 $response[$DbKey][$total_count] = $DbValue;
	    }
	    $response['deals'][$total_count++] = true;
		//++$total_count;
	  }	  
     }
	}   
  }
  elseif(isset($request["deals_id_list"], $request["longitude"], $request["latitude"])){
   if (isset($request["amount"]) && $request["amount"] > 0){
    $_Limit=$request["amount"];
   }
   else{   
    $request["deals_id_list"]=='0'?$_Limit=16:$_Limit=1;
   }
   if ($stmt = $dbo->prepare("
	SELECT DISTINCT PRM.ltp_promo_type, PRM.ltp_id, PRM.ltp_headline, PRM.ltp_description, PRM.ltp_promo_code, PRM.ltp_image
	FROM lt_promos PRM
	INNER JOIN lt_member_merchants MMC ON PRM.ltb_id=MMC.ltb_id
	INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id
	WHERE MMC.ltb_active 
	AND MRC.ltm_active 
	AND (
	 (NOW() < PRM.ltp_enddate AND NOW() > PRM.ltp_startdate) 
	 OR (PRM.ltp_enddate IS NULL AND PRM.ltp_startdate IS NULL)
	) 	
	AND PRM.ltp_active
	AND PRM.ltp_id NOT IN ({$request['deals_id_list']})
	ORDER BY POW(POW((:customerlat-MRC.ltm_lat),2)+(POW((:customerlong-MRC.ltm_long),2)),(1/2))
	LIMIT ".$_Limit)){
     /*
     AND TIME(NOW()) > PRM.ltp_time_start 
	 AND TIME(NOW()) < PRM.ltp_time_end      
	 
	 INNER JOIN tbl_consumer CSM ON CSM.ltm_pick_id=MRC.ltm_id
	 
	 AND CSM.csm_id=:csmid
	 
     $stmt->bindValue(":csmid", $_SESSION['user']['consumer']['csm_id'], PDO::PARAM_INT);
	 */
     $stmt->bindValue(":customerlat", $request['latitude'], PDO::PARAM_STR);	
	 $stmt->bindValue(":customerlong", $request['longitude'], PDO::PARAM_STR);
	 $stmt->execute();
	  $Key=0;
	  while ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){	
       $response['status']='OK';
       
	   foreach ($_result as $DbKey => $DbValue){
		$response[$DbKey][$Key] = $_result[$DbKey];
	   }
       /*
       ltp_promo_type, ltp_id, ltp_headline, ltp_description, ltp_promo_code

	   
	   $response['deal_id'][$Key] = $_result['ltp_id']; 
	   $response['deal_headline'][$Key] = $_result['ltp_headline']; 
	   $response['deal_description'][$Key] = $_result['ltp_description']; 
	   $response['deal_promocode'][$Key] = $_result['ltp_promo_code'];    	  
	   $response['deal_promotype'][$Key] = $_result['ltp_promo_type'];*/
	   ++$Key;
      }
    }
   }
   elseif(isset($request["cat_id"])){
   if ($stmt = $dbo->prepare("SELECT cat_id, cat_name, cat_slug FROM tbl_category WHERE cat_parent_id=:catid")){
     $stmt->bindValue(":catid", $request["cat_id"], PDO::PARAM_INT);	
	 $stmt->execute();
	 $Key=0; 
	  while ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){	
       $response['status']='OK';
	   foreach($_result as $Dbkey => $DbValue){        
	    $response[$Dbkey][$Key] = $DbValue; 	    	    
	   }
	   ++$Key;
      }
	  
    }
   }
   elseif(isset($request["merchant_id_list"],$request["longitude"],$request["latitude"])){
   $request["merchant_id_list"]=='0'?$_Limit=16:$_Limit=1;
   if ( NEW_DB_SWITCH ) {
	  $_inner_join = "
		INNER JOIN tbl_package PACK ON MMC.pk_id = PACK.pk_id
		INNER JOIN tbl_product PROD ON PACK.pk_id = PROD.prod_id
	  ";
	  $sqlOr = '';
   }
   else {
	  $_inner_join = "
		INNER JOIN lt_plan_type AS PTY ON MMC.pty_id=PTY.pty_id
		INNER JOIN lt_merchant_plans AS PTM ON PTM.pty_id=PTY.pty_id
	  ";
	  $sqlOr = 'PTY.pty_id DESC, ';
   }
   if ($stmt = $dbo->prepare("
    SELECT DISTINCT MRC.*, MMC.* 
	FROM lt_member_merchants MMC	
	INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id
	{$_inner_join}
	LEFT JOIN lt_promos PRM ON PRM.ltb_id=MMC.ltb_id	
	WHERE MMC.ltb_active
	AND (
	 (NOW() < PRM.ltp_enddate AND NOW() > PRM.ltp_startdate) 
	 OR (PRM.ltp_enddate IS NULL AND PRM.ltp_startdate IS NULL)
	) 
	AND PRM.ltp_active
	AND MRC.ltm_active		
	AND MRC.ltm_id NOT IN ({$request['merchant_id_list']})
	ORDER BY MMC.pty_id DESC, POW(POW((:customerlat-MRC.ltm_lat),2)+(POW((:customerlong-MRC.ltm_long),2)),(1/2))
	LIMIT ".$_Limit)){
	 /*
     $stmt->bindValue(":csmid", $_SESSION['user']['consumer']['csm_id'], PDO::PARAM_INT);
	 
	 INNER JOIN tbl_consumer CSM ON CSM.ltm_pick_id=MRC.ltm_id
	 
	 AND CSM.csm_id=:csmid
	 */
     $stmt->bindValue(":customerlat", $request['latitude'], PDO::PARAM_STR);	
	 $stmt->bindValue(":customerlong", $request['longitude'], PDO::PARAM_STR);		 
	 $stmt->execute();
	  $Key=0;
	  while ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){	
	   $response['status']='OK';
	   foreach($_result as $Dbkey => $DbValue){        
	    $response[$Dbkey][$Key] = $DbValue; 	    	    
	   }
	   ++$Key;
      }	  
    }
   }
   elseif(isset($request["merchant_id"]) || isset($request["promo_id"])){
   
   if (isset($request["merchant_id"])){
    $_Value=$request["merchant_id"];
	$Key=':merchid';
	$Where="
	 WHERE MMC.ltb_active 
	 AND MRC.ltm_active 
	 
	 AND MRC.ltm_id=:merchid";
	}
   elseif (isset($request["promo_id"])){
    if (isset($_SESSION['user']['consumer']['csm_id']) && $_SESSION['user']['consumer']['csm_id'] > 1){//Here we increment promo views amount
	 if ($stmt = $dbo->prepare("	 
       INSERT INTO lt_promo_tracking (csm_id, ltp_id, lpk_date)
	   SELECT * FROM (
	    SELECT :csmid AS csmid, :ltpid AS ltpid, DATE(NOW()) AS todays_date
	   ) tmp
	   WHERE NOT EXISTS (
	   SELECT csm_id, ltp_id FROM lt_promo_tracking WHERE csm_id = tmp.csmid AND ltp_id = tmp.ltpid AND lpk_date=tmp.todays_date
	   )	  
	  ")){
      $stmt->bindValue(':csmid', $_SESSION['user']['consumer']['csm_id'], PDO::PARAM_INT);		 
	  $stmt->bindValue(':ltpid', $request["promo_id"], PDO::PARAM_INT);		 
	  $stmt->execute();
	 }
     if ($stmt = $dbo->prepare("	 
       UPDATE lt_promo_tracking SET lpk_views=lpk_views+1	  
	   WHERE csm_id = :csmid AND ltp_id = :ltpid AND lpk_date=DATE(NOW())
	  ")){
      $stmt->bindValue(':csmid', $_SESSION['user']['consumer']['csm_id'], PDO::PARAM_INT);		 
	  $stmt->bindValue(':ltpid', $request["promo_id"], PDO::PARAM_INT);		 
	  $stmt->execute();
	 }
	}
    $_Value=$request["promo_id"];
    $Key=':promoid';	
	$Where="
	 WHERE MMC.ltb_active 
	 AND MRC.ltm_active 
	 AND PRM.ltp_active 
	 AND (
	  (NOW() < PRM.ltp_enddate AND NOW() > PRM.ltp_startdate) 
	  OR (PRM.ltp_enddate IS NULL AND PRM.ltp_startdate IS NULL)
	 ) 
	 AND PRM.ltp_id=:promoid";
   }
   if ($stmt = $dbo->prepare("
    SELECT DISTINCT PRM.*, MRH.*, MMC.*, MRC.*
	FROM lt_member_merchants MMC
	INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id
	LEFT JOIN lt_promos PRM ON PRM.ltb_id=MMC.ltb_id
	LEFT JOIN lt_promo_types PRT ON PRM.ltp_promo_type=PRT.lpt_id
	LEFT JOIN lt_merchant_hours MRH ON MRC.ltm_id=MRH.ltm_id
	{$Where}")){
     $stmt->bindValue($Key, $_Value, PDO::PARAM_INT);		 
	 $stmt->execute();
	  $Key=0;
	  while ($_result = $stmt->fetch( PDO::FETCH_ASSOC )){	
	   $response['status']='OK';
	   foreach($_result as $Dbkey => $DbValue){        
	    $response[$Dbkey][$Key] = $DbValue;
		if ($Dbkey == 'ltm_company_name'){
		 $response['ltm_company_font_size'][$Key] = get_company_name_size($DbValue,$response); 
		}
	   }
	   ++$Key;
      }	  
    }
   }
  }
  else{
   $response['error']=$request;
  }  
 }
 

 
 
 
 
 
 
 
 
function get_company_name_size($DbValue, &$response, $_max_Size=40, $_min_Size=16, $_max_Charts=64, $_max_Letters=10){
 
 if (!empty($DbValue)){
  
  $_words=explode(' ', $DbValue);
  
  $_words_Array=array_intersect_key(
  
                     array_filter($_words),
					 
                     array_unique(array_map("StrToLower",array_filter($_words)))
					 
                );
  
  $_amount_Array=array_map('strlen', $_words_Array);
  
  $_maxlen = max($_amount_Array);
  
  $_total_Sum=array_sum($_amount_Array)+count($_amount_Array)-1;
  
  $_based_on_word_length = round( $_max_Size - ( ( $_maxlen - $_max_Letters ) * $_max_Size / $_max_Letters ) );
    
  $_based_on_charts_amount = round( (100-$_total_Sum) * $_min_Size / (100-$_max_Charts) );
  
  //$response['testing____________________']=$_based_on_word_length.':'.$_based_on_charts_amount;
  
  return min($_based_on_word_length, $_based_on_charts_amount);
 
 }
 
 return $_max_Size;
 
} 
 
 
 
 
 
 
 
 
echo json_encode($response);