<?php
/*
API Specs

******Search around current position request******
It could be either $_POST or $_GET

Where 
(Required for the search around current position)
$_POST['longitude'] or $_GET['longitude'] is a double value, current location longitude
$_POST['latitude'] or $_GET['latitude'] is a double value, current location latitude

(optional for the search around current position)
$_POST['amount'] or $_GET['amount'] is an integer between 1 and 100, if not set or is out of that range 1 will be the default value
and is the amount of merchants around the current location (the latitude and longitude set above)

******Search around current position response******
Array with the following format

___ARRAY STATUS___
$response['status']='OK'; The search took place and the response array is built
$response['status']='EMPTY'; For some reason the search didn't took place and the response array is not built

___LIST OF FOUND MERCHANTS ON (lt_merchants) WITH PLATINUM MEMBERSHIP___
FIRST MEERCHANT FOUND 

$response['id'][0] = 1212; id of the first merchant (integer)
$response['merchant'][0] = false; the merchant has not deals (string)
$response['longitude'][0]; longitude of the first merchant (double)
$response['latitude'][0]; latitude of the first merchant (double)

SECOND MEERCHANT FOUND 
 
$response['id'][1] = 1222; id of the second merchant (integer)
$response['merchant'][1]; the merchant company name (string)
$response['longitude'][1]; longitude of the second merchant (double)
$response['latitude'][1]; latitude of the second merchant (double)

and so on...

******Sign up request******
It could be either $_POST or $_GET

(Required for Sign up process)
$_POST['f_name'] or $_GET['f_name']; First name of the consumer that is signing in
$_POST['f_name'] or $_GET['l_name']; Last name of the consumer that is signing in
$_POST['email'] or $_GET['email']; email of the consumer that is signing in
$_POST['password'] or $_GET['password']; password of the consumer that is signing in
$_POST['re_password'] or $_GET['re_password']; retyped password of the consumer that is signing in
$_POST['su_merchant_id'] or $_GET['su_merchant_id']; Id of the merchant under consumer that is signing in
$_POST['cell_phone'] or $_GET['cell_phone']; cell phone number of the consumer that is signing in
$_POST['zip_code'] or $_GET['zip_code']; ZIP code number of the consumer that is signing in
$_POST['csm_lat'] or $_GET['csm_lat']; Latitude of the consumer that is signing in
$_POST['csm_long'] or $_GET['csm_long']; Longitude of the consumer that is signing in

******Sign up response******
Array with the following format

___ARRAY STATUS___
$response['status']='OK'; The sign up took place
$response['status']='EMPTY'; For some reason the sign up didn't took place and the corresponded message is set on $response['notify']

$response['notify']; html message, if $response['status'] is 'EMPTY' otherwise is not set
*/

require '../app/start_session.php';
header( 'Content-Type: application/json; charset=utf-8' );
$response['status']='EMPTY';
$response['Consumer_Id']=0;

function consumer_exists($dbo, $an_email){
 if ($stmt = $dbo->prepare("
   SELECT csm_id FROM tbl_consumer WHERE csm_email=:email LIMIT 1")){
	$stmt->bindValue(":email", $an_email, PDO::PARAM_STR);	
	$stmt->execute();
  if ($_Result=$stmt->fetch(PDO::FETCH_OBJ)){
   return (int) $_Result->csm_id;
  }
  return false;
 }	
 return true;
}

if (($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET')){ 
 require '../app/function.connect.php';
 require '../app/global.php';


// this code block returns a list of merchants in the area
 if (isset($_REQUEST['latitude'], $_REQUEST['longitude'])
  && preg_match("/[+-]?\\d*\\.?\\d+/", $_REQUEST['longitude'])
  && preg_match("/[+-]?\\d*\\.?\\d+/", $_REQUEST['latitude'])
 ){
  $_amount=1;
  if (isset($_REQUEST['amount']) 
   && preg_match("/^[0-9]+$/", $_REQUEST['amount'])   
  ) {
  if ($_REQUEST['amount']&&$_REQUEST['amount']>0&&$_REQUEST['amount']<101) $_amount=$_REQUEST['amount'];}  
  if ( NEW_DB_SWITCH ) {
	  $_inner_join = "
		INNER JOIN tbl_package PACK ON MMR.pk_id = PACK.pk_id
		INNER JOIN tbl_product PROD ON PACK.pk_id = PROD.prod_id
	  ";
	  $sqlWh = '';
   }
   else {
	  $_inner_join = "
		INNER JOIN lt_plan_type AS PTY ON MMR.pty_id=PTY.pty_id
		INNER JOIN lt_merchant_plans AS PTM ON PTM.pty_id=PTY.pty_id
	  ";
	  $sqlWh = 'MMR.pty_id<>1 AND ';
   }
  if ($stmt = $dbo->prepare("
   SELECT * FROM
   (SELECT MRC.ltm_lat, MRC.ltm_long, MRC.ltm_id, MRC.ltm_company_name 
   FROM lt_merchants AS MRC 
   INNER JOIN lt_member_merchants AS MMR ON MMR.ltb_id=MRC.ltb_id   
   WHERE MRC.ltm_id=1) AS a
   UNION ALL
   (SELECT DISTINCT MRC.ltm_lat, MRC.ltm_long, MRC.ltm_id, MRC.ltm_company_name 
   FROM lt_merchants AS MRC 
   INNER JOIN lt_member_merchants AS MMR ON MMR.ltb_id=MRC.ltb_id
   {$_inner_join}
   WHERE MMR.ltb_active AND {$sqlWh}MRC.ltm_id>1 AND (  3959 * acos( cos( radians(:customerlat) ) * cos( radians( MRC.ltm_lat ) ) * cos( radians( MRC.ltm_long ) - radians(:customerlong) ) + sin( radians(:customerlat) ) * sin(radians(MRC.ltm_lat)) ) )  < (:raius)   
   ORDER BY POW(POW((:customerlat-MRC.ltm_lat),2)+(POW((:customerlong-MRC.ltm_long),2)),(1/2)) LIMIT ".($_amount).")")){
	$stmt->bindValue(":customerlat", $_REQUEST['latitude'], PDO::PARAM_STR);	
	$stmt->bindValue(":customerlong", $_REQUEST['longitude'], PDO::PARAM_STR);
	$stmt->bindValue(":raius", MERCHANT_MAX_DISTANCE, PDO::PARAM_INT);	
	$stmt->execute();	
  }
  $_i=0;   
  $_Found_Any=false;$_Our_Index=-1;
   while ($_result = $stmt->fetch(PDO::FETCH_OBJ)){
	if ($_result->ltm_id!=1){ $_Found_Any=true; }else{$_Our_Index=$_i;}
	$response['status']='OK';
	$response['id'][$_i]=$_result->ltm_id;
	$response['merchant'][$_i]=$_result->ltm_company_name;
	$response['longitude'][$_i]=$_result->ltm_long;
	$response['latitude'][$_i]=$_result->ltm_lat;   
	++$_i;
   }
  if ($_Found_Any && $_Our_Index!=-1){
   for($_j=$_Our_Index; $_j < $_i-1; $_j++){
	$response['id'][$_j]=$response['id'][$_j+1];
	$response['merchant'][$_j]=$response['merchant'][$_j+1];
	$response['longitude'][$_j]=$response['longitude'][$_j+1];
	$response['latitude'][$_j]=$response['latitude'][$_j+1];
   }
   unset($response['id'][$_i-1]);
   unset($response['merchant'][$_i-1]);
   unset($response['longitude'][$_i-1]);
   unset($response['latitude'][$_i-1]);  
  } 
 }
 else { // else were signing up a new consumer 
	//check the values of passed variables
	require '../app/class.variables.php';
	$cv= new _variables(); // new instance
	$cv_array=array('psw32_match_password_r', 'wnu_su_merchant_id_r','dec_csm_long','dec_csm_lat','ema64_email_r', 'nam64_f_name_r', 'nam64_l_name_r', 'wnu_zip_code_r', 'pho_cell_phone'); //list all varibles to be check in
	if (isset($_REQUEST['wnu_mall_id']))
	 $cv_array[]='wnu_mall_id';
	foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
	$request=$cv->get_cleaned_variables();
	$errors=$cv->get_bad_variables();
	// match passwords & password length
	if (strcmp($_REQUEST['psw32_match_password_r'],$_REQUEST['psw32_match_re_password_r']) !== 0){
	  array_push( $errors, "Passwords must match" );
	}
	if (!empty($errors)){ // throw errors if there are any
		$request['notify'] = '<div class="alert alert-danger alert-error" role="alert"><a href="#" class="close" data-dismiss="alert">&times;</a><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span><span class="sr-only">Error:</span> A problem has occurred while submitting your data.<ol>';
		foreach( $errors as $val ) $request['notify'].= "<li>$val</li>"; 
		$request['notify'].= '</ol></div>';
		
		$response['notify'] = $request['notify'];
		$response['status'] = 'EMPTY';
	} else { // proceed with consumer signup
		$request['success'] = true;
  
  // check if consumer email exists already
  $_Found_Id = consumer_exists($dbo, $request['email']);
  if ($_Found_Id){
   $response['notify'] = '<div class="alert alert-danger alert-error" role="alert"><a href="#" class="close" data-dismiss="alert">&times;</a><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span><span class="sr-only">Error:</span> A problem has occurred while submitting your data.<ol><li> The email address: '.$request['email'].' is already taken</li></ol></div>';
   $response['status'] = 'EMPTY';
   if (is_int($_Found_Id))
	$response['Consumer_Id'] = $_Found_Id;
  }
  elseif ($stmt = $dbo->prepare("
   INSERT INTO tbl_consumer
   (csm_added_by, csm_first_name, csm_last_name, csm_email, csm_password, csm_cell_number, csm_add_date, csm_last_login, csm_lat, csm_long, csm_zip, ltm_id, ltm_pick_id) 
   VALUES (".(isset($request['mall_id'])?"'nationalmall'":"'website'").", :fname, :lname, :email, :password, :cellphone, NOW(), NOW(), :csmlat, :csmlong, :zipcode, :merchantid, :merchantpickid)")){
	require '../app/model/crypt.php';
	$_crypt = new Crypt( $request['email'] );
	$stmt->bindValue(":fname", $request['f_name'], PDO::PARAM_STR);
	$stmt->bindValue(":lname", $request['l_name'], PDO::PARAM_STR);
	$stmt->bindValue(":email", $request['email'], PDO::PARAM_STR);
	$stmt->bindValue(":password", $_crypt->encode($request['match_password']), PDO::PARAM_STR);
	$stmt->bindValue(":cellphone", preg_replace("/[^0-9]/","",$request['cell_phone']), PDO::PARAM_STR);
	$stmt->bindValue(":zipcode", $request['zip_code'], PDO::PARAM_STR);
	$su_merchant_id=$request['su_merchant_id'];
	if (isset($request['mall_id'])){
		if ($stmt1 = $dbo->prepare("SELECT MRC.ltm_id 
								FROM lt_merchants AS MRC 
								INNER JOIN lt_member_merchants AS MMR ON MMR.ltb_id=MRC.ltb_id 
								INNER JOIN tbl_mall AS MALL ON MMR.ltb_id=MALL.ltb_id 
								WHERE MALL.mall_lss_id=:mallid LIMIT 1")){
			$stmt1->bindValue(":mallid", $request['mall_id'], PDO::PARAM_INT); 
			$stmt1->execute();
			if ($qrResponse = $stmt1->fetch(PDO::FETCH_OBJ)){
				
				$su_merchant_id=$qrResponse->ltm_id;
				 
			}			
			
		}	
	}
	$stmt->bindValue(":merchantid", $su_merchant_id, PDO::PARAM_INT);
	$stmt->bindValue(":merchantpickid", $su_merchant_id, PDO::PARAM_INT);
	$stmt->bindValue(":csmlong", $request['csm_long'], PDO::PARAM_STR);
	$stmt->bindValue(":csmlat", $request['csm_lat'], PDO::PARAM_STR);
	$stmt->execute();
	$response['Consumer_Id'] = $dbo->lastInsertId();		
	if ($response['Consumer_Id']){
	 $response['status'] = 'OK';
	 if (!isset($_REQUEST['do-not-set-session'])){
	  $_SESSION['user']['consumer']['csm_id'] = $response['Consumer_Id'];
	  $_SESSION['user']['display']['csm_long'] = $request['csm_long'];
	  $_SESSION['user']['display']['csm_lat'] = $request['csm_lat'];
	 } 
	if ($response['Consumer_Id'] > 1){
		if ((isset($_REQUEST['send_email']) && $_REQUEST['send_email'] == '1') || !isset($_REQUEST['send_email'])){
			// welcome email
			$ema_body = file_get_contents('../mail/localthanks/website/consumer_welcome/consumer_welcome.html');
			$ema_email = $request['email'];
			$ema_ltm_id = $request['su_merchant_id'];
			include '../app/build-email.php';
			$to       = $ema_email;
			$subject  = 'Welcome to Local Thanks!';
			$message  = $ema_body;
			$headers  = "From: noreply@localthanks.com\r\n";
			$headers .= "Reply-To: noreply@localthanks.com\r\n";
			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
			mail($to, $subject, $message, $headers);
		}
		
		// send opt-in text message
		if(intval($_REQUEST['text_opt_in'])===1){
			include '../app/function.send-text.php'; //_appSendText($_msg, $_recipient);
			$text_msg = 'Text YES to join LocalThanks.com Text Alerts. Msg&data rates may apply. Reply HELP for help, STOP to cancel.';
			_appSendText($text_msg, preg_replace("/[^0-9]/","",$request['cell_phone']));
		}
	 }
	}
   }
 }
}
}
echo json_encode($response);