<?php
// success survey used at the end of merchant sign up and in MyStore
header('Content-Type: application/json');
require $_SERVER['DOCUMENT_ROOT'].'/app/start_session.php';
$response = [];
$response['status'] = 'empty';


// Get Survey Questions, Inputs and Answers
if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_SESSION['user']['merchant']['ltb_id'])){

  require $_SERVER['DOCUMENT_ROOT'].'/app/function.connect.php';

  // check if survey has already been taken
  $response['survey_taken'] = false;
  $sql = 'SELECT sva_id FROM tbl_survey_answers WHERE ltb_id = :ltb_id LIMIT 1';
  $qry = $dbo->prepare( $sql );
  $qry->bindValue(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
  $qry=execPDO($qry);
  $qry = $qry->fetch(PDO::FETCH_ASSOC);
  if (!empty($qry)){
    $response['survey_taken'] = true;
  }

  // success survey questions
  $sql = 'SELECT SVQ.svq_id, SVQ.svq_question, SVQ.svq_parent_id, SVI.svi_id, SVI.svi_label, SVI.svi_type
  FROM tbl_survey_questions SVQ 
  INNER JOIN tbl_survey_inputs SVI ON SVQ.svq_id = SVI.svq_id
  ORDER BY SVQ.svq_id, SVI.svi_order, SVI.svq_id, SVI.svi_id';
  $qry = $dbo->prepare( $sql );
  $qry->execute();
  $qry = $qry->fetchAll(PDO::FETCH_ASSOC);
  foreach ($qry as $k => $v) {
    if (!$response['survey_questions'][$v['svq_id']]){
      $response['survey_questions'][$v['svq_id']] = array(
        'id'        => $v['svq_id'],
        'question'  => $v['svq_question'],
        'parent_id' => $v['svq_parent_id'],
        'inputs'    => array(array('id'=> $v['svi_id'], 'label'=>$v['svi_label'], 'type'=>$v['svi_type'], 'order'=>$v['svi_order'], 'checked'=>false, 'text'=>null))
      );
    } 
    else {
      $next_input = array('id'=> $v['svi_id'], 'label'=>$v['svi_label'], 'type'=>$v['svi_type'], 'order'=>$v['svi_order']);
      array_push($response['survey_questions'][$v['svq_id']]['inputs'], $next_input);
    }
  }

  $surveyAnswers = array();
  if ($response['survey_taken']){   
    // get this merchants answers 
    $stmt = $dbo->prepare("
      SELECT SVA.sva_id, SVA.svi_id, SVA.svq_id, SVT.svt_text
      FROM tbl_survey_answers SVA
      LEFT JOIN tbl_survey_answers_text SVT ON SVA.svi_id = SVT.svi_id AND SVA.ltb_id = SVT.ltb_id
      WHERE SVA.ltb_id = :ltb_id
      ORDER BY SVA.svq_id
    ");       
    $stmt->bindValue(":ltb_id", $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
    $stmt->execute();
    if ( $surveyAnswers = $stmt->fetchAll( PDO::FETCH_ASSOC ) ) {
      // update response with answers
      foreach ($response['survey_questions'] as $k=>$v){
        foreach ($surveyAnswers as $k2=>$v2){
          foreach ($v['inputs'] as $k3=>$v3){
            // if the answer array has this input ID, marked it as checked
            if ($v2['svi_id'] == $v3['id']){
              $response['survey_questions'][$k]['inputs'][$k3]['checked'] = true;
              // if the input has associated text, update that input 
              if ($v2['svt_text']){
                $response['survey_questions'][$k]['inputs'][$k3]['text'] = $v2['svt_text'];
              }
            }
          }
        }
      }
    }
  }
  $response['status'] = 'success';
}

// Update survey answers
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SESSION['user']['merchant']['ltb_id'])){
  require $_SERVER['DOCUMENT_ROOT'].'/app/function.connect.php';
  require $_SERVER['DOCUMENT_ROOT'].'/app/global.php';

  // delete previous answers
  $sql = "DELETE FROM tbl_survey_answers WHERE ltb_id=:ltb_id; OPTIMIZE TABLE tbl_survey_answers";
  $qry = $dbo->prepare($sql);
  $qry->bindValue(':ltb_id',$_SESSION['user']['merchant']['ltb_id']);
  $qry=execPDO($qry);
  $qry->closeCursor();
  $sql = "DELETE FROM tbl_survey_answers_text WHERE ltb_id=:ltb_id; OPTIMIZE TABLE tbl_survey_answers_text";
  $qry = $dbo->prepare($sql);
  $qry->bindValue(':ltb_id',$_SESSION['user']['merchant']['ltb_id']);
  $qry=execPDO($qry);
  $qry->closeCursor();

  foreach ($_POST as $k=>$v){
    $arr = explode('-', $k);
    if ($arr[0] == 'TEXT'){

      if ($arr[1] == 'ONLY'){
        // text only input
        // input id
        $svi_id = explode('_', $arr[2]);
        $svi_id = $svi_id[2];

        // question id
        $svq_id = explode('_', $arr[3]);
        $svq_id = $svq_id[2];

        // sanitize value
        $text = trim(htmlspecialchars(strip_tags($v)));

        // insert
        insertSurveyAnswer($svi_id, $svq_id, $_SESSION['user']['merchant']['ltb_id'], $dbo);
        insertSurveyAnswerText($svi_id, $_SESSION['user']['merchant']['ltb_id'], $text, $dbo);

      } else {
        // text + radio or check mark
        // input id
        $svi_id = explode('_', $arr[1]);
        $svi_id = $svi_id[2];

        // question id
        $svq_id = explode('_', $arr[2]);
        $svq_id = $svq_id[2];

        // sanitize value
        $text = trim(htmlspecialchars(strip_tags($v)));
        // insertSurveyAnswer() will be handled seperately since this input had both a checkbox/radio & text box
        insertSurveyAnswerText($svi_id, $_SESSION['user']['merchant']['ltb_id'], $text, $dbo);
      }

    } else {

      $arr = explode('_', $k);

      if ($arr[0] == 'svq'){

        $svq_id = $arr[2];

        if (is_array($v)){

          foreach ($v as $aKey=>$aVal){
            $svi_id = $aVal;
            insertSurveyAnswer($svi_id, $svq_id, $_SESSION['user']['merchant']['ltb_id'], $dbo);
          }

        } else {
          $svi_id = $v;
          insertSurveyAnswer($svi_id, $svq_id, $_SESSION['user']['merchant']['ltb_id'], $dbo);
        }
      }
    }
  }
  $response['post'] = $_POST;
  $response['status'] = 'success';
}

echo json_encode($response);


// methods
function insertSurveyAnswer($svi_id, $svq_id, $ltb_id, $dbo){
  if (is_numeric($svq_id) && is_numeric($svi_id) && is_numeric($ltb_id)){
    $sql = 'INSERT INTO tbl_survey_answers (svi_id, svq_id, ltb_id) VALUES (:svi_id, :svq_id, :ltb_id)';
    $qry = $dbo->prepare($sql);
    $qry->bindValue(':svi_id', $svi_id, PDO::PARAM_INT);
    $qry->bindValue(':svq_id', $svq_id, PDO::PARAM_INT);
    $qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);
    $qry=execPDO($qry);
  }
}

function insertSurveyAnswerText($svi_id, $ltb_id, $text, $dbo){
  if (is_numeric($svi_id) && is_numeric($ltb_id) && $text !== ''){
    $sql = 'INSERT INTO tbl_survey_answers_text (svt_text, svi_id, ltb_id) VALUES (:svt_text, :svi_id, :ltb_id)';
    $qry = $dbo->prepare($sql);
    $qry->bindValue(':svt_text', $text, PDO::PARAM_STR);
    $qry->bindValue(':svi_id', $svi_id, PDO::PARAM_INT);
    $qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);
    $qry=execPDO($qry);
  }
}
?>