<?php 
/*

This is the file that Twilio POSTs to when our phone number receives an SMS text message.

More info here: https://www.twilio.com/docs/api/twiml/sms/twilio_request

*/
header('Content-Type: text/xml');

include $_SERVER['DOCUMENT_ROOT'].'/app/global.php';

$body = trim(strtolower($_REQUEST['Body'])); // this is the message that was received
$from = trim($_REQUEST['From']); // this is the phone number that sent the message
$response = ""; // our response

// format number to match our database. from +15555555 to 5555555
if (substr($from, 0, 2) === '+1') {
	$from = substr($from, 2);
}

// get consumers SMS text status (opted in, opted out, NULL)
$sql = '
SELECT csm_txt_status FROM tbl_consumer 
WHERE csm_cell_number=:phone ORDER BY csm_id DESC LIMIT 1';
$qry = $dbo->prepare($sql);
$qry->bindValue(':phone', $from, PDO::PARAM_STR);
$qry=execPDO($qry);
$qry = $qry->fetchAll(PDO::FETCH_ASSOC);
$txt_status = $qry[0]['csm_txt_status'];

switch ($body) {
	/* 
		handle all stop/end/opt-out keywords

		since we're currently using a LONG CODE - Twilio handles the text replies, but we still need to update our database

		when we switch to a SHORT CODE we will also need to send a text reply once we update our database
	*/
	case 'stop':
	case 'stopall':
	case 'unsubscribe':
	case 'cancel':
	case 'end':
	case 'quit':
		// update database: this user has unsubscribed
		$sql = '
		UPDATE tbl_consumer 
		SET csm_txt_status = 0,
			csm_txt_status_date = Now()
		WHERE csm_cell_number=:phone';
		$qry = $dbo->prepare($sql);
	 	$qry->bindValue(':phone', $from, PDO::PARAM_STR);
	 	$qry=execPDO($qry);
	break;

	/* 
		handle all start/yes/opt-in keywords
	*/
	case 'start':
	case 'yes':
	case 'unstop':
		// update database: this user has opted in
		$sql = '
		UPDATE tbl_consumer 
		SET csm_txt_status = 1,
			csm_txt_status_date = Now()
		WHERE csm_cell_number=:phone';
		$qry = $dbo->prepare($sql);
	 	$qry->bindValue(':phone', $from, PDO::PARAM_STR);
	 	$qry=execPDO($qry);

	 	// send confirmation text
	 	// if this user WAS opted out and now is opting back in, Twilio will send them a confirmation
	 	// if this is a user opting in for the first time, we need to send our own confirmation message
	 	if($txt_status === NULL){
	 		include $_SERVER['DOCUMENT_ROOT'].'/app/function.send-text.php';
	 		_appSendText('You are now subscribed to LOCALThanks.com text msg alerts. Reply STOP to unsubscribe. Msg and Data rates may apply.', $from);
	 	}
	break;
	
	
	/*
		handle text to signup
	*/

	// TODO: text to signup
	
	default:
		// checking if the text is lt123...
		$foundFlag = false;
		if ( preg_match('/^(lt)([0-9]{1,11})$/i', strtolower($body) ) ) {
			//find merchant by its id
			$merchantId = preg_replace( "/[^0-9]/","",$body );			
			// update database: this user has opted in
			$sql = '
			SELECT * 
			FROM lt_member_merchants
			WHERE ltb_id = :ltbId AND ltb_active LIMIT 1';
			$qry = $dbo->prepare($sql);
			$qry->bindValue(':ltbId', $merchantId, PDO::PARAM_INT);
			$qry=execPDO($qry);
			$merchArr = $qry->fetch(PDO::FETCH_ASSOC);
			if ( isset( $merchArr['ltb_slug'] ) ) {
				include $_SERVER['DOCUMENT_ROOT'].'/app/function.send-text.php';
				_appSendText('Please click the link to signup: ' . $_siteURL . $merchArr['ltb_slug'] . '?signup=1', $from);				
				$foundFlag = true;
			}
		}

		if (!$foundFlag) {
			$toSignup = preg_replace( "/[^0-9a-zA-Z]/","",$body );
			if ( strlen( $toSignup ) <= 12 && strlen( $toSignup ) > 0 ) {
				//find merchant by its ltb_text_to_signup
				$sql = '
				SELECT * 
				FROM lt_member_merchants
				WHERE ltb_text_to_signup LIKE :ltb_text_to_signup AND ltb_active LIMIT 1';
				$qry = $dbo->prepare($sql);
				$qry->bindValue(':ltb_text_to_signup', $toSignup, PDO::PARAM_STR);
				$qry=execPDO($qry);
				$merchArr = $qry->fetch(PDO::FETCH_ASSOC);
				if ( isset( $merchArr['ltb_slug'] ) ) {
					include $_SERVER['DOCUMENT_ROOT'].'/app/function.send-text.php';
					_appSendText('Please click the link to signup: ' . $_siteURL . $merchArr['ltb_slug'] . '?signup=1', $from);				
				}
			}
		}	
		
	break;
}
/*
	EXAMPLE USAGE
*/



 //if($body == 'Hello'){
   //  $response = '<Response><Message>Hi, how are you? Your phone number is: '.$from.'</Message></Response>';
 //}	 
// }else if($body == 'bye'){
//     $response = '<Response><Message>See ya! Your phone number is: '.$from.'</Message></Response>';
// }

print $response;