<?php

class CakeAPI {
  private $apikey;
  private $apiurl='https://api.wbsrvc.com' ;//'https://api-v2-bridge-staging.wbsrvc.com';//'https://api.wbsrvc.com'; 
  function __construct($apikey){
    $this->apikey = $apikey;
  }
  function call($url, $params) {
     //echo '<br>' . $this->apiurl . $url . '?'. 'apikey='.$this->apikey . '&' . http_build_query($params, null, '&');	  
    try {
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $this->apiurl . $url);       
      curl_setopt($ch, CURLOPT_HTTPHEADER, array('apikey:'.$this->apikey));
      curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params, null, '&'));
	  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_TIMEOUT, 900);
      curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	  curl_setopt($ch, CURLOPT_POST, true);
      //curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
      $result = curl_exec($ch);
      if ($result === false) {
	    $_curl_err=curl_error($ch);
	    curl_close($ch);
        return 'Curl error: ' . $_curl_err;
      } else {
        if (!$result = json_decode($result)) {
		  curl_close($ch);
          return 'API Key Validation Error for ' . $this->apikey . '. Contact your administrator!';
        } 
        if ($result->status != 'success') {
		  curl_close($ch);		  
          return $result->data;
        }
      }
      curl_close($ch);
      return $result->data;
    } catch (Exception $e) {
      curl_close($ch);
      return $e->getMessage();
    }
  }
}

class CakeMail extends CakeAPI{

 //This function gets the Optional, Require and Path (Params needed to make the Cake Mail API) based on the API action you are about to make
 private function get_Params($an_Action, $_CakeMail_Params, $remove_Empty_Optionals = false){
  $_Params=array('Path'=>'', 'Requires'=>array(), 'Optionals'=>array());
  $_Action_Found=false;
  switch ($an_Action){
   
   //Country API Params (Information about countries and provinces/states)
   case 'Country_GetList':   
   $_Params['Path']='/Country/GetList/';
   $_Action_Found=true;
   break;
   case 'Country_GetProvinces':
   $_Params['Requires']=array( /*Integer*/
                               'country_id'=>'' 
							  );   
   $_Params['Path']='/Country/GetProvinces/';
   $_Action_Found=true;
   break;
   
   //Relay API Params (A relay is a one-off email. It can be used for instance to send a confirmation email or a password recovery email)
   case 'Relay_Send':
   $_Params['Requires']=array( 
                              /*User Key of the user who initiates the call. Type: string*/
                              'user_key'=>''
							  /*The email address of the recipient. Type: string*/
                              ,'email'=>''
							  /*Encoding to be used for the relay. Type: string - possible value 'utf-8', 'iso-8859-x'*/
                              ,'encoding'=>''
							  /*Subject of the relay. Type: string*/
                              ,'subject'=>''
							  /*Email address of the sender of the relay. Type: string*/
                              ,'sender_email'=>''
							  /*Name of the sender of the relay. Type: string*/
                              ,'sender_name'=>''
							 );
   $_Params['Optionals']=array( 
                              /*HTML content of the relay. Type: string*/
                              'html_message'=>''
							  /*Text content of the relay. Type: string*/
                              ,'text_message'=>''
							  /*Track the opens in the HTML version. Type: string - possible value 'true', 'false'*/
                              ,'track_opening'=>''
							  /*Track the clicks in the HTML version. Type: string - possible value 'true', 'false'*/
                              ,'track_clicks_in_html'=>''
							  /*Track the clicks in the text version. Type: string - possible value 'true', 'false'*/
                              ,'track_clicks_in_text'=>''
							  /*Headers of the relay. Type: array of headers*/
                              ,'data'=>''
							  /*ID for tracking purposes. Type: integer*/
                              ,'tracking_id'=>''
							  /*Client ID of the client in which the relay is located. Type: integer*/
                              ,'client_id'=>''
							  );
   $_Params['Path']='/Relay/Send/';
   $_Action_Found=true;
   break;
   
   case 'Relay_GetLogs':
   $_Params['Requires']=array( 
                              /*User Key of the user who initiates the call. Type: string*/
                              'user_key'=>''							  							 
							 );
   $_Params['Optionals']=array( 
                              /*ID for tracking purposes. Type: integer*/
                              'tracking_id'=>''							  
							  /*Filter using the log type. Type: string - possible value 'sent', 'bounce', 'open', 'clickthru'*/
                              ,'log_type'=>''
							  /*Filter using a start date. Type: date - yyyy-mm-dd hh:mm:ss*/
                              ,'start_time'=>''
							  /*Filter using a end date. Type: date - yyyy-mm-dd hh:mm:ss*/
                              ,'end_time'=>''
							  /*Limit the number of resulting log items. Type: integer*/
                              ,'limit'=>''
							  /*Offset the beginning of resulting log items. Type: integer*/
                              ,'offset'=>''
							  /*Return the number of log items. Type: string - possible value 'true', 'false'*/
                              ,'count'=>''
							  /*Client ID of the client in which the relay is located. Type: integer*/
                              ,'client_id'=>''
							  );
   $_Params['Path']='/Relay/GetLogs/';
   $_Action_Found=true;
   break;
   
   //Client API Params
   case 'Client_GetTimezones':  
    $_Params['Path']='/Client/GetTimezones/';
    $_Action_Found=true;
   break;   
   case 'Client_Create':
    $_Params['Requires']=array(
                              /*ID of the parent client. Type: integer*/ 								  
                              'parent_id'=>''
							  /*Name of the client. Type: string*/ 	
							, 'company_name'=>''
							  /*Address of the client. Type: string*/
							, 'address1'=>''
							  /*City of the client. Type: string*/
							, 'city'=>''
							  /*Postal code of the client. Type: string*/ 
							, 'postal_code'=>''
							  /*ID of the country of the client. Type: integer*/ 
							, 'country_id'=>''
							  /*Email address of the admin user. Type: string*/ 
							, 'admin_email'=>''
							  /*First name of the admin user. Type: string*/ 
							, 'admin_first_name'=>''
							  /*Last name of the admin user. Type: string*/ 
							, 'admin_last_name'=>''
							  /*Email address of the primary contact user. Type: string*/
							, 'contact_email'=>''
							  /*Last name of the primary contact user. Type: string*/
							, 'contact_last_name'=>''
							  /*First name of the primary contact user. Type: string*/
							, 'contact_first_name'=>'' 
							);
    $_Params['Optionals']=array(
	                           /*Address of the client. Type: string*/
                               'address2'=>''
							   /*ID of the province of the client. Type: integer*/ 
							 , 'province_id'=>''
							   /*Website URL of the client. Type: string*/
							 , 'website'=>''
							   /*Phone number of the client. Type: string*/
							 , 'phone'=>''
							   /*Fax number of the client. Type: string*/ 
							 , 'fax'=>''
							   /*Title of the admin user. Type: string*/ 
							 , 'admin_title'=>''
							   /*Office phone of the admin user. Type: string*/ 
							 , 'admin_office_phone'=>''
							   /*Mobile phone of the admin user. Type: string*/  
							 , 'admin_mobile_phone'=>''
							   /*Language of the admin user. Type: string - i.e. 'en_US' for English (US)*/  
							 , 'admin_language'=>''
							   /*ID of the timezone of the admin user. Type: integer*/  
							 , 'admin_timezone_id'=>''
							   /*Password of the admin user. Type: integer?????*/  
							 , 'admin_password'=>''
							   /*Password Confirmation of the admin user. Type: integer?????*/  
							 , 'admin_password_confirmation'=>''
							   /*Is the primary contact different from the admin user? Type: Type: string - possible value '0' => false, '1' => true*/
							 , 'contact_same_as_admin'=>''
							   /*Title of the primary contact user. Type: string*/
							 , 'contact_title'=>''
							   /*Office phone of the primary contact user. Type: string*/
							 , 'contact_office_phone'=>''
							   /*Mobile phone of the primary contact user. Type: string*/
							 , 'contact_mobile_phone'=>''
							   /*Language of the primary contact user. Type: string - i.e. en_US for English (US)*/
							 , 'contact_language'=>''
							   /*ID of the timezone of the primary contact user. Type: integer*/
							 , 'contact_timezone_id'=>''
							   /*Confirmation Password of the primary contact user. Type: integer*/
							 , 'contact_password_confirmation'=>''
							   /*Password of the primary contact user. Type: integer*/
							 , 'contact_password'=>''

                             , 'industry_id'=>''							 
							 );
    $_Params['Path']='/Client/Create/';
    $_Action_Found=true;	
   break;   
   
   case 'Client_Activate':  
    $_Params['Path']='/Client/Activate/';
	$_Params['Requires']=array(/*Confirmation code returned by the Create method. Type: string*/'confirmation'=>'');
    $_Action_Found=true;
   break;  
   
   case 'Client_GetInfo':  
    $_Params['Path']='/Client/GetInfo/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   );
	$_Params['Optionals']=array( 
	                           /*ID of the client. Type: integer*/
							   'client_id'=>''
							   /*Start date to return stats about the client. Type: date - yyyy-mm-dd hh:mm:ss*/
							 , 'start_date'=>'' 
							 /*End date to return stats about the client. Type: date - yyyy-mm-dd hh:mm:ss*/
							 , 'end_date'=>''
                             /*Confirmation code to get the information of a pending client. Type: string*/
							 , 'confirmation'=>''
							   );						   
    $_Action_Found=true;
   break;  
   
   case 'Client_GetList':  
    $_Params['Path']='/Client/GetList/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   );
	$_Params['Optionals']=array( 
	                           /*ID of the client. Type: integer*/
							   'client_id'=>''
							   /*Filter using the client status. Type: string - possible value 'all', 'pending', 'trial', 'active', 'suspended_all'*/
							 , 'status'=>'' 
							 /*Filter using the client name. Type: string*/
							 , 'company_name'=>''
                             /*Sort resulting clients. ype: string - possible value 'company_name', 'registered_date', 'mailing_limit', 'month_limit', 'contact_limit', 'last_activity'*/
							 , 'sort_by'=>''
                             /*Direction of the sorting. Type: string - possible value 'asc', 'desc'*/
							 , 'direction'=>''
                             /*Limit the number of resulting clients. Type: integer*/
							 , 'limit'=>''							 
							 /*Offset the beginning of resulting clients. Type: integer*/
							 , 'offset'=>''
							 /*Return the number of clients. Type: string - possible value 'true', 'false'*/
							 , 'count'=>''
							 /*Return all sub accounts recursively. Type: string - possible value 'true', 'false'*/
							 , 'recursive'=>''
							   );						   
    $_Action_Found=true;
   break;
    case 'Client_SetInfo':  
    $_Params['Path']='/Client/SetInfo/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   );
	$_Params['Optionals']=array( 
	                           /*ID of the client. Type: integer*/
							   'client_id'=>''
							   /*Name of the client. Type: string*/ 	
							, 'company_name'=>''
							  /*Address of the client. Type: string*/
							, 'address1'=>''
							  /*City of the client. Type: string*/
							, 'city'=>''
							  /*Postal code of the client. Type: string*/ 
							, 'postal_code'=>''
							  /*ID of the country of the client. Type: integer*/ 
							, 'country_id'=>''
							  /*Address of the client. Type: string*/
                            , 'address2'=>''
							   /*ID of the province of the client. Type: integer*/ 
							 , 'province_id'=>''
							   /*Website URL of the client. Type: string*/
							 , 'website'=>''
							   /*Phone number of the client. Type: string*/
							 , 'phone'=>''
							   /*Fax number of the client. Type: string*/ 
							 , 'fax'=>''
							 /*Per campaign limit of the client. Type: integer*/ 
							 , 'mailing_limit'=>''
							 /*Monthly emails sent limit of the client. Type: integer*/ 
							 , 'month_limit'=>''
							 /*Number of contacts limit of the client. Type: integer*/ 
							 , 'contact_limit'=>''
							 /*Is the client a reseller? Type: string - possible value 'true', 'false'*/ 
							 , 'reseller'=>''
							 /*Status of the client. Type: string - possible value 'trial', 'active', 'suspended_by_reseller', 'deleted'*/ 
							 , 'status'=>''
							 , 'industry_id'=>''
							   );						   
    $_Action_Found=true;
   break;
   
   //Mailing API Params (A mailing is an email campaign. It can be used to send standard email campaigns, A/B split campaigns or recurring campaigns.)
   case 'Mailing_Create':  
    $_Params['Path']='/Mailing/Create/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   );
	$_Params['Optionals']=array( 
	                           /*Name of the mailing. Type: string*/
							   'name'=>''							   
							   /*ID of the campaign you want to associate the mailing with. Type: integer*/ 	
							, 'campaign_id'=>''
							   /*Type of the mailing. Type: string - possible value 'standard', 'recurring', 'absplit'*/ 	
							, 'type'=>''  
							   /*ID of the first recurrence in case of a 'recurring' or 'absplit' mailing. Type: integer*/ 	
							, 'recurring_id'=>'' 
                               /*Encoding to be used for the mailing. Type: string - possible value 'utf-8', 'iso-8859-x'*/
							, 'encoding'=>''
							   /*Transfer encoding to be used for the mailing. Type: string - possible value 'quoted-printable', 'base64'*/
							, 'transfer_encoding'=>''
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							, 'client_id'=>''
							   );						   
    $_Action_Found=true;
   break;
   
   case 'Mailing_Delete':  case 'Mailing_Unschedule': case 'Mailing_Suspend':  
    $_Params['Path']='/Mailing/'. explode('_',$an_Action)[1] .'/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   /*ID of the mailing. Type: integer*/ 	
							 , 'mailing_id'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   );						   
    $_Action_Found=true;
   break;
   
   case 'Mailing_Schedule':  
    $_Params['Path']='/Mailing/Schedule/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   /*ID of the mailing. Type: integer*/ 	
							 , 'mailing_id'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   /*Date when the mailing is scheduled. If not provided, the mailing will be sent right away. Type: date - yyyy-mm-dd hh:mm:ss*/
							 , 'date'=>''
							   );						   
    $_Action_Found=true;
   break;   
   
   //List API Params (A List is a collection of subscribers (or List Members, or Records). Each subscriber or List Member is uniquely identified by their email address, and may include an limited amount of Fields containing demographic information associated to each email address.)
   case 'List_Create':  
    $_Params['Path']='/List/Create/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   /*Name of the list. Type: string*/ 	
							 , 'name'=>''
							   /*Name of the default sender of the list. Type: string*/ 	
							 , 'sender_name'=>''
                               /*Email of the default sender of the list. Type: string*/ 	
							 , 'sender_email'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   /*Accept the anti-spam policy for this list. Type: string - possible value 'accepted', 'declined'*/ 	
							 , 'list_policy'=>''
							   );						   
    $_Action_Found=true;
   break;
   
   case 'List_GetList':  
    $_Params['Path']='/List/GetList/';
	$_Params['Requires']=array( 
	                           
							   'user_key'=>''
							   
							   );
	$_Params['Optionals']=array(                
							   
							   'client_id'=>''
							   
							 , 'status'=>''/*Filter using the list status. Type: string - possible value 'active', 'archived'*/
							 
							 , 'name'=>''
							 
							 , 'sort_by'=>''/*Sort resulting lists. Type: string - possible value 'name', 'created_on', 'active_members_count'*/
							 
							 , 'direction'=>''
							 
							 , 'limit'=>''
							 
							 , 'offset'=>''
							 
							 , 'count'=>''
							 
							 , 'no_details'=>''/*Do not retrieve all the stats for the list.Type: string - possible value 'true', 'false'*/
							 
							 , 'with_engagement'=>''
							   );						   
    $_Action_Found=true;
   break;
   
   case 'List_Show':  
    $_Params['Path']='/List/Show/';
	$_Params['Requires']=array( 	                           
							   'user_key'=>''							   
							 , 'list_id'=>''
							   );
	$_Params['Optionals']=array(
							   'client_id'=>''/*Client ID of the client in which the list is located. Type: integer*/
							 , 'status'=>''/*Filter using the member status. Type: string - possible value 'active', 'unsubscribed', 'deleted', 'inactive_bounced', 'spam'*/
							 , 'sort_by'=>''/*Sort resulting members. Type: string - possible value 'id', 'email'*/
							 , 'direction'=>''/*Direction of the sorting. Type: string - possible value 'asc', 'desc'*/
							 , 'limit'=>''/*Limit the number of resulting members. Type: integer*/
							 , 'offset'=>''/*Offset the beginning of resulting members. Type: integer*/							
							 , 'count'=>''/*Return the number of members. Type: string - possible value 'true', 'false'*/
   						     , 'query'=>''/*Query to retrieve members from a segment. Type: string*/	 
							   );						   
    $_Action_Found=true;
   break;   
   
   case 'List_Delete':  
    $_Params['Path']='/List/Delete/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''							 
							   /*ID of the list. Type: integer*/
							 , 'list_id'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   );						   
    $_Action_Found=true;
   break;
   
   case 'List_SubscribeEmail':  
    $_Params['Path']='/List/SubscribeEmail/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''							 
							   /*ID of the list. Type: integer*/
							 , 'list_id'=>''
							   /*Email address of the member. Type: string*/
							 , 'email'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   /*Trigger the autoresponders. Type: string - possible value 'true', 'false'*/
							 , 'autoresponders'=>'false'
							   /*Trigger the welcome email. Type: string - possible value 'true', 'false'*/
							 , 'triggers'=>'false'
							   /*Additional data for the member. Type: array of fields and values - i.e. array('firstname' => 'John')
							 , 'data'=>''*/
							   );						   
    $_Action_Found=true;
   break;
   case 'List_Import':  
    $_Params['Path']='/List/Import/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''							 
							   /*ID of the list. Type: integer*/
							 , 'list_id'=>''
							   /*Email address of the member. Type: string*/
							 , 'record'=>array()//'email'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   /*Trigger the autoresponders. Type: string - possible value 'true', 'false'*/
							 , 'autoresponders'=>'false'
							   /*Trigger the welcome email. Type: string - possible value 'true', 'false'*/
							 , 'triggers'=>'false'							   
							 , 'import_to'=>'active'
							   );						   
    $_Action_Found=true;
   break;
   case 'List_SetInfo':  
    $_Params['Path']='/List/SetInfo/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''							 
							   /*ID of the list. Type: integer*/
							 , 'list_id'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   
							 , 'policy'=>'accepted'
							 
							   );						   
    $_Action_Found=true;
   break;
   case 'List_UnsubscribeEmail':  
    $_Params['Path']='/List/UnsubscribeEmail/';
	$_Params['Requires']=array( 
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''							 
							   /*ID of the list. Type: integer*/
							 , 'list_id'=>''
							   /*Email address of the member. Type: string*/
							 , 'email'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   );						   
    $_Action_Found=true;
   break;
   
   //A Campaign is a group of Mailings and can be seen as a folder.
   case 'Campaign_Create':  
    $_Params['Path']='/Campaign/Create/';
	$_Params['Requires']=array(
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   /*Name of the campaign. Type: string*/
							 , 'name'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   );						   
    $_Action_Found=true;
   break;
    
   case 'Campaign_Delete':  
    $_Params['Path']='/Campaign/Delete/';
	$_Params['Requires']=array(
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   /*ID of the campaign to delete. Type: integer*/
							 , 'campaign_id'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   );						   
    $_Action_Found=true;
   break;
   
   //A User is an individual associated to a Client. A User has access to a single Account.
   case 'User_Create':  
    $_Params['Path']='/User/Create/';
	$_Params['Requires']=array(
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							   /*Email address of the user. Type: string*/
							 , 'email'=>''
							   /*First name of the user. Type: string*/
							 , 'first_name'=>''
							   /*Last name of the user. Type: string*/
							 , 'last_name'=>''							 
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   /*Title of the user. Type: string*/
							 , 'title'=>''
							   /*Office phone number of the user. Type: string*/
							 , 'office_phone'=>''
							   /*Mobile phone number of the user. Type: string*/
							 , 'mobile_phone'=>'' 
							   /*Language of the user. Type: string - i.e. 'en_US' for English (US)*/
							 , 'language'=>'' 
							   /*ID of the timezone of the user. Type: integer*/
							 , 'timezone_id'=>''
							   /*Password of the user. Type: integer*/
							 , 'password'=>''
							   /*Password confirmation of the user. Type: integer*/
							 , 'password_confirmation'=>''
							   );						   
    $_Action_Found=true;
   break;
   
    case 'User_SetInfo':  
    $_Params['Path']='/User/SetInfo/';
	$_Params['Requires']=array(
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							 , 'user_id'=>''							   							   
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''
							   /*Title of the user. Type: string*/
							 , 'title'=>''
							   /*Office phone number of the user. Type: string*/
							 , 'office_phone'=>''
							   /*Mobile phone number of the user. Type: string*/
							 , 'mobile_phone'=>'' 
							   /*Language of the user. Type: string - i.e. 'en_US' for English (US)*/
							 , 'language'=>'' 
							   /*ID of the timezone of the user. Type: integer*/
							 , 'timezone_id'=>''
							   /*Password of the user. Type: integer*/
							 , 'password'=>''
							   /*Password confirmation of the user. Type: integer*/
							 , 'password_confirmation'=>''
							 /*Email address of the user. Type: string*/
							 , 'email'=>''
							   /*First name of the user. Type: string*/
							 , 'first_name'=>''
							   /*Last name of the user. Type: string*/
							 , 'last_name'=>''
							   );						   
    $_Action_Found=true;
	
   break;
   
   case 'User_GetInfo':  
    $_Params['Path']='/User/GetInfo/';
	$_Params['Requires']=array(
	                           /*User Key of the user who initiates the call. Type: string*/
							   'user_key'=>''
							 , 'user_id'=>''
							   );
	$_Params['Optionals']=array(                
							   /*Client ID of the client in which the mailing is created. Type: integer*/
							   'client_id'=>''							   
							   );						   
    $_Action_Found=true;
   break;
   
   case 'User_Login':  
    $_Params['Path']='/User/Login/';
	$_Params['Requires']=array(
	                           /*Password of the user. Type: string*/
							   'password'=>''
							   /*Email address of the user. Type: string*/
							 , 'email'=>''
                               /*ID of the client to check for the login. Type: integer*/
							 , 'client_id'=>''							 
							   );					   
    $_Action_Found=true;
   break;
  }
  
  if ($_Action_Found){
   //getting require params for the action
   foreach ($_Params['Requires'] as $Key=>$Value){
    if ( array_key_exists ( $Key , $_CakeMail_Params ) ){
	 $_Params['Requires'][$Key]=$_CakeMail_Params[$Key];
	 //unset($_CakeMail_Params[$Key]);
	}
	else { return "The Param {$Key} is required to complete this API call."; }
   }

   //getting optional params for the action
   foreach ($_CakeMail_Params as $Key=>$Value){
    if ( array_key_exists ( $Key , $_Params['Optionals'] ) ){
	 $_Params['Optionals'][$Key] = $_CakeMail_Params[$Key];
	}	
   }
   
   if ($remove_Empty_Optionals) $_Params['Optionals'] = array_filter($_Params['Optionals'], function($val) { return $val != ''; });
   
   //echo $an_Action . ': <br>'; var_dump($_Params['Optionals']);
   
   return $_Params;
   
  }
  
  return "Invalid action: {$an_Action}";  
 }
 
 function call_API($_CakeMail_Action, $_CakeMail_Params, $remove_Empty_Optionals = false){
  $_Params=$this->get_Params($_CakeMail_Action, $_CakeMail_Params, $remove_Empty_Optionals);
  if ( isset($_Params['Path'], $_Params['Requires'], $_Params['Optionals']) ){ return $this->call($_Params['Path'], array_merge($_Params['Requires'], $_Params['Optionals'])); }
  else{ return $_Params; }
 }
 
 function get_Account(&$_Result, $ltm_id, $dbo){
  $_Result=array();
  if ($stmt = $dbo->prepare("
	SELECT DISTINCT CML.*, MMC.*, MRC.*, (CASE WHEN CAT.cat_parent_id IS NULL OR CAT.cat_parent_id=0 THEN CAT.cat_id ELSE CAT.cat_parent_id END) AS cat_id
	FROM lt_member_merchants MMC
	INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id
	INNER JOIN lt_m2cat M2C ON MRC.ltb_id=M2C.ltb_id
	INNER JOIN tbl_category CAT ON CAT.cat_id=M2C.cat_id
	LEFT JOIN tbl_cakemail_login CML ON CML.ltm_id=MRC.ltm_id 
	WHERE MRC.ltm_id=:ltmid AND ltm_active LIMIT 1")){
	 $stmt->bindValue(":ltmid", $ltm_id, PDO::PARAM_INT);
	 $stmt->execute();
	 if ($_Result = $stmt->fetch( PDO::FETCH_ASSOC )){
	  return true;
	 }
	}
  return false;
 }
}

/*

require 'class.cakemail.php';
try {
    $CakeAPI = new CakeAPI('YourApiKey');
    
     Pass the params to the API as a string with the /Class/Method you want and an array with the parameters.
        In case you need to parse an array that one of the params is another array, do so like you would do normally: 
        
        array(
            'param1' => 'some value', 
            'param2' => array(
                'first_name' => 'Your Name',
                'last_name' => 'Last Name'
            )
        );
   
    var_dump($CakeAPI->call('/User/login', array('email' => 'some@email.com', 'password' => 'abcd1234')));
    
} catch (Exception $e) {
    echo $e->getMessage();
}

*/
