<?php
namespace App\MemberMerchant\Store\Consumer {
	
	use App\Jwt as Jwt;
	
	require_once "class.variables.php";
	require_once "class.jwt.php";
	
	class storeConsumer {
		//Private Properties
		private $cDbo=null;
		
		//protected properties
		protected $consumerRecords = array();
		protected $currentConsumerId=0;
		protected $validDataErrors = array();
		
		//protected functions
		protected function validData(&$cleanData, $fieldValue, $fileType='wnu_ltb_id_r' ){
			$_tempArr = is_array($fileType) && is_array($fieldValue)? $fieldValue : array( $fileType => $fieldValue );
			$cv= new \_variables($_tempArr); // new instance
			$cv_array=is_array($fileType) ? $fileType : array($fileType); //list all varibles to be check in array
			foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
			$clean=$cv->get_cleaned_variables();
			$this->validDataErrors=$cv->get_bad_variables();
			 
			if (!count($this->validDataErrors)) {
				$cleanData = $clean;
				return true;								
			}
			//var_dump($cleanData);
			return false;
		}
		
		//public properties
		public $totalCount = array();	
		
		//private functions
		private function loadRecords( $anId, $fieldName = 'csm_id', $tableName = 'CSM', $fieldType = \PDO::PARAM_INT, $cleanRecords = false, $justActives = true ) {
			if ($cleanRecords) {
				$this->consumerRecords = array();
			}
			
			$stmt = $this->cDbo->prepare("
			SELECT MMR.*, MRC.*, CSM.*, DATE_FORMAT(CSM.csm_add_date,'%c/%d/%Y') as date_joined
			FROM tbl_consumer CSM
			INNER JOIN lt_merchants MRC ON CSM.ltm_pick_id = MRC.ltm_id
			INNER JOIN lt_member_merchants MMR ON MMR.ltb_id = MRC.ltb_id
			WHERE {$tableName}.{$fieldName}=:Id
			".($justActives? "AND CSM.csm_active = 1 AND CSM.csm_id <> 1":"")."
			ORDER BY CSM.csm_id LIMIT 1".(strcmp($fieldName, 'csm_id') === 0  && strcmp($tableName, 'CSM') === 0?"":"00")."
			");
			$stmt->bindValue(":Id", $anId, $fieldType);
			$stmt->execute();
			while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				$this->consumerRecords[$resultSet['csm_id']] = $resultSet;						
				$this->currentConsumerId = $resultSet['csm_id'];
			}
			return $this->consumerRecords;
		}
		
		private function getTotalCount($ltmId) {
			$stmt = $this->cDbo->prepare("
			SELECT COUNT(CSM.csm_id) AS Total_Count
			FROM tbl_consumer CSM
			INNER JOIN lt_merchants MRC ON CSM.ltm_pick_id = MRC.ltm_id
			WHERE MRC.ltm_id=:Id AND CSM.csm_active = 1 AND CSM.csm_id <> 1");
			$stmt->bindValue(":Id", $ltmId, \PDO::PARAM_INT);
			$stmt->execute();
			$this->totalCount[$ltmId] = 0;
			if ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				$this->totalCount[$ltmId] = $resultSet['Total_Count'];
			}			
			return $this->totalCount[$ltmId];
		}
		
		private function signUp ($requestArr, &$errorArr, &$tokenVal, $dataChecked=false, $sendWelcomeEmail = false) {
			if (!isset($errorArr)) $errorArr = array();
			if (!isset($tokenVal)) $tokenVal = "";
			if (
				isset($requestArr['Email'], 
				$requestArr['Password'],
				$requestArr['First_Name'], 
				$requestArr['Last_Name'],
				$requestArr['Longitude'],
				$requestArr['Latitude'],
				$requestArr['Zipcode'])
			) {	
				$arrayKeys = array(
									'ema_Email_r', 
									'psw_Password_r', 
									'nam_First_Name_r', 
									'nam_Last_Name_r',
									'dec_Longitude_r',
									'dec_Latitude_r',
									'zip_Zipcode_r',
									'wnu_Merchant_Id'
								);
				if (isset($requestArr['Phone'])) {
					array_push($arrayKeys, 'pho_Phone_r');
					$requestValue['pho_Phone_r'] = $requestArr['Phone'];
				}
				elseif (isset($requestArr['Messages_Accepted']) && $requestArr['Messages_Accepted'] == 1) {					
					$errorArr = array('Phone is a required field.');
					return false;
				}
				
				if ( isset($requestArr['Merchant_Id']) ) {
					$requestValue['wnu_Merchant_Id'] = $requestArr['Merchant_Id'];					
				}
				else {
					$requestValue['wnu_Merchant_Id'] = '1';
				}
				
				$requestValue['ema_Email_r']      = $requestArr['Email']; 
				$requestValue['psw_Password_r']   = $requestArr['Password'];
				$requestValue['nam_First_Name_r'] = $requestArr['First_Name']; 
				$requestValue['nam_Last_Name_r']  = $requestArr['Last_Name'];
				$requestValue['dec_Longitude_r']  = $requestArr['Longitude'];
				$requestValue['dec_Latitude_r']   = $requestArr['Latitude'];
				$requestValue['zip_Zipcode_r']    = $requestArr['Zipcode'];
	
				if ( $this->validData($cleanData, $requestValue, $arrayKeys ) /*not user exists with that email*/ ) {	
					if ( intval($cleanData['Merchant_Id']) > 1 ) {
						//checking for that merchant existence
						$stmt = $this->cDbo->prepare("SELECT ltm_id FROM lt_merchants WHERE ltm_id=:ltmid AND ltm_active = 1 LIMIT 1");
						$stmt->bindValue(":ltmid", $cleanData['Merchant_Id'], \PDO::PARAM_STR);
						$stmt->execute();
						if ( !( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) ) {
							$errorArr = array('The merchant was not found.');
							return false;
						}
					}	
					
					require_once 'model/crypt.php';
					$crypt   = new \Crypt( $cleanData['Email'] );
					$cryptck = $crypt->encode( $cleanData['Password'] );					
					$tmpRec = $this->loadRecords( $cleanData['Email'], 'csm_email', 'CSM', \PDO::PARAM_STR, true, false );
					if ( empty( $tmpRec ) ) {
						//Good to go
						$stmt = $this->cDbo->prepare("
						INSERT IGNORE INTO tbl_consumer 
							(
								csm_added_by, 
								csm_first_name, 
								csm_last_name, 
								csm_email, 
								csm_password, 
								csm_cell_number, 
								csm_add_date, 
								csm_last_login, 
								csm_lat, 
								csm_long, 
								csm_zip, 
								ltm_id, 
								ltm_pick_id
							) 
							VALUES 
							(
								'mobile', 
								:fname,
								:lname,
								:email,
								:pass,
								:phone,
								NOW(),
								NOW(),
								:lat,
								:long,
								:zip,
								:ltmid,
								:ltmpid
							)");						
						
						$stmt->bindValue(":fname", $cleanData['First_Name'], \PDO::PARAM_STR);
						$stmt->bindValue(":lname", $cleanData['Last_Name'], \PDO::PARAM_STR);
						$stmt->bindValue(":email", $cleanData['Email'], \PDO::PARAM_STR);
						$stmt->bindValue(":pass", $cryptck, \PDO::PARAM_STR);
						$stmt->bindValue(":phone", isset($cleanData['Phone'])? $cleanData['Phone']: null, \PDO::PARAM_STR);
						$stmt->bindValue(":lat", $cleanData['Latitude'], \PDO::PARAM_STR);
						$stmt->bindValue(":long", $cleanData['Longitude'], \PDO::PARAM_STR);
						$stmt->bindValue(":zip", $cleanData['Zipcode'], \PDO::PARAM_STR);						
						$stmt->bindValue(":ltmid", $cleanData['Merchant_Id'], \PDO::PARAM_STR);
						$stmt->bindValue(":ltmpid", $cleanData['Merchant_Id'], \PDO::PARAM_STR);		
						$stmt->execute();
						
						if ($sendWelcomeEmail) {
							/*
								if ((isset($_REQUEST['send_email']) && $_REQUEST['send_email'] == '1') || !isset($_REQUEST['send_email'])){
									// welcome email
									$ema_body = file_get_contents('../mail/localthanks/website/consumer_welcome/consumer_welcome.html');
									$ema_email = $request['email'];
									$ema_ltm_id = $request['su_merchant_id'];
									include '../app/build-email.php';
									$to       = $ema_email;
									$subject  = 'Welcome to Local Thanks!';
									$message  = $ema_body;
									$headers  = "From: noreply@localthanks.com\r\n";
									$headers .= "Reply-To: noreply@localthanks.com\r\n";
									$headers .= "MIME-Version: 1.0\r\n";
									$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
									mail($to, $subject, $message, $headers);
								}						
							*/
						}
						
						return $this->logIn($cleanData, $errorArr, $tokenVal, true, true);
						
					}
					else {
						$errorArr = array('User already exists');
						return false;
					}					
				}
				else {
					$errorArr = $this->validDataErrors;//array('Incorrect Request Fields');
					return false;
				}
			}			
			else{
				$errorArr = array('Missing Fields');
				return false;
			}
		}
		
		private function tokenGenerate ($userRec) {
			$tokenVal = '';
			if (isset($userRec[$this->currentConsumerId]['csm_id'], $userRec[$this->currentConsumerId]['csm_password'])) {
				$userTokenKey = uniqid();
				$upd = $this->cDbo->prepare( "UPDATE `tbl_consumer` SET csm_device_token = :uTokenKey, csm_last_login=NOW()".($table == 'tbl_admin'? ", adm_last_activity = CURRENT_TIMESTAMP":"")." WHERE csm_id=:id LIMIT 1" );
				$upd->bindValue( ":id", $userRec[$this->currentConsumerId]['csm_id'], \PDO::PARAM_INT );
				$upd->bindValue( ":uTokenKey", $userTokenKey, \PDO::PARAM_STR );
				$upd->execute();
				
				$payload['uid'] = $userRec[$this->currentConsumerId]['csm_id'];						
				$payload['iss'] = "Localthanks";
				$payload['sub'] = "Login Token";
				$payload['aud'] = "App";
				$payload['exp'] = time();
				
				$tokenVal = Jwt\Jwt::encode($payload, $userTokenKey.$userRec[$this->currentConsumerId]['csm_password']);
			}
			return $tokenVal;
		}
		
		private function logIn($requestArr,  &$errorArr, &$tokenVal, $resetError=false, $dataChecked=false, $setSessions = true) {
			if (!isset($errorArr) || $resetError) $errorArr = array();
			if (!isset($tokenVal)) $tokenVal = "";
			
			if (
				isset($requestArr['Email'], 
				$requestArr['Password'])
			) {	
				$arrayKeys = array(
									'ema_Email_r', 
									'psw_Password_r'
								);				
				
				$requestValue['ema_Email_r']      = $requestArr['Email']; 
				$requestValue['psw_Password_r']   = $requestArr['Password'];
				
				if ( $this->validData($cleanData, $requestValue, $arrayKeys ) /*not user exists with that email*/ ) {	
					$tmpRec = $this->loadRecords( $cleanData['Email'], 'csm_email', 'CSM', \PDO::PARAM_STR, true );
					
					
					
					if ( isset( $tmpRec[$this->currentConsumerId]['csm_password'] ) ) {						
						
						require_once 'model/crypt.php';
						$crypt   = new \Crypt( $tmpRec[$this->currentConsumerId]['csm_email'] );
						$cryptck = $crypt->decode( $tmpRec[$this->currentConsumerId]['csm_password'] );
						
						if( $cleanData['Password'] != $cryptck ) { 
							$errorArr = array( 'Invalid Password. Please Try Again' );
							return false;
						}
						
						//user ok, loggin him in
						$tokenVal = $this->tokenGenerate ($tmpRec);						
						return array('Id' => $tmpRec[$this->currentConsumerId]['csm_id'], 'Email' => $tmpRec[$this->currentConsumerId]['csm_email'], 'First_Name'=>$tmpRec[$this->currentConsumerId]['csm_first_name'], 'Last_Name'=>$tmpRec[$this->currentConsumerId]['csm_last_name'], 'Zipcode'=>$tmpRec[$this->currentConsumerId]['csm_zip']);
									
					}
					else {
						$errorArr = array('User account not found');
						return false;
					}					
				}
				else {
					$errorArr = $this->validDataErrors;//array('Incorrect Request Fields');
					return false;
				}
			}
			
			else{
				$errorArr = array('Missing Fields');
				return false;
			}
			
		}
		
		private function updateUserFromAPI ($csmId, $userData) {
			$arrayKeys = array(); $requestValue= array(); $qStr = '';
			
			if (isset($userData['First_Name'])) {
				array_push($arrayKeys, 'nam_First_Name_r');
				$requestValue['nam_First_Name_r'] = $userData['First_Name'];
				$qStr = ' csm_first_name =:fname';
			}			
			if (isset($userData['Last_Name'])) {
				array_push($arrayKeys, 'nam_Last_Name_r');
				$requestValue['nam_Last_Name_r'] = $userData['Last_Name'];
				$qStr .= (empty($qStr)? '': ',') . ' csm_last_name =:lname';
			}
			if (isset($userData['Zipcode'])) {
				array_push($arrayKeys, 'zip_Zipcode_r');
				$requestValue['zip_Zipcode_r'] = $userData['Zipcode'];
				$qStr .= (empty($qStr)? '': ',') . ' csm_zip =:zip';
			}
			if (isset($userData['Longitude'])) {
				array_push($arrayKeys, 'dec_Longitude_r');
				$requestValue['dec_Longitude_r'] = $userData['Longitude'];
				$qStr .= (empty($qStr)? '': ',') . ' csm_long =:long';
			}
			if (isset($userData['Latitude'])) {
				array_push($arrayKeys, 'dec_Latitude_r');
				$requestValue['dec_Latitude_r'] = $userData['Latitude'];
				$qStr .= (empty($qStr)? '': ',') . ' csm_lat =:lat';
			}
			if (isset($userData['Phone'])) {
				array_push($arrayKeys, 'pho_Phone_r');
				$requestValue['pho_Phone_r'] = $userData['Phone'];
				$qStr .= (empty($qStr)? '': ',') . ' csm_cell_number =:phone';
			}
			if (isset($userData['UDID'])) {
				array_push($arrayKeys, 'adn64_UDID_r');
				$requestValue['adn64_UDID_r'] = $userData['UDID'];
			}
			
			if (empty($arrayKeys) || empty($requestValue) || !$this->validData($cleanData, $requestValue, $arrayKeys )) return false;
			else{
				$stmt = $this->cDbo->prepare("
							UPDATE tbl_consumer SET
								{$qStr}
							WHERE csm_id =:id
						");						
				$stmt->bindValue(":id", $csmId, \PDO::PARAM_INT);
			
				if (isset($userData['First_Name'])) {
					$stmt->bindValue(":fname", $cleanData['First_Name'], \PDO::PARAM_STR);
				}			
				if (isset($userData['Last_Name'])) {
					$stmt->bindValue(":lname", $cleanData['Last_Name'], \PDO::PARAM_STR);
				}
				if (isset($userData['Zipcode'])) {
					$stmt->bindValue(":zip", $cleanData['Zipcode'], \PDO::PARAM_STR);
				}
				if (isset($userData['Longitude'])) {
					$stmt->bindValue(":long", $cleanData['Longitude'], \PDO::PARAM_STR);
				}
				if (isset($userData['Latitude'])) {
					$stmt->bindValue(":lat", $cleanData['Latitude'], \PDO::PARAM_STR);
				}
				if (isset($userData['Phone'])) {
					$stmt->bindValue(":phone", isset($cleanData['Phone'])? $cleanData['Phone']: null, \PDO::PARAM_STR);
				}		
				$stmt->execute();
				
				if (isset($cleanData['UDID'])) {
					$stmt = $this->cDbo->prepare("
						INSERT IGNORE INTO tbl_device (csm_id, dvc_udid) VALUES (:id, :udid)
					");	
					$stmt->bindValue(":id", $csmId, \PDO::PARAM_INT);					
					$stmt->bindValue(":udid", $cleanData['UDID'], \PDO::PARAM_STR);												
					$stmt->execute();
				}	
				return true;
			}
		}
		
		private function renewToken($loginToken, $urlUserId) {
			$loginTokenArr = explode(' ', $loginToken);
			if (is_array($loginTokenArr) && count($loginTokenArr) == 2) {						
				Jwt\Jwt::decode($loginTokenArr[1], 'temporary', array('HS384', 'HS512', 'HS256'), $err, false);				
				$tokenVal = Jwt\Jwt::$payload;
				if ( isset($tokenVal->uid) && $urlUserId == $tokenVal->uid) {					
					$resUser = $this->loadRecords($tokenVal->uid, 'csm_id', 'CSM', \PDO::PARAM_INT, true, true);
					if (isset($resUser[$tokenVal->uid]['csm_password'], $resUser[$tokenVal->uid]['csm_device_token']))
						$tokenVal = Jwt\Jwt::decode($loginTokenArr[1], $resUser[$tokenVal->uid]['csm_device_token'].$resUser[$tokenVal->uid]['csm_password'], array('HS384', 'HS512', 'HS256'), $err);
					if ( isset($err[0]) && strcmp('Expired token', $err[0]) === 0 ) {
						return $this->tokenGenerate ($resUser);
					}
				}
			}
			return '';
		}
		
		//public functions
		function getUserFromToken ($loginToken, &$tokenExpired) {
			$loginTokenArr = explode(' ', $loginToken); $tokenExpired = false;
			if (is_array($loginTokenArr) && count($loginTokenArr) == 2) {
				$tokenVal = Jwt\Jwt::decode($loginTokenArr[1], 'temporary', array('HS384', 'HS512', 'HS256'), $err, false);				
				if ( isset($tokenVal->uid) ) {
					$resUser = $this->loadRecords($tokenVal->uid, 'csm_id', 'CSM', \PDO::PARAM_INT, true, true);	
					if (isset($resUser[$tokenVal->uid]['csm_password'], $resUser[$tokenVal->uid]['csm_device_token']))
						$tokenVal = Jwt\Jwt::decode($loginTokenArr[1], $resUser[$tokenVal->uid]['csm_device_token'].$resUser[$tokenVal->uid]['csm_password'], array('HS384', 'HS512', 'HS256'), $err);					

					if ($tokenVal !== false) {						
						return array('Id' => $resUser[$tokenVal->uid]['csm_id'], 'Email' => $resUser[$tokenVal->uid]['csm_email'], 'First_Name'=>$resUser[$tokenVal->uid]['csm_first_name'], 'Last_Name'=>$resUser[$tokenVal->uid]['csm_last_name'], 'Zipcode'=>$resUser[$tokenVal->uid]['csm_zip']);
					}					
				}
				if (isset($err[0]) && strcmp('Expired token', $err[0])) {$tokenExpired = true;}
			}
			return array();
		}
		
		private function restPassword($requestArr, &$errorArr, &$tokenVal) {
			if (!isset($errorArr) || $resetError) $errorArr = array();
			
			
			if (
				isset($requestArr['Email'])
			) {	
				$arrayKeys = array(
									'ema_Email_r'
								);				
				
				$requestValue['ema_Email_r']      = $requestArr['Email']; 
				
				$action = 'send-email';
				
				if ( isset($requestArr['Password'], $requestArr['Code']) ) {
					array_push($arrayKeys, 'psw_Password_r', 'wnu7_Code_r');
					$requestValue['psw_Password_r']   = $requestArr['Password'];
					$requestValue['wnu7_Code_r'] = $requestArr['Code'];
					$action = 'reset-password';
				}
				
				if ( $this->validData($cleanData, $requestValue, $arrayKeys ) /*not user exists with that email*/ ) {	
					$tmpRec = $this->loadRecords( $cleanData['Email'], 'csm_email', 'CSM', \PDO::PARAM_STR, true );					
					
					if ( isset( $tmpRec[$this->currentConsumerId]['csm_id'] ) ) {						
						switch ($action) {
							case 'reset-password':
							
								$stmt = $this->cDbo->prepare("
									DELETE FROM lt_member_login_reset WHERE llr_uid = :llruid AND csm_id = :id AND llr_email = :uemail
								");
								
								$stmt->bindValue(":id", $tmpRec[$this->currentConsumerId]['csm_id'], \PDO::PARAM_INT);					
								$stmt->bindValue(":uemail", $tmpRec[$this->currentConsumerId]['csm_email'], \PDO::PARAM_STR);												
								$stmt->bindValue(":llruid", $cleanData['Code'], \PDO::PARAM_STR);	
								$stmt->execute();
								
								if ($stmt->rowCount() == 0) {
									$errorArr = array('The pair code-email was not found');
									return false;
								}
								else {
									//good to change passwords
									require_once 'model/crypt.php';
									$crypt   = new \Crypt( $tmpRec[$this->currentConsumerId]['csm_email'] );
									$cryptck = $crypt->encode( $cleanData['Password'] );
									
									$stmt = $this->cDbo->prepare("
										UPDATE tbl_consumer SET csm_password = :passw WHERE csm_id = :id
									");	
									
									$stmt->bindValue(":id", $tmpRec[$this->currentConsumerId]['csm_id'], \PDO::PARAM_INT);
									$stmt->bindValue(":passw", $cryptck, \PDO::PARAM_STR);
									$stmt->execute();
									
									$tmpRec[$this->currentConsumerId]['csm_password'] = $cryptck;
									
									//user ok, loggin him in
									$tokenVal = $this->tokenGenerate ($tmpRec);
									return array('Id' => $tmpRec[$this->currentConsumerId]['csm_id'], 'Email' => $tmpRec[$this->currentConsumerId]['csm_email'], 'First_Name'=>$tmpRec[$this->currentConsumerId]['csm_first_name'], 'Last_Name'=>$tmpRec[$this->currentConsumerId]['csm_last_name'], 'Zipcode'=>$tmpRec[$this->currentConsumerId]['csm_zip']);
								}
								
							break;
							default: 
							/*send-email*/
								$code = mt_rand(10000,9999999);
								
								$stmt = $this->cDbo->prepare("
									UPDATE lt_member_login_reset SET llr_uid = :llruid WHERE csm_id = :id AND llr_email = :uemail
								");	
								$stmt->bindValue(":id", $tmpRec[$this->currentConsumerId]['csm_id'], \PDO::PARAM_INT);					
								$stmt->bindValue(":uemail", $tmpRec[$this->currentConsumerId]['csm_email'], \PDO::PARAM_STR);												
								$stmt->bindValue(":llruid", $code, \PDO::PARAM_STR);	
								$stmt->execute();
																
								if ($stmt->rowCount() == 0){
									$stmt = $this->cDbo->prepare("
										INSERT IGNORE INTO lt_member_login_reset (llr_uid,csm_id,llr_email) VALUES (:llruid, :id, :uemail)
									");	
									$stmt->bindValue(":id", $tmpRec[$this->currentConsumerId]['csm_id'], \PDO::PARAM_INT);					
									$stmt->bindValue(":uemail", $tmpRec[$this->currentConsumerId]['csm_email'], \PDO::PARAM_STR);												
									$stmt->bindValue(":llruid", $code, \PDO::PARAM_STR);	
									$stmt->execute();
								}
								
								$to       = $tmpRec[$this->currentConsumerId]['csm_email'];
								$subject  = 'Local Thanks Password Reset';
								$message  = 
											'User: ' . $cleanData['Email'] . "\r\n" .
											'Code: ' . $code . "\r\n\n" .
											'Thank you!' . "\r\n\n" . 
											'-- Local Thanks';	
								$headers  = 'From: noreply@loyaltysuperstore.com' . "\r\n" .											
											'X-Mailer: PHP/' . phpversion();

								//-------------------------
								// Send emails here.
								//-------------------------
								
								if( !mail( $to, $subject, $message, $headers ) ) {
									$errorArr = array('The email could not be sent');
									return false;
								}							
								else {
									return true;
								}
						}
						
						/*
						require_once 'model/crypt.php';
						$crypt   = new \Crypt( $tmpRec[$this->currentConsumerId]['csm_email'] );
						$cryptck = $crypt->decode( $tmpRec[$this->currentConsumerId]['csm_password'] );
						
						if( $cleanData['Password'] != $cryptck ) { 
							$errorArr = array( 'Invalid Password. Please Try Again' );
							return false;
						}
						
						//user ok, loggin him in
						$tokenVal = $this->tokenGenerate ($tmpRec);						
						return array('Id' => $tmpRec[$this->currentConsumerId]['csm_id'], 'Email' => $tmpRec[$this->currentConsumerId]['csm_email'], 'First_Name'=>$tmpRec[$this->currentConsumerId]['csm_first_name'], 'Last_Name'=>$tmpRec[$this->currentConsumerId]['csm_last_name'], 'Zipcode'=>$tmpRec[$this->currentConsumerId]['csm_zip']);
						*/
						
					}
					else {
						$errorArr = array('User account not found');
						return false;
					}
				}
				else {
					$errorArr = $this->validDataErrors;//array('Incorrect Request Fields');
					return false;
				}
			}
			
			else{
				$errorArr = array('Email is a required field');
				return false;
			}
			
		}
		
		function runPostApiAction( $requestUrlArr, $requestBodyArr, $requestHeaders, &$errorArr, &$tokenVal ){
			$tokenVal = null; $errorArr = array();
			if ( is_array($requestUrlArr) && count($requestUrlArr) === 4 && $requestUrlArr[0] === 'api' && $requestUrlArr[1] === 'v1' && $requestUrlArr[2] === 'users' ) {
				switch ( $requestUrlArr[3] ) {
					case 'login':
						return $this->logIn($requestBodyArr, $errorArr, $tokenVal);
					break;
					case 'signup':						
						return $this->signUp($requestBodyArr, $errorArr, $tokenVal);
					break;
					case 'reset-password':
						return $this->restPassword($requestBodyArr, $errorArr, $tokenVal);
					break;
					default: 
						if ( is_numeric( $requestUrlArr[3]) && intval($requestUrlArr[3]) > 0 ){					
							$userRec = $this->getUserFromToken (isset($requestHeaders['Authorization'])? $requestHeaders['Authorization'] : '', $exp);
							if ( isset($userRec['Id']) && intval($userRec['Id']) === intval($requestUrlArr[3]) ) {								
								$tmpResFlag = $this->updateUserFromAPI ($userRec['Id'], $requestBodyArr);								
								if (!$tmpResFlag) {
									$errorArr = array('The submitted data did not pass validation');
								}								
								return $tmpResFlag;
							}	
							else{						
								$errorArr = array("Invalid user account, access denied");
								return false;
							}	
						}
						else
							$errorArr = array("Invalid method requested"); return false;
				}				
			}
			$errorArr = array("Invalid request URL");
			return false;
		}
		
		function runGetApiAction( $requestUrlArr, $requestHeaders, &$errorArr, &$userRec, &$token ) {
			$userRec = array(); $errorArr = array();
			if ( is_array($requestUrlArr) && count($requestUrlArr) === 4 && $requestUrlArr[0] === 'api' && $requestUrlArr[1] === 'v1' && $requestUrlArr[2] === 'users' ) {
				if ( is_numeric( $requestUrlArr[3]) && intval($requestUrlArr[3]) > 0 ){					
					$userRec = $this->getUserFromToken (isset($requestHeaders['Authorization'])? $requestHeaders['Authorization'] : '', $exp);
					if ( isset($userRec['Id']) && intval($userRec['Id']) === intval($requestUrlArr[3]) )
						return true;
					else{						
						$errorArr = array("User account not found, access denied");
						return false;
					}	
				}
				else {
					$errorArr = array("Invalid user account, access denied");
					return false;
				}
			}
			elseif (is_array($requestUrlArr) && count($requestUrlArr) === 5 && $requestUrlArr[0] === 'api' && $requestUrlArr[1] === 'v1' && $requestUrlArr[2] === 'users' &&  $requestUrlArr[4] === 'token' && is_numeric( $requestUrlArr[3]) && intval($requestUrlArr[3]) > 0) {				
				$tmpToken = $this->renewToken(isset($requestHeaders['Authorization'])? $requestHeaders['Authorization'] : '', intval($requestUrlArr[3]));
				if ( !empty( $tmpToken ) ) {
					$token = $tmpToken;
					return true;
				}	
				else{						
					$errorArr = array("User account not found, access denied");
					return false;
				}	
			}
			
			$errorArr = array("Invalid request URL");
			
		}
		
		function getConsumerCount ($ltmId) {
			if ( !isset($this->totalCount[$ltmId]) && is_numeric($ltmId) && intval($ltmId) > 0 ) {
				$ltmIdOk = intval($ltmId);
				$this->getTotalCount($ltmIdOk);
				return $this->totalCount[$ltmIdOk];
			}
				
			return 0;
		}
		
		function getValue ($fieldName, $csmId = null) {
			if (empty($csmId)) $csmId = $this->currentConsumerId;
			if ( isset($this->consumerRecords[$csmId][$fieldName]) )
				return $this->consumerRecords[$csmId][$fieldName];
			return '';
		}
		
		function getLoadedRecords(){
			return $this->consumerRecords;
		}
		
		function __construct( $dbObj, $csmId=null, $ltmId=null ) {
			$this->cDbo=$dbObj;
			if ($csmId!==null && is_numeric($csmId) && $csmId > 0) {
				$this->loadRecords( (int) $csmId );
			}
			else if ($ltmId!==null && is_numeric($ltmId) && $ltmId > 0) {
				$this->loadRecords( $ltmId, 'ltm_id', 'MRC');
			}
		}
		
	}

}	

?>