<?php
namespace App\DiscountCode {
	
	require_once $_SERVER['DOCUMENT_ROOT']."/app/class.variables.php";
	class discountCode {
		
		private $mDbo;
		private $thisCode;
		private $resellerCodeArr = array(  );
		private $codeArr = array(  );
		
		function findCode( $dscId ) {
			if ( is_numeric( $dscId ) && intval( $dscId ) > 0 ) {
				
				$sql = '
				SELECT DCO.*
				FROM tbl_discount_code DCO
				WHERE DCO.dsc_id = :dscId LIMIT 1';
				
				$qry = $this->mDbo->prepare( $sql );
				$qry->bindValue( ':dscId', intval( $dscId ), \PDO::PARAM_INT );
				$qry->execute(  );
				$this->codeArr[ intval( $dscId ) ] = $qry->fetch( \PDO::FETCH_ASSOC );
				
				return $this->codeArr[ intval( $dscId ) ];
			}
			return array();
		}
		
		private function codeExists( $dscCode, $codeId = 0 ) {			
			$sql = '
			SELECT DCO.*
			FROM tbl_discount_code DCO
			WHERE DCO.dsc_code = :dscCode AND DCO.dsc_id <> :codeId LIMIT 1';
			
			$qry = $this->mDbo->prepare( $sql );
			$qry->bindValue( ':dscCode', $dscCode, \PDO::PARAM_STR );
			$qry->bindValue( ':codeId', $codeId, \PDO::PARAM_INT );
			$qry->execute(  );
		
			return $tmp = $qry->fetchAll( \PDO::FETCH_ASSOC );
		}
		
		function applyCodeToPrice ( $dscId, $planPrice ) {
			$tmpCode = $this->findCode( $dscId ); $currentCharges = $planPrice;
			if (!empty($tmpCode) && is_numeric($planPrice)) {
				$currentCharges = floatval($planPrice);
				//finding code discount
				if ( isset( $disCodeRec['dsc_monthly_dollar_off'] ) ) {
					$currentCharges = $currentCharges - floatval( $disCodeRec['dsc_monthly_dollar_off'] );
					$currentCharges = $currentCharges > 0? $currentCharges: 0;					
				}
				elseif ( isset( $disCodeRec['dsc_monthly_percent_off'] ) ) {
					$currentCharges = $currentCharges - (($currentCharges * intval($disCodeRec['dsc_monthly_percent_off']) ) / 100);
					$currentCharges = $currentCharges > 0? $currentCharges: 0;					
				}
			}
			return $planPrice;
		}
		
		function applyCodeToSetupFee ( $dscId, $planSetupFee ) {
			$tmpCode = $this->findCode( $dscId ); $currentCharges = is_numeric($planSetupFee)? floatval($planSetupFee): 0.00;
			if (!empty($tmpCode)) {				
				//finding code discount
				if ( isset( $disCodeRec['dsc_setup_fee'] ) ) {
					$currentCharges = floatval($disCodeRec['dsc_setup_fee']) > $currentCharges? $currentCharges: floatval($disCodeRec['dsc_setup_fee']) ;
				}
			}
			return $currentCharges;
		}
		
		function getCodeValues( $resId=null ) {
			
			if ( is_numeric( $resId ) && intval( $resId ) > 0 ) {
				
				$sql = '
				SELECT DCO.*, RES.res_name
				FROM tbl_discount_code DCO
				INNER JOIN tbl_reseller RES ON RES.res_id = DCO.res_id
				WHERE DCO.res_id = :resId';
				
				$qry = $this->mDbo->prepare( $sql );
				$qry->bindValue( ':resId', intval( $resId ), \PDO::PARAM_INT );
				$qry->execute(  );
				$this->resellerCodeArr[ intval( $resId ) ] = $qry->fetchAll( \PDO::FETCH_ASSOC );
				
				return $this->resellerCodeArr[ intval( $resId ) ];
				
			}
			
			return array(  );
			
		}
		
		public function getTableRowsOutput ($resId) {
			$results = '';
			if (isset($this->resellerCodeArr[$resId]))
				foreach ( $this->resellerCodeArr[$resId] as $id => $v ) {
					
					$newDate = '';
					if (!empty( $v['dsc_expire_date'] )) {
						$originalDate = $v['dsc_expire_date'];
						$newDate = date("m/d/Y", strtotime($originalDate));
					}
					
					$results .= '<tr>';
					$results .=   '<td>' . $v['dsc_id'] . '</td>';			
					$results .=   '<td>' . $v['dsc_code'] . '</td>';
					$results .=   '<td>' . $newDate . '</td>';
					$results .=   '<td>' . ( is_null( $v['dsc_monthly_percent_off'] )? '': $v['dsc_monthly_percent_off'] . '%' ) . '</td>';
					$results .=   '<td>' . ( is_null( $v['dsc_monthly_dollar_off'] )? '': '$' . $v['dsc_monthly_dollar_off'] ) . '</td>';			
					$results .=   '<td>' . ( is_null($v['dsc_setup_fee'])? '': '$' . $v['dsc_setup_fee'] ) . '</td>';			
					$results .=   '<td>' . $v['dsc_quantity'].'</td>';
					$results .=   '<td>' . $v['dsc_discount_months'] . '</td>';
					$results .=   '<td>
									'.(!$this->isCodeBeenUsed ($v['dsc_id'])?'
									<div style="min-width:80px;" class="btn-group btn-group-xs" role="group" aria-label="...">
										<button title="Code Edit" aria-label="..." type="button" class="btn btn-info editCodeBtn" data-toggle="modal" data-target="#globalModal" data-id="'.$v['dsc_id'].'"><span class="glyphicon glyphicon-pencil"></span> Edit</button>										
										<button title="Delete Edit" type="button" class="btn btn-danger deleteCodeBtn" data-id="'.$v['dsc_id'].'"><span class="glyphicon glyphicon-remove-circle"></span> Delete</button>
									</div>
									':'Already Used').'	
								   </td>';
					$results .= '</tr>';
				}
			return $results;
		}
		
		function validateCode( $promoCode ) {
			$sql = 'SELECT * FROM tbl_discount_code WHERE dsc_code = :promo_code LIMIT 1';
			$qry = $this->mDbo->prepare($sql);
			$qry->bindValue( ':promo_code', $promoCode, \PDO::PARAM_STR );
			$qry->execute(  );
			$qry = $qry->fetchAll( \PDO::FETCH_ASSOC );
		}
		
		function deleteCode( $codeId ) {
			$requestArr = array( 'wnu_code_r'=>$codeId );
			$cv = new \_variables( $requestArr ); // new instance
			$cv->varible_in( 'wnu_code_r' ); //each variable is added to class by array loop
			$_v = $cv->get_cleaned_variables(  );
			$errors= array_values( $cv->get_bad_variables(  ) );
			
			if ( count( $errors ) === 0 && !$this->isCodeBeenUsed( $_v['code'] ) ) {	
				$sql = '
				DELETE 
				FROM tbl_discount_code 
				WHERE dsc_id = :codeId';
				$qry = $this->mDbo->prepare($sql);
				$qry->bindValue( ':codeId', $_v['code'], \PDO::PARAM_INT );
				$qry->execute();
				return $qry->rowCount();
			}
			
			return false;
		}
		
		function getResellerCode( $aCode, $resId ) {
			$sql = '
			SELECT DSC.* 
			FROM tbl_discount_code DSC
			INNER JOIN tbl_reseller RES ON DSC.res_id=RES.res_id
			WHERE DSC.dsc_code = :promo_code AND RES.res_id=:res_id AND (DSC.dsc_quantity IS NULL OR DSC.dsc_quantity > 0) AND ( DSC.dsc_expire_date IS NULL OR DATEDIFF( DSC.dsc_expire_date, NOW() ) >= 0 ) LIMIT 1';
			$qry = $this->mDbo->prepare($sql);
			$qry->bindValue( ':promo_code', $aCode, \PDO::PARAM_STR );
			$qry->bindValue( ':res_id', $resId, \PDO::PARAM_INT );
			$qry->execute();
			return $qry->fetchAll( \PDO::FETCH_ASSOC );
		}
		
		function applyDiscountCode( $disCodeRec, $chosenPlan, &$prismpayArr, &$prismpayArr1/*In case another billing needs to be set*/, &$datesSetPerPeriod, &$chargesArr ) {
			$datesSetPerPeriod = array(); $chargesArr = array();
			$prismpayArr1 = null;
			if ( NEW_DB_SWITCH ) {
				if ( 
					isset( 
							$disCodeRec['dsc_code'], 
							$disCodeRec['dsc_id'], 
							/*$chosenPlan['lmp_billing_delay'], */
							$chosenPlan['ppr_price'], 
							$chosenPlan['ppr_setup']
						)	
					) {

					$currentSetupFee = floatval( $chosenPlan['ppr_setup'] );
					$discountPeriodFlag = false;
					$datesSetPerPeriod[0]['codeId'] = null;
					if ( 
						isset( 
								$disCodeRec['dsc_setup_fee']
							)
							&& floatval( $disCodeRec['dsc_setup_fee'] ) >= 0
							&& $currentSetupFee > floatval( $disCodeRec['dsc_setup_fee'] ) 
						) {
						//$disCodeRec['dsc_setup_fee'] = ';	
						$discountPeriodFlag = true;
						$datesSetPerPeriod[0]['codeId'] = $disCodeRec['dsc_id'];
						$currentSetupFee = floatval ( $disCodeRec['dsc_setup_fee'] );
					}
					
					$currentCharges = floatval($chosenPlan['ppr_price']);
					$prismpayArr['recur_amount'] = $currentCharges * 100;
					//finding code discount
					if ( isset( $disCodeRec['dsc_monthly_dollar_off'] ) ) {
						$currentCharges = $currentCharges - floatval( $disCodeRec['dsc_monthly_dollar_off'] );
						$currentCharges = $currentCharges > 0? $currentCharges: 0;
						$discountPeriodFlag = true;
						$datesSetPerPeriod[0]['codeId'] = $disCodeRec['dsc_id'];
						$prismpayArr['recur_amount'] = $currentCharges * 100;
					}
					
					elseif ( isset( $disCodeRec['dsc_monthly_percent_off'] ) ) {
						$currentCharges = $currentCharges - (($currentCharges * intval($disCodeRec['dsc_monthly_percent_off']) ) / 100);
						$currentCharges = $currentCharges > 0? $currentCharges: 0;
						$discountPeriodFlag = true;
						$datesSetPerPeriod[0]['codeId'] = $disCodeRec['dsc_id'];
						$prismpayArr['recur_amount'] = $currentCharges * 100;
					}
					$unsetRecurringBill =false;
					
					$prismpayArr['amount'] = ($currentSetupFee + $currentCharges) * 100;
					if ( isset( $disCodeRec['dsc_discount_months'] ) && intval( $disCodeRec['dsc_discount_months'] ) > 1 ) {
						$prismpayArr['recur_billingmax'] = intval($disCodeRec['dsc_discount_months']) - 1;
					}	
					else {
						$unsetRecurringBill = true;
						$prismpayArr['recur_billingmax'] = 0;
					}	
					
					
					
					$datesSetPerPeriod[0]['startTime'] = strtotime('now');
					$datesSetPerPeriod[0]['endTime']   = strtotime('now +1 month');
					$datesSetPerPeriod[0]['timeDiff']  = abs($datesSetPerPeriod[0]['endTime'] - $datesSetPerPeriod[0]['startTime']);
					$datesSetPerPeriod[0]['delayDays'] = $datesSetPerPeriod[0]['timeDiff']/86400; // 86400 seconds in one day
					$datesSetPerPeriod[0]['startCycle'] = date('Y-m-d', strtotime('now')); //it was like this here: date('Y-m-d',$datesSetPerPeriod[0]['endTime']);
					$datesSetPerPeriod[0]['endCycle'] = null;
					
					$chargesArr[0]['setupFee'] = $currentSetupFee;
					$chargesArr[0]['price'] = $currentCharges;
					
					$prismpayArr['recur_start'] = intval($datesSetPerPeriod[0]['delayDays']);
					
					if ($discountPeriodFlag) {
						//we have to setup an additional period for charges					
						$prismpayArr1                       = $prismpayArr;
						$datesSetPerPeriod[1]['codeId']     = null;
						$datesSetPerPeriod[1]['startTime']  = strtotime( 'now +1 month' );
						$datesSetPerPeriod[1]['endTime']    = strtotime('now +'.( 2 + ( $prismpayArr1['recur_billingmax'] ) ).' month');
						$datesSetPerPeriod[1]['timeDiff']   = abs($datesSetPerPeriod[1]['endTime'] - $datesSetPerPeriod[1]['startTime']);
						$datesSetPerPeriod[1]['delayDays']  = $datesSetPerPeriod[1]['timeDiff']/86400; // 86400 seconds in one day
						$datesSetPerPeriod[1]['startCycle'] = date('Y-m-d',strtotime('now +'.(1 + ( $prismpayArr1['recur_billingmax'] ) ).' month'));
						$datesSetPerPeriod[1]['endCycle'] = null;
						$datesSetPerPeriod[0]['endCycle'] = date('Y-m-d',strtotime('now +'.( 1 + ( $prismpayArr1['recur_billingmax'] ) ).' month'));
						
						$prismpayArr1['amount']      = 0.01;
						$prismpayArr1['authonly']    = 1;
						$prismpayArr1['recur_start'] = intval($datesSetPerPeriod[1]['delayDays']);
						
						$prismpayArr1['recur_billingmax'] = -1;
						$prismpayArr1['recur_amount']     = floatval($chosenPlan['ppr_price']) * 100; 
						
						$chargesArr[1]['setupFee'] = 0.00;
						$chargesArr[1]['price'] = floatval($chosenPlan['ppr_price']);
						
					}
					
					//in case there isn't any charge for now
					if ( $prismpayArr['amount'] == 0 ) {
						$prismpayArr['amount'] = 0.01;
						$prismpayArr['authonly'] = 1;	
					}
					
					if ($unsetRecurringBill) {
						unset(
							$prismpayArr['recur_create'],
							$prismpayArr['recur_billingcycle'],
							$prismpayArr['recur_billingmax'],
							$prismpayArr['recur_start'],
							$prismpayArr['recur_amount']
						);
						//$datesSetPerPeriod[0]['startCycle'] = date('Y-m-d', strtotime( 'now' ) );
					}
					
					return true;
					
				}
			}
			else {
				if ( 
					isset( 
							$disCodeRec['dsc_code'], 
							$disCodeRec['dsc_id'], 
							$chosenPlan['lmp_billing_delay'], 
							$chosenPlan['lmp_price'], 
							$chosenPlan['lmp_fee'], 
							$chosenPlan['lmp_price'] 
						)	
					) {

					/*
						$disCodeRec['dsc_setup_fee'],
						$disCodeRec['dsc_monthly_dollar_off'],
						$disCodeRec['dsc_monthly_percent_off'],
						$disCodeRec['dsc_discount_months']
					*/
					
					$currentSetupFee = floatval( $chosenPlan['lmp_fee'] );
					$discountPeriodFlag = false;
					$datesSetPerPeriod[0]['codeId'] = null;
					if ( 
						isset( 
								$disCodeRec['dsc_setup_fee']
							)
							&& floatval( $disCodeRec['dsc_setup_fee'] ) >= 0
							&& $currentSetupFee > floatval( $disCodeRec['dsc_setup_fee'] ) 
						) {
						//$disCodeRec['dsc_setup_fee'] = ';	
						$discountPeriodFlag = true;
						$datesSetPerPeriod[0]['codeId'] = $disCodeRec['dsc_id'];
						$currentSetupFee = floatval ( $disCodeRec['dsc_setup_fee'] );
					}
					
					$currentCharges = floatval($chosenPlan['lmp_price']);
					$prismpayArr['recur_amount'] = $currentCharges * 100;
					//finding code discount
					if ( isset( $disCodeRec['dsc_monthly_dollar_off'] ) ) {
						$currentCharges = $currentCharges - floatval( $disCodeRec['dsc_monthly_dollar_off'] );
						$currentCharges = $currentCharges > 0? $currentCharges: 0;
						$discountPeriodFlag = true;
						$datesSetPerPeriod[0]['codeId'] = $disCodeRec['dsc_id'];
						$prismpayArr['recur_amount'] = $currentCharges * 100;
					}
					
					elseif ( isset( $disCodeRec['dsc_monthly_percent_off'] ) ) {
						$currentCharges = $currentCharges - (($currentCharges * intval($disCodeRec['dsc_monthly_percent_off']) ) / 100);
						$currentCharges = $currentCharges > 0? $currentCharges: 0;
						$discountPeriodFlag = true;
						$datesSetPerPeriod[0]['codeId'] = $disCodeRec['dsc_id'];
						$prismpayArr['recur_amount'] = $currentCharges * 100;
					}
					
					$unsetRecurringBill =false;
					
					if ( intval( $chosenPlan['lmp_billing_delay'] ) === 0 ) {
						//there isn't any billing delay set, we need to find out what the price will be after applying the promo code
						$billDelay = 1;
						$prismpayArr['amount'] = ($currentSetupFee + $currentCharges) * 100;
						if ( isset( $disCodeRec['dsc_discount_months'] ) && intval( $disCodeRec['dsc_discount_months'] ) > 1 ) {
							$prismpayArr['recur_billingmax'] = intval($disCodeRec['dsc_discount_months']) - 1;
						}	
						else {
							$unsetRecurringBill = true;
							$prismpayArr['recur_billingmax'] = 0;
						}	
					}
					else{
						$billDelay = intval( $chosenPlan['lmp_billing_delay'] );
						$prismpayArr['amount'] = ($currentSetupFee) * 100;
						if ( isset( $disCodeRec['dsc_discount_months'] ) && intval( $disCodeRec['dsc_discount_months'] ) > 0 )
							$prismpayArr['recur_billingmax'] = intval($disCodeRec['dsc_discount_months']);
						else {
							$unsetRecurringBill = true;
							$prismpayArr['recur_billingmax'] = 0;	
						}
					}
					
					$datesSetPerPeriod[0]['startTime'] = strtotime('now');
					$datesSetPerPeriod[0]['endTime']   = strtotime('now +'.$billDelay.' month');
					$datesSetPerPeriod[0]['timeDiff']  = abs($datesSetPerPeriod[0]['endTime'] - $datesSetPerPeriod[0]['startTime']);
					$datesSetPerPeriod[0]['delayDays'] = $datesSetPerPeriod[0]['timeDiff']/86400; // 86400 seconds in one day
					$datesSetPerPeriod[0]['startCycle'] = date('Y-m-d', strtotime('now')); //it was like this here: date('Y-m-d',$datesSetPerPeriod[0]['endTime']);
					$datesSetPerPeriod[0]['endCycle'] = null;
					
					$chargesArr[0]['setupFee'] = $currentSetupFee;
					$chargesArr[0]['price'] = $currentCharges;
					
					$prismpayArr['recur_start'] = intval($datesSetPerPeriod[0]['delayDays']);
					
					if ($discountPeriodFlag) {
						//we have to setup an additional period for charges					
						$prismpayArr1                       = $prismpayArr;
						$datesSetPerPeriod[1]['codeId']     = null;
						$datesSetPerPeriod[1]['startTime']  = strtotime( 'now +'.( $billDelay ).' month' );
						$datesSetPerPeriod[1]['endTime']    = strtotime('now +'.( ( $billDelay+1 ) + ( $prismpayArr1['recur_billingmax'] ) ).' month');
						$datesSetPerPeriod[1]['timeDiff']   = abs($datesSetPerPeriod[1]['endTime'] - $datesSetPerPeriod[1]['startTime']);
						$datesSetPerPeriod[1]['delayDays']  = $datesSetPerPeriod[1]['timeDiff']/86400; // 86400 seconds in one day
						$datesSetPerPeriod[1]['startCycle'] = date('Y-m-d',strtotime('now +'.($billDelay + ( $prismpayArr1['recur_billingmax'] ) ).' month'));
						$datesSetPerPeriod[1]['endCycle'] = null;
						$datesSetPerPeriod[0]['endCycle'] = date('Y-m-d',strtotime('now +'.( ( $billDelay ) + ( $prismpayArr1['recur_billingmax'] ) ).' month'));
						
						$prismpayArr1['amount']      = 0.01;
						$prismpayArr1['authonly']    = 1;
						$prismpayArr1['recur_start'] = intval($datesSetPerPeriod[1]['delayDays']);
						
						$prismpayArr1['recur_billingmax'] = -1;
						$prismpayArr1['recur_amount']     = floatval($chosenPlan['lmp_price']) * 100; 
						
						$chargesArr[1]['setupFee'] = 0.00;
						$chargesArr[1]['price'] = floatval($chosenPlan['lmp_price']);
						
					}
					
					//in case there isn't any charge for now
					if ( $prismpayArr['amount'] == 0 ) {
						$prismpayArr['amount'] = 0.01;
						$prismpayArr['authonly'] = 1;	
					}
					
					if ($unsetRecurringBill) {
						unset(
							$prismpayArr['recur_create'],
							$prismpayArr['recur_billingcycle'],
							$prismpayArr['recur_billingmax'],
							$prismpayArr['recur_start'],
							$prismpayArr['recur_amount']
						);
						//$datesSetPerPeriod[0]['startCycle'] = date('Y-m-d', strtotime( 'now' ) );
					}
					
					return true;
					
				}
			}	
			
			return false;
		}
		
		function applyDiscCodeUsingBillings( $disCodeRec, $currentBilling, $chosenPlan, $oldPlan, &$prismpayArr, &$prismpayArr1/*In case another billing needs to be set*/, &$datesSetPerPeriod, &$chargesArr ) {
			$datesSetPerPeriod = array(); $chargesArr = array();
			$prismpayArr1 = null;
			
			if ( 
				isset ( 
						$disCodeRec['dsc_code'], 
						$disCodeRec['dsc_id'], 
						/*$chosenPlan['lmp_billing_delay'], */
						$chosenPlan['ppr_price'], 
						$chosenPlan['ppr_setup']
					)	
				) {

				$currentSetupFee = floatval( $chosenPlan['ppr_setup'] );
				$discountPeriodFlag = false;
				$datesSetPerPeriod[0]['codeId'] = null;
				if ( 
					isset( 
							$disCodeRec['dsc_setup_fee']
						)
						&& floatval( $disCodeRec['dsc_setup_fee'] ) >= 0
						&& $currentSetupFee > floatval( $disCodeRec['dsc_setup_fee'] ) 
					) {
					//$disCodeRec['dsc_setup_fee'] = ';	
					$discountPeriodFlag = true;
					$datesSetPerPeriod[0]['codeId'] = $disCodeRec['dsc_id'];
					$currentSetupFee = floatval ( $disCodeRec['dsc_setup_fee'] );
				}
				
				$oldSetupFee = floatval( $oldPlan['ppr_setup'] );
				
				if ( 
					isset( 
							$disCodeRec['dsc_setup_fee']
						)
						&& floatval( $disCodeRec['dsc_setup_fee'] ) >= 0
						&& $oldSetupFee > floatval( $disCodeRec['dsc_setup_fee'] ) 
					) {
					$oldSetupFee = floatval ( $disCodeRec['dsc_setup_fee'] );
				}
				
				$currentSetupFee = $currentSetupFee - $oldSetupFee > 0? $currentSetupFee - $oldSetupFee: 0.00;
				
				$currentCharges = floatval( $chosenPlan['ppr_price'] );
				
				//finding code discount
				if ( isset( $disCodeRec['dsc_monthly_dollar_off'] ) ) {
					$currentCharges = $currentCharges - floatval( $disCodeRec['dsc_monthly_dollar_off'] );
					$currentCharges = $currentCharges > 0? $currentCharges: 0;
					$discountPeriodFlag = true;
					$datesSetPerPeriod[0]['codeId'] = $disCodeRec['dsc_id'];
					$prismpayArr['recur_amount'] = $currentCharges * 100;
				}
				
				elseif ( isset( $disCodeRec['dsc_monthly_percent_off'] ) ) {
					$currentCharges = $currentCharges - (($currentCharges * intval($disCodeRec['dsc_monthly_percent_off']) ) / 100);
					$currentCharges = $currentCharges > 0? $currentCharges: 0;
					$discountPeriodFlag = true;
					$datesSetPerPeriod[0]['codeId'] = $disCodeRec['dsc_id'];
					$prismpayArr['recur_amount'] = $currentCharges * 100;
				}
				
				$oldCharges = floatval( $oldPlan['ppr_price'] );
				
				//finding code discount
				if ( isset( $disCodeRec['dsc_monthly_dollar_off'] ) ) {
					$oldCharges = $oldCharges - floatval( $disCodeRec['dsc_monthly_dollar_off'] );
					$oldCharges = $oldCharges > 0? $oldCharges: 0;
				}
				
				elseif ( isset( $disCodeRec['dsc_monthly_percent_off'] ) ) {
					$oldCharges = $oldCharges - (($oldCharges * intval($disCodeRec['dsc_monthly_percent_off']) ) / 100);
					$oldCharges = $oldCharges > 0? $oldCharges: 0;					
				}
				
				$currentCharges = $currentCharges - $oldCharges > 0 ? $currentCharges - $oldCharges : 0.00;
				//$prismpayArr['recur_amount'] = $currentCharges * 100;
				
				
				$unsetRecurringBill =false;
				
				$prismpayArr['amount'] = ($currentSetupFee + $currentCharges) * 100;
				
				if ( isset( $disCodeRec['dsc_discount_months'] ) && intval( $disCodeRec['dsc_discount_months'] ) > 1 ) {
					$prismpayArr['recur_billingmax'] = intval($disCodeRec['dsc_discount_months']) - 1;
				}	
				else {
					$unsetRecurringBill = true;
					$prismpayArr['recur_billingmax'] = 0;
				}
				
				//$currentBilling
				$timeNow = strtotime( 'now' );
				
				$timeCycleStart = strtotime( $currentBilling['bill_cyclestart'] );				
				$tmpCycleStart = $timeCycleStart;
				for ($i = 1; $i < 10000; $i++) {
					$timeCycleStart = strtotime( $currentBilling['bill_cyclestart'] . " +{$i} month" );
					if ($timeNow < $timeCycleStart) {$timeCycleStart = $tmpCycleStart; break;}					
					$tmpCycleStart = $timeCycleStart;					
				}
				
				$monthsApplied = date('Y-m-d', $timeCycleStart - strtotime( $currentBilling['bill_cyclestart'] ));
				
				$datesSetPerPeriod[0]['startTime'] = $timeCycleStart;
				$datesSetPerPeriod[0]['endTime']   = strtotime(date('Y-m-d',  $timeCycleStart ) . ' +1 month');
				$datesSetPerPeriod[0]['timeDiff']  = abs($datesSetPerPeriod[0]['endTime'] - $datesSetPerPeriod[0]['startTime']);
				$datesSetPerPeriod[0]['delayDays'] = $datesSetPerPeriod[0]['timeDiff']/86400; // 86400 seconds in one day
				$datesSetPerPeriod[0]['startCycle'] = date('Y-m-d', $timeCycleStart); //it was like this here: date('Y-m-d',$datesSetPerPeriod[0]['endTime']);
				$datesSetPerPeriod[0]['endCycle'] = null;
				
				$chargesArr[0]['setupFee'] = $currentSetupFee;
				$chargesArr[0]['price'] = $currentCharges;
				
				$prismpayArr['recur_start'] = $datesSetPerPeriod[0]['delayDays'];
				
				if ($discountPeriodFlag) {
					//we have to setup an additional period for charges					
					$prismpayArr1                       = $prismpayArr;
					$datesSetPerPeriod[1]['codeId']     = null;
					$datesSetPerPeriod[1]['startTime']  = strtotime( date('Y-m-d', $timeCycleStart ) . ' +1 month' );
					$datesSetPerPeriod[1]['endTime']    = strtotime(date('Y-m-d', $timeCycleStart ) . ' +' . ( 2 + ( $prismpayArr1['recur_billingmax'] ) ).' month');
					$datesSetPerPeriod[1]['timeDiff']   = abs($datesSetPerPeriod[1]['endTime'] - $datesSetPerPeriod[1]['startTime']);
					$datesSetPerPeriod[1]['delayDays']  = $datesSetPerPeriod[1]['timeDiff']/86400; // 86400 seconds in one day
					$datesSetPerPeriod[1]['startCycle'] = $currentBilling['bill_cycleend'];
					$datesSetPerPeriod[1]['endCycle'] = null;
					$datesSetPerPeriod[0]['endCycle'] = $currentBilling['bill_cycleend'];
					
					$prismpayArr1['amount']      = 0.01;
					$prismpayArr1['authonly']    = 1;
					$prismpayArr1['recur_start'] = intval($datesSetPerPeriod[1]['delayDays']);
					
					$prismpayArr1['recur_billingmax'] = -1;
					$prismpayArr1['recur_amount']     = floatval($chosenPlan['ppr_price']) * 100; 
					
					$chargesArr[1]['setupFee'] = 0.00;
					$chargesArr[1]['price'] = floatval($chosenPlan['ppr_price']);
					
				}
				
				//in case there isn't any charge for now
				if ( $prismpayArr['amount'] == 0 ) {
					$prismpayArr['amount'] = 0.01;
					$prismpayArr['authonly'] = 1;	
				}
				
				if ($unsetRecurringBill) {
					unset(
						$prismpayArr['recur_create'],
						$prismpayArr['recur_billingcycle'],
						$prismpayArr['recur_billingmax'],
						$prismpayArr['recur_start'],
						$prismpayArr['recur_amount']
					);
					//$datesSetPerPeriod[0]['startCycle'] = date('Y-m-d', strtotime( 'now' ) );
				}
				
				return true;
				
			}
		

			
			return false;
		}
		
		private function isCodeBeenUsed ($codeId) {
			$sql = '
			SELECT * 
			FROM tbl_discount_code DSC
			INNER JOIN lt_merchant_billing MBL ON DSC.dsc_id = MBL.dsc_id
			WHERE DSC.dsc_id=:codeId
			LIMIT 1 ';
			$qry = $this->mDbo->prepare($sql);
			$qry->bindValue( ':codeId', $codeId, \PDO::PARAM_INT );			
			$qry->execute();
			return $tmp = $qry->fetch( \PDO::FETCH_ASSOC );
		}
		
		function reduceQuantity( $aCode, $resId ) {
			$sql = '
			UPDATE tbl_discount_code 
			SET dsc_quantity = (dsc_quantity - 1)
			WHERE dsc_code = :promo_code 
				  AND res_id = :res_id 
				  AND dsc_quantity IS NOT NULL 
				  AND dsc_quantity > 0';
			$qry = $this->mDbo->prepare($sql);
			$qry->bindValue( ':promo_code', $aCode, \PDO::PARAM_STR );
			$qry->bindValue( ':res_id', $resId, \PDO::PARAM_INT );
			$qry->execute();
		}

		function __construct( $dbObj ) {
			$this->mDbo=$dbObj;		
 		}
		
		function editCode($requestBody, &$errors) {
			$_response = array();
		
			if ( 
				isset( 
						$requestBody['dsc_id'],						
						$requestBody['res_id'],
						$requestBody['dsc_code'],
						$requestBody['dsc_discount_months'],
						$requestBody['dsc_expire_date'],
						$requestBody['dsc_monthly_dollar_off'],
						$requestBody['dsc_monthly_percent_off'],
						$requestBody['dsc_quantity'],
						$requestBody['dsc_setup_fee']
					) 
			) {				
				
				$requestArr['wnu_res_id_r'] = $requestBody['res_id'];
				$requestArr['adn_dsc_code_r'] = $requestBody['dsc_code'];
				$requestArr['wnu_dsc_id_r'] = $requestBody['dsc_id'];
				$requestArr['aon_dsc_code_r'] = $requestBody['dsc_code'];
				
				$fields = array('wnu_res_id_r', 'wnu_dsc_id_r', 'adn_dsc_code_r');
				
				if (!empty($requestBody['dsc_discount_months'])) {
					$requestArr['wnu3_dsc_discount_months_r'] = $requestBody['dsc_discount_months'];
					array_push($fields, 'wnu3_dsc_discount_months_r');
				}

				if ( !empty( $requestBody['dsc_expire_date'] ) ) {
					$requestArr['dat_dsc_expire_date_r'] = $requestBody['dsc_expire_date'];
					array_push($fields, 'dat_dsc_expire_date_r');					
				}
				
				if (!empty($requestBody['dsc_setup_fee'])) { 
					$requestArr['dec_dsc_setup_fee_r'] = $requestBody['dsc_setup_fee'];
					array_push($fields, 'dec_dsc_setup_fee_r');
				}
				
				if ( !empty( $requestBody['dsc_quantity'] ) ) { 
					$requestArr['wnu2_dsc_quantity_r'] = $requestBody['dsc_quantity'];
					array_push($fields, 'wnu2_dsc_quantity_r');
				}
				
				if ( $requestBody['dsc_monthly_dollar_off'] !== '' ) {
					$requestArr['dec_dsc_monthly_dollar_off_r'] = $requestBody['dsc_monthly_dollar_off'];
					array_push($fields, 'dec_dsc_monthly_dollar_off_r');
				}
				elseif ( $requestBody['dsc_monthly_percent_off'] !== '' ) {
					array_push($fields, 'wnu3_dsc_monthly_percent_off_r');
					$requestArr['wnu3_dsc_monthly_percent_off_r'] = $requestBody['dsc_monthly_percent_off'];
				}
				else {
					$errors[0] = $requestBody;//'The discount percentage or the dollar amount has to be entered.';
				}
				
				if ( !isset( $errors[0] ) ) {
					$cv = new \_variables($requestArr); // new instance
					foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
					$_v = $cv->get_cleaned_variables(  );
					$errors= array_values($cv->get_bad_variables(  ));					
					
					if ( count( $errors ) === 0 && !$this->isCodeBeenUsed( $_v['dsc_id'] )) {
						if ( !$this->codeExists( $_v['dsc_code'], $_v['dsc_id'] ) ) {
							//let's do it
							if (!isset($_v['dsc_discount_months'])) {
								$_v['dsc_discount_months'] = null;							
							}
							
							if ( !isset( $_v['dsc_setup_fee'] ) ) {
								$_v['dsc_setup_fee'] = null;							
							}
							
							if (!isset( $_v['dsc_expire_date'])) {
								$_v['dsc_expire_date'] = null;							
							}
							else {
								$originalDate = $_v['dsc_expire_date'];
								$_v['dsc_expire_date'] = date("Y-m-d", strtotime($originalDate));
							}
							
							if (!isset($_v['dsc_quantity'])) { 
								$_v['dsc_quantity'] = null;							
							}
							
							if (!isset($_v['dsc_monthly_dollar_off'])) {
								$_v['dsc_monthly_dollar_off'] = null;							
							}
							
							if (!isset( $_v['dsc_monthly_percent_off'])) {
								$_v['dsc_monthly_percent_off'] = null;
							}
							$strFields = '';
							foreach ($_v as $k=>$v) {
								$strFields .= (empty($strFields)? '' : ',') . "{$k}=:{$k}";
							}
							
							$sql = "UPDATE IGNORE tbl_discount_code SET {$strFields} WHERE dsc_id=:dsc_id";
							//$errors [1] = $_v;
							$qry = $this->mDbo->prepare($sql);
							
							foreach ($_v as $k=>$v) {
								$qry->bindValue( ":{$k}", $v, \PDO::PARAM_STR );
							}
							
							$qry->execute(  );
							$tmpVal = $qry->rowCount();
							
							if (!$tmpVal) {
								$errors[0] = 'The code could not be edited.';
							}
							
							return $tmpVal? true: false;
						}
						else {
							$errors[0] = 'The code ' . $_v['dsc_code'] . ' already exists.';
						}
					}
					else {
						if (count($errors) === 0)
							array_push($errors, 'This code cannot be deleted, it was already used');							
						else 
							array_push($errors, 'Invalid Request Body');	
					}
					
				}
			}
			else {
				$errors[0] = 'Invalid Request Body';
			}
			
			return false;
		}
		
		function createCode ($requestBody, &$errors) {
			$_response = array();
		
			if ( 
				isset( 
						$requestBody['res_id'],
						$requestBody['dsc_code'],
						$requestBody['dsc_discount_months'],
						$requestBody['dsc_expire_date'],
						$requestBody['dsc_monthly_dollar_off'],
						$requestBody['dsc_monthly_percent_off'],
						$requestBody['dsc_quantity'],
						$requestBody['dsc_setup_fee']
					) 
			) {				
				
				$requestArr['wnu_res_id_r'] = $requestBody['res_id'];
				$requestArr['adn_dsc_code_r'] = $requestBody['dsc_code'];
				
				$fields = array('wnu_res_id_r', 'adn_dsc_code_r');
				
				if (!empty($requestBody['dsc_discount_months'])) {
					$requestArr['wnu3_dsc_discount_months_r'] = $requestBody['dsc_discount_months'];
					array_push($fields, 'wnu3_dsc_discount_months_r');
				}

				if ( !empty( $requestBody['dsc_expire_date'] ) ) {
					
					$requestArr['dat_dsc_expire_date_r'] = $requestBody['dsc_expire_date'];
					array_push($fields, 'dat_dsc_expire_date_r');
										
				}
				
				if (!empty($requestBody['dsc_setup_fee'])) { 
					$requestArr['dec_dsc_setup_fee_r'] = $requestBody['dsc_setup_fee'];
					array_push($fields, 'dec_dsc_setup_fee_r');
				}
				
				if (!empty($requestBody['dsc_quantity'])) {
					$requestArr['wnu2_dsc_quantity_r'] = $requestBody['dsc_quantity'];
					array_push($fields, 'wnu2_dsc_quantity_r');
				}
				
				if ( $requestBody['dsc_monthly_dollar_off'] !== '' ) {
					$requestArr['dec_dsc_monthly_dollar_off_r'] = $requestBody['dsc_monthly_dollar_off'];
					array_push($fields, 'dec_dsc_monthly_dollar_off_r');
				}
				elseif ( $requestBody['dsc_monthly_percent_off'] !== '' ) {
					array_push($fields, 'wnu3_dsc_monthly_percent_off_r');
					$requestArr['wnu3_dsc_monthly_percent_off_r'] = $requestBody['dsc_monthly_percent_off'];
				}
				
				else {
					$errors[0] = 'The discount percentage or the dollar amount has to be entered.';
				}
				
				if ( !isset( $errors[0] ) ) {
					$cv = new \_variables($requestArr); // new instance
					foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
					$_v = $cv->get_cleaned_variables(  );
					$errors= array_values($cv->get_bad_variables(  ));
					
					if ( count( $errors ) === 0 && !$this->codeExists($_v['dsc_code'] ) ) {	
						//let's do it
						
						if ( isset( $_v['dsc_expire_date'] ) ) {
							$originalDate = $_v['dsc_expire_date'];
							$_v['dsc_expire_date'] = date("Y-m-d", strtotime($originalDate));
						}
						
						$strFields = ''; $strValues = '';
						foreach ($_v as $k=>$v) {
							$strFields .= (empty($strFields)? '' : ',') . "{$k}";
							$strValues .= (empty($strValues)? '' : ',')  . ":{$k}";
						}
						
						$sql = "INSERT IGNORE INTO tbl_discount_code ({$strFields}) VALUES ({$strValues})";
						
						$qry = $this->mDbo->prepare($sql);
						
						foreach ($_v as $k=>$v) {
							$qry->bindValue( ":{$k}", $v, \PDO::PARAM_STR );
						}
						
						$qry->execute(  );
						$tmpVal = $this->mDbo->lastInsertId();
						
						if (!$tmpVal) {
							$errors[0] = 'The new code could not be entered, it was already taken.';
						}
						
						return $tmpVal;
						
					}
					else {
						if (count($errors) === 0)
							array_push($errors, 'The code ' . $_v['dsc_code'] . ' already exists.');								
						else
							array_push($errors, 'Invalid Request Body.');	
					}	
				}
			}
			else {
				$errors[0] = 'Invalid Request Body';
			}
			
			return 0;
			
		}
		
	}


}
?>