<?php
namespace App\Jwt{

	class Jwt{
		public static $payload = null;

		public static $dateToCheck = 300;//86400

		public static $timeValue = null;
		public static $supportedAlgs = array(
			'HS256' => array('hash_hmac', 'SHA256'),
			'HS512' => array('hash_hmac', 'SHA512'),
			'HS384' => array('hash_hmac', 'SHA384'),			
		);
		
		public static function decode($jwt, $key, $allowed_algs = array(), &$err, $verifySignature = true)
		{	
			$err = array(); self::$payload = null;
			$timeValue = is_null(static::$timeValue) ? time() : static::$timeValue;
			if (empty($key)) {
				$err = array('Key may not be empty');
				return false;
			}
			if (!is_array($allowed_algs)) {
				$err = array('Algorithm not allowed');
				return false;
			}
			$tks = explode('.', $jwt);
			if (count($tks) != 3) {
				$err = array('Wrong number of segments');
				return false;
			}
			list($headb64, $bodyb64, $cryptob64) = $tks;
			if (null === ($header = static::jsonDecode(static::urlsafeB64Decode($headb64)))) {
				$err = array('Invalid header encoding');
				return false;
			}
			if (null === $payload = static::jsonDecode(static::urlsafeB64Decode($bodyb64))) {
				$err = array('Invalid claims encoding');
				return false;
			}
			$sig = static::urlsafeB64Decode($cryptob64);
			
			if (empty($header->alg)) {
				$err = array('Empty algorithm');
				return false;
			}
			if (empty(static::$supportedAlgs[$header->alg])) {
				$err = array('Algorithm not supported');
				return false;
			}
			if (!in_array($header->alg, $allowed_algs)) {
				$err = array('Algorithm not allowed');
				return false;
			}
			if (is_array($key) || $key instanceof \ArrayAccess) {
				if (isset($header->kid)) {
					$key = $key[$header->kid];
				} else {
					$err = array('"kid" empty, unable to lookup correct key');
					return false;
				}
			}
			
			if ($verifySignature && !static::verifySignature("$headb64.$bodyb64", $sig, $key, $header->alg, $e)) {
				$err = array('Signature verification failed');
				return false;
			}
			
			if (isset($payload->nbf) && $payload->nbf > ($timeValue + static::$dateToCheck)) {
				
				$err = array(
					'Cannot handle token prior to ' . date(DateTime::ISO8601, $payload->nbf)
				);
				return false;
			}
			
			if (isset($payload->iat) && $payload->iat > ($timeValue + static::$dateToCheck)) {
				$err = array(
					'Cannot handle token prior to ' . date(DateTime::ISO8601, $payload->iat)
				);
				return false;
			}
			// Check if this token has expired.
			if (isset($payload->exp) && ($timeValue - static::$dateToCheck) >= $payload->exp) {
				$err = array('Expired token');
				self::$payload = $payload;
				return false;
			}
			return $payload;
		}
		
		public static function encode($payload, $key, $alg = 'HS256', $keyId = null, $head = null)
		{
			$header = array('typ' => 'JWT', 'alg' => $alg);
			if ($keyId !== null) {
				$header['kid'] = $keyId;
			}
			if ( isset($head) && is_array($head) ) {
				$header = array_merge($head, $header);
			}
			$segments = array();
			$segments[] = static::urlsafeB64Encode(static::jsonEncode($header, $e));
			$segments[] = static::urlsafeB64Encode(static::jsonEncode($payload, $e));
			$signing_input = implode('.', $segments);
			$signature = static::sign($signing_input, $key, $alg, $e);
			$segments[] = static::urlsafeB64Encode($signature);
			return implode('.', $segments);
		}
		
		public static function sign($msg, $key, $alg = 'HS256', &$err)
		{
			if (empty(static::$supportedAlgs[$alg])) {
				$err = array('Algorithm not supported');
				return false;
			}
			list($function, $algorithm) = static::$supportedAlgs[$alg];
			switch($function) {
				case 'hash_hmac':
					return hash_hmac($algorithm, $msg, $key, true);
			}
		}
		
		public static function verifySignature($msg, $signature, $key, $alg, &$err)
		{
			if (empty(static::$supportedAlgs[$alg])) {
				$err = array('Algorithm not supported');
				return false;
			}
			list($function, $algorithm) = static::$supportedAlgs[$alg];
			switch($function) {
				
				case 'hash_hmac':
				default:
					$hash = hash_hmac($algorithm, $msg, $key, true);
					if (function_exists('hash_equals')) {
						return hash_equals($signature, $hash);
					}
					$len = min(static::safeStrlen($signature), static::safeStrlen($hash));
					$status = 0;
					for ($i = 0; $i < $len; $i++) {
						$status |= (ord($signature[$i]) ^ ord($hash[$i]));
					}
					$status |= (static::safeStrlen($signature) ^ static::safeStrlen($hash));
					return ($status === 0);
			}
		}
		
		public static function jsonDecode($input)
		{
			if (version_compare(PHP_VERSION, '5.4.0', '>=') && !(defined('JSON_C_VERSION') && PHP_INT_SIZE > 4)) {
				
				$obj = json_decode($input, false, 512, JSON_BIGINT_AS_STRING);
			} else {
				
				$max_int_length = strlen((string) PHP_INT_MAX) - 1;
				$json_without_bigints = preg_replace('/:\s*(-?\d{'.$max_int_length.',})/', ': "$1"', $input);
				$obj = json_decode($json_without_bigints);
			}
			if (function_exists('json_last_error') && $errno = json_last_error()) {
				static::handleJsonError($errno, $err);
			} elseif ($obj === null && $input !== 'null') {
				$err = array('Null result with non-null input');
			}
			return $obj;
		}
		
		public static function jsonEncode($input, &$err)
		{
			$json = json_encode($input);
			if (function_exists('json_last_error') && $errno = json_last_error()) {
				static::handleJsonError($errno, $err);
			} elseif ($json === 'null' && $input !== null) {
				$err = array('Null result with non-null input');
				return false;
			}
			return $json;
		}
		
		public static function urlsafeB64Decode($input)
		{
			$remainder = strlen($input) % 4;
			if ($remainder) {
				$padlen = 4 - $remainder;
				$input .= str_repeat('=', $padlen);
			}
			return base64_decode(strtr($input, '-_', '+/'));
		}
		
		public static function urlsafeB64Encode($input)
		{
			return str_replace('=', '', strtr(base64_encode($input), '+/', '-_'));
		}
		
		private static function handleJsonError($errno, &$err)
		{
			$messages = array(
				JSON_ERROR_DEPTH => 'Maximum stack depth exceeded',
				JSON_ERROR_CTRL_CHAR => 'Unexpected control character found',
				JSON_ERROR_SYNTAX => 'Syntax error, malformed JSON'
			);
			$err= array(
				isset($messages[$errno])
				? $messages[$errno]
				: 'Unknown JSON error: ' . $errno
			);
		}
		
		private static function safeStrlen($str)
		{
			if (function_exists('mb_strlen')) {
				return mb_strlen($str, '8bit');
			}
			return strlen($str);
		}
	}
}