<?php
namespace App\Mailgun {
	
//_____________________________________________________Class mailgun_____________________________________________________________
	class mailgun { 
		const testEmail = 'fady@loyaltysuperstore.com';
		const emailFrom = 'noreply@localthanks.com';
		const globApiUrl = 'https://api.mailgun.net/v3';
		const apiUrl = 'https://api.mailgun.net/v3/mg.localthanks.com';
		const pubKey = 'pubkey-260439c530a0ad57ae0078831970e9a4';
		const secKey = 'key-d709f156f44297ca337abd691b3650a0';

		private $dbObj = null;
		
		//private function
		private function buildEmail($email_settings){
			require_once 'global.php';
			require_once 'function.get-subdir.php';

			// set defaults if needed
			if (!isset($email_settings['ema_fname'])) $email_settings['ema_fname'] = 'Luke';
			if (!isset($email_settings['ema_lname'])) $email_settings['ema_lname'] = 'Skywalker';
			if (!isset($email_settings['ema_fullname'])) $email_settings['ema_fullname'] = $email_settings['ema_fname'].' '.$email_settings['ema_lname'];
			if (!isset($email_settings['ema_number_1'])) $email_settings['ema_number_1'] = '123';
			if (!isset($email_settings['ema_message'])) $email_settings['ema_message'] = 'Hello.';
			if (!isset($email_settings['ema_ltm_id'])) $email_settings['ema_ltm_id'] = '1';
			if (!isset($email_settings['ema_csr_email'])) $email_settings['ema_csr_email'] = CSR_FORM_EMAIL;
			if (!isset($email_settings['ema_csr_phone'])) $email_settings['ema_csr_phone'] = CSR_PHONE_NUMBER;
			
			$sql = "SELECT LTM.ltm_company_name, LTB.ltb_slug, LTB.ltb_id, LTB.ltb_header_image FROM lt_merchants LTM INNER JOIN lt_member_merchants LTB ON LTM.ltb_id = LTB.ltb_id WHERE ltm_id=:ltm_id LIMIT 1";
			$stmt = $this->dbObj->prepare( $sql );
			$stmt->bindValue(':ltm_id', $email_settings['ema_ltm_id'], \PDO::PARAM_INT);
			$stmt->execute();
			$res=$stmt->fetchAll(\PDO::FETCH_ASSOC);
			$email_settings['ema_ltb_id'] = $res[0]['ltb_id'];
			$email_settings['ema_slug'] = $res[0]['ltb_slug'];
			$email_settings['ema_header_image'] = $res[0]['ltb_header_image'];
			$email_settings['ema_company_name'] = $res[0]['ltm_company_name'];
			
			if ($email_settings['ema_header_image'] === NULL){
				$email_settings['ema_header'] = '{%%company_name%%}';
			} else {
				$email_settings['ema_header'] = '<img src="http://localthanks.{%%tld%%}/merchant-custom-files/{%%subdir_ltb_id%%}/_files/img/h_250w_{%%header_image%%}" border="0" alt="{%%company_name%%}">';
			}

			// replace header
			$email_settings['ema_body'] = str_replace('{%%header%%}', $email_settings['ema_header'], $email_settings['ema_body']);

			// check the host and get our top level domain
			$email_settings['ema_sub'] = explode( '.', $_SERVER['HTTP_HOST'], 3 );
			$email_settings['ema_TLD'] = $email_settings['ema_sub'][2];
			if(count($email_settings['ema_sub'])==2){$email_settings['ema_TLD'] = $email_settings['ema_sub'][1];}

			// replace placeholders with real info
			$email_settings['ema_body'] = str_replace('{%%login_email%%}', '?login=' . $email_settings['ema_email'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%email%%}', $email_settings['ema_email'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%FirstName%%}', $email_settings['ema_fname'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%LastName%%}', $email_settings['ema_lname'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%FullName%%}', $email_settings['ema_fullname'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%company_name%%}', $email_settings['ema_company_name'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%number_1%%}', $email_settings['ema_number_1'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%message%%}', $email_settings['ema_message'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%header_image%%}', $email_settings['ema_header_image'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%tld%%}', $email_settings['ema_TLD'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%slug%%}', $email_settings['ema_slug'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%subdir_ltb_id%%}', getMerchantSubDir($email_settings['ema_ltb_id']), $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%ltb_id%%}', $email_settings['ema_ltb_id'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%ltm_id%%}', $email_settings['ema_ltm_id'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%csr_phone%%}', $email_settings['ema_csr_phone'], $email_settings['ema_body']);
			$email_settings['ema_body'] = str_replace('{%%csr_email%%}', $email_settings['ema_csr_email'], $email_settings['ema_body']);

			return $email_settings;
		}
		
		//public functions
		public function validateEmail ($emailAddress) {
			$url = self::globApiUrl . '/address/validate';
			$fields = array(
				'address' => urlencode($emailAddress) 
			);
			$username = 'mg.localthanks.com';
			$password = self::pubKey;
			
			$fields_string = '?';
			//url-ify the data for the POST
			foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');

			//open connection
			$ch = curl_init();
			
			curl_setopt($ch,CURLOPT_URL, $url.$fields_string);
			curl_setopt($ch, CURLOPT_TIMEOUT, 30); //timeout after 30 seconds
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
			curl_setopt($ch, CURLOPT_USERPWD, "$username:$password");
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			//curl_setopt($ch,CURLOPT_POST, 0);
			//curl_setopt($ch, CURLOPT_HTTPGET, 1);
			//curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
			
			//execute post
			$result = @json_decode(curl_exec($ch), true);
			
			//close connection
			curl_close($ch);
			return $result;
		}
		
		public function sendEmail( $email_settings ) {

			if (!isset($email_settings['ema_body'])){
				$Result['Error'] = 'Missing "ema_body" field.';
				return $Result;
			}

			// set from and to emails
			if (empty($email_settings['from'])){ $email_settings['from'] = self::emailFrom; }
			if (empty($email_settings['ema_email'])){ $email_settings['ema_email'] = self::testEmail; }

			// validate email
			$tmpResponseTo = $this->validateEmail( $email_settings['ema_email'] );
			$tmpResponseFrom = $this->validateEmail( $email_settings['from'] );
			if (!isset($tmpResponseTo['is_valid']) || !$tmpResponseTo['is_valid']) {
				$Result['Error'] = 'The email: ' . $email_settings['ema_email'] . ' is not a valid email address';
				return $Result;
			}
			else if (!isset($tmpResponseFrom['is_valid']) || !$tmpResponseFrom['is_valid']) {
				$Result['Error'] = 'The email: ' .$email_settings['from']. ' is not a valid email address';
				return $Result;
			}
			else {
				// build email
				$email_settings = $this->buildEmail($email_settings);
				
				// prepare to send
				$url = self::apiUrl . '/messages';
				$fields = array(
					'from' => urlencode($email_settings['from']),
					'to' => urlencode($email_settings['ema_email']),
					'subject' => urlencode($email_settings['ema_subject']),
					'text' => urlencode($email_settings['text']),
					'html' => urlencode($email_settings['ema_body'])
				);
				$username = 'api';
				$password = self::secKey;
				
				$fields_string = '';
				//url-ify the data for the POST
				foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
				rtrim($fields_string, '&');

				//open connection
				$ch = curl_init();
				
				curl_setopt($ch, CURLOPT_URL, $url);
				curl_setopt($ch, CURLOPT_TIMEOUT, 30); //timeout after 30 seconds
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
				curl_setopt($ch, CURLOPT_USERPWD, "$username:$password");
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
				
				//execute post
				// $Result['Result']['Email'] = $newEmailRec;
				// $Result['Result']['Structure'] = $emailStruct;
				$Result['Result']['Response'] = @json_decode(curl_exec($ch), true);
				
				//close connection
				curl_close($ch);
				return $Result['Result'];
				
			}
		}

		public function __construct($dbObj) {
			$this->dbObj = $dbObj;
		}
		
	}
	
}	
//_____________________________________________________End Class mailgun_____________________________________________________________
?>