<?php
namespace App\MemberMerchant {
	require_once "class.promo.php";
	require_once "class.store.php";
	require_once "class.variables.php";
	require_once "class.prismpay.php";
	if ( \NEW_DB_SWITCH ) {		
		require_once "class.package.php";
	}	
	use App\MemberMerchant\Promo as Promo;
	use App\MemberMerchant\Store  as Store;	
	use App\Prismpay as Prismpay;
	use App\Package as Package;
	
	class MemberMerchant {
		
		// Private Properties
		private $userLocation = array('lat'=>0.00000, 'lng'=>0.00000);
		private $maxPromoDisplay = array();
		private $totalActivePromos = null;
		private $mDbo;
		private $croosPromMerchId = 0;

		// Public Properties

		public $mRecords = array();
		public $currentMerchantId=0;
		
		// Private Methods
		private function countActivePromos () {
			$this->totalActivePromos = 0;
			$stmt = $this->mDbo->prepare("
			SELECT COUNT(PRM.ltp_id) AS totalActive
			FROM lt_member_merchants MMC
			INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id
			INNER JOIN lt_promos PRM ON PRM.ltb_id=MMC.ltb_id 
			WHERE MMC.ltb_id=:ltbId AND ((CURDATE() <= PRM.ltp_enddate AND CURDATE() >= PRM.ltp_startdate) OR (PRM.ltp_enddate IS NULL AND PRM.ltp_startdate IS NULL)) AND PRM.ltp_active " );				
			$stmt->bindValue( ":ltbId", $this->currentMerchantId, \PDO::PARAM_INT );
			$stmt->execute(  );
			if ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				$this->totalActivePromos = $resultSet['totalActive'];
			}
		}
		
		private function loadRecords($ltbId = null, $loadPromos = false, $offset = 0) {
			$varOffset = $offset;
			if ( !is_int( $varOffset ) || $varOffset <= 0) $varOffset = '0';
			
			/*DO NOT UPLOAD THIS FUNCTION CHANGES, UNLESS THE NEW DB STRUCTURE AND FEATURES ARE IN PLACE*/
			
			//INNER JOIN lt_plan_type AS PTY ON MMC.pty_id = PTY.pty_id
			//INNER JOIN lt_merchant_plans AS PTM ON PTM.lmp_id = MMC.lmp_id
			
			$sql = \NEW_DB_SWITCH?"
			SELECT DISTINCT MMC. *, PACK.*, PROD.*, TMZ.*
			FROM lt_member_merchants MMC
			INNER JOIN tbl_package PACK ON MMC.pk_id = PACK.pk_id
			INNER JOIN tbl_product PROD ON PACK.pk_id = PROD.prod_id
			INNER JOIN tbl_timezone TMZ ON MMC.tmz_id = TMZ.tmz_id
			": "
			SELECT DISTINCT MMC. *, PTY.*, PTM.*, TMZ.*
			FROM lt_member_merchants MMC
			INNER JOIN lt_plan_type AS PTY ON MMC.pty_id = PTY.pty_id
			INNER JOIN lt_merchant_plans AS PTM ON PTM.lmp_id = MMC.lmp_id
			INNER JOIN tbl_timezone TMZ ON MMC.tmz_id = TMZ.tmz_id
			";
			
			$stmt = $this->mDbo->prepare($sql.( $ltbId === null? "LIMIT 100 OFFSET {$varOffset}": " WHERE MMC.ltb_id=:ltbId LIMIT 1" ) );
			if ( $ltbId !== null )
				$stmt->bindValue( ":ltbId", $ltbId, \PDO::PARAM_INT );
			$stmt->execute();
			
			if ( \NEW_DB_SWITCH )
				$packObj = new Package\package( $this->mDbo, 0 );
			while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				$resultSet['Switches']= $this->gatMerchantSwitches( $resultSet['ltb_id'] );
				
				$resultSet['Plan'] = \NEW_DB_SWITCH? $packObj->findBasicProductList ( $resultSet['pk_id'] ) : $this->gatPlanFeatures( $resultSet['ltb_id'], $resultSet['lmp_id'] );	
				
				if ( \NEW_DB_SWITCH ) {
					$tmpOk = $packObj->getRecords( $resultSet['pk_id'], 'Max_Promos' );
					$this->maxPromoDisplay[$resultSet['ltb_id']] = !is_array($tmpOk)? $tmpOk: 0;						
				}	
				$resultSet['Store']= new Store\MerchantStore( $this->mDbo );
				$resultSet['Store']->loadRecords( $resultSet['ltb_id'], 'ltb_id', \PDO::PARAM_INT );
								
				if ($loadPromos) {
					$resultSet['Promo'] = new Promo\MerchantPromo( $this->mDbo, null);					
					$resultSet['Promo']->loadRecords( $resultSet['ltb_id'], 'ltb_id', 'MMC', isset($resultSet['Switches']['randomize_promos']) && $resultSet['Switches']['randomize_promos']? 'random' : 'default' );						
				}
				else
					$resultSet['Promo'] = null;
				$this->mRecords[$resultSet['ltb_id']] = $resultSet;
				$this->currentMerchantId = $resultSet['ltb_id'];
				$this->nationalMallJumpBasedOnRes();				
			}	
		}
		
		function merchantHasProduct ( $productName ) {	
			if ( is_array( $this->mRecords[$this->currentMerchantId]['Plan'] ) ) {
				foreach ( $this->mRecords[$this->currentMerchantId]['Plan'] as $prodId => $valArr ) {					
					//var_dump($valArr['Data']['prod_keyword']);					
					if ( strcmp( $valArr['Data']['prod_keyword'], $productName ) === 0 ) {
						return true;
					}
				}
			}
			return false;
		}
	
		private function loadPayments() {			
			if ( $this->currentMerchantId > 0 && isset($this->mRecords[$this->currentMerchantId]) && !isset($this->mRecords[$this->currentMerchantId]['Payments']) ) {
				$this->mRecords[$this->currentMerchantId]['Payments'] = array();
				$stmt = $this->mDbo->prepare("
				SELECT CCD.*
				FROM lt_m2ccards NCD
				INNER JOIN lt_member_merchants MMC ON MMC.ltb_id = NCD.ltb_id
				INNER JOIN tbl_creditcards CCD ON NCD.ccd_id = CCD.ccd_id				
				WHERE MMC.ltb_id=:ltbId" );					
				$stmt->bindValue( ":ltbId", $this->currentMerchantId, \PDO::PARAM_INT );
				$stmt->execute();
				while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {											
					$this->mRecords[$this->currentMerchantId]['Payments'][$resultSet['ccd_id']] = $resultSet;				
				}
			}
		}
		
		//protected functions
		protected function gatPlanFeatures($ltbId, $lmpId) {
			
			//echo "It was called";
			
			$Result = array();

			if (!isset($this->mRecords[$ltbId]['Plan'], $this->maxPromoDisplay[$ltbId])) {
				$sqlString = '
				SELECT LMP.lmp_id, LMP.lmp_name, LMP.pty_id, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
				FROM lt_merchant_plans LMP 
				INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
				LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
				WHERE LMP.lmp_id = :lmp_id AND LPF.lpf_active = 1 AND (MFC.ltb_id IS NULL OR MFC.ltb_id = :ltb_id) ORDER BY MFC.ltb_id ASC';
				$p = $this->mDbo->prepare( $sqlString );
				$p->bindValue(':lmp_id', $lmpId, \PDO::PARAM_INT);
				$p->bindValue(':ltb_id', $ltbId, \PDO::PARAM_INT);
				$p->execute();
				$rSet = $p->fetchAll(\PDO::FETCH_ASSOC);				
				foreach ( $rSet as $v ) {
					 if (!$Result){
						$Result = array(
						  'lmp_id'                => $v['lmp_id'],
						  'pty_id'                => $v['pty_id'],
						  'lmp_name'              => $v['lmp_name']
						);
						$Result['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
					  } 
					  else {
						// this will overwrite the default plan values with custom merchant values 
						$Result['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
						
					  }	
					  if ( $v['lpf_id'] == '19' ) {$this->maxPromoDisplay[$ltbId] = (int) $v['mfc_count'];}						
				}
				//echo 'Searched ' . $this->maxPromoDisplay[$ltbId];
			}
			else {$Result = $this->mRecords[$ltbId]['Plan']; /*echo 'Did not search '.$this->maxPromoDisplay[$ltbId];*/}
			
			return $Result;
		}
		
		protected function gatMerchantSwitches( $ltbId ) {
			$Result = array();
			if (!isset($this->mRecords[$ltbId]['Switches'])) {
				$sqlString = '
					SELECT M2S.swt_name
					FROM lt_merchants LTM
					INNER JOIN lt_member_merchants LTB ON LTM.ltb_id=LTB.ltb_id
					INNER JOIN lt_mmerch2switch M2S ON LTM.ltb_id=M2S.ltb_id
					WHERE LTM.ltb_id = :ltbId AND LTM.ltm_active=1
				';
				$p = $this->mDbo->prepare( $sqlString );				
				$p->bindValue(':ltbId', $ltbId, \PDO::PARAM_INT);
				$p->execute();
				$rSet = $p->fetchAll(\PDO::FETCH_ASSOC);				
				foreach ( $rSet as $v ) {
					$Result[$v['swt_name']] = true; 
				}				
			}
			else {$Result = $this->mRecords[$ltbId]['Switches'];}
			
			return $Result;
		}
		
		function getMerchantReseller( $ltbId ) {
			$Result = array();
			if (!isset($this->mRecords[$ltbId]['Reseller'])) {
				$sqlString = '
					SELECT RES.*
					FROM lt_member_merchants MMR
					INNER JOIN tbl_reseller RES ON RES.res_id = MMR.res_id
					WHERE MMR.ltb_id = :ltbId
					LIMIT 1
				';
				$p = $this->mDbo->prepare( $sqlString );				
				$p->bindValue(':ltbId', $ltbId, \PDO::PARAM_INT);
				$p->execute();				
				$this->mRecords[$ltbId]['Reseller'] = $p->fetch(\PDO::FETCH_ASSOC);
				return $this->mRecords[$ltbId]['Reseller'];
			}
			else {$Result = $this->mRecords[$ltbId]['Reseller'];}
			return $Result;
		}
		
		protected function validData(&$cleanData, $fieldValue, $fileType='wnu_ltb_id_r' ){
			$_tempArr[$fileType] = $fieldValue;
			$cv= new \_variables($_tempArr); //new instance
			$cv_array=array($fileType); //list all varibles to be check in array
			foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
			$clean=$cv->get_cleaned_variables();
			$errors=$cv->get_bad_variables();
			if ( !count( $errors ) ) {
				$cleanData = $clean;
				return true;				
			}
			//var_dump($cleanData);
			return false;
		}
		
		//Public Methods
		/*
		function getCurrentBilling ( $ltbId ) {
			if ( $this->validData($cleanActive, $ltbId, $fileType='wnu_ltbId_r' ) ) {
				$sql = "
					SELECT BILL.bill_id, BILL.bill_name, BILL.bill_orderid, BILL.lmp_id, BILL.bill_date, BILL.bill_cyclestart, BILL.bill_cycleend, BILL.bill_active
					FROM lt_merchant_billing BILL 
					INNER JOIN lt_merchants MRC ON BILL.ltm_id = MRC.ltm_id
					INNER JOIN lt_member_merchants MMC ON MRC.ltb_id=MMC.ltb_id 
					WHERE MMC.ltb_id = :ltb_id AND BILL.bill_active = 1 
					ORDER BY BILL.bill_date DESC 
					LIMIT 1";
				$qry = $this->mDbo->prepare( $sql );
				$qry->bindValue(':ltb_id',$cleanActive['ltbId'], \PDO::PARAM_INT);
				$qry->execute(); 
				return $qry->fetchAll( \PDO::FETCH_ASSOC );
			}
			return array();	
		}
		*/
		
		function getCurrentBilling ( $ltbId, $checkIsNotCancelled = false ) {
			if ( $this->validData($clean, $ltbId, $fileType='wnu_ltbId_r' ) ) {
				$sql = "
					SELECT BILL.dsc_id,BILL.bill_accountnumber,BILL.bill_id, BILL.bill_name, BILL.bill_orderid, BILL.lmp_id, BILL.bill_date, BILL.bill_cyclestart, BILL.bill_cycleend, BILL.bill_active
					FROM lt_merchant_billing BILL 
					INNER JOIN lt_merchants MRC ON BILL.ltm_id = MRC.ltm_id
					INNER JOIN lt_member_merchants MMC ON MRC.ltb_id=MMC.ltb_id 
					WHERE 
						MMC.ltb_id = :ltb_id AND 
						BILL.bill_active = 1 
						".($checkIsNotCancelled? "
						AND BILL.bill_id NOT IN 
							(
								SELECT BILL1.bill_id
								FROM lt_merchant_billing BILL1 
								INNER JOIN tbl_prod2trans P2T ON P2T.bill_id = BILL1.bill_id
								INNER JOIN tbl_transaction TR ON P2T.tr_id = TR.tr_id
								WHERE 
									TR.tr_type = 'cancellation'
							)
						":"")."
					ORDER BY BILL.bill_date DESC 
					LIMIT 1";
				$qry = $this->mDbo->prepare( $sql );
				$qry->bindValue(':ltb_id',$clean['ltbId'], \PDO::PARAM_INT);
				$qry->execute(); 
				return $qry->fetchAll( \PDO::FETCH_ASSOC );
			}
			return array();	
		}
		
		function isActive ( $ltbId ) {
			if ( isset($this->mRecords[$ltb_id]) ) 
				return intval($this->mRecords[$ltb_id]['ltb_active']) === 1? true : false;
			else
			if ( $this->validData($clean, $ltbId, $fileType='wnu_ltbId_r' ) ) {
				$sql = "
					SELECT *
					FROM lt_merchants MRC
					INNER JOIN lt_member_merchants MMC ON MRC.ltb_id=MMC.ltb_id 
					WHERE MMC.ltb_id = :ltb_id AND MMC.ltb_active
					LIMIT 1";
				$qry = $this->mDbo->prepare( $sql );
				$qry->bindValue(':ltb_id',$clean['ltbId'], \PDO::PARAM_INT);
				$qry->execute(); 
				return $tmp = $qry->fetchAll( \PDO::FETCH_ASSOC );
			}
			return false;	
		}
		
		function getMerchInfo($ltb_id, $forceReload = false) {
			if ( !$forceReload && isset($this->mRecords[$ltb_id]) ) 
				return $this->mRecords[$ltb_id];
			elseif ($this->validData($clean, $ltb_id, $fileType='wnu_ltbid_r' )) {
				$this->loadRecords($clean['ltbid']);
				return isset($this->mRecords[$clean['ltbid']])? $this->mRecords[$clean['ltbid']]:[];
			}	
			else
				return [];
		}
		
		function getDiscountCodeUsed (  ) {
			$sql = "
				SELECT DSC.dsc_code
				FROM lt_merchant_billing BILL
				INNER JOIN lt_merchants MRC ON BILL.ltm_id = MRC.ltm_id
				INNER JOIN lt_member_merchants MMC ON MRC.ltb_id = MMC.ltb_id
				INNER JOIN tbl_discount_code DSC ON DSC.dsc_id = BILL.dsc_id
				WHERE MMC.ltb_id = :ltb_id
				ORDER BY BILL.bill_id
			";
			$qry = $this->mDbo->prepare( $sql );
			$qry->bindValue(':ltb_id',$this->currentMerchantId, \PDO::PARAM_INT);
			$qry->execute();
			$tmp = $qry->fetch( \PDO::FETCH_ASSOC );
			return isset($tmp['dsc_code'])? $tmp['dsc_code'] : ''; 
		}
		
		function getScheduledBillings (  ) {
			$sql = "
			SELECT BILL.dsc_id, BILL.bill_id, BILL.bill_name, BILL.bill_orderid, BILL.lmp_id, BILL.bill_date, BILL.bill_cyclestart, BILL.bill_cycleend, BILL.bill_active 
			FROM lt_merchant_billing BILL
			INNER JOIN lt_merchants MRC ON BILL.ltm_id = MRC.ltm_id
			INNER JOIN lt_member_merchants MMC ON MRC.ltb_id=MMC.ltb_id 
			WHERE MMC.ltb_id = :ltb_id AND (BILL.bill_active = 1 OR DATEDIFF(BILL.bill_cyclestart, DATE(NOW())) >= 0 )
			ORDER BY BILL.bill_date DESC";
			$qry = $this->mDbo->prepare( $sql );
			$qry->bindValue(':ltb_id',$this->currentMerchantId, \PDO::PARAM_INT);

			$qry->execute();  
			return $qry->fetchAll( \PDO::FETCH_ASSOC ); 
		}
		
		function updateBillingPeriod ( $billId, $amount = null, $active = 1 ) {
			if ( $this->validData($cleanActive, $active, $fileType='bit_active_r' ) && ( !isset( $amount ) || $this->validData( $cleanAmount, $amount, $fileType='dec_amount_r' ) ) && $this->validData($clean, $billId, $fileType='wnu_billId_r' ) ) {
				$sql = "
				UPDATE lt_merchant_billing BILL
				SET BILL.bill_active = :active".(empty($cleanActive['active'])? ', BILL.bill_canceled=NOW()':'').( isset( $cleanAmount['amount'] )?', BILL.bill_price = :amount':'' )."
				WHERE BILL.bill_id = :billId";
				$qry = $this->mDbo->prepare( $sql );
				$qry->bindValue(':billId', $clean['billId'], \PDO::PARAM_INT);
				if (isset($cleanAmount['amount']))
					$qry->bindValue(':amount', $cleanAmount['amount'], \PDO::PARAM_INT);
				$qry->bindValue(':active', intval( $cleanActive['active'] ), \PDO::PARAM_INT);
				$qry->execute();  
				return $qry->rowCount()? true: false;
			}
			return false;
		}
		
		function updateMerchantPlan ( $ltbId, $pkId ) {
			if ( 
				    $this->validData($cleanLtb, $ltbId, $fileType='wnu_ltbId_r' )				
				 && $this->validData($cleanPk, $pkId, $fileType='wnu_pkId_r' ) 
			   ) {
					$sql = "UPDATE lt_member_merchants SET pk_id=:pk_id WHERE ltb_id=:ltb_id AND ltb_id <> 1";
					$qry = $this->mDbo->prepare( $sql );					
					$qry->bindValue(':ltb_id', $cleanLtb['ltbId'], \PDO::PARAM_INT);
					$qry->bindValue(':pk_id', $cleanPk['pkId'], \PDO::PARAM_INT);
					$qry->execute();  
					return $qry->rowCount()? true: false;
			}
			return false;
		}
		
		function resetProductCounts ( $ltbId ) {
			if ( 
				    $this->validData($cleanLtb, $ltbId, $fileType='wnu_ltbId_r' )								
			   ) {
					$sql = "DELETE FROM tbl_use_count WHERE ltb_id=:ltb_id AND ltb_id <> 1";
					$qry = $this->mDbo->prepare( $sql );					
					$qry->bindValue(':ltb_id', $cleanLtb['ltbId'], \PDO::PARAM_INT);
					$qry->execute();  
					return $qry->rowCount()? true: false;
			}
			return false;
		}
		
		function resetProductCountsFromMax ( $ltbId ) {
			if ( 
				    $this->validData($cleanLtb, $ltbId, $fileType='wnu_ltbId_r' )								
			   ) {	
					$tmp = $this->getCurrentMerchantPack( $ltbId );
					if ( isset( $tmp['pk_id'] ) ) {
						$packObj = new Package\package( $this->mDbo, 0 );	
						$tmp = $packObj->findBasicProductList ( $tmp['pk_id'] );
						$this->resetProductCounts ( $ltbId );
						foreach ( $tmp as $prodId => $valArr ) {
							if ( isset( $valArr['Data']['p2p_count'] ) && intval($valArr['Data']['p2p_count']) > 0 ) {
								$sql = "INSERT IGNORE INTO tbl_use_count (prod_id, ltb_id, use_count) VALUES (:prod_id, :ltb_id, :count)";
								$qry = $this->mDbo->prepare( $sql );					
								$qry->bindValue(':ltb_id', $cleanLtb['ltbId'], \PDO::PARAM_INT);
								$qry->bindValue(':prod_id', $prodId, \PDO::PARAM_INT);
								$qry->bindValue(':count', $valArr['Data']['p2p_count'], \PDO::PARAM_INT);
								$qry->execute();
							}	
						}
						return $qry->rowCount(  )? true: false;
					}
			}
			return false;
		}
		
		function productCountsOldPk_NewPk ( $ltbId, $oldPackId, $newPackId ) {
			if (
				    $this->validData($cleanOld, $oldPackId, $fileType='wnu_pkId_r' ) &&
					$this->validData($cleanNew, $newPackId, $fileType='wnu_pkId_r' ) &&
					$this->validData($cleanLtb, $ltbId, $fileType='wnu_ltbId_r' )
			   ) {
					$packObj = new Package\package( $this->mDbo, 0 );	
					$tmpOld = $packObj->findBasicProductList ( $cleanOld['pkId'] );
					$tmpNew = $packObj->findBasicProductList ( $cleanNew['pkId'] );					
					
					foreach ( $tmpOld as $prodId => $valArr ) {
						foreach ( $tmpNew as $prodId1 => $valArr1 ) {
							if ( $valArr1['Data']['prod_id'] !== $valArr['Data']['prod_id'] ) {
								$tmpNew[$prodId1]['Data']['p2p_count'] = intval($tmpNew[$prodId1]['Data']['p2p_count']) - intval($tmpOld[$prodId]['Data']['p2p_count']);
							}
						}
						$sql = "DELETE FROM tbl_use_count WHERE prod_id=:prod_id AND ltb_id=:ltb_id";
						$qry = $this->mDbo->prepare( $sql );					
						$qry->bindValue(':ltb_id', $cleanLtb['ltbId'], \PDO::PARAM_INT);
						$qry->bindValue(':prod_id', $prodId, \PDO::PARAM_INT);						
						$qry->execute();						
					}
					
					foreach ( $tmpNew as $prodId => $valArr ) {
						if ( isset( $valArr['Data']['p2p_count'] ) && intval($valArr['Data']['p2p_count']) > 0 ) {
							$sql = "INSERT IGNORE INTO tbl_use_count (prod_id, ltb_id, use_count) VALUES (:prod_id, :ltb_id, :count)";
							$qry = $this->mDbo->prepare( $sql );					
							$qry->bindValue(':ltb_id', $cleanLtb['ltbId'], \PDO::PARAM_INT);
							$qry->bindValue(':prod_id', $prodId, \PDO::PARAM_INT);
							$qry->bindValue(':count', $valArr['Data']['p2p_count'], \PDO::PARAM_INT);
							$qry->execute();
						}	
					}
					
					return $qry->rowCount(  )? true: false;
					
			}
			return false;
		}
		
		function deactivateAccount ( $ltbId ) {
			if ( $this->validData($clean, $ltbId, $fileType='wnu_ltbId_r' ) ) {
				$sql = "
					UPDATE IGNORE lt_member_merchants MMC 
					INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id 
					LEFT JOIN tbl_consumer CSM ON CSM.ltm_pick_id=MRC.ltm_id 
					SET CSM.ltm_pick_id = 1, MMC.ltb_active = 0  
					WHERE MMC.ltb_id=:ltb_id
				";
				$_q  = $this->mDbo->prepare($sql);
				$_q->bindValue(':ltb_id', $clean['ltbId'], \PDO::PARAM_INT);
				$_q->execute(  );
				if ( $_q->rowCount() > 0 ) {
					//if ( !$this->pendantPlanCancellation( $clean['ltbId'] ) )
					$this->cancelAllBillings($clean['ltbId'], $err, $billings, false);
					return true;
				}
			}
			return false;
		}
		
		function cancelNextBillingPiriod($ltbId, &$errors) {
			
			$this->cancelAllBillings( $ltbId, $errors, $my_bills );
			
			$my_bill = $this->getCurrentBilling ( $ltbId ); $errors=[];
			
			//var_dump($my_bill);
			
			$this->cancelBillings ($my_bill, true);
			
			return false; 
		}
		
		private function cancelBillings ($billsArr, $enterCancelTrans = false) {
			if( isset( $billsArr[0]['bill_orderid'] ) ) {
				$pPObj = new Prismpay\prismPay( $this->mDbo );
				//cancel previous recurring sub
				foreach ($billsArr as $val) {
					$uri = array(
						'action' => 'recur_cancel',
						'canceltype' => 1 //next billin period				
					);

					//process cancelation
					$thisPay =  $pPObj->cancelBilling ( $val['bill_orderid'], $uri );

					// check cancel status
					if( $thisPay['status'] == "Declined" ) {
						$reason = explode( ':', str_replace('..', '', $thisPay['reason']) );
						// show errors
						array_push($errors, 'There was a problem canceling your current subscription: "'. $reason[2]);
					} elseif ( $thisPay['status'] == "Accepted" ) {

						//deactivate bill
						$qry = $this->mDbo->prepare("
							UPDATE `lt_merchant_billing`
							SET bill_cycleend = 
								(
									CASE 
										WHEN DATE_ADD(bill_cyclestart, INTERVAL FLOOR(DATEDIFF(CURDATE(), bill_cyclestart) / 31) MONTH) > CURDATE() 
										THEN DATE_ADD(bill_cyclestart, INTERVAL FLOOR(DATEDIFF(CURDATE(), bill_cyclestart) / 31) MONTH) 
										ELSE DATE_ADD(bill_cyclestart, INTERVAL (FLOOR(DATEDIFF(CURDATE(), bill_cyclestart) / 31) + 1) MONTH )
									END 
								)
							WHERE bill_id = :bill_id"
						);
						
						$qry->bindValue( ':bill_id', $val["bill_id"], \PDO::PARAM_INT );
						$qry->execute();
						
						if ($enterCancelTrans) {
							
						}
						
						return true;
						
					} else {
						array_push($errors, 'Your transaction could not be completed at this time.');
					}
				}
				
			}
			
			return false;
		}
		
		public function pendantPlanCancellation($ltbId) {
			if ( $this->validData($clean, $ltbId, $fileType='wnu_ltbId_r' ) ) {
				$sql = "
					SELECT TR.tr_id
					FROM tbl_transaction TR 					
					INNER JOIN tbl_prod2trans P2T ON P2T.tr_id=TR.tr_id					
					INNER JOIN lt_merchant_billing BILL ON BILL.bill_id = P2T.bill_id
					INNER JOIN tbl_prod_price PPR ON PPR.ppr_id = P2T.ppr_id
					
					
					INNER JOIN tbl_product PROD ON PPR.prod_id=PROD.prod_id					
					INNER JOIN lt_member_merchants MMR ON MMR.pk_id=PROD.prod_id

					WHERE MMR.ltb_id = :ltb_id AND TR.tr_type = 'cancellation'
					LIMIT 1
				";
				$_q  = $this->mDbo->prepare($sql);
				$_q->bindValue(':ltb_id', $clean['ltbId'], \PDO::PARAM_INT);
				$_q->execute(  );
				if ($tmp = $_q->fetch( \PDO::FETCH_ASSOC ))
					return true;
			}
			return false;
		}
		
		public function getCurrentMerchantPack ( $ltbId ) {
			if ( $this->validData($clean, $ltbId, $fileType='wnu_ltbId_r' ) ) {
				$sql = "
					SELECT PPR.*, PACK.*, PROD.* 
					FROM lt_member_merchants MMC 
					INNER JOIN tbl_package PACK ON PACK.pk_id=MMC.pk_id
					INNER JOIN tbl_product PROD ON PACK.pk_id=PROD.prod_id
					INNER JOIN tbl_prod_price PPR ON PPR.prod_id = PROD.prod_id		
					WHERE MMC.ltb_id=:ltb_id AND PPR.ppr_current_price
					LIMIT 1
				";
				$_q  = $this->mDbo->prepare($sql);
				$_q->bindValue(':ltb_id', $clean['ltbId'], \PDO::PARAM_INT);
				$_q->execute(  );
				if ($tmp = $_q->fetch( \PDO::FETCH_ASSOC ))
					return $tmp;
			}
			return [];
		}
		
		function changeMerchantPackage ($ltbId, $selectedPackageInfo, $discCodeObj, &$errors) {
			
			if (!isset($errors)) $errors = [];
			if (isset($selectedPackageInfo['ppr_price'], $selectedPackageInfo['ppr_id'], $selectedPackageInfo['pk_id']) && $this->validData($clean, $ltbId, $fileType='wnu_ltbId_r' ) && $this->getMerchInfo($clean['ltbId'])) {
				//create new billins from the canceled for the new plan
				$oldPackInfo = $this->getCurrentMerchantPack ($clean['ltbId']);
				
				if ( $oldPackInfo['ppr_price'] ) {
					
					if (floatval($oldPackInfo['ppr_price']) >= floatval($selectedPackageInfo['ppr_price'])) {
						//its a downgrade
						//$this->cancelAllBillings($clean['ltbId'], $errors, $merchantBills, true);
						
						if ( floatval($selectedPackageInfo['ppr_price']) == 0 /*&& floatval($selectedPackageInfo['ppr_setup']) == 0*/ ) {
							$this->cancelAllBillings( $clean['ltbId'], $errors, $merchantBills );
							//adding the new transaction we do not add a billing since the plan price is $0.00
							$qry = $this->mDbo->prepare("INSERT INTO `tbl_transaction` (ltb_id, tr_datetime, tr_type, tr_session_Id) VALUES (:ltb_id, NOW(), 'checkout', :ses_id)");
							
							$qry->bindValue( ':ltb_id', $clean['ltbId'], \PDO::PARAM_INT );
							$qry->bindValue( ':ses_id', session_id(), \PDO::PARAM_STR );
							$qry->execute();									
							$newTrans = $this->mDbo->lastInsertId();
							
							if ($newTrans) {								
								$qry = $this->mDbo->prepare("
									INSERT IGNORE INTO `tbl_prod2trans` (
										tr_id,
										ppr_id,
										p2t_prod_count,
										dsc_id,
										bill_id,
										p2t_datetime
									)
									VALUES
									(
										:tr_id,
										:ppr_id,
										1,
										NULL,
										0,
										NOW()
									)
								");
																	
								$qry->bindValue( ':tr_id', $newTrans, \PDO::PARAM_INT );
								$qry->bindValue( ':ppr_id', $selectedPackageInfo['ppr_id'], \PDO::PARAM_INT );
								
								$qry->execute();
							}
							
							
							if ( floatval($oldPackInfo['ppr_price']) == 0 ) {
								$this->updateProductCount( $clean['ltbId'], $selectedPackageInfo['pk_id'], null);
								$this->resetProductCounts ( $clean['ltbId'] );
								$this->setNewPlan ($clean['ltbId'], $selectedPackageInfo['pk_id'], true);
							}
							
						}
						else{
							$this->cancelAllBillings( $clean['ltbId'], $errors, $merchantBills, true );
							/*
							echo '<pre>';
							var_dump($merchantBills);
							echo '</pre>';
							*/
							if ($merchantBills) {
								$prismPay = new Prismpay\prismPay ( $this->mDbo );	 
								foreach ( $merchantBills as $k=>$v ) {
									$planPrice = floatval( $selectedPackageInfo['ppr_price'] );
									$billingPrice = floatval( $v['bill_price'] );
									
									if ( isset( $v['dsc_id'] ) && is_object($discCodeObj) && method_exists($discCodeObj, 'applyCodeToPrice')) { $planPrice = $discCodeObj->applyCodeToPrice ( $v['dsc_id'], $planPrice ); }
									//if ( $billingPrice != $planPrice ) {
										/*
										$updatedBillings = $prismPay->updateBillingAmount( $v['bill_orderid'], $planPrice );
										if ( !$updatedBillings ) {
											break;
										}
										else {
										*/	
											//update billing amount in our DB									
											//$merchObj->updateBillingPeriod ( $v['bill_id'], $planPrice );
									 
									 $prismPay->updateBillingAmount( $v['bill_orderid'], $this->createNewBillingPeriodFrom ( $clean['ltbId'], $v['bill_id'], $oldPackInfo['ppr_id'], $selectedPackageInfo['ppr_id'], $planPrice ) );
									 
										 
										//}
									//}
								}
								
									
							}
						
						}	
					}
					else {
						//its an upgrade
						$errors = array( 0=>'The merchant account upgrade requires to take a creit card, it should be done thru the predefined process in the mystore area.' );
					}


				}
					
			}
			/*
			foreach ( $scheduledBillings as $k=>$v ) {
				$planPrice = floatval( $selected_plan['ppr_price'] );
				$billingPrice = floatval( $v['bill_price'] );
				
				if ( isset( $v['dsc_id'] ) ) { $planPrice = $discCode->applyCodeToPrice ( $v['dsc_id'], $planPrice ); }
				
				if ( $billingPrice != $planPrice ) {
					$updatedBillings = $prismPay->updateBillingAmount( $v['bill_orderid'], $planPrice );
					if ( !$updatedBillings ) {
						break;
					}
					else {
						//update billing amount in our DB									
						$merchObj->updateBillingPeriod ( $v['bill_id'], $planPrice );
					}
				}
				
			}
			*/
			
		}
		
		public function setNewPlan ($ltbId, $pkId, $activeteMerch = false) {
			
			if (
					$this->validData($clean, $ltbId, $fileType='wnu_ltbId_r' ) && 
					$this->validData($clean, $pkId, $fileType='wnu_pkId_r' ) 
				) {
				$sql = "
					UPDATE lt_member_merchants SET pk_id = :pkId".($activeteMerch? ", ltb_active = 1":'')."
					WHERE ltb_id = :ltbId
				";
				$_q  = $this->mDbo->prepare($sql);
				$_q->bindValue(':ltbId', $ltbId, \PDO::PARAM_INT);
				$_q->bindValue(':pkId', $pkId, \PDO::PARAM_INT);
				$_q->execute(  );
				if ($_q->rowCount()) {
					return true;
				}
			}
			
			return false;
		}
		
		private function getBillingTotalPrice($billId, $exceptPriceId) {
			$sql = "
					SELECT SUM( PPR.ppr_price ) AS total
					FROM tbl_prod2trans P2T					
					INNER JOIN lt_merchant_billing BILL	ON BILL.bill_id = P2T.bill_id
					INNER JOIN tbl_prod_price PPR ON PPR.ppr_id = P2T.ppr_id		
					WHERE BILL.bill_id = :bill_id AND PPR.ppr_id <> :exc_id
				";
				$_q  = $this->mDbo->prepare($sql);
				$_q->bindValue(':bill_id', $billId, \PDO::PARAM_INT);
				$_q->bindValue(':exc_id', $exceptPriceId, \PDO::PARAM_INT);
				$_q->execute(  );
				if ($tmp = $_q->fetch( \PDO::FETCH_ASSOC )) {
					return $tmp['total'];
				}
				return 0;
		}
		
		private function createNewBillingPeriodFrom ( $ltbId, $billId, $oldPackPriceId, $selectedPackagePriceId, $newPackPrice ) {			
			/*
				updateBillingPeriod ( $billId, $amount = null, $active = 1 )
			*/
			$qry = $this->mDbo->prepare("INSERT INTO `tbl_transaction` (ltb_id,tr_datetime,tr_type,tr_session_Id) VALUES (:ltb_id,NOW(),'checkout',:ses_id)");							
			
			$qry->bindValue( ':ltb_id', $ltbId, \PDO::PARAM_INT );
			$qry->bindValue( ':ses_id', session_id(), \PDO::PARAM_STR );
			$qry->execute();									
			$newTrans = $this->mDbo->lastInsertId();
			$totalPrice = 0;
			if ($newTrans) {
				$totalPrice = floatval($this->getBillingTotalPrice($billId, $oldPackPriceId)) + floatval($newPackPrice);
				/*
				  INSERT INTO user (id, name, username, opted_in)
				  SELECT id, name, username, opted_in 
				  FROM user LEFT JOIN user_permission AS userPerm ON user.id = userPerm.user_id
				*/
				$qry = $this->mDbo->prepare("
					INSERT INTO `lt_merchant_billing` (
						ltm_id, 
						lmp_id, 
						bill_name, 
						bill_address1, 
						bill_address2, 
						bill_state, 
						bill_city, 
						bill_zip, 
						bill_accountnumber, 
						bill_orderid, 
						bill_date, 
						bill_cyclestart, 
						bill_cycleend, 
						bill_active, 
						bill_price, 
						bill_fee, 
						dsc_id, 
						bill_canceled, 
						tr_id
					)
					SELECT 
						ltm_id, 
						lmp_id, 
						bill_name, 
						bill_address1, 
						bill_address2, 
						bill_state, 
						bill_city, 
						bill_zip, 
						bill_accountnumber, 
						bill_orderid, 
						NOW(), 
						NOW(), 
						bill_cycleend, 
						1 AS bAct, 
						:newPrice AS newPrice, 
						0.00 AS bFee, 
						dsc_id, 
						NULL AS Canc, 
						:tr_id AS trId
						FROM lt_merchant_billing
						WHERE bill_id = :bill_id
				
				");
				$qry->bindValue( ':bill_id', $billId, \PDO::PARAM_INT );							
				$qry->bindValue( ':tr_id', $newTrans, \PDO::PARAM_INT );
				$qry->bindValue( ':newPrice', $totalPrice, \PDO::PARAM_STR );
				$qry->execute();						
								
				$newBill = $this->mDbo->lastInsertId();
				if ($newBill) {
					$qry = $this->mDbo->prepare("
					INSERT IGNORE INTO `tbl_prod2trans` (
						tr_id,
						ppr_id,
						p2t_prod_count,
						dsc_id,
						bill_id,
						p2t_datetime
					)
					SELECT 
						:tr_id AS trId,
						ppr_id,
						p2t_prod_count,
						dsc_id,
						:newbillid AS bId,
						NOW() AS dT
						FROM `tbl_prod2trans`
						WHERE bill_id = :oldbillid AND ppr_id <> :exc_id
					");
					
					$qry->bindValue( ':oldbillid', $billId, \PDO::PARAM_INT );
					$qry->bindValue( ':newbillid', $newBill, \PDO::PARAM_INT );
					$qry->bindValue( ':tr_id', $newTrans, \PDO::PARAM_INT );
					$qry->bindValue( ':exc_id', $oldPackPriceId, \PDO::PARAM_INT );					
					
					$qry->execute();
					
					$qry = $this->mDbo->prepare("
					INSERT IGNORE INTO `tbl_prod2trans` (
						tr_id,
						ppr_id,
						p2t_prod_count,
						dsc_id,
						bill_id,
						p2t_datetime
					)
					VALUES (:tr_id, :ppr_id, 1, NULL, :newbillid, NOW())
					");
										
					$qry->bindValue( ':newbillid', $newBill, \PDO::PARAM_INT );
					$qry->bindValue( ':tr_id', $newTrans, \PDO::PARAM_INT );
					$qry->bindValue( ':ppr_id', $selectedPackagePriceId, \PDO::PARAM_INT );
					$qry->execute();
					
					$qry = $this->mDbo->prepare("
						UPDATE `lt_merchant_billing` 
						SET bill_cycleend = NOW(), bill_active = 0
						WHERE bill_id = :bill_id
					");
					$qry->bindValue( ':bill_id', $billId, \PDO::PARAM_INT );					
					$qry->execute();
										
				}
			}
			return $totalPrice;			
		}
		
		private function getTransactionProducts ($trId, $justPacks = false, $justTopPacks = false) {
			$sql = "
				SELECT PROD.*".($justPacks? ", PACK.*":"")."
				FROM tbl_transaction TR
				INNER JOIN tbl_prod2trans P2T ON P2T.tr_id = TR.tr_id
				INNER JOIN tbl_prod_price PPR ON PPR.ppr_id = P2T.ppr_id
				INNER JOIN tbl_product PROD ON PROD.prod_id = PPR.prod_id
				".($justPacks? "INNER JOIN tbl_package PACK ON PROD.prod_id = PACK.pk_id":"")."
				WHERE 
					PROD.prod_active
					".($justPacks && $justTopPacks? "
					AND	PACK.pk_id NOT IN 
						(
							SELECT PACK1.pk_id
							FROM tbl_package PACK1
							INNER JOIN tbl_prod2pack P2T1 ON P2T1.prod_id = PACK1.pk_id
						 )
					":"")."
			";
			$_q  = $this->mDbo->prepare( $sql );
			$_q->execute(  );
			
			$activate = $_q->fetchAll( \PDO::FETCH_ASSOC );
		}
		
		function bulkActivateBillins(  ) {
			
			$sql = "
				SELECT BILL.bill_id, TR.ltb_id, TR.tr_id
				FROM `lt_merchant_billing` BILL 	
				INNER JOIN tbl_transaction TR ON TR.tr_id = BILL.bill_id				
				WHERE 
					BILL.bill_cyclestart <= CURDATE() 
					AND (BILL.bill_cycleend > CURDATE() 
					OR BILL.bill_cycleend IS NULL) 
					AND NOT BILL.bill_active
					AND BILL.bill_id NOT IN (
						SELECT BILL1.bill_id 
						FROM `lt_merchant_billing` BILL1 
						INNER JOIN tbl_prod2trans P2T ON BILL1.bill_id = P2T.bill_id
						INNER JOIN tbl_transaction TRANS ON TRANS.tr_id = P2T.tr_id
						WHERE TRANS.tr_type = 'cancellation'
					)
				    AND TR.tr_type = 'checkout'	
			";
			$_q  = $this->mDbo->prepare( $sql );
			$_q->execute(  );
			
			$activate = $_q->fetchAll( \PDO::FETCH_ASSOC );
			
			foreach( $activate as $key => $value ) {
				$transProducs = $this->getTransactionProducts ( $value["tr_id"], true, true );
				
				// activate bill
				$qry = $this->mDbo->prepare( "
				UPDATE `lt_merchant_billing` 
				SET bill_active = 1 
				WHERE bill_id = :bill_id" );
				$qry->bindValue(':bill_id', $value["bill_id"], \PDO::PARAM_INT);
				$qry->execute();
				
				if ($transProducs[0]['pk_id']) {
					// activate bill
					$qry = $this->mDbo->prepare("
					UPDATE `lt_member_merchants`					
					SET pk_id = :pk_id
					WHERE ltb_id = :ltb_id");
					$qry->bindValue(':pk_id', $transProducs[0]['pk_id'], \PDO::PARAM_INT);
					$qry->bindValue(':ltb_id', $value["ltb_id"], \PDO::PARAM_INT);
					$qry->execute();
					$this->resetProductCountsFromMax($value["ltb_id"]);					
				}
			}
		}
		
		function bulkDeactivateBillins (  ) {
			$qry = $this->mDbo->prepare( "
			SELECT BILL.ltm_id, BILL.bill_id 
			FROM `lt_merchant_billing` BILL 			
			WHERE BILL.bill_cycleend <= CURDATE() AND BILL.bill_active = 1" );
			$qry->execute();
			$deactivate = $qry->fetchAll( \PDO::FETCH_ASSOC );
			
			foreach( $deactivate as $key => $value ) {
								
				$packObj = new Package\package($this->mDbo, 0);
				$freePlan = $packObj->getOneFreeTopLevelPackage();
				
				// deactivate bill
				$qry = $this->mDbo->prepare("
				UPDATE `lt_merchant_billing` 
				SET bill_active = 0 
				WHERE bill_id = :bill_id");
				$qry->bindValue(':bill_id', $value["bill_id"], \PDO::PARAM_INT);
				$qry->execute();
				
				if ($freePlan['pk_id']) {
					//set merchant on a free package just in case
					$qry = $this->mDbo->prepare("
					UPDATE `lt_member_merchants`					
					SET pk_id = :pk_id
					WHERE ltb_id = :ltb_id");
					$qry->bindValue(':pk_id', $freePlan[0]['pk_id'], \PDO::PARAM_INT);
					$qry->bindValue(':ltb_id', $value["ltb_id"], \PDO::PARAM_INT);
					$qry->execute();
					$this->resetProductCountsFromMax($value["ltb_id"]);
				}
			}
		}
		
		function cancelAllBillings( $ltbId, &$errors, &$my_bills, $cancelOurDbOnly = false ) {
			if ($this->validData( $clean, $ltbId, $fileType = 'wnu_ltbid_r' ) ) {
				$this->currentMerchantId = intval( $clean['ltbid'] );
				$my_bills = $this->getScheduledBillings ( $clean['ltbid'] ); $errors=[];
				
				if ( $cancelOurDbOnly || $this->cancelBillings( $my_bills ) ) { 
					$newTrans = false;
					foreach ( $my_bills as $k => $v ) {
						
						if ( !$newTrans ) {
							//adding a new cancellation transaction
							
							$qry = $this->mDbo->prepare("INSERT INTO `tbl_transaction` (ltb_id, tr_datetime, tr_type, tr_session_Id) VALUES (:ltb_id, NOW(), 'cancellation', :ses_id)");
							
							$qry->bindValue( ':ltb_id', $this->currentMerchantId, \PDO::PARAM_INT );
							$qry->bindValue( ':ses_id', session_id(), \PDO::PARAM_STR );
							$qry->execute();						
							$newTrans = $this->mDbo->lastInsertId();
						}	
						
						if ( $newTrans ) {
							//deactivate bill
							$qry = $this->mDbo->prepare("
								INSERT IGNORE INTO `tbl_prod2trans` (
								tr_id,
								ppr_id,
								p2t_prod_count,
								dsc_id,
								bill_id,
								p2t_datetime
							)
							SELECT 
								:tr_id AS trId,
								ppr_id,
								p2t_prod_count,
								dsc_id,
								bill_id,
								NOW() AS dT
								FROM `tbl_prod2trans`
								WHERE bill_id = :bill_id
								"
							);
							
							$qry->bindValue( ':bill_id', $v["bill_id"], \PDO::PARAM_INT );
							$qry->bindValue( ':tr_id', $newTrans, \PDO::PARAM_INT );
							$qry->execute();
						}		
					}
					return $newTrans? true: false;
				}
			
				
			}
			return false;
		}
		
		public function merchantExists( $aFieldValue, &$errorMsg, $fieldName = 'ltb_email' ) {
			$errorMsg = '';
			if ( ($fieldName === 'ltb_email'? !filter_var($aFieldValue, FILTER_VALIDATE_EMAIL) === false : $fieldName === 'ltb_id' && $this->validData($clean, $aFieldValue, $fileType='wnu_ltbId_r' )) ) {
				$sqlString = '
					SELECT ltb_email FROM lt_member_merchants WHERE ' . $fieldName . ' = :ltbName LIMIT 1
				';
				$p = $this->mDbo->prepare( $sqlString );				
				$p->bindValue(':ltbName', $aFieldValue, $fieldName === 'ltb_email'? \PDO::PARAM_STR: \PDO::PARAM_INT);
				$p->execute();
				return $rSet = $p->fetchAll( \PDO::FETCH_ASSOC );		
			}
			
			$errorMsg = 'Not a valid email address';
			
			return false;
		}
		
		public function activateOnFreePlan ( $ltbId ) {
			
			//$this->cancelAllBillings($ltbId, $errors, $my_bills);
			$packObj = new Package\package($this->mDbo, 0);
			$freePlan = $packObj->getOneFreeTopLevelPackage();
			
			if( isset( $freePlan['pk_id'] ) && $this->validData($clean, $ltbId, $fileType = 'wnu_ltbId_r' ) ) {				
				$qry = $this->mDbo->prepare("INSERT INTO `tbl_transaction` (ltb_id, tr_datetime, tr_type, tr_session_Id) VALUES (:ltb_id, NOW(), 'checkout', :ses_id)");
							
				$qry->bindValue( ':ltb_id', $clean['ltbId'], \PDO::PARAM_INT );
				$qry->bindValue( ':ses_id', session_id(), \PDO::PARAM_STR );
				$qry->execute();									
				$newTrans = $this->mDbo->lastInsertId();
				
				if ($newTrans) {								
					$qry = $this->mDbo->prepare("
						INSERT IGNORE INTO `tbl_prod2trans` (
							tr_id,
							ppr_id,
							p2t_prod_count,
							dsc_id,
							bill_id,
							p2t_datetime
						)
						VALUES
						(
							:tr_id,
							:ppr_id,
							1,
							NULL,
							0,
							NOW()
						)
					");
														
					$qry->bindValue( ':tr_id', $newTrans, \PDO::PARAM_INT );
					$qry->bindValue( ':ppr_id', $freePlan['ppr_id'], \PDO::PARAM_INT );
					
					$qry->execute();
					$this->updateProductCount( $clean['ltbId'], $freePlan['pk_id'], null );
					$this->resetProductCounts ( $clean['ltbId'] );
					$this->setNewPlan ($clean['ltbId'], $freePlan['pk_id'] , true);				
					return true;
				}	
			}			
			return false;
		}
		
		public function getLoadedStoresHours () {			
			$Result = array();
			if (isset($this->mRecords[$this->currentMerchantId]['Store'])) {
				$tmpStoreId = $this->mRecords[$this->currentMerchantId]['Store']->currentStoreId;
				
				foreach ($this->mRecords[$this->currentMerchantId]['Store']->storeRecords as $storeId => $storeValues) {
					$this->mRecords[$this->currentMerchantId]['Store']->currentStoreId = $storeId;
					$Result[$storeId] = $this->getCurrentStore('Hours');
					if (empty($Result[$storeId])) 
						$Result[$storeId] = $this->mRecords[$this->currentMerchantId]['Store']->loadHours();
				}
				$this->mRecords[$this->currentMerchantId]['Store']->currentStoreId = $tmpStoreId;
			}
			return $Result;
		}
		
		public function checkMerchantSwitch ($switch) {
			$switches = $this->getCurrent('Switches');
			if (isset($switches[$switch])){
				return true;
			} else {
				return false;
			}
		}

		public function getCroosPromMerchId() {
			return $this->croosPromMerchId;
		}
		
		public function setUserLocation($lat, $lng) {
			if ($this->validData($clean, $lat, $fileType='dec_lat_r' ))
				$this->userLocation['lat'] = $clean['lat'];
			if ($this->validData($clean, $lng, $fileType='dec_lng_r' ))
				$this->userLocation['lng'] = $clean['lng'];
		}		
		
		public function loadRecordsFromStore($ltmId, $loadPromos = false) {
			
			$sql = \NEW_DB_SWITCH?"
				SELECT DISTINCT MMC. *, PACK.* , PROD. *, TMZ.*
				FROM lt_member_merchants MMC
				INNER JOIN lt_merchants MRC ON MMC.ltb_id = MRC.ltb_id				
				INNER JOIN tbl_timezone TMZ ON MMC.tmz_id = TMZ.tmz_id
				INNER JOIN tbl_package PACK ON MMC.pk_id = PACK.pk_id
				INNER JOIN tbl_product PROD ON PACK.pk_id = PROD.prod_id
				WHERE MRC.ltm_id=:ltmId LIMIT 1"
				:
				"
				SELECT DISTINCT MMC. *, PTY.* , PTM. *, TMZ.*
				FROM lt_member_merchants MMC
				INNER JOIN lt_merchants MRC ON MMC.ltb_id = MRC.ltb_id
				INNER JOIN lt_plan_type AS PTY ON MMC.pty_id = PTY.pty_id
				INNER JOIN tbl_timezone TMZ ON MMC.tmz_id = TMZ.tmz_id
				INNER JOIN lt_merchant_plans AS PTM ON PTM.lmp_id = MMC.lmp_id
				WHERE MRC.ltm_id=:ltmId LIMIT 1";			
			
			if ( is_numeric( $ltmId ) && $ltmId > 0 ) {
				$stmt = $this->mDbo->prepare($sql);
				$stmt->bindValue( ":ltmId", intval($ltmId), \PDO::PARAM_INT );
				$stmt->execute();
				if ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
					if ( \NEW_DB_SWITCH )
						$packObj = new Package\package( $this->mDbo, 0 );
					$resultSet['Switches']= $this->gatMerchantSwitches( $resultSet['ltb_id'] );					
					
					$resultSet['Plan'] = \NEW_DB_SWITCH? $packObj->findBasicProductList ( $resultSet['pk_id'] ) : $this->gatPlanFeatures( $resultSet['ltb_id'], $resultSet['lmp_id'] );
					
					if ( \NEW_DB_SWITCH ) {
						//$packObj->findBasicProductList($resultSet['pk_id']);
						$tmpOk = $packObj->getRecords( $resultSet['pk_id'], 'Max_Promos' );						
						$this->maxPromoDisplay[$resultSet['ltb_id']] = !is_array($tmpOk)? $tmpOk: 0;						
					}	
					
					$resultSet['Store']= new Store\MerchantStore( $this->mDbo );
					$resultSet['Store']->loadRecords( $resultSet['ltb_id'], 'ltb_id', \PDO::PARAM_INT );
					
					if ($loadPromos) {
						$resultSet['Promo'] = new Promo\MerchantPromo( $this->mDbo, null);
						$resultSet['Promo']->loadRecords( $resultSet['ltb_id'], 'ltb_id', 'MMC', isset($resultSet['Switches']['randomize_promos']) && $resultSet['Switches']['randomize_promos']? 'random' : 'default' );
					}
					else
						$resultSet['Promo'] = null;
					
					$this->currentMerchantId = $resultSet['ltb_id'];				
					$this->mRecords[$resultSet['ltb_id']] = $resultSet;				
				}	
			}
		}

		
		function getTotalActivePromos() {			
			if ($this->totalActivePromos === null){
				$this->countActivePromos();
			}			
			return $this->totalActivePromos;
		}
		
		function nationalMallJumpBasedOnRes () {
		
			$stmt = $this->mDbo->prepare("
				SELECT RES.*
				FROM tbl_reseller2switch R2S
				INNER JOIN tbl_reseller RES ON R2S.res_id = RES.res_id
				INNER JOIN tbl_reseller_switches RSW ON RSW.rss_id=R2S.rss_id
				WHERE RES.res_id=:resId AND RSW.rss_name = 'hide_mystore_lt_jump' LIMIT 1" );
			$stmt->bindValue( ":resId", $this->getCurrent('res_id'), \PDO::PARAM_INT );
			$stmt->execute();
			
			if ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				
				$this->mRecords[$this->currentMerchantId]['Hide_NM_Customization'] = true;
				if (!$this->checkMerchantSwitch('hide_natmall_banner')) {
					$stmt = $this->mDbo->prepare("
					INSERT IGNORE INTO lt_mmerch2switch (swt_name, ltb_id) VALUES ('hide_natmall_banner', :ltb_id)" );
					$stmt->bindValue( ":ltb_id", $this->currentMerchantId, \PDO::PARAM_INT );
					$stmt->execute();
					unset($this->mRecords[$this->currentMerchantId]['Switches']);
					$this->mRecords[$this->currentMerchantId]['Switches'] = $this->gatMerchantSwitches( $this->currentMerchantId );
				}
				return true;
			}
			return false;
		}
		
		function buildPromoLayouts( $siteURL, $userId, $exceptPromoIds = array(), $totalToBuild = 0, $includeWrapper = true, $forSerching = false ) {

			$Result = ''; $merchantURL = $this->getMerchantSubDir('/merchant-custom-files');
		
			if (is_numeric($userId) && $userId > 0 && isset($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords) && !empty($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords) ){
				
				$userIdOk = $userId;
				$current = 0; $countTotal = count($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords) - count($exceptPromoIds);
				$total = !is_numeric($totalToBuild) || $totalToBuild <= 0? $countTotal: (!$forSerching && $countTotal > 1 && $countTotal < intval($totalToBuild)? $countTotal: intval($totalToBuild));				
				
				if (!$forSerching && $total > $this->maxPromoDisplay[$this->currentMerchantId]) $total = $this->maxPromoDisplay[$this->currentMerchantId];
				
				foreach ($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords as $key=>$val)					
					
					
					
					if ( !in_array($val['ltp_id'], $exceptPromoIds) ) {
						
						if (!$forSerching) {
							if (++$current > $total) { break;}
						}
						else
							++$current;
						
						$onClickEvent = '';

						$linkHref = '/' . $this->mRecords[$this->currentMerchantId]['ltb_slug'] . '/deals/' . $val['ltp_slug'];

						$this->mRecords[$this->currentMerchantId]['Promo']->currentPromoId = $val['ltp_id'];

						$imageURL = $this->mRecords[$this->currentMerchantId]['Promo']->findImageURL($siteURL, $merchantURL, $croosPromMerchId);	
						
						if ( $croosPromMerchId !== 0 ) { 
						
							$this->croosPromMerchId = $croosPromMerchId;
							
							/*
							Old Cross Promo code
							$temp = $this->currentMerchantId;

							$this->currentMerchantId = $croosPromMerchId;

						 	$imageURL = str_replace('{%%CrossPromoMerchant%%}', $this->getMerchantSubDir('/merchant-custom-files'), $imageURL);

							$this->currentMerchantId = $temp;
							
							*/
						}
						
						//echo $imageURL . '<br>';
						
						$promoFooterLink = array('Millage'=>$this->mRecords[$this->currentMerchantId]['Store']->getDistance($this->userLocation['lat'], $this->userLocation['lng']), 'From'=>array('lat'=>$this->userLocation['lat'], 'lng'=>$this->userLocation['lng']), 'To'=>array('lat'=>$this->mRecords[$this->currentMerchantId]['Store']->getCurrent('ltm_lat'), 'lng'=>$this->mRecords[$this->currentMerchantId]['Store']->getCurrent('ltm_long') ));						

						$Result .= $this->mRecords[$this->currentMerchantId]['Promo']->buildPromoLayOut($imageURL, $userIdOk, $total, $current, $onClickEvent, $linkHref, $promoFooterLink);

					}					

			}			

			return empty($Result)? $Result: ($includeWrapper? '<div id="promos_div" style="width:100%;"><div class="row" style="background-color: transparent;"><div id="promo-wrapper-div">':'').$Result.($includeWrapper?"</div></div></div>":'');

		}
		
		function buildMapLayOut($siteExt, $loggedUser = false){
			$outputStr = '<div class="search-info-window"><div class="row">';
			$mmbStore = $this->findStore($this->currentMerchantId);
			$mName = '';
			$mLat = '0.00000';
			$mLon = '0.00000';
			$storeHideAddress = true;
			if ( $mmbStore !== null) {
				$mmbStore->getHours($isStoreOpen, $todayHours, $this->getCurrent('tmz_name'));
				$mName = trim( $mmbStore->getCurrent('ltm_company_name') );
				$mLat = $mmbStore->getCurrent('ltm_lat');
				$mLon = $mmbStore->getCurrent('ltm_long');
				$storeHideAddress = strcmp( $mmbStore->getCurrent( 'ltm_hide_address' ), '0' ) === 0? false: true;
			}
			if (!$storeHideAddress) {	
				$outputStr .= '				
				<div class="row"><div class="col-xs-3"><a href="/'.$this->getCurrent('ltb_slug') . '"><img class="img-responsive" alt="Merchant Logo" src="https://localthanks.' . $siteExt . $this->getHeaderImage(). '"/></a></div>
				<div class="col-xs-9"><p class="promo_prep-text">' . $mName . '</p>';
					$outputStr .= (isset($todayHours) && !empty($todayHours)?'											
						<p class="promo_prep-text"><span></span><span>Today ' . $todayHours . '</span><br><span>'.($isStoreOpen?"Open Now":"Closed Now").'</span></p>
				':'');
				$outputStr .= '</div></div>
				<div class="row">
				<div class="col-xs-6">
					<a href="/'.$this->getCurrent('ltb_slug') . '"><p class="promo_prep-text promo_blue-text">'.$this->getTotalActivePromos().'  Promotion(s)</p></a>
				</div>
				<div class="col-xs-6">															
					<a '.($loggedUser?'target="_blank" href="' . "https://www.google.com/maps?f=d&source=s_d&saddr=@".(empty($_SESSION["user"]["consumer"]["search_point"])?$_SESSION["user"]["consumer"]["csm_lat"].','.$_SESSION["user"]["consumer"]["csm_long"]: $_SESSION["user"]["consumer"]["search_point"])."&daddr=@{$mLat},{$mLon}" . '"':'href="javascript:void(0);" class="homeTriggerSignup"').'><p class="promo_prep-text promo_blue-text"><img class="promo_prep-img" alt="Directions Icon" width="24" height="24" src="/localthanks/images/icon_directions.svg"/><span> Directions</span></p></a>
				</div></div>';
			}	
			$outputStr .= '</div></div>';
			return $outputStr;
		}
		
		function buildSearchLayOut($siteExt, $loggedUser = false) {
			$mmbPhoneNumber = $this->getCurrentStore('ltm_phone_number');
			$mmbWebUrl = $this->getCurrent('ltb_web_url');
			$outputStr = '<div class="col-sm-12"><div class="search-result-div"><div class="row">';
			$mmbStore = $this->findStore($this->currentMerchantId);
			$storeHideAddress = true;
			if ( $mmbStore !== null) {
				$mmbStore->getHours($isStoreOpen, $todayHours, $this->getCurrent('tmz_name')); 
				$storeHideAddress = strcmp( $mmbStore->getCurrent( 'ltm_hide_address' ), '0' ) === 0? false: true;
			}
			$outputStr .= '<div class="col-sm-4"><a href="/'.$this->getCurrent('ltb_slug') . '"><img class="img-responsive serach-merch-logo" alt="Merchant Logo" src="https://localthanks.' . $siteExt . $this->getHeaderImage(). '"/></a></div>';
			$outputStr .= '<div class="col-sm-4">
			'.(isset($todayHours) && !empty($todayHours)?'						
			<div class="row">
				<div class="col-xs-12">																			
					<p class="promo_prep-text"><span></span><span>Today ' . $todayHours . '</span><br><span>'.($isStoreOpen?"Open Now":"Closed Now").'</span></p>
				</div>										
			</div>':'').
			'<span class="search-share">Like &amp; Share</span>
			<div class="promo_share-div" style="text-align: left !important;">
				<img width="30" data-title="' . ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): '') . '" data-href="https://localthanks.' . $siteExt . '/' . $this->getCurrent('ltb_slug').'" title="Share '. ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): 'Merchant') .' on Facebook" class="searchFacebookShare" height="30" src="/localthanks/images/icon_share_facebook.svg" alt="Facebook Share"/>						
				<a '. ($loggedUser?'href="http://www.linkedin.com/shareArticle?url=https://localthanks.' . $siteExt . '/' . $this->getCurrent('ltb_slug').'" target="_blank" ': 'href="javascript:void(0);"').' type="IN/Share">
					<img width="30" title="Share ' . ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): 'Merchant') . ' on Linkdin" class="searchLinkdinShare" height="30" src="/localthanks/images/icon_share_linkdin.svg" alt="Linkdin Share"/>
				</a>						
				<a ' . ($loggedUser? 'href="https://twitter.com/intent/tweet?url=https://localthanks.' . $siteExt . '/' . $this->getCurrent('ltb_slug').'"':'href="javascript:void(0);"').'><img width="30" title="Share ' . ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): 'Merchant') . ' on Twitter" class="searchTwitterShare" height="30" src="/localthanks/images/icon_share_twitter.svg" alt="Twitter Share"/></a>	
				<a  ' . ($loggedUser? 'href="https://plus.google.com/share?url=https://localthanks.' . $siteExt . '/' . $this->getCurrent('ltb_slug').'" target="_blank" ':'href="javascript:void(0);"').'><img width="30" title="Share ' . ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): 'Merchant') . ' on Google Plus" class="searchGooglePlusShare" height="30" src="/localthanks/images/icon_share_googleplus.svg" alt="Google Plus Share"/></a>
			</div>
			</div>';								
			$outputStr .= '<div class="col-sm-4">
				'.(!$storeHideAddress?'
				<div class="row">
					<div class="col-xs-12">
						<p class="promo_prep-text"><img class="promo_prep-img" alt="Location Icon" width="24" height="24" src="/localthanks/images/icon_location.svg"/><span> ' . "{$this->getCurrentStore('ltm_address')} {$this->getCurrentStore('ltm_city')} {$this->getCurrentStore('ltm_state')} {$this->getCurrentStore('ltm_zipcode')}" . '</span></p>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12">															
						<a '. ($loggedUser?'target="_blank" href="' . "https://www.google.com/maps?f=d&source=s_d&saddr=@".(empty($_SESSION["user"]["consumer"]["search_point"])?$_SESSION["user"]["consumer"]["csm_lat"].','.$_SESSION["user"]["consumer"]["csm_long"]: $_SESSION["user"]["consumer"]["search_point"])."&daddr=@{$this->getCurrentStore('ltm_lat')},{$this->getCurrentStore('ltm_long')}" . '"':'href="javascript:void(0);" class="search_trigger-signup"').'><p class="promo_prep-text promo_blue-text"><img class="promo_prep-img" alt="Directions Icon" width="24" height="24" src="/localthanks/images/icon_directions.svg"/><span> Get Directions</span></p></a> 
					</div>
				</div>
				
				':'').(!empty($mmbPhoneNumber)? '						
				<div class="row">
					<div class="col-xs-12">															
						<a '. ($loggedUser?'href="tel:' . $mmbPhoneNumber . '"':'href="javascript:void(0);" class="search_trigger-signup"').'><p class="promo_prep-text"><img class="promo_prep-img" alt="Phone Icon" width="24" height="24" src="/localthanks/images/icon_phone.svg"/><span> ' . $mmbPhoneNumber . '</span></p></a>
					</div>										
				</div>':'').
				(!empty($mmbWebUrl)?

				'<div class="row">
					<div class="col-xs-12">																			
						<a '. ($loggedUser?'target="_blank" href="'.$mmbWebUrl.'"': 'href="javascript:void(0);" class="search_trigger-signup"').'><p class="promo_prep-text promo_blue-text"><img class="promo_prep-img" alt="Website Icon" width="24" height="24" src="/localthanks/images/icon_desktop.svg"/><span> '.$mmbWebUrl.'</span></p></a>
					</div>										
				</div>':'').'
			</div>';
			$outputStr .= '</div></div></div>';
			
			return $outputStr;
		}		
				
		function callStoreFunction($funcName, $funcParams) {
			if (isset($this->mRecords[$this->currentMerchantId]['Store']) && method_exists($this->mRecords[$this->currentMerchantId]['Store'], $funcName) )
				return call_user_func(array($this->mRecords[$this->currentMerchantId]['Store'], $funcName), $funcParams);
			else return false;
		}
		
		function buildFrontPageLayOut( $siteExt, $loggedUser = false ) {
			$mmbPhoneNumber = $this->getCurrentStore('ltm_phone_number');
			$mmbWebUrl = $this->getCurrent('ltb_web_url');
			$mmbDescription = $this->getCurrent("ltb_description");
			$mmbPayment = $this->getPaymentMethods('string');
			$outputStr = '';
			$mmbStore = $this->findStore($this->currentMerchantId);
			$hoursArr = ''; $mmbMerchantName = '';
			
			$showPunchCardLink = false;	$hasUserPunchCard = false; $punchCardActive = false;
			$storeHideAddress = true;
			if ( $mmbStore !== null) {
				
				$tmzN = $this->getCurrent('tmz_name');
				$mmbStore->getHours($isStoreOpen, $todayHours, $tmzN);
				$hoursArr = $mmbStore->getEveryDayHours($isStoreOpen, $tmzN, 'string');
				$mmbMerchantName = $mmbStore->getCurrent('ltm_company_name');
				$storeHideAddress = strcmp($mmbStore->getCurrent('ltm_hide_address'), '0') === 0? false: true;
				if ( $loggedUser ) {
					$punchCardVar = $mmbStore->getPunchCard();
					$punchCardActive = isset($punchCardVar['dpc_active']) && $punchCardVar['dpc_active'] == 1? true: false;
					$tmpPunchCard = $mmbStore->getPunchCardHistory($_SESSION["user"]["consumer"]["csm_id"], $mmbStore->currentStoreId);					
					
					$hasUserPunchCard = isset($tmpPunchCard['History']) && !empty($tmpPunchCard['History']);
					$showPunchCardLink = !empty($tmpPunchCard) && ($punchCardActive || ($hasUserPunchCard && $tmpPunchCard['History'][count($tmpPunchCard['History'])-1]['dph_task'] !== 'redeem'));
				}
			}
			$outputStr .= '
			<div class="row merchant-logo-name">
				<div class="col-sm-4">
					<div class="local-merchant-head-card">
						<div class="row">
							<div class="col-sm-12 murl-full-width-logo murl-head-div">
								<img class="img-responsive" alt="Merchant Logo" src="https://localthanks.' . $siteExt . $this->getHeaderImage(). '" />
							'.($loggedUser == false ? 
								'
								<button class="murl-signup-btn homeTriggerSignup" type="button"><strong>Sign Up</strong> Here <span class="btn-seperator"></span><span class="glyphicon glyphicon-tag"></span></button>
								<div class="murl-signup-desc">To Receive Special Offers<br>from this Merchant</div>
								' 
							: '').'
							</div>
						</div>
					</div>
				</div>

				<div class="col-sm-4">
					<div class="local-merchant-head-card">
						<h1 class="header-mmb-name">'.$mmbMerchantName.'</h1>
						'.(!empty($mmbDescription)? 
							'<div class="header-mmb-desc">' . $mmbDescription . '</div>'	
						:'').'	
						<hr class="murl-hr">
						'.($mmbWebUrl != '' ? 
							'<a href="'.$mmbWebUrl.'" target="_blank" class="murl-website-url">'.$mmbWebUrl.'</a>'
						:'').'

						'.($showPunchCardLink? 
							'<div><a href="' . 'https://localthanks.' . $siteExt. '/' . $this->getCurrent('ltb_slug') . '/punch-card' . '" class="homeTriggerSignup">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="12 10 50 50" xml:space="preserve" style="height: 40px;width: 40px;vertical-align: middle;"><defs><style>.cls-1{fill:#fff;}.cls-2{fill:#0388fe;}</style></defs><path class="cls-2" d="M57.09,42.23,24.25,53.71a2.9,2.9,0,0,1-3.69-1.78L14.62,35a2.9,2.9,0,0,1,1.78-3.69L49.25,19.79a2.9,2.9,0,0,1,3.69,1.78l5.93,17A2.9,2.9,0,0,1,57.09,42.23ZM24.19,47A2.17,2.17,0,1,0,27,48.3,2.17,2.17,0,0,0,24.19,47Zm4.93-1.72a2.17,2.17,0,1,0,2.77,1.34A2.17,2.17,0,0,0,29.12,45.25ZM34,43.53a2.17,2.17,0,1,0,2.77,1.34A2.17,2.17,0,0,0,34,43.53ZM39,41.81a2.17,2.17,0,1,0,2.77,1.34A2.17,2.17,0,0,0,39,41.81Zm4.93-1.72a2.17,2.17,0,1,0,2.77,1.34A2.17,2.17,0,0,0,43.9,40.08Zm4.93-1.72A2.17,2.17,0,1,0,51.6,39.7,2.17,2.17,0,0,0,48.83,38.36Zm4.93-1.72A2.17,2.17,0,1,0,56.53,38,2.17,2.17,0,0,0,53.76,36.64Z"/></g></g></svg>
							'.($hasUserPunchCard? 'View': 'Get').' Digital Punch Card!
							</a></div>'
						: '').'						
						
						<div class="murl-social-share">
							<span class="search-share">Like &amp; Share</span>
							<br />
							<img width="30" data-title="' . ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): '') . '" data-href="https://localthanks.' . $siteExt . '/' . $this->getCurrent('ltb_slug').'" title="Share '. ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): 'Merchant') .' on Facebook" id="homeTriggerFacebook" style="cursor:pointer;" class="homeTriggerSignup" height="30" src="/localthanks/images/icon_share_facebook.svg" alt="Facebook Share"/>						
							<a target="_blank" '. ($loggedUser?'href="http://www.linkedin.com/shareArticle?url=https://localthanks.' . $siteExt . '/' . $this->getCurrent('ltb_slug').'" ': 'href="javascript:void(0);"').' type="IN/Share"><img width="30" title="Share ' . ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): 'Merchant') . ' on Linkdin" class="homeTriggerSignup" height="30" src="/localthanks/images/icon_share_linkdin.svg" alt="Linkdin Share"/></a>						
							<a ' . ($loggedUser? 'href="https://twitter.com/intent/tweet?url=https://localthanks.' . $siteExt . '/' . $this->getCurrent('ltb_slug').'"':'href="javascript:void(0);"').'><img width="30" title="Share ' . ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): 'Merchant') . ' on Twitter" class="homeTriggerSignup" height="30" src="/localthanks/images/icon_share_twitter.svg" alt="Twitter Share"/></a>	
							<a target="_blank" ' . ($loggedUser? 'href="https://plus.google.com/share?url=https://localthanks.' . $siteExt . '/' . $this->getCurrent('ltb_slug').'"':'href="javascript:void(0);"').'><img width="30" title="Share ' . ( $mmbStore !== null? $mmbStore->getCurrent('ltm_company_name'): 'Merchant') . ' on Google Plus" class="homeTriggerSignup" height="30" src="/localthanks/images/icon_share_googleplus.svg" alt="Google Plus Share"/></a>
						</div>
					</div>
				</div>

				<div class="col-sm-4">
					<div class="local-merchant-head-card">
						'.(!$storeHideAddress?'
						<a '. ($loggedUser?'target="_blank" href="' . "https://www.google.com/maps?f=d&source=s_d&saddr=@".(empty($_SESSION["user"]["consumer"]["search_point"])?$_SESSION["user"]["consumer"]["csm_lat"].','.$_SESSION["user"]["consumer"]["csm_long"]: $_SESSION["user"]["consumer"]["search_point"])."&daddr=@{$this->getCurrentStore('ltm_lat')},{$this->getCurrentStore('ltm_long')}" . '"':'href="javascript:void(0);" class="homeTriggerSignup"').'>
							<div id="homeMapCanvas"></div>
						</a>
						
						<div class="murl-table">
							<div class="murl-cell">
								<img alt="Location Icon" width="24" height="24" src="/localthanks/images/icon_location.svg">
							</div>
							<div class="murl-cell murl-cell-desc">
								' . "{$this->getCurrentStore('ltm_address')} <br /> {$this->getCurrentStore('ltm_city')}, {$this->getCurrentStore('ltm_state')} {$this->getCurrentStore('ltm_zipcode')}" . '
							</div>
						</div>
						
						<div class="murl-table">
							<div class="murl-cell">
								<img alt="Directions Icon" width="24" height="24" src="/localthanks/images/icon_directions.svg">
							</div>
							<div class="murl-cell murl-cell-desc">
								<a '. ($loggedUser?'target="_blank" href="' . "https://www.google.com/maps?f=d&source=s_d&saddr=@".(empty($_SESSION["user"]["consumer"]["search_point"])?$_SESSION["user"]["consumer"]["csm_lat"].','.$_SESSION["user"]["consumer"]["csm_long"]: $_SESSION["user"]["consumer"]["search_point"])."&daddr=@{$this->getCurrentStore('ltm_lat')},{$this->getCurrentStore('ltm_long')}" . '"':'href="javascript:void(0);" class="homeTriggerSignup"').'>Get Directions</a>
							</div>
						</div>
						':'').'
						<div class="murl-table">
							<div class="murl-cell">
								<img alt="Phone Icon" width="24" height="24" src="/localthanks/images/icon_phone.svg">
							</div>
							<div class="murl-cell murl-cell-desc">
								<a '. ($loggedUser?'href="tel:' . $mmbPhoneNumber . '"':'href="javascript:void(0);" class="homeTriggerSignup"').'>' . $mmbPhoneNumber . '</a>
							</div>
						</div>

						<div class="murl-table">
							<div class="murl-cell">
								<img alt="Clock Icon" width="24" height="24" src="/localthanks/images/icon_time.svg">
							</div>

							<div class="murl-cell murl-cell-desc" style="font-size: 11px;">
								'.(isset($todayHours) && !empty($todayHours)?
									'<span style="color:#00A99D;">'									
										.($isStoreOpen?'Open Now':'Closed Now').
									'</span>
									<span>' . $todayHours . '</span>
								':'Closed Today').'
								
								<button class="btn btn-link" type="button" id="expandHoursBtn"><span class="glyphicon glyphicon-menu-down"></span></button>

								<div class="murl-hidden-hours">
								' . (!empty($hoursArr)? $hoursArr :'') . '
								</div>
							</div>
						</div>
					</div>
				</div>			
			</div>
			';
						
			return $outputStr;
		}

		function getNotScratchedScrecialIds( $userId ) {

			$Result = array();

			if ( isset($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords) && !empty($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords) && $this->currentMerchantId > 0 && is_numeric($userId) && $userId > 0) {

				$userIdOk = intval($userId);

				foreach ($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords as $key => $val)

					if (!$this->mRecords[$this->currentMerchantId]['Promo']->wasScrecialScratched($userIdOk, $val['ltp_id']) && $this->mRecords[$this->currentMerchantId]['Promo']->isCurrentScercial()){

						array_push($Result, $val['ltp_id']);

					}

				$userIdOk;				

			}

			return $Result;

		}

		function getPromoDisplayLimit() {
			return $this->maxPromoDisplay[$this->currentMerchantId];
		}

		function getInactivePromoIds(  ) {

			$Result = array();

			if ( isset($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords) && !empty($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords) ) {				

				foreach ($this->mRecords[$this->currentMerchantId]['Promo']->promoRecords as $key => $val)

					if ( !$this->mRecords[$this->currentMerchantId]['Promo']->isCurrentActive($val['ltp_id']) ) {

						array_push($Result, $val['ltp_id']);

					}

			}

			return $Result;

		}		

		

		function getMerchantSubDir( $initDir = './merchant-custom-files', $createIfNotExists = false ) {

			//var init

			$_i = 0; $subId = substr( $this->currentMerchantId, $_i, 2 ); $fullPath = $initDir; $Result = '';

			

			if ( !empty( $this->currentMerchantId ) ){

				do {

					$fullPath.= ($fullPath===''?'':'/') . $subId;

					$Result.= ( $Result == ''? '': '/' ) . $subId;

					if ( $createIfNotExists && !file_exists( $fullPath ) ){  

						//create it

						mkdir( $fullPath );

					}

					$_i+=2;

					$subId = substr( $this->currentMerchantId, $_i, 2 );

				}

				while ( $subId != '' );

				if ( $createIfNotExists ){

					if ( !file_exists( $fullPath . '/_files' ) ) { 

						//create it

						mkdir( $fullPath . '/_files' );

					}			

					if ( !file_exists( $fullPath . '/_files/img' ) ) {

						//create it

						mkdir( $fullPath . '/_files/img' );

					}

					if ( !file_exists( $fullPath . '/_files/custom' ) ) {

						//create it

						mkdir( $fullPath . '/_files/custom' );

					}

				}

			}			

			return $Result; 

		}

		

		function getPaymentMethods($resultType = 'array'){

			if ($resultType == 'array')

				$Result = array();

			else

				$Result = '';

			$this->loadPayments();

			if ( is_array($Result) )

				$Result = $this->mRecords[$this->currentMerchantId]['Payments'];

			else {

				foreach ($this->mRecords[$this->currentMerchantId]['Payments'] as $key=>$val) 

					$Result .= (empty($Result)?'':', ').$val['ccd_name'];

			}

			return $Result;

		}

		

		function getCurrent($mField) {

			if (isset($this->mRecords[$this->currentMerchantId][$mField])/* && $this->mRecords[$this->currentMerchantId][$mField] !== null*/) {				

				return $this->mRecords[$this->currentMerchantId][$mField];

			}			

			return '';

		}

		

		function getHeaderImage(){

			$tempVal = $this->getCurrent('ltb_header_image');			

			if (empty($tempVal)) {

				$currSelected = $this->currentMerchantId;

				$this->loadRecords(1, false);

				$mmbImage = '/merchant-custom-files/1/_files/img/h_250w_' . $this->getCurrent('ltb_header_image');

				$this->currentMerchantId = $currSelected;

			}			

			else {

				$mmbImage = '/merchant-custom-files/'.$this->getMerchantSubDir('/merchant-custom-files').'/_files/img/h_250w_' . $this->getCurrent('ltb_header_image');

			}

			return $mmbImage;

		}	

		

		function findStore($ltbId, $ltmId=null) {

			$storeRec = array();

			if (!isset($this->mRecords[$ltbId]))

				$this->loadRecords($ltbId, true);

			if ( isset( $this->mRecords[$ltbId], $this->mRecords[$ltbId]['Store'] ) )

				$storeRec = $this->mRecords[$ltbId]['Store']->findStore( $ltmId );			

			if ( !empty($storeRec) )

				return new Store\MerchantStore( $this->mDbo, $storeRec['ltm_id']);

			return null;

		}			

		function promoRedeemptionCount($promoId) {
			if (isset( $this->mRecords[$this->currentMerchantId], $this->mRecords[$this->currentMerchantId]['Promo'] ) && is_numeric($promoId) && intval($promoId) == $promoId)
				return $this->mRecords[$this->currentMerchantId]['Promo']->getRedeemptionCount($promoId);
			return 0;
		}

		function getCurrentStore($storeField) {			

			if ( isset( $this->mRecords[$this->currentMerchantId], $this->mRecords[$this->currentMerchantId]['Store'] ) )

				return $this->mRecords[$this->currentMerchantId]['Store']->getCurrent( $storeField );						

			return '';

		}

		function getCurrentPromo($promoField) {			

			if ( isset( $this->mRecords[$this->currentMerchantId], $this->mRecords[$this->currentMerchantId]['Promo'] ) )

				return $this->mRecords[$this->currentMerchantId]['Promo']->getCurrent( $promoField );

			return '';

		}

		function getIdBySlug($ltbSlug){

			foreach ($this->mRecords as $key => $val) {

				if ( $val['ltb_slug'] == $ltbSlug ) {

					$this->currentMerchantId = $key;

					return $key;

				}	

			}

			if ( $this->validData( $clean, $ltbSlug, 'adn_ltb_slug_r' ) ) {

				$stmt = $this->mDbo->prepare("

				SELECT MMC.ltb_id

				FROM lt_member_merchants MMC				

				WHERE MMC.ltb_slug=:ltbSlug LIMIT 1" );	

				$stmt->bindValue( ":ltbSlug", $clean['ltb_slug'], \PDO::PARAM_STR );

				$stmt->execute();

				if ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {

					$this->currentMerchantId = $resultSet['ltb_id'];

					return $resultSet['ltb_id'];

				}

			}

			return 0;

		}

		

		function findPromo( $ltbId, $promoSlug, $ltpId = 0, $countView = false){

			$promoRec = array();

			if (!isset($this->mRecords[$ltbId]))

				$this->loadRecords($ltbId, true);
			
			if ( isset( $this->mRecords[$ltbId], $this->mRecords[$ltbId]['Promo'] ) )

				$promoRec = $this->mRecords[$ltbId]['Promo']->findPromo( $promoSlug );			

			if ( !empty($promoRec) ) {
				if ($countView) {
					return new Promo\MerchantPromo( $this->mDbo, $promoRec['ltp_id'], 'default', true);
				}
				else {
					return new Promo\MerchantPromo( $this->mDbo, $promoRec['ltp_id']);
				}	
			}	

			return null;

		}
		
		function updateProductCount ($ltbId, $prodId, $prodCount) {
			if ( $this->validData( $cleanProdId, $prodId, 'wnu_prodId_r' ) 
				&& $this->validData( $cleanLtbId, $ltbId, 'wnu_ltbId_r' )
				&& ($this->validData( $cleanProdCount, $prodCount, 'wnu_count_r') || $prodCount===null)
			) {
				if (!isset($cleanProdCount['count'])) $cleanProdCount['count'] = null;
				
				$stmt = $this->mDbo->prepare("

				INSERT IGNORE INTO tbl_use_count (prod_id, ltb_id, use_count) VALUES (:prodid, :ltbid, :pcount)" );	

				$stmt->bindValue( ":prodid", $cleanProdId['prodId'], \PDO::PARAM_INT );
				$stmt->bindValue( ":ltbid", $cleanLtbId['ltbId'], \PDO::PARAM_INT );
				$stmt->bindValue( ":pcount", $cleanProdCount['count'], \PDO::PARAM_INT );

				$stmt->execute();

				if ( !$stmt->rowCount() ) {

					$stmt = $this->mDbo->prepare("

						UPDATE tbl_use_count SET use_count = :pcount WHERE prod_id = :prodid AND ltb_id = :ltbid" );	

					$stmt->bindValue( ":prodid", $cleanProdId['prodId'], \PDO::PARAM_INT );
					$stmt->bindValue( ":ltbid", $cleanLtbId['ltbId'], \PDO::PARAM_INT );
					$stmt->bindValue( ":pcount", $cleanProdCount['count'], \PDO::PARAM_INT );

					$stmt->execute();

				}
				
				return $stmt->rowCount()? true: false;
				
			}
			return false;
		}
		
		function loadPromo ($ltbId, $ltpId){ 
			if (!isset($this->mRecords[$ltbId]))
				$this->loadRecords($ltbId, false);
			$this->mRecords[$ltbId]['Promo'] = new Promo\MerchantPromo( $this->mDbo, $ltpId);			
			return $this->mRecords[$ltbId]['Promo'];
		}

		function __construct($dbObj, $loadRecords=true, $ltbId=null, $loadPromos=false){
			$this->mDbo=$dbObj;
			
			if ($loadRecords && $this->validData($clean, $ltbId, $fileType='wnu_ltb_id_r' )) {
				
				$this->loadRecords($clean['ltb_id'], $loadPromos);
			}	
		}

	}

}

?>
