<?php
namespace App\Package {
	require_once 'class.variables.php';
	require_once 'class.product.php';
	use App\Product as Product;
	class package extends Product\product { 
		
		//private properties
		private $packRecords = array();
		private $packId = 0;
		private $productList = array();
		private $basicProductList = array();
		private $preventStackOverflow = array();
		//private functions
		private function updatePackage( $packageRec, &$errorArr ) {
			$errorArr = array();
			$newProductRec['wnu_pk_id_r'] = $packageRec['pk_id'];
			$newProductRec['txt64_pk_internal_name'] = isset($packageRec['pk_internal_name'])? $packageRec['pk_internal_name'] : null;
			$newProductRec['txt_pk_more_info'] = isset($packageRec['pk_more_info'])? $packageRec['pk_more_info'] : null;		
			$newProductRec['txt_pk_terms'] = isset($packageRec['pk_terms'])? $packageRec['pk_terms'] : null;		
			
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					UPDATE tbl_package
					SET pk_internal_name = :pk_internal_name, 
						pk_more_info = :pk_more_info, 
						pk_terms = :pk_terms	
					WHERE pk_id = :pk_id
				");/*pk_itemizable = :pk_itemizable */
				
				$stmt->bindValue( ':pk_internal_name', empty($cleaned['pk_internal_name'])? null: $cleaned['pk_internal_name'], \PDO::PARAM_STR );
				$stmt->bindValue( ':pk_more_info', empty($cleaned['pk_more_info'])? null: $cleaned['pk_more_info'], \PDO::PARAM_STR );
				$stmt->bindValue( ':pk_terms', empty($cleaned['pk_terms'])? null: $cleaned['pk_terms'], \PDO::PARAM_STR );			
				//$stmt->bindValue( ':pk_itemizable', isset($packageRec['pk_itemizable'])? 1 : 0, \PDO::PARAM_INT );			
				$stmt->bindValue( ':pk_id', $cleaned['pk_id'], \PDO::PARAM_INT );
				
				$stmt->execute();
				
				return true;
				
			}
			else {
				
				$errorArr = array_values($errorArr);
			}
			return false;
		}
		
		private function getPackProducts($packId, $ofrId = null) {			
			$str = 'WHERE PACK.pk_id = :packId';
			
			if ( $ofrId !== null ) {
				$str .= ' AND PROD.ofr_id = :ofrId';
			}
			
			$stmt = $this->dbObj->prepare("
				SELECT PPR.*, PROD.*, POFF.ofr_company, POFF.ofr_id, PACK.*, P2P.*, (CASE WHEN PACK1.pk_id IS NULL THEN 0 ELSE 1 END) AS is_pack 
				FROM tbl_prod2pack P2P
				
				INNER JOIN tbl_product PROD ON PROD.prod_id = P2P.prod_id
				LEFT JOIN tbl_package PACK1 ON PACK1.pk_id = PROD.prod_id
				LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PROD.prod_id
				INNER JOIN tbl_prod_offerer POFF ON POFF.ofr_id = PROD.ofr_id
				
				INNER JOIN tbl_package PACK ON PACK.pk_id = P2P.pk_id				
				{$str}
			");
			
			$stmt->bindValue(':packId', $packId, \PDO::PARAM_INT);
			
			if ($ofrId !== null) {
				$stmt->bindValue(':ofrId', $ofrId, \PDO::PARAM_INT);
			}
			
			$stmt->execute();
			
			$this->productList[$packId]['Products'] = array();
			
			while ( $Result = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {		
				if (intval($Result['is_pack']) === 1) {
					array_push($this->productList[$Result['pk_id']]['Products'], array('Data' => $Result, 'Obj' => new \App\Package\package( $this->dbObj, $Result['prod_id'] ) ) );	
				}	
				else {
					array_push($this->productList[$Result['pk_id']]['Products'], array('Data' => $Result, 'Obj' => new \App\Product\product( $this->dbObj, $Result['prod_id'] ) ) );
				}
			}
			
			return $this->productList;
		}

		public function addPackage( $packageRec, &$errorArr ) {
			$errorArr = array();
			$tmpProdId = $this->createProduct($packageRec, $errorArr);
			if ($tmpProdId) {		
				$newProductRec['wnu_pk_id_r'] = $tmpProdId;
				$newProductRec['txt64_pk_internal_name'] = isset($packageRec['pk_internal_name'])? $packageRec['pk_internal_name'] : null;
				$newProductRec['txt_pk_more_info'] = isset($packageRec['pk_more_info'])? $packageRec['pk_more_info'] : null;
				$newProductRec['txt_pk_terms'] = isset($packageRec['pk_terms'])? $packageRec['pk_terms'] : null;
				
				$cleaned = $this->validate ( $newProductRec, $errorArr );
				
				if ( count( $errorArr ) === 0 ) {
					//good to go
					$stmt = $this->dbObj->prepare("
						INSERT IGNORE INTO tbl_package	(pk_id, pk_internal_name, pk_more_info, pk_terms) VALUES (:pk_id, :pac_internal_name, :pac_more_info, :pac_terms) 
					"); /*, pk_itemizable , :pac_itemizable*/
					
					$stmt->bindValue( ':pac_internal_name', empty($cleaned['pk_internal_name'])? null : $cleaned['pk_internal_name'], \PDO::PARAM_STR );
					$stmt->bindValue( ':pac_more_info', empty($cleaned['pk_more_info'])? null: $cleaned['pk_more_info'], \PDO::PARAM_STR );
					$stmt->bindValue( ':pac_terms', empty($cleaned['pk_terms'])? null: $cleaned['pk_terms'], \PDO::PARAM_STR );
					$stmt->bindValue( ':pk_id', $cleaned['pk_id'], \PDO::PARAM_INT );
					//$stmt->bindValue( ':pac_itemizable', isset($packageRec['pk_itemizable'])? 1 : 0, \PDO::PARAM_INT );

					$stmt->execute();
					return $this->dbObj->lastInsertId();
					
				}
				else {
					$errorArr = array_values($errorArr);
				}
			}
			
			return 0;
		}
		
		function update ($packProdRec, &$errors) {
			if ($this->updateProduct($packProdRec, $errors)) {
				return $this->updatePackage( $packProdRec, $errors );
			}
			return false;
		}
		
		public function filterProducts ($filterStructObj, $exclusiveCmp = false) {
			$tmpArr = []; $filterStruct = $filterStructObj;
			foreach ( $this->productList as $id => $v ) {

				$flag=false;

				if ( isset( $filterStruct['prod_active'] ) ) {
					$filterStruct['prod_active'] = (string) $filterStruct['prod_active'];
					
					if ( 
								strcmp ( $filterStruct['prod_active'], '0' ) !== 0
							&&  strcmp ( $filterStruct['prod_active'], '1' ) !== 0
						) {
						unset( $filterStruct['prod_active'] );
					}
				}
				
				if ( isset($v['Data']['ofr_id'], $filterStruct['ofr_id']) && !empty($filterStruct['ofr_id']) && strcmp($v['Data']['ofr_id'], $filterStruct['ofr_id']) !== 0) {
					$flag = true;
				}

				foreach ( $v['Data'] as $field => $fVal ) {
					if ( !$flag && isset( $filterStruct[$field] ) && (!empty( $filterStruct[$field] ) || $field == 'prod_active') ) {
						$flag = $exclusiveCmp? strcmp( $fVal , $filterStruct[$field] ) !== 0 : stripos( $fVal , $filterStruct[$field] ) === false;					
					}
				}
				
				if ($flag) {
					array_push($tmpArr, $id);
				}
			}
			
			foreach ($tmpArr as $v) {
				unset($this->productList[$v]);
			}
		}
		
		function getProductList($packId) {
			if (isset($this->productList[$packId]['Products'])) {
				return $this->productList[$packId]['Products'];
			}
			return array();
		}
		
		function getPackageData($packId) {
			if (isset($this->productList[$packId]['Data'])) {
				return $this->productList[$packId]['Data'];
			}
			return array();
		}
		
		private function getAll() {
			$stmt = $this->dbObj->prepare("
				SELECT PPR.*, PROD.*, PACK.*, POFF.ofr_company, POFF.ofr_id 
				FROM tbl_product PROD
				INNER JOIN tbl_package PACK ON PACK.pk_id = PROD.prod_id
				INNER JOIN tbl_prod_offerer POFF ON POFF.ofr_id = PROD.ofr_id
				LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PROD.prod_id
			");

			$stmt->execute();
			
			while ( $Result = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				$this->productList[$Result['pk_id']]['Data'] = $Result;	
				$this->productList[$Result['pk_id']]['Obj'] = new \App\Product\product( $this->dbObj, $Result['prod_id'] );
				//$this->getPackProducts($Result['pk_id']);
			}
			
			return $this->productList;
		}
		
		private function getPackage($packId) { /*This function should always be private it has to be called thru the constructor*/
			$valRec = array('wnu_value_r'=>$packId);
			if ($this->validate ( $valRec, $errors ) && count($errors) === 0) {				
				$stmt = $this->dbObj->prepare("
					SELECT PPR.*,PROD.*, PACK.*
					FROM tbl_product PROD
					INNER JOIN tbl_package PACK ON PACK.pk_id = PROD.prod_id
					LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PROD.prod_id
					WHERE PACK.pk_id = :pId
					LIMIT 1
				");
				$stmt->bindValue(':pId', $packId, \PDO::PARAM_INT);
				$stmt->execute();
				
				while ( $Result = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
					$this->productList[$Result['pk_id']]['Data'] = $Result;	
					$this->productList[$Result['pk_id']]['Obj'] = $this;					
					$this->getPackProducts($Result['pk_id']);
				}
				return $this->productList;
			}
			
			return false;
		}
		
		public function getPackageInfo($packId) {
			$valRec = array('wnu_value_r'=>$packId);
			if (isset($this->productList[$packId]['Info']))
				return $this->productList[$packId]['Info'];
			elseif ($this->validate ( $valRec, $errors ) && count($errors) === 0) {				
				$stmt = $this->dbObj->prepare("
					SELECT PPR.*,PROD.*, PACK.*, TEM.tem_path
					FROM tbl_product PROD
					INNER JOIN tbl_package PACK ON PACK.pk_id = PROD.prod_id
					LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PROD.prod_id
					LEFT JOIN tbl_emails TEM ON PACK.tem_id = TEM.tem_id
					WHERE PACK.pk_id = :pId
					LIMIT 1
				");
				$stmt->bindValue(':pId', $packId, \PDO::PARAM_INT);
				$stmt->execute();
				
				if ( $Result = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
					$this->productList[$Result['pk_id']]['Info'] = $Result;
					return $this->productList[$Result['pk_id']]['Info'];
				}
			}
			return array();
		}
		
		public function getPackTableRowsOutput () {
			$results = '';
			foreach ( $this->productList as $id => $v ) {
				$results .= '<tr>';
				$results .=   '<td>'.$v['Data']['pk_id'].'</td>';
				$results .=   '<td>'.$v['Data']['prod_name'].'</td>';
				$results .=   '<td>'.$v['Data']['prod_descript'].'</td>';
				$results .=   '<td>'.$v['Data']['pk_internal_name'].'</td>';
				$results .=   '<td>'.$v['Data']['prod_keyword'] . '</td>';
				$results .=   '<td>'.$v['Data']['pk_terms'].'</td>';			
				$results .=   '<td>'.$v['Data']['pk_more_info'].'</td>';
				$results .=   '<td>'.($v['Data']['prod_active']=='0'?"No":($v['Data']['prod_active']=='1'?"Yes":"")).'</td>';
				$results .=   '<td>
								<div style="min-width:120px;" class="btn-group btn-group-xs" role="group" aria-label="...">
									<button title="Package Edit" aria-label="..." type="button" class="btn btn-info triggerEdit" data-toggle="modal" data-target="#globalModal" data-id="'.$v['Data']['pk_id'].'"><span class="glyphicon glyphicon-pencil"></span></button>
									<button title="Change Provider" aria-label="..." type="button" class="btn btn-default triggerOfferer" data-toggle="modal" data-id = "' . $v['Data']['pk_id'] . '" data-ofr_id = "'.$v['Data']['ofr_id'].'" data-id="'.$v['Data']['pk_id'].'" data-target="#globalModal"><span class="glyphicon glyphicon-check"></span></button>
									<button title="Package Prices" aria-label="..." type="button" class="btn btn-primary triggerPrice" data-toggle="modal" data-id="'.$v['Data']['pk_id'].'" data-target="#globalModal"><span class="glyphicon glyphicon-usd"></span></button>
									<button title="Package Product List" aria-label="..." type="button" class="btn btn-warning triggerProdList" data-toggle="modal" data-id="'.$v['Data']['pk_id'].'" data-name="'.$v['Data']['prod_name'].'" data-target="#globalModal"><span class="glyphicon glyphicon-list"></span></button>
								</div>	
							   </td>';
				$results .= '</tr>';
			}
			return $results;
		}
		
		private function getPackBasicProductList( $packId, $loadObj = false ) {
			$stmt = $this->dbObj->prepare("
				SELECT PROD.*, P2P.*, PPR.ppr_id, PPR.ppr_price, PPR.ppr_setup, PACK1.pk_id AS prodIsPack
				FROM tbl_prod2pack P2P 
				
				INNER JOIN tbl_product PROD ON PROD.prod_id = P2P.prod_id
				LEFT JOIN (
					SELECT PPR.*
					FROM tbl_prod_price PPR
					INNER JOIN tbl_product PROD ON PROD.prod_id = PPR.prod_id
					WHERE PPR.ppr_current_price
					
				) PPR ON PROD.prod_id = PPR.prod_id
				LEFT JOIN tbl_package PACK1 ON PACK1.pk_id = PROD.prod_id
				
				INNER JOIN tbl_package PACK ON PACK.pk_id = P2P.pk_id
				
				WHERE PACK.pk_id = :packId 
			");
				
			$stmt->bindValue(':packId', $packId, \PDO::PARAM_INT);
		
			$stmt->execute();
			
			while ( $Result = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				if (isset($Result['prodIsPack']))
					$this->getPackBasicProductList($Result['prod_id']);	
				else {
					if ($loadObj)
						$this->basicProductList[$Result['pk_id']][$Result['prod_id']]['Obj'] = new Product\product( $this->dbObj, $Result['prod_id'] );
					$this->basicProductList[$Result['pk_id']][$Result['prod_id']]['Data'] = $Result;
					if ($Result['prod_keyword'] === 'LT_MAX_ACTIVE_PROMOS') {
						$this->packRecords[$Result['pk_id']]['Max_Promos'] = $Result['p2p_count'];
					}
				}	
			}
			return $this->basicProductList;
		}
		
		function getRecords ( $packId = 0, $fieldName = '' ) {
			return isset($this->packRecords[$packId][$fieldName])? $this->packRecords[$packId][$fieldName]: ($this->packRecords[$packId]?$this->packRecords[$packId]:$this->packRecords);
		}
		
		public function findBasicProductList ( $packId, $loadObj = false ) {
			$this->preventStackOverflow = [];
			$this->getPackBasicProductList( $packId, $loadObj );
			return isset($this->basicProductList[$packId])? $this->basicProductList[$packId]: [];
		}
		
		public function getRecBasicList () {
			return $this->basicProductList;
		}
		
		public function getnonIncludedList($pkId, $justPackages = false) {		
			$newProductRec['wnu_pk_id_r'] = $pkId;		
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			$this->productRecords['Non_Included_List'] = array();
			if ( count( $errorArr ) === 0 ) {
				$str = '';	
				$stmt = $this->dbObj->prepare("
					SELECT 
						PRD.*, POF.*,
						(CASE WHEN ISPACK.pk_id IS NULL THEN 0 ELSE 1 END) AS is_pack,
						ISPACK.pk_terms,
						ISPACK.pk_more_info,
						ISPACK.pk_internal_name,
						PPR.ppr_id,
						PPR.ppr_setup,
						PPR.ppr_price
						
					FROM tbl_product PRD
					LEFT JOIN tbl_prod_offerer POF ON POF.ofr_id = PRD.ofr_id
					".($justPackages? "INNER":"LEFT")." JOIN tbl_package ISPACK ON ISPACK.pk_id = PRD.prod_id
					
					LEFT JOIN 
						(
							SELECT * FROM tbl_prod_price WHERE ppr_current_price LIMIT 1
						) PPR ON PPR.prod_id = PRD.prod_id
					
					WHERE
							".($justPackages? "":"ISPACK.pk_id IS NULL AND ")."
							PRD.prod_id <> :pk_id 
						AND PRD.prod_id NOT IN
							(	
								SELECT PROD_B.prod_id
								FROM tbl_prod2pack P2P_B
								INNER JOIN tbl_package PACK ON PACK.pk_id = P2P_B.pk_id
								INNER JOIN tbl_product PROD_B ON PROD_B.prod_id = P2P_B.prod_id				
								WHERE PACK.pk_id = :pk_id
								
							)
						AND PRD.prod_id NOT IN
							(
								SELECT PACK_B.pk_id
								FROM tbl_prod2pack P2P_C
								INNER JOIN tbl_package PACK_B ON PACK_B.pk_id = P2P_C.pk_id
								INNER JOIN tbl_product PROD_C ON PROD_C.prod_id = P2P_C.prod_id				
								WHERE PROD_C.prod_id = :pk_id
							)
				"); /*Every product that is not itself, or one of its included products or one of the packages that it is included into*/
				$stmt->bindValue( ':pk_id', $cleaned['pk_id'], \PDO::PARAM_INT );
				$stmt->execute();
				
				while ( $Result = $stmt->fetch(\PDO::FETCH_ASSOC) ) {
					$this->productRecords['Non_Included_List'][] = $Result;			
				}
			}
			return $this->productRecords['Non_Included_List'];
		}
		
		function getPackEmailAmount($pkId) {
			$newProductRec['wnu_pk_id_r'] = $pkId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			if ( count( $errorArr ) === 0 ) {
				$tmpProds = $this->findBasicProductList( $cleaned['pk_id'] );
				foreach ($tmpProds as $pr => $data) {
					if ($data['Data']['prod_keyword'] == 'LT_EMAILS') {
						return $data['Data']['p2p_count'];
					}
				}	
			}
			return 0;
		}
		
		public function addProdToPackage($requestBody, &$errorArr ) {
			$errorArr = array();
			$newProductRec['wnu_pk_id_r'] = isset( $requestBody['pk_id'] )? $requestBody['pk_id'] : null;
			$newProductRec['wnu_prod_id_r'] = isset($requestBody['prod_id'])? $requestBody['prod_id']:null;
			
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {		
				$stmt = $this->dbObj->prepare("
					INSERT IGNORE INTO tbl_prod2pack (pk_id, prod_id) VALUES (:pk_id, :prod_id)
				");	
				$stmt->bindValue( ':pk_id', $cleaned['pk_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );			
				$stmt->execute();						
				return true;
			}
			else {
				$errorArr = array_values($errorArr);
			}
			return false;
		}
		
		public function removeProdFromPackage($requestBody, &$errorArr) {
			$errorArr = array();
			$newProductRec['wnu_pk_id_r'] = isset( $requestBody['pk_id'] )? $requestBody['pk_id'] : null;
			$newProductRec['wnu_prod_id_r'] = isset($requestBody['prod_id'])? $requestBody['prod_id']:null;
			
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {		
				$stmt = $this->dbObj->prepare("
					DELETE FROM tbl_prod2pack WHERE pk_id=:pk_id AND prod_id=:prod_id
				");	
				$stmt->bindValue( ':pk_id', $cleaned['pk_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );			
				$stmt->execute();						
				return true;
			}
			else {
				$errorArr = array_values($errorArr);
			}
			return false;
		}
		
		public function saveProdPackage( $requestBody, &$errorArr ) {
			$errorArr = array();
			$newProductRec['wnu_pk_id_r'] = isset( $requestBody['pk_id'] )? $requestBody['pk_id'] : null;
			$newProductRec['wnu_prod_id_r'] = isset($requestBody['prod_id'])? $requestBody['prod_id']:null;
			
			if (isset( $requestBody['p2p_count'] )) {
				
				$newProductRec['wnu_p2p_count_r'] = $requestBody['p2p_count'];
				$cleaned = $this->validate ( $newProductRec, $errorArr );
				$tmpVar = 'p2p_count';
				
			}
			elseif (isset( $requestBody['p2p_show_in_pack'] )) {
				
				$newProductRec['bit_p2p_show_in_pack_r'] = $requestBody['p2p_show_in_pack'];
				$tmpVar = 'p2p_show_in_pack';
				$cleaned = $this->validate ( $newProductRec, $errorArr );
				
			}
			/*
			elseif (isset( $requestBody['p2p_lock_price'] )) {
				
				$newProductRec['bit_p2p_lock_price_r'] = $requestBody['p2p_lock_price'];
				$tmpVar = 'p2p_lock_price';
				$cleaned = $this->validate ( $newProductRec, $errorArr );
				
			}
			*/
			elseif (isset( $requestBody['p2p_display_order'] )) {
				
				$newProductRec['bit_p2p_display_order_r'] = $requestBody['p2p_display_order'];
				$tmpVar = 'p2p_display_order';
				$cleaned = $this->validate ( $newProductRec, $errorArr );
				
			}
			else {
				$errorArr = array('No value found');
			}
			
			if ( count( $errorArr ) === 0 ) {		
				$stmt = $this->dbObj->prepare("
					UPDATE tbl_prod2pack SET {$tmpVar}=:{$tmpVar} WHERE pk_id=:pk_id AND prod_id=:prod_id
				");
				
				$stmt->bindValue( ':pk_id', $cleaned['pk_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':'.$tmpVar, intval($cleaned[$tmpVar]), \PDO::PARAM_INT );
				$stmt->execute();						
				return true;
			}
			else {
				$errorArr = array_values($errorArr);
			}
			
			return false;
		}
		
		public function getResellerPackages ( $resId, &$htmlTable, $placement = 'msp' ) {
			$errorArr = array(); $htmlTable = '';
			$newProductRec['wnu_res_id_r'] = $resId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			switch ($placement) {
				case '4my.store': 
					$p2r_placement = $placement;
				break;	
				default: 
					$p2r_placement = 'msp';
			}

			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					SELECT DISTINCT PPR.*, P2R.p2r_placement, P2R.p2r_featured, RES.*, PRD.*, PIN.*
					FROM tbl_prod2reseller P2R 
					INNER JOIN tbl_reseller RES ON RES.res_id = P2R.res_id 					
					INNER JOIN tbl_package PIN ON P2R.prod_id = PIN.pk_id 
					INNER JOIN tbl_product PRD ON PRD.prod_id = PIN.pk_id 
					LEFT JOIN ( SELECT * FROM `tbl_prod_price` WHERE ppr_current_price ) PPR ON PRD.prod_id = PPR.prod_id
					WHERE RES.res_id = :res_id AND P2R.p2r_placement = :plac
					ORDER BY PPR.ppr_price 					
				");
							
				$stmt->bindValue( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':plac', $p2r_placement, \PDO::PARAM_STR );
				$stmt->execute();
				$Results = $stmt->fetchAll( \PDO::FETCH_ASSOC );
				$this->productRecords['Reseller_Packages'] = array();
				$results = '';
				foreach ( $Results as $Result ) {
					if (!isset($this->productRecords['Reseller_Packages'][$Result['res_id']]))
						$this->productRecords['Reseller_Packages'][$Result['res_id']] = array();
									
					$results .= '<tr>'; 
					$results .=   '<td><a href="/admin/packages?prod_id='.$Result['prod_id'].'&search=1">'.$Result['prod_id'].'</a></td>';
					$results .=   '<td>'.$Result['prod_name'].'</td>';
					$results .=   '<td>'.$Result['prod_descript'].'</td>';
					$results .=   '<td>'.$Result['pk_internal_name'].'</td>';
					$results .=   '<td>'.$Result['prod_keyword'] . '</td>';
					$results .=   '<td>'.$Result['pk_terms'].'</td>';			
					$results .=   '<td>'.$Result['pk_more_info'].'</td>';
					$results .=   '<td>'.$Result['p2r_placement'].'</td>';
					$results .=   '<td><div style="min-width:80px;" class="btn-group btn-group-md" role="group" aria-label="...">
											<button class="btn btn-danger removePlan" data-placement="'.$Result['p2r_placement'].'" data-resid="'.$Result['res_id'].'" data-placement="'.$Result['p2r_placement'].'" data-pkid="'.$Result['pk_id'].'"><span class="glyphicon glyphicon-trash"></span></button>
											<button data-placement="'.$Result['p2r_placement'].'" class="btn btn-'.(intval($Result['p2r_featured']) === 1?'info unfeaturePlan" title="Featured package, remove featured mark"':'default featurePlan" title="Mark it as a featured package"').' data-resid="'.$Result['res_id'].'" data-pkid="'.$Result['pk_id'].'"><span class="glyphicon glyphicon-' . (intval($Result['p2r_featured']) === 1?'check': 'unchecked') . '"></span></button>
										</div>
									</td>';
					$results .= '</tr>';
					array_push( $this->productRecords['Reseller_Packages'][$Result['res_id']], $Result );
					
					$this->productRecords['Product_List'][$Result['pk_id']] = $this->findBasicProductList( $Result['pk_id'] );
					//var_dump($this->productRecords['Product_List'][$Result['pk_id']]);
					
				}
				
				$htmlTable = $results;
				return $this->productRecords['Reseller_Packages'];
				
			}
			else {
				$errorArr = array_values( $errorArr );
			}
			
			return [];
		}
		
		public function getOneFreeTopLevelPackage($notInArr = []){			
			$newProductRec['wnu_val0_r'] = 0;
			foreach ($notInArr as $k=>$v) {
				$newProductRec['wnu_val'.$v.'_r'] = $v;
			}			
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				
				$tmpStr = implode(',',$cleaned);
				//var_dump($tmpStr);
				//good to go
				$stmt = $this->dbObj->prepare("
					SELECT DISTINCT P2R.p2r_placement, P2R.p2r_featured, RES.*, PRD.*, PIN.*, PPR.*
					FROM tbl_prod2reseller P2R
					INNER JOIN tbl_reseller RES ON RES.res_id = P2R.res_id
					INNER JOIN tbl_package PIN ON P2R.prod_id = PIN.pk_id
					INNER JOIN tbl_product PRD ON PRD.prod_id = PIN.pk_id
					INNER JOIN tbl_prod_price PPR ON PRD.prod_id = PPR.prod_id
					WHERE PRD.prod_active AND PPR.ppr_current_price AND PPR.ppr_price = 0.00 AND PPR.ppr_setup = 0.00 AND PRD.prod_id NOT IN ({$tmpStr})
					LIMIT 1					
				");
										
				$stmt->execute();
				$this->productRecords['Free_Top_Package'] = array();
				$results = '';
				if ( $Result = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
					$this->productRecords['Free_Top_Package'] = $Result;					
				}
				
				return $this->productRecords['Free_Top_Package'];
				
			}			
			
			return [];
		}
		
		public function getResellerTopLevelPackages( $resId, $priceLessThanPackId = 0) {

			$newProductRec['wnu_res_id_r'] = $resId;
			$newProductRec['wnu_pack_id_r'] = $priceLessThanPackId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					SELECT DISTINCT P2R.p2r_placement, P2R.p2r_featured, RES.*, PRD.*, PIN.*, PPR.*
					FROM tbl_prod2reseller P2R
					INNER JOIN tbl_reseller RES ON RES.res_id = P2R.res_id
					INNER JOIN tbl_package PIN ON P2R.prod_id = PIN.pk_id
					INNER JOIN tbl_product PRD ON PRD.prod_id = PIN.pk_id
					INNER JOIN tbl_prod_price PPR ON PPR.prod_id = PRD.prod_id
					WHERE 
						PRD.prod_active 
						AND PPR.ppr_current_price 
						AND RES.res_id = :res_id 
						AND PIN.pk_id NOT IN (
							SELECT PRD.prod_id
							FROM tbl_prod2pack P2P
							INNER JOIN tbl_package PACK ON P2P.prod_id = PACK.pk_id
							INNER JOIN tbl_product PRD ON PRD.prod_id = PACK.pk_id						
						)					
						AND PPR.ppr_price <= (
							SELECT ppr_price
							FROM tbl_prod_price
							WHERE 
								ppr_current_price 
								AND prod_id = :pack_id 
							LIMIT 1
						)
				");
							
				$stmt->bindValue( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':pack_id', $cleaned['pack_id'], \PDO::PARAM_INT );
				$stmt->execute();
				$this->productRecords['Reseller_Top_Packages'][$cleaned['res_id']] = array();
				$results = '';
				while ( $Result = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
					if (!isset($this->productRecords['Reseller_Top_Packages'][$Result['res_id']]))
						$this->productRecords['Reseller_Top_Packages'][$Result['res_id']] = array();
					array_push( $this->productRecords['Reseller_Top_Packages'][$Result['res_id']], $Result );
				}
				
				return $this->productRecords['Reseller_Top_Packages'][$cleaned['res_id']];
				
			}
			
			return [];
		}
		
		public function getNonResellerPackages($resId, &$htmlTable){
			$errorArr = array(); $htmlTable = '';
			$newProductRec['wnu_res_id_r'] = $resId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					SELECT DISTINCT PRD.*, PIN.pk_internal_name
					FROM tbl_product PRD
					INNER JOIN tbl_package PIN ON PRD.prod_id = PIN.pk_id								
					
					WHERE PIN.pk_id NOT IN (
						SELECT Pk1.pk_id
						FROM tbl_prod2reseller P2R1
						INNER JOIN tbl_reseller RES1 ON RES1.res_id = P2R1.res_id
						INNER JOIN tbl_package Pk1 ON Pk1.pk_id = P2R1.prod_id
						WHERE RES1.res_id = :res_id AND P2R1.p2r_placement = 'msp'
					)
					OR PIN.pk_id NOT IN (
						SELECT Pk2.pk_id
						FROM tbl_prod2reseller P2R2
						INNER JOIN tbl_reseller RES2 ON RES2.res_id = P2R2.res_id
						INNER JOIN tbl_package Pk2 ON Pk2.pk_id = P2R2.prod_id
						WHERE RES2.res_id = :res_id AND P2R2.p2r_placement = '4my.store'
					)
				");
							
				$stmt->bindValue( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$stmt->execute();
				$this->productRecords['Non_Reseller_Packages'] = array();
				$results = '';
				while ( $Result = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
					if (!isset($this->productRecords['Non_Reseller_Packages'][$cleaned['res_id']]))
						$this->productRecords['Non_Reseller_Packages'][$cleaned['res_id']] = array();
									
					$results .= '<tr>';
					$results .=   '<td>'.$Result['prod_id'].'</td>';
					$results .=   '<td>'.$Result['prod_name'].'</td>';
					$results .=   '<td>'.$Result['prod_descript'].'</td>';
					$results .=   '<td>'.$Result['pk_internal_name'].'</td>';
					$results .=   '<td><input type="checkbox" class="addPlanToReseller"/><button title="Add plan to the reseller" style="display: none; margin-left: 10px;" data-prod_id="'.$Result['prod_id'].'" data-res_id="'.$cleaned['res_id'].'" class="btn btn-success addPlanToResellerBtn"><span class="glyphicon glyphicon-ok"></span></button><br><select class="p2ResPlacement" style="display:none;" name="placement"><option value="msp">msp</option><option value="4my.store">4my.store</option><option value="both">both</option></select></td>';	
					$results .= '</tr>';
					
					
					array_push( $this->productRecords['Non_Reseller_Packages'][$cleaned['res_id']], $Result );
				}
				
				$htmlTable = $results;
				
				return $this->productRecords['Non_Reseller_Packages'][$cleaned['res_id']];
				
			}
			else {
				$errorArr = array_values($errorArr);
			}
			
			return [];
		}
		
		public function removePackageFromReseller($packId, $resId, $p2rPlacement) {		
			$newProductRec['wnu_pk_id_r'] = $packId;
			$newProductRec['wnu_res_id_r'] = $resId;
			switch ($p2rPlacement) {
				case '4my.store': 
					$p2rPlacementOk = $p2rPlacement;
				break;				
				default: 
					$p2rPlacementOk = 'msp';
			}
			
			
			$cleaned = $this->validate ($newProductRec, $errorArr);
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					DELETE FROM tbl_prod2reseller
					WHERE prod_id = :pk_id AND res_id = :res_id AND p2r_placement = :placement
				");
				
				$stmt->bindValue( ':pk_id', $cleaned['pk_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':placement', $p2rPlacementOk, \PDO::PARAM_STR );
				
				$stmt->execute();
				return true;
				
			}
			return false;
		}
		
		public function addPlanToReseller($pkId, $resId, $p2rPlacement = 'msp'){
			switch ($p2rPlacement) {
				case '4my.store': 
					$p2rPlacementOk = $p2rPlacement;
				break;
				case 'both': 
					$this->addPlanToReseller($pkId, $resId, 'msp');
					$p2rPlacementOk = '4my.store';
				break;	
				default: 
					$p2rPlacementOk = 'msp';
			}
			
			$errorArr = array();
			$newProductRec['wnu_res_id_r'] = $resId;
			$newProductRec['wnu_pk_id_r'] = $pkId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				//good to go
				
				$stmt = $this->dbObj->prepare("
					INSERT IGNORE INTO tbl_prod2reseller (res_id, prod_id, p2r_placement) VALUES (:res_id, :pk_id, :rdc_placement)
				");
				
				$stmt->bindValue( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':pk_id', $cleaned['pk_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':rdc_placement', $p2rPlacementOk, \PDO::PARAM_STR );
				$stmt->execute();
				
				return $this->dbObj->lastInsertId();
			}
			else {
				$errorArr = array_values($errorArr);
			}	
			return false;
			
		}
		
		public function un_markAsFeatured($prodId, $resId, $placement, $isItFeatured = true){
			$errorArr = array();
			$newProductRec['wnu_res_id_r'] = $resId;
			$newProductRec['wnu_prod_id_r'] = $prodId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			switch ($placement) {
				case '4my.store': 
					$p2r_placement = $placement;
				break;
				case 'both': 
					$this->un_markAsFeatured($prodId, $resId, 'msp', $isItFeatured);
					$p2r_placement = '4my.store';
				break;	
				default: 
					$p2r_placement = 'msp';
			}

			
			
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					UPDATE tbl_prod2reseller SET p2r_featured=".($isItFeatured?'1':'0')." WHERE res_id = :res_id AND prod_id = :prod_id AND p2r_placement = :p2r_placement
				");	
				$stmt->bindValue( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );			
				$stmt->bindValue( ':p2r_placement', $p2r_placement, \PDO::PARAM_STR );							
				$stmt->execute();		
				return $this->dbObj->lastInsertId();
			}
			else {
				$errorArr = array_values($errorArr);
			}	
			return false;
			
		}
		
		function getPackPlacement ($prodId, $resId) {
			$errorArr = array();
			$newProductRec['wnu_res_id_r'] = $resId;
			$newProductRec['wnu_prod_id_r'] = $prodId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					SELECT DISTINCT P2R.p2r_placement
					FROM tbl_prod2reseller P2R
					INNER JOIN tbl_reseller RES ON RES.res_id=P2R.res_id
					INNER JOIN tbl_product PROD ON PROD.prod_id=P2R.prod_id
					WHERE 
						P2R.res_id = :res_id AND PROD.prod_id = :prod_id
				");	
				$stmt->bindValue( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );
				$stmt->execute();		
				return $stmt->fetchAll( \PDO::FETCH_ASSOC );
			}
			return [];
		}
		
		//constructor
		public function __construct ($dbObj, $packId, $ofrId = null) {
			parent::__construct($dbObj, $packId, null);
			if ($packId === null)
				$this->getAll();
			else
				if ( intval( $packId ) > 0 ) {
					$this->getPackage( $packId );
					$this->getPackageInfo( $packId );
				}	
		}
		
	}
}