<?php
namespace App\Prismpay {
	
	require_once "class.variables.php";
	require_once "global.php";

	class prismPay {
		
		private $dbObj = null;
		//private $environmentName = '';
		private $prismAction = 'ns_quicksale_cc'; //recur_add
		private $prismPayID = 'PYYC3';
		private $prismPaySubid = 'LOCAL';
		private $prismPayMerchantPin = PRISMPAY_MERCHANT_PIN;
		
		private $currentTransIP = '';
		private $currentTransAmount = 0;

		private $validForm = false;
		
		//private methods 
		private function checkPrysmpayVariables($aForm, $justReq = true) {
		 $this->validForm = isset($aForm['ccname']) 
			&& isset($aForm['ccnum'])
			&& isset($aForm['expmon'])
			&& isset($aForm['expyear'])
			&& isset($aForm['cvv2'])
			&& isset($aForm['ci_billzip']);
			
			if (!$justReq)
				$this->validForm = $this->validForm && isset($aForm['ci_email'])
				&& isset($aForm["ci_billaddr1"])
				&& isset($aForm["ci_billaddr2"])
				&& isset($aForm["ci_billcity"])
				&& isset($aForm["ci_billcountry"]); 
			return $this->validForm;
		}
		
		private function checkMonthlyBillingVars($aForm) {
			$this->validForm = isset($aForm['recur_billingmax'], $aForm['acctdata2'], $aForm['acctdata1'], $aForm['acctname'], $aForm['accttype']); 
			return $this->validForm;
		}
		
		//protected methods
		protected function setPrismpayIds( $aPrismpayId, $aPrismpaySubId ) {
			if ( strcmp( $aPrismpayId, 'PYYC3' ) === 0 /*or any other allowed id*/ ) {
				$this->prismPayID = $aPrismpayId;
			}
			
			if ( strcmp($aPrismpaySubId, 'LOCAL' ) === 0 /*or any other allowed sub-id*/ ) {
				$this->prismPaySubid = 'LOCAL';
			}
		}
		
		//public methods
		public function processPrysmpay($aForm, $anAmount, $amountFieldName = 'amount') {
			 $response = '';
			 
			 if ( /*We will do this before calling this function, $this->checkPrysmpayVariables($aForm) && */(is_numeric($anAmount) && $anAmount >= 0) || $anAmount === false ) {
			  $this->currentTransAmount = $anAmount;
			   
			  /*Re-do with curl*/
			  $newForm = $aForm;
			  if ($anAmount)
				$newForm[$amountFieldName] = number_format( (float)$anAmount, 2, '.', '' );
			  $newForm['action'] = $this->prismAction;
			  $newForm['acctid'] = $this->prismPayID;
			  $newForm['subid'] = $this->prismPaySubid;
			  $newForm['merchantpin'] = $this->prismPayMerchantPin;
			  $ch = curl_init();
			  curl_setopt( $ch, CURLOPT_POST, 1 );
			  curl_setopt( $ch, CURLOPT_POSTFIELDS, http_build_query($newForm) );
			  curl_setopt( $ch, CURLOPT_URL, 'https://trans.myprismpay.com/cgi-bin/process.cgi' );
			  curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 2 );
			  curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
			  curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
			  $result = curl_exec( $ch );
			  
			  //var_dump($newForm);
			  //var_dump($result);
			  
			  curl_close( $ch );
			  if( $result == '' ) {
				return false;
			  }
			  else {
				  
				$result = array_unique( explode( "\n", trim( strip_tags( $result ) ) ) );
				foreach( $result as $val ) {
					list( $k, $v ) = explode( '=', $val );
					$response[ strtolower( $k ) ] = preg_replace( "/\r|\n/", '', $v );
				}
				
				return $response;
			  }
			}
		}
		
		public function setupMonthlyBilling ($aForm, $anAmount, &$msg) {
			$msg = '';
			
			if ( $this->checkMonthlyBillingVars() ) {
				//setting acction
				$this->prismAction = 'recur_add';
				return $this->processPrysmpay($aForm, $anAmount, 'recur_amount');
			}
			else {
				$msg = 'Missing data';
			}
			
			return false;
		}
		
		public function updateBillingAmount ( $orderId, $anAmount ) {			
			$aForm['orderkeyid'] = $orderId;
			//setting acction
			$this->prismAction = 'recur_update';
			return $this->processPrysmpay( $aForm, $anAmount, 'recur_amount' );
		}
		
		public function cancelBilling ( $orderId, $cancelType = '' ) {
			$aForm['orderkeyid'] = $orderId;
			switch ( $cancelType ) {
				case 1 /* Cancel Next Billing Period */:
					$aForm['canceltype'] = $cancelType;
				break;
				case 2 /* Cancel immediately and add to negative database */: 
					$aForm['canceltype'] = $cancelType;
				break;
				default /* 0 Immediately */:
					$aForm['canceltype'] = 0;
			}	
			//setting acction
			$this->prismAction = 'recur_cancel';
			return $this->processPrysmpay( $aForm, false );
		}
		
		//constructors
		public function __construct($dbObj/*, $globEnvName*/) {
			//$this->environmentName = $globEnvName;
			$this->dbObj = $dbObj;
			$this->currentTransIP = getenv( 'HTTP_CLIENT_IP' ) ? :
			   getenv( 'HTTP_X_FORWARDED_FOR' ) ? :
			   getenv( 'HTTP_X_FORWARDED' ) ? :
			   getenv( 'HTTP_FORWARDED_FOR' ) ? :
			   getenv( 'HTTP_FORWARDED' ) ? :
			   getenv( 'REMOTE_ADDR' );
		}
		
	}
	
}	