<?php
namespace App\Product {
	require_once 'class.variables.php';

	class product {
		
		//private properties
		private $productId = 0;
		
		//protected properties
		protected $dbObj = null;
		protected $belongsToPack = array();
		protected $productRecords = array();
		
		private function getProducts($prodId = null, $ofrId = null) {
			$str = 'WHERE PACK.pk_id IS NULL';
			if ( $prodId !== null ) {
				$str .= ' AND PRD.prod_id = :prodId';
			}
			
			if ($ofrId !== null) {
				$str .= ' AND PRD.ofr_id = :ofrId';
			}
			
			$stmt = $this->dbObj->prepare("
				SELECT PPR.*,PRD.*
				FROM tbl_product PRD
				LEFT JOIN tbl_package PACK ON PACK.pk_id = PRD.prod_id
				LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PRD.prod_id
				{$str}		
			");
			
			if ($prodId !== null) {
				$stmt->bindValue(':prodId', $prodId, \PDO::PARAM_INT);
			}
			
			if ($ofrId !== null) {
				$stmt->bindValue(':ofrId', $ofrId, \PDO::PARAM_INT);
			}
			
			$stmt->execute();
			
			while ( $Result = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				$this->productRecords[$Result['prod_id']] = $Result;
				if (!$productId) {$productId = $Result['prod_id'];}
			}
			return $this->productRecords;
		}
		
		public function getProviders () {
			$str = '';
			
			$stmt = $this->dbObj->prepare("
				SELECT * FROM tbl_prod_offerer
			");
			
			$stmt->execute();
			
			$tmp = array();
			
			while ( $Result = $stmt->fetch(\PDO::FETCH_ASSOC) ) {
				$tmp['Providers'][] = $Result;			
			}
			
			return $tmp['Providers'];
			
		}
		
		protected function validate ( $valRec, &$errors ) {
			$cv= new \_variables( $valRec );
			foreach( $valRec as $name => $value ) $cv->varible_in( $name );
			$clean = $cv->get_cleaned_variables();
			$errors = $cv->get_bad_variables();
			return $clean;
		}
		
		//public functions
		public function getProductOfferers($offererName) {
			$stmt = $this->dbObj->prepare("
				SELECT DISTINCT PRO.prod_id, OFR.*
				FROM tbl_product PRO
				INNER JOIN tbl_prod_offerer OFR ON OFR.ofr_id = PRO.ofr_id
				WHERE OFR.ofr_company LIKE :name OR OFR.ofr_company LIKE :name1 OR OFR.ofr_company LIKE :name2
			");
			
			$stmt->bindValue( ':name', $offererName.'%', \PDO::PARAM_STR );
			$stmt->bindValue( ':name1', '%'.$offererName.'%', \PDO::PARAM_STR );
			$stmt->bindValue( ':name2', '%'.$offererName, \PDO::PARAM_STR );
			
			$stmt->execute(); $resultOfferer = []; $tmpArr = [];
			while ( $Result = $stmt->fetch(\PDO::FETCH_ASSOC) ) {
				$this->productRecords[$Result['prod_id']]['Offerer'] = $Result;
				if (!in_array($Result['ofr_id'], $tmpArr)) {
					array_push($tmpArr, $Result['ofr_id']);
					unset($Result['prod_id']);
					array_push($resultOfferer, $Result);
				}
			}
			
			return $resultOfferer;
			
		}
			
		public function filterProducts ($filterStructObj, $exclusiveCmp = false) {
			$tmpArr = []; $filterStruct = $filterStructObj;
			
			foreach ( $this->productRecords as $id => $v ) {

				$flag=false;

				if ( isset( $filterStruct['prod_active'] ) ) {
					$filterStruct['prod_active'] = (string) $filterStruct['prod_active'];
					
					if ( 
								strcmp ( $filterStruct['prod_active'], '0' ) !== 0
							&&  strcmp ( $filterStruct['prod_active'], '1' ) !== 0
						) {
						unset( $filterStruct['prod_active'] );
					}
				}
				
				if ( isset($v['ofr_id'], $filterStruct['ofr_id']) && !empty($filterStruct['ofr_id']) && strcmp($v['ofr_id'], $filterStruct['ofr_id']) !== 0) {
					$flag = true;
				}

				foreach ( $v as $field => $fVal ) {
					if ( !$flag && isset( $filterStruct[$field] ) && (!empty( $filterStruct[$field] ) || $field == 'prod_active') ) {
						$flag = $exclusiveCmp? strcmp( $fVal , $filterStruct[$field] ) !== 0 : stripos( $fVal , $filterStruct[$field] ) === false;					
					}
				}
				
				if ($flag) {
					array_push($tmpArr, $id);
				}
			}
			
			foreach ($tmpArr as $v) {
				unset($this->productRecords[$v]);
			}
		}
		
		public function createProduct($productRec, &$errorArr) {
			$errorArr = array();		
			$newProductRec['wnu_ofr_id_r'] = isset($productRec['ofr_id'])? $productRec['ofr_id'] : null;
			$newProductRec['txt255_prod_name_r'] = isset($productRec['prod_name'])? $productRec['prod_name'] : null;			
			$newProductRec['txt1024_prod_descript'] = isset($productRec['prod_descript'])? $productRec['prod_descript'] : null;
			$newProductRec['aon64_prod_count_type'] = isset($productRec['prod_count_type'])? $productRec['prod_count_type'] : null;
			
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
				INSERT INTO tbl_product 
					(ofr_id, prod_active, prod_count_type, prod_descript, prod_name) VALUES (:ofr_id,:prod_active, :prod_count_type, :prod_descript, :prod_name)");			
					
				$stmt->bindValue( ':prod_active', isset($productRec['prod_active'])? 1 : 0, \PDO::PARAM_INT );
				$stmt->bindValue( ':prod_count_type', $cleaned['prod_count_type'], \PDO::PARAM_STR );	
				$stmt->bindValue( ':prod_descript', $cleaned['prod_descript'], \PDO::PARAM_STR );
				$stmt->bindValue( ':prod_name', $cleaned['prod_name'], \PDO::PARAM_STR );
				$stmt->bindValue( ':ofr_id', $cleaned['ofr_id'], \PDO::PARAM_INT );
				$stmt->execute();
				return $this->dbObj->lastInsertId();
			
			}
			else {
				$errorArr = array_values($errorArr);
			}
			
			return 0;
		}
		
		public function updateProduct($productRec, &$errorArr) {
			
			$errorArr = array();
			$newProductRec['wnu_prod_id_r'] = isset($productRec['prod_id'])? $productRec['prod_id'] : null;
			$newProductRec['txt255_prod_name_r'] = isset($productRec['prod_name'])? $productRec['prod_name'] : null;
			$newProductRec['txt1024_prod_descript'] = isset($productRec['prod_descript'])? $productRec['prod_descript'] : null;		
			$newProductRec['aon64_prod_count_type'] = isset($productRec['prod_count_type'])? $productRec['prod_count_type'] : null;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					UPDATE tbl_product 
					SET prod_active = :prod_active, 
						prod_count_type = :prod_count_type,
						prod_descript = :prod_descript, 
						prod_name = :prod_name 
					WHERE prod_id = :prod_id
				");
				
				$stmt->bindValue( ':prod_active', isset($productRec['prod_active'])? 1 : 0, \PDO::PARAM_INT );
				$stmt->bindValue( ':prod_count_type', empty($cleaned['prod_count_type'])? null: $cleaned['prod_count_type'], \PDO::PARAM_STR );			
				$stmt->bindValue( ':prod_descript', empty($cleaned['prod_descript'])?null:$cleaned['prod_descript'], \PDO::PARAM_STR );
				$stmt->bindValue( ':prod_name', $cleaned['prod_name'], \PDO::PARAM_STR );
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );
				
				$stmt->execute(); $resultOfferer = []; $tmpArr = [];
				
				return true;
				
			}
			else {
				$errorArr = array_values($errorArr);
			}
			
			return false;
			
		}
		
		public function changeProvider($prodId, $ofrId, &$errorArr) {
			$errorArr = array();
			$newProductRec['wnu_prod_id_r'] = $prodId;
			$newProductRec['wnu_ofr_id_r'] = $ofrId;		
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					UPDATE tbl_product 
						SET ofr_id = :ofr_id
					WHERE prod_id = :prod_id
				");
				
				$stmt->bindValue( ':ofr_id', $cleaned['ofr_id'], \PDO::PARAM_STR );
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_STR );
				$stmt->execute();
				
				return true;	
			}
			else {
				$errorArr = array_values($errorArr);
			}
			return false;
		}
		
		public function getTableRowsOutput () {
			$results = '';
			foreach ( $this->productRecords as $id => $v ) {
				$results .= '<tr>';
				$results .=   '<td>'.$v['prod_id'].'</td>';			
				$results .=   '<td>'.$v['prod_name'].'</td>';
				$results .=   '<td>'.$v['prod_descript'].'</td>';
				$results .=   '<td>'.$v['prod_keyword'] . '</td>';
				$results .=   '<td>'.$v['prod_count_type'].'</td>';			
				$results .=   '<td>'.(strcmp($v['prod_active'], '1') === 0? 'Yes':'No').'</td>';			
				$results .=   '<td>
								<div style="min-width:120px;" class="btn-group btn-group-xs" role="group" aria-label="...">
									<button title="Product Edit" aria-label="..." type="button" class="btn btn-info triggerEdit" data-toggle="modal" data-target="#globalModal" data-id="'.$v['prod_id'].'"><span class="glyphicon glyphicon-pencil"></span></button>
									<button title="Change Product Provider" aria-label="..." type="button" class="btn btn-default triggerOfferer" data-toggle="modal" data-id = "' . $v['prod_id'] . '" data-ofr_id = "'.$v['ofr_id'].'" data-id="'.$v['prod_id'].'" data-target="#globalModal"><span class="glyphicon glyphicon-check"></span></button>
									<button title="Products Prices" aria-label="..." type="button" class="btn btn-primary triggerPrice" data-toggle="modal" data-id="'.$v['prod_id'].'" data-target="#globalModal"><span class="glyphicon glyphicon-usd"></span></button>								
								</div>	
							   </td>';
				$results .= '</tr>';
			}
			return $results;
		}
		
		public function getPrices( $prodId ) {
			$errorArr = array();
			$newProductRec['wnu_prod_id_r'] = $prodId;		
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			$this->productRecords[$prodId]['Prices'] = array();
			if ( count( $errorArr ) === 0 ) {				
				$stmt = $this->dbObj->prepare("
					SELECT * FROM tbl_prod_price WHERE prod_id=:prod_id
				");
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );
				$stmt->execute();
				
				while ( $Result = $stmt->fetch(\PDO::FETCH_ASSOC) ) {
					$this->productRecords[$cleaned['prod_id']]['Prices'][] = $Result;			
				}
			}
			return $this->productRecords[$prodId]['Prices'];
		}
		
		public function deletePrice( $priceId ) {
			$errorArr = array(); 
			$newProductRec['wnu_ppr_id_r'] = $priceId;		
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {			
				$stmt = $this->dbObj->prepare("
					SELECT * FROM tbl_prod2trans WHERE ppr_id=:ppr_id
				");
				$stmt->bindValue(':ppr_id', $cleaned['ppr_id'], \PDO::PARAM_INT);
				$stmt->execute();
				if ( $Result = $stmt->fetch(\PDO::FETCH_ASSOC) ) {
					
					//the price cannot be deleted it has been added to a cart
					
				}
				else {				
					$stmt = $this->dbObj->prepare("
						DELETE FROM tbl_prod_price WHERE ppr_id=:ppr_id
					");
					$stmt->bindValue( ':ppr_id', $cleaned['ppr_id'], \PDO::PARAM_INT );
					$stmt->execute();
					return true;
				}
			}
			
			return false;
		}
		
		public function addPrice( $priceRec, $prodId, &$errorArr ) {
			$errorArr = array();
			$newProductRec['wnu_prod_id_r'] = $prodId;
			$newProductRec['dec_ppr_price'] = isset($priceRec['ppr_price'])? $priceRec['ppr_price']:null;
			$newProductRec['dec_ppr_setup'] = isset($priceRec['ppr_setup'])? $priceRec['ppr_setup']:null;
			
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				
				$stmt = $this->dbObj->prepare("
					SELECT * FROM tbl_prod_price WHERE prod_id=:prod_id AND ppr_price = :ppr_price AND ppr_setup = :ppr_setup
				");
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':ppr_price', $cleaned['ppr_price'], \PDO::PARAM_STR );
				$stmt->bindValue( ':ppr_setup', $cleaned['ppr_setup'], \PDO::PARAM_STR );
				$stmt->execute();
				
				if ( $row = $stmt->fetch(\PDO::FETCH_ASSOC) ) {
					$stmt = $this->dbObj->prepare("
						UPDATE tbl_prod_price SET ppr_current_price = 0 WHERE prod_id=:prod_id;
						UPDATE tbl_prod_price SET ppr_current_price = 1 WHERE prod_id=:prod_id AND ppr_price = :ppr_price AND ppr_setup = :ppr_setup AND ppr_price_delay = :ppr_price_delay AND ppr_setup_delay = :ppr_setup_delay;
					");
					$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );
					$stmt->bindValue( ':ppr_price', $cleaned['ppr_price'], \PDO::PARAM_STR );
					$stmt->bindValue( ':ppr_setup', $cleaned['ppr_setup'], \PDO::PARAM_STR );
					$stmt->execute();
				}
				else {
					$stmt = $this->dbObj->prepare("
						INSERT INTO tbl_prod_price (prod_id, ppr_price, ppr_setup) VALUES (:prod_id, :ppr_price, :ppr_setup)
					");
					$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );
					$stmt->bindValue( ':ppr_price', $cleaned['ppr_price'], \PDO::PARAM_STR );
					$stmt->bindValue( ':ppr_setup', $cleaned['ppr_setup'], \PDO::PARAM_STR );
					$stmt->execute();
					
					if ($this->dbObj->lastInsertId()) {
						$stmt = $this->dbObj->prepare("
							UPDATE tbl_prod_price SET ppr_current_price = 0 WHERE prod_id = :prod_id AND ppr_id <> :ppr_id
						");
						$stmt->bindValue(':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT);
						$stmt->bindValue(':ppr_id', $this->dbObj->lastInsertId(), \PDO::PARAM_INT);								
						$stmt->execute();
					}
				}
				return true;
			}
			else {
				$errorArr = array_values($errorArr);
			}
			
			return false;
		}
		
		public function getRecords() {
			return $this->productRecords;
		}
		
		public function getCurrentId() {
			return $this->productId;
		}
		
		//constructor
		public function __construct ($dbObj, $prodId = null, $ofrId = null) {
			$this->dbObj = $dbObj;
			$this->getProducts($prodId, $ofrId);
		}
	}
}
?>