<?php

namespace App\MemberMerchant\Promo{

	class MerchantPromo{

		// Private Properties		

		private $pDbo=null;		

		//Private Methods 
		private function sizePromoByCount($total, $current){
		  	switch (true) {
		  		case $total == 1:
		  				return 'col-md-12';
		  			break;
		  		case $total ==  2:
		  		case $total ==  4:
		  				return 'col-md-6';
		  			break;
		  		case $total == 3:
		  		case $total == 6:
		  				return 'col-md-4';
		  			break;
		  		case $total == 5:
		  			switch (true) {
		  				case $current <= 2:
		  						return 'col-md-6';
		  					break;
		  				
		  				default:
		  						return 'col-md-4';
		  					break;
		  			}
		  			break;
		  		case $total == 7:
		  			switch (true) {
		  				case $current <= 3:
		  						return 'col-md-4';
		  					break;
		  				
		  				default:
		  						return 'col-md-3';
		  					break;
		  			}
		  			break;
		  		default:
		  				return 'col-md-3';
		  			break;
		  	}
		}
		
		protected function countAsPunchCard ($promoId, $userId) {
			if (isset($this->promoRecords[$this->currentPromoId]['CountAsPunch']))
				return $this->promoRecords[$this->currentPromoId]['CountAsPunch'];
			elseif (is_numeric($userId) && intval($userId) > 0) {
				$stmt = $this->pDbo->prepare("

				SELECT (CASE WHEN PRD.dpc_active OR (NOT PRD.dpc_active AND PHY.dph_task = 'redeem') THEN 1 ELSE 0 END) AS CountASPunch
				FROM tbl_consumer CSM
				INNER JOIN tbl_punch_history PHY ON CSM.csm_id = PHY.csm_id 
				INNER JOIN tbl_punch_card PRD ON PRD.dpc_id = PHY.dpc_id
				INNER JOIN lt_merchants MER ON PRD.ltm_id = MER.ltm_id				
				INNER JOIN lt_member_merchants MMR ON MMR.ltb_id = MER.ltb_id
				INNER JOIN lt_promos PRO ON MMR.ltb_id = PRO.ltb_id				
				WHERE CSM.csm_id = :csmId AND PRO.ltp_id = :promoId AND PRO.ltp_punchcard
				ORDER BY PHY.dph_id LIMIT 1");

				$stmt->bindValue(':csmId', intval($userId), \PDO::PARAM_INT);
				$stmt->bindValue(':promoId', intval($promoId), \PDO::PARAM_INT);

				$stmt->execute();
				
				$tmp = $stmt->fetch(\PDO::FETCH_ASSOC);
				
				$this->promoRecords[$this->currentPromoId]['CountAsPunch'] = isset($tmp['CountASPunch']) && $tmp['CountASPunch'] == 1;
				return $this->promoRecords[$this->currentPromoId]['CountAsPunch'];				
			}
			
			
			
			return false;
		}
		
		//Protected Methods
		protected function markView(  ) {
			 //$this->currentPromoId
			
			if (isset($_SESSION['user']['consumer']['csm_id'])) {				
				$stmt = $this->pDbo->prepare("
				UPDATE lt_promo_tracking SET lpk_views = lpk_views + 1 WHERE ltp_id=:ltp_id AND csm_id=:csm_id AND lpk_date = DATE(NOW())");
				$stmt->bindValue(':ltp_id', $this->currentPromoId, \PDO::PARAM_INT);
				$stmt->bindValue(':csm_id', $_SESSION['user']['consumer']['csm_id'], \PDO::PARAM_INT);
				$stmt->execute();
				
				if (!$stmt->rowCount()) {
					
					$stmt = $this->pDbo->prepare("
					INSERT INTO lt_promo_tracking (lpk_views, ltp_id, csm_id, lpk_date) VALUES (1, :ltp_id, :csm_id, DATE(NOW()))");
					$stmt->bindValue(':ltp_id', $this->currentPromoId, \PDO::PARAM_INT);
					$stmt->bindValue(':csm_id', $_SESSION['user']['consumer']['csm_id'], \PDO::PARAM_INT);
					$stmt->execute();
				}
			
			}
			 
		}
		
		protected function getCrossPromoData() {

			$stmt = $this->pDbo->prepare("

			SELECT LTB.ltb_slug, LTB.ltb_id, LTM.ltm_company_name, LTB.ltb_header_image 

			FROM lt_merchants LTM 

			INNER JOIN lt_cross_promotions CPR ON LTM.ltm_id = CPR.ltm_id 

			INNER JOIN lt_member_merchants LTB ON LTM.ltb_id = LTB.ltb_id 

			WHERE CPR.ltp_id=:ltp_id LIMIT 1");

			$stmt->bindValue(':ltp_id', $this->currentPromoId, \PDO::PARAM_STR);

			$stmt->execute();

			return $stmt->fetchAll(\PDO::FETCH_ASSOC);

		}		

		
		// Public Properties

		public $promoRecords=array();

		public $currentPromoId=0;

		

		// Public Methods

		function loadRecords( $anId, $fieldName = 'ltb_id', $tableName = 'MMC', $orderBy = 'default' ) {
				
				switch ($orderBy) {
					case 'random':
						$oBy = 'ORDER BY RAND()';						
					break;
					case 'activeDesc':
						$oBy = 'ORDER BY PRM.ltp_active DESC';
					break;
					default:
						$oBy = 'ORDER BY PRM.ltp_id';
				}
			
				$stmt = $this->pDbo->prepare("

				SELECT DISTINCT PRM.*, PRT.*, MRC.ltm_company_name, MRC.ltm_city, (CASE WHEN ((CURDATE() <= PRM.ltp_enddate AND CURDATE() >= PRM.ltp_startdate) OR (PRM.ltp_enddate IS NULL AND PRM.ltp_startdate IS NULL)) THEN 1 ELSE 0 END) AS ltp_active_by_date 

				FROM lt_member_merchants MMC

				INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id

				LEFT JOIN lt_promos PRM ON PRM.ltb_id=MMC.ltb_id	

				LEFT JOIN lt_promo_types PRT ON PRM.ltp_promo_type=PRT.lpt_id			

				WHERE {$tableName}.{$fieldName}=:Id
				
				{$oBy}");

				$stmt->bindValue( ":Id", $anId, \PDO::PARAM_INT );

				$stmt->execute();

				while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {

					$this->promoRecords[$resultSet['ltp_id']] = $resultSet;
					
				}
				
				return $this->promoRecords;

		}

		

		function findImageURL ($localEnv, $merchantDir, &$crossPromoMerchId) {

			$crossPromoMerchId = 0;

			if (isset($this->promoRecords[$this->currentPromoId]['ltp_image']) && $this->promoRecords[$this->currentPromoId]['ltp_image'] !== '' /*&& $this->promoRecords[$this->currentPromoId]['ltp_promo_type'] != 5*/){
				
				if ($this->promoRecords[$this->currentPromoId]['ltp_promo_type'] == 5) {					

					$qry2 = $this->getCrossPromoData();

					$crossPromoMerchId = isset($qry2[0]['ltb_id'])? $qry2[0]['ltb_id']: 0;
					
				}
				
				$check_img = explode('_', $this->promoRecords[$this->currentPromoId]['ltp_image']);

				$check_img = $check_img[0];

				if ($check_img == 'unv'){

					$img_type = 'library';

					$img_dir = 'https://localthanks.'.$localEnv.'/images/promo_library/'.$this->promoRecords[$this->currentPromoId]['ltp_image'];

				} else {

					$img_type = 'gallery';

					$img_dir = 'https://localthanks.'.$localEnv.'/merchant-custom-files/' . $merchantDir . '/_files/img/p_600x400_'.$this->promoRecords[$this->currentPromoId]['ltp_image'];

				}

			} else {

				switch ($this->promoRecords[$this->currentPromoId]['ltp_promo_type']) {

					case 5:

						$img_type = 'cross_promotion';						

						$qry2 = $this->getCrossPromoData();						

						$crossPromoMerchId = isset($qry2[0]['ltb_id'])? $qry2[0]['ltb_id']: 0;
						
						/*Old cross promo location treated as a merchant image*/
						//$img_dir = 'http'.($localEnv == 'com'? 's':'').'://localthanks.'.$localEnv.'/merchant-custom-files/{%%CrossPromoMerchant%%}/_files/img/h_250w_' . (is_null($qry2[0]['ltb_header_image']) ? 'header.png' : $qry2[0]['ltb_header_image']);
						
						/*New cross promo location treated as any other promo*/
						$img_dir = 'https://localthanks.'.$localEnv.'/images/promo_defaults/promo-default_'.$this->promoRecords[$this->currentPromoId]['ltp_promo_type'].'.jpg';

						break;

					default:

						$img_type = 'default';						

						$img_dir = 'https://localthanks.'.$localEnv.'/images/promo_defaults/promo-default_'.$this->promoRecords[$this->currentPromoId]['ltp_promo_type'].'.jpg';

						break;

				}

			}

			return $img_dir;

		}

		function buildPromoLayOut($imgURL, $userId, $total, $current, $onClick = '', $linkHref = 'javascript:void(0);', $locationLinkArr = array('Millage' => 0, 'From'=>array('lat'=>0.00000, 'lng'=>0.00000), 'To'=>array('lat'=>0.00000, 'lng'=>0.00000))) {

			//echo $onClick;

			$echo_var = '';

			$promo_link = '<a href="'.(isset($crossPromo[0]['ltb_slug'])? '/' . $crossPromo[0]['ltb_slug'] : $linkHref).'">';

			if ( isset( $this->promoRecords[$this->currentPromoId] ) ) {								
								
				if ($this->isCurrentActive() && $this->getCurrent('ltp_enddate') != null) { 					
					$year = date('Y', strtotime($this->getCurrent('ltp_enddate')));					
					$d = ' use by ' . date('M d', strtotime($this->getCurrent('ltp_enddate'))) . ($year <> date('Y')? ' ' . $year: '');					
					$useByDate = '<img style="margin-right: 1px;" width="16" src="/localthanks/images/icon_date_range.svg"/> ' . $d;
				}
				
				$echo_var .= '<div class="col-xs-12 col-sm-6 '.$this->sizePromoByCount($total, $current).'"><div class="promo_wrap">';

				if ($this->promoRecords[$this->currentPromoId]['ltp_promo_type'] == 5) 

					$crossPromo = $this->getCrossPromoData();
				
				$screcialNotScratchedFlag = false;
				
				if ($this->promoRecords[$this->currentPromoId]['ltp_promo_type'] == 6 && !$this->wasScrecialScratched($userId) ){ // screcial
					$screcialNotScratchedFlag = true;
					$echo_var .= '<div class="promo_image" style="background: url(/plugins/screcials/scratchoffs/screcial600x400.gif) center center no-repeat; background-size: cover;" id="prom_' . $this->promoRecords[$this->currentPromoId]['ltp_id'] . '">
						'.$promo_link.'<img src="/images/trans_3x2.gif" alt="Local Thanks Placeholder Image" class="img-responsive"></a>
					</div>';

				} else {					

					$echo_var .= '<div class="promo_image" style="background: url(' . $imgURL . ') top center no-repeat #ffffff; background-size: ' . ($this->promoRecords[$this->currentPromoId]['ltp_promo_type'] == 5 ? 'contain':'cover').';"' . (empty($onClick)? '' : ' onclick="'.$onClick.'"') . ' id="prom_' . $this->promoRecords[$this->currentPromoId]['ltp_id'] . '">
								'.$promo_link.'<img src="/images/trans_3x2.gif" alt="Local Thanks Placeholder Image" class="img-responsive"></a>
								</div>';

				}
					
				$echo_var .= '
								<div class="promo_details">
									<div class="promo_headline">'.$promo_link.($screcialNotScratchedFlag? 'Click then Scratch Off To Reveal':$this->promoRecords[$this->currentPromoId]['ltp_headline']).'</a></div>
									<div class="promo_use_by">
										' . (isset($useByDate) ? $useByDate : '') . '
									</div>
									<div class="promo_punchcard">
										'.($this->countAsPunchCard ($this->currentPromoId, $userId)? '<img width="15" height="15" alt="Punch Card Icon" src="/localthanks/images/icon-punchcard.svg"/> Count as a punch' : '').'
									</div>
									<div class="promo_merchant">
										'.$this->promoRecords[$this->currentPromoId]['ltm_company_name'].'
									</div>
									<a target="_blank" href="https://www.google.com/maps?f=d&source=s_d&saddr=@'.$locationLinkArr['From']['lat'].','.$locationLinkArr['From']['lng'].'&daddr=@'.$locationLinkArr['To']['lat'].','.$locationLinkArr['To']['lng'].'">
										<div class="promo_city">
											<span class="glyphicon glyphicon-globe"></span> '.ucwords($this->promoRecords[$this->currentPromoId]['ltm_city']).', '.$locationLinkArr['Millage'].' mi
										</div>
									</a>
									<div class="promo_price">
										'.($this->promoRecords[$this->currentPromoId]['ltp_price'] == 0 ? '': '<span class="promo_dollar_sign">$</span>'. str_replace('.00', '', $this->promoRecords[$this->currentPromoId]['ltp_price'])).'
									</div>	
								</div>
							</div>
						</div>';
			}	

			return $echo_var;

		}

		

		

		function getCurrent($promoField) {

			if ( isset($this->promoRecords[$this->currentPromoId][$promoField]) && $this->promoRecords[$this->currentPromoId][$promoField] !== null ) {

				return $this->promoRecords[$this->currentPromoId][$promoField];

			}			

			return '';

		}

		

		function findPromo($promoSlug) {

			reset($this->promoRecords);

			$currentVal = current($this->promoRecords);

			$stopFlag = true;

			while ($currentVal && $stopFlag){

				if ($currentVal['ltp_slug'] == $promoSlug) {					

					$stopFlag = false;

				}

				else{

					$currentVal = next($this->promoRecords);

				}	

			}

			if (!$stopFlag)				
				return $currentVal;
			return array();

		}

		

		function isCurrentScercial($setCurrent=null) {

			if ($setCurrent!==null) $this->currentPromoId = $setCurrent;			

			return isset($this->promoRecords[$this->currentPromoId]['ltp_promo_type']) && $this->promoRecords[$this->currentPromoId]['ltp_promo_type'] == '6';

		}

		function isCurrentRedeemable($setCurrent = null) {

			if ($setCurrent!==null) $this->currentPromoId = $setCurrent;			

			return $this->promoRecords[$this->currentPromoId]['ltp_max_redemptions_global'][0] === null || $this->promoRecords[$this->currentPromoId]['ltp_max_redemptions_global'][0] > 0;

		}

		function wasScrecialScratched($userId, $setCurrent=null) {

			if ($setCurrent!==null) $this->currentPromoId = $setCurrent;

			if ( $this->isCurrentScercial() && !isset($this->promoRecords[$this->currentPromoId]['Scratched'][$userId]) ) {

				$stmt = $this->pDbo->prepare("

				SELECT count(PTR.lpk_id) AS SC_Amount

				FROM lt_promo_tracking PTR

				INNER JOIN lt_promos PRM ON PRM.ltp_id=PTR.ltp_id

				INNER JOIN tbl_consumer CSM ON CSM.csm_id=PTR.csm_id

				WHERE PTR.lpk_scratched = 1 AND PRM.ltp_promo_type = 6 AND CSM.csm_id=:csmid AND PRM.ltp_id=:ltpid");

				$stmt->bindValue(":csmid", $userId, \PDO::PARAM_INT);

				$stmt->bindValue(":ltpid", $this->currentPromoId, \PDO::PARAM_INT);

				$stmt->execute();

				if ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {

					$this->promoRecords[$this->currentPromoId]['Scratched'][$userId] = intval( $resultSet['SC_Amount'] ) > 0? true: false;

				}				

			}

			return isset($this->promoRecords[$this->currentPromoId]['Scratched'][$userId]) && $this->promoRecords[$this->currentPromoId]['Scratched'][$userId];

		}

		

		function isCurrentActive($setCurrent=null) {

			if ($setCurrent!==null) $this->currentPromoId = $setCurrent;

			return isset($this->promoRecords[$this->currentPromoId]) && $this->promoRecords[$this->currentPromoId]['ltp_active'] == '1' && ($this->promoRecords[$this->currentPromoId]['ltp_active_by_date'] == '1');

		}

		

		function __construct( $dbObj, $ltpId = null, $loadRandom = 'default', $markView = false ) {

			$this->pDbo=$dbObj;

			if ( $ltpId !== null && is_numeric($ltpId) && $ltpId > 0) {

				$ltpIdOk = (int) $ltpId;

				$this->loadRecords( $ltpIdOk, $fieldName = 'ltp_id', $tableName = 'PRM', $loadRandom ); 				
				
				if ( isset($this->promoRecords[$ltpIdOk])) {
					
					$this->currentPromoId = $ltpIdOk;
					
					if ($markView) {
						$this->markView();
					}
				}

			}

		}

		

	}

}

?>