<?php
namespace App\MemberMerchant\Store\PunchCard {
	
	class punchCard {

		// Private Properties
		private $pcDbo=null;
		
		//protected properties
		protected $currentPunchCardId = 0;
		
		//public properties
		public $punchCardRecords = array();
				
		//private functions
		private function getSubDir ($anInt) {
			$_i = 0; $subId = substr( $anInt, $_i, 2 ); $Result = '';
			do {
				$Result.= ( $Result === ''? '': '/' ) . $subId;
				$_i+=2;
				$subId = substr( $anInt, $_i, 2 );
			}
			while ( $subId != '' );
			return $Result; 
		}		
		
		private function getPunchCardsInTheArea(&$htmlLayOut, &$foundAnyData, $foundPunchCardIds = '0'){			
			if ( !isset($htmlLayOut) || empty($htmlLayOut) ) $htmlLayOut = '';
			
			$stmt = $this->pcDbo->prepare("
			SELECT PRD.*, MMR.ltb_id, MMR.ltb_slug, MMR.ltb_header_image, MER.ltm_company_name
			FROM tbl_punch_card PRD
			INNER JOIN lt_merchants MER ON PRD.ltm_id = MER.ltm_id
			INNER JOIN lt_member_merchants MMR ON MMR.ltb_id = MER.ltb_id	
			WHERE MMR.ltb_active AND MER.ltm_active AND PRD.dpc_active AND PRD.dpc_id NOT IN ({$foundPunchCardIds})
			ORDER BY POW(POW((:customerlat-MER.ltm_lat),2)+(POW((:customerlong-MER.ltm_long),2)),(1/2)) LIMIT 5");
				
			$stmt->bindValue(":customerlat", $_SESSION['user']['consumer']['csm_lat'], \PDO::PARAM_STR);	
			$stmt->bindValue(":customerlong", $_SESSION['user']['consumer']['csm_long'], \PDO::PARAM_STR);
			$stmt->execute();
			$this->punchCardRecords['Area-Punch-Card'] = array(); $anyData= false;
			
			$htmlLayOut .= '<div class="punch-card-list-wrap">';
			while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				
				if (!empty($resultSet['ltb_slug'])) {
					
										
					if (!$anyData) {
						$htmlLayOut .= '<div class="punch-card-div-bar">AVAILABLE PUNCH CARDS IN YOUR AREA</div>';
						$anyData = true;
						$foundAnyData = true;
					}
					
					$enterHTML = !isset($this->punchCardRecords['Area-Punch-Card'][$resultSet['ltm_id']]);
					$htmlLayOut .= $enterHTML?'<div class="punch-card-inner-wrap"><div class="card-row"><div class="card-col-2"><a href="/'.$resultSet['ltb_slug'].'"><img alt="' . $resultSet['ltb_slug'] . '" src="' . (empty($resultSet['ltb_header_image'])? '/merchant-custom-files/1/_files/img/h_250w_header.png' : '/merchant-custom-files/'.$this->getSubDir($resultSet['ltb_id']).'/_files/img/h_250w_' . $resultSet['ltb_header_image'] ) . '" class="img-responsive"/></a></div><div class="card-col-10"><div class="row"><div class="col-sm-7"><strong><h4 class="punch_card_mname">'.$resultSet['ltm_company_name'] .'</h4></strong><strong><h4 class="punch_card_title">'.$resultSet['dpc_header'].'</h4></strong></div><div class="col-sm-5"><div class="card-row"> <div class="card-col-btn"><a href="/'.$resultSet['ltb_slug'].'/punch-card"><div class="get-punch-card-btn">GET PUNCH CARD</div></a></div> </div></div></div></div>':'';
					
					
					if (!isset($this->punchCardRecords['Area-Punch-Card'][$resultSet['ltm_id']][$resultSet['dpc_id']]) ) $this->punchCardRecords['Area-Punch-Card'][$resultSet['ltm_id']][$resultSet['dpc_id']] = array();				
					array_push($this->punchCardRecords['Area-Punch-Card'][$resultSet['ltm_id']][$resultSet['dpc_id']], $resultSet);
					
					$htmlLayOut .= $enterHTML? '</div></div>' : '';				
				}
			}	
			$htmlLayOut .= '</div>';			
		}
		
		private function getLayout ($consumerId, $resultSet, &$unviewedHistory, &$htmlLayOut, &$foundAnyData, &$foundPunchCardsCount) {
			if ( $resultSet['dph_task'] == 'subscribe' || $resultSet['dph_task'] == 'redeem' || !isset($foundPunchCardsCount[$resultSet['dpc_id']]['Amount']) ) {
				$foundPunchCardsCount[$resultSet['dpc_id']]['Amount'] = 0;
				$foundPunchCardsCount[$resultSet['dpc_id']]['Total_Amount'] = intval($resultSet['dpc_required_punches']);
			}
			elseif ( $resultSet['dph_task'] == 'punch' ) $foundPunchCardsCount[$resultSet['dpc_id']]['Amount']++;
								
			if (!$foundAnyData) {
				$htmlLayOut .= '<div class="punch-card-div-bar">MY DIGITAL PUNCH CARDS</div>';
				$foundAnyData = true;
			}
			
			$enterHTML = !isset($this->punchCardRecords['Consumers-Punch-Card'][$consumerId][$resultSet['ltm_id']]);
			$htmlLayOut .= $enterHTML?'
				<div class="punch-card-inner-wrap">
					<div class="card-row">
						<div class="card-col-2">
							<a href="/'.$resultSet['ltb_slug'].'">
								<img alt="' . $resultSet['ltb_slug'] . '" src="' . (empty($resultSet['ltb_header_image'])? '/merchant-custom-files/1/_files/img/h_250w_header.png' : '/merchant-custom-files/'.$this->getSubDir($resultSet['ltb_id']).'/_files/img/h_250w_' . $resultSet['ltb_header_image'] ) . '" class="img-responsive"/>
							</a>
						</div>
						<div class="card-col-10">
							<div class="row">
								
								<div class="col-sm-7">
									<strong><h4 class="punch_card_mname">'.$resultSet['ltm_company_name'] .'</h4></strong>
									<strong><h4 class="punch_card_title">'.$resultSet['dpc_header'].'</h4></strong>
								</div>
								<div class="col-sm-5">
									<div class="card-row">
										<div class="card-col-btn-punches">
											<div class="punches-of-totalpunches-Replace-Class-Str_'.$resultSet['dpc_id'].'">'.'ReplaceStr_'.$resultSet['dpc_id'].'<span> OF </span>'.$resultSet['dpc_required_punches'].'</div>
										</div>
										<div class="card-col-btn">
											<a href="/'.$resultSet['ltb_slug'].'/punch-card">
												<div class="get-punch-card-btn">VIEW PUNCH CARD</div>
											</a>
										</div>
									</div>
								</div>
							</div>
						</div>':'';
			
			if ( $resultSet['dph_viewed'] == '0' ) $unviewedHistory++;
			if (!isset($this->punchCardRecords['Consumers-Punch-Card'][$consumerId][$resultSet['ltm_id']][$resultSet['dpc_id']]) ) $this->punchCardRecords['Consumers-Punch-Card'][$resultSet['csm_id']][$resultSet['ltm_id']][$resultSet['dpc_id']] = array();				
			array_push($this->punchCardRecords['Consumers-Punch-Card'][$consumerId][$resultSet['ltm_id']][$resultSet['dpc_id']], $resultSet);
			
			$htmlLayOut .= $enterHTML? '</div></div>' : '';
		}
		
		private function getConsumerPunchCards($consumerId, &$unviewedHistory, &$htmlLayOut, &$foundAnyData) {			
		    $foundAnyData = false;
			$stmt = $this->pcDbo->prepare("
			SELECT PRD.*, PHY.*, MMR.ltb_id, MMR.ltb_slug, MMR.ltb_header_image, MER.ltm_company_name
			FROM tbl_consumer CSM
			INNER JOIN tbl_punch_history PHY ON CSM.csm_id = PHY.csm_id 
			INNER JOIN tbl_punch_card PRD ON PRD.dpc_id = PHY.dpc_id
			INNER JOIN lt_merchants MER ON PRD.ltm_id = MER.ltm_id
			INNER JOIN lt_member_merchants MMR ON MMR.ltb_id = MER.ltb_id
			
			WHERE MMR.ltb_active AND MER.ltm_active AND CSM.csm_id = :csmId
			ORDER BY PHY.csm_id, PRD.dpc_id, PHY.dph_id");		
			$stmt->bindValue(":csmId", $consumerId, \PDO::PARAM_INT);
			$stmt->execute();
	
			$this->punchCardRecords['Consumers-Punch-Card'][$consumerId] = array();
			$unviewedHistory = 0;
			$htmlLayOut = '<div class="punch-card-list-wrap">'; $foundPunchCards = array('0'); $foundPunchCardsCount = array(); $notActiveCards = array();
			while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {				
				if (!in_array($resultSet['dpc_id'], $foundPunchCards)) array_push($foundPunchCards, $resultSet['dpc_id']);
				if (!empty($resultSet['ltb_slug'])) {
					if ($resultSet['dpc_active'] == 1)	
						$this->getLayout($consumerId, $resultSet, $unviewedHistory, $htmlLayOut, $foundAnyData, $foundPunchCardsCount);
					else {
						$notActiveCards[$resultSet['dpc_id']] = $resultSet;						
					}
				}
			}
				
			foreach ($notActiveCards as $k=>$v) {
				if ($v['dph_task'] != 'redeem')
					$this->getLayout($consumerId, $v, $unviewedHistory, $htmlLayOut, $foundAnyData, $foundPunchCardsCount);
			}
			
			foreach ($foundPunchCardsCount as $id => $amountArr) {
	
				if ($amountArr['Total_Amount'] == $amountArr['Amount']) 
					$htmlLayOut = str_replace( '-Replace-Class-Str_'. $id, ' punch-card-ready-to-redeem', $htmlLayOut );
				else
					$htmlLayOut = str_replace( '-Replace-Class-Str_'. $id, '', $htmlLayOut );				
				$htmlLayOut = str_replace( 'ReplaceStr_'. $id, $amountArr['Amount'], $htmlLayOut );				
			}
			
			$foundPunchCards = implode(',', $foundPunchCards);
			
			$this->getPunchCardsInTheArea($htmlLayOut, $foundAnyData, $foundPunchCards);
			
			$htmlLayOut .= '</div>';
			
			return $this->punchCardRecords['Consumers-Punch-Card'][$consumerId];
		}
		
		public function resetHistory($consumerId) {
			if (is_numeric($consumerId) && intval($consumerId) > 0) {
				$consumerIdOk = intval($consumerId);
				$stmt = $this->pcDbo->prepare("
				UPDATE tbl_punch_history 
				SET dph_viewed = 1
				WHERE csm_id = :csmId");		
				$stmt->bindValue(":csmId", $consumerIdOk, \PDO::PARAM_INT);
				$stmt->execute();
			}	
		}
		
		function __construct( $dbObj, $punchCardId=null, $csmId=null, $ltmId=null, &$consumerStats) {
			$this->pcDbo = $dbObj;
			$consumerStats = array();
			if ( $csmId !== null && is_numeric($csmId) && intval($csmId) > 0 ) {
				$this->getConsumerPunchCards(intval($csmId), $consumerStats['UnviewedCount'], $consumerStats['HTMLLayOut'], $consumerStats['foundAnyPunchCard']);
			}
		}
		
	}

}	

?>