<?php
namespace App\Search {	
	require_once "class.variables.php"; //no sure we need it
	require_once "class.member-merchant.php";
	use App\MemberMerchant as Merchant;
	class LocalSearch {
		//private properties
		private $searchLimit = 10;
		private $searchOffset = 0;
		private $maxLoad = 100;
		private $sDbo;
		//public properties
		public $searchReturn = array();		
		public $validParamsArr = array();
		public $prevResults = false;
		public $nextResults = false;
		public $googleIds = '';
		//private functions
		private function validData( &$cleanData, $fieldsArr ){
			$cv= new \_variables($fieldsArr); // new instance
			$cv_array=array_keys($fieldsArr); //list all varibles to be check in array
			foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
			$clean=$cv->get_cleaned_variables();
			$errors=$cv->get_bad_variables();			
			if (!count($errors)) {
				$cleanData = $clean;
				return true;								
			}			
			return false;
		}
		
		private function setSession($sessionField, $value){
			if ($sessionField === 'csm_lat' || $sessionField === 'csm_long') {
				$_SESSION['geo_location'][$sessionField]=$value;
			}
			$_SESSION['user']['consumer'][$sessionField]=$value;
		}
		
		private function merchantSearch(  ) {
			$sqlJoin = \NEW_DB_SWITCH?"
				INNER JOIN tbl_package PACK ON MMC.pk_id = PACK.pk_id
				INNER JOIN tbl_product PROD ON PACK.pk_id = PROD.prod_id
			": "
				INNER JOIN lt_plan_type AS PTY ON MMC.pty_id = PTY.pty_id
				INNER JOIN lt_merchant_plans AS PTM ON PTM.lmp_id = MMC.lmp_id			
			";
			$orBy = \NEW_DB_SWITCH?"": "PTY.pty_id DESC, ";
			$this->correctKeyWords ( $rToURL, $bArray, $qString, $wString );	
			//echo $wString;
			$moreRes=$this->validParamsArr['limit']+1;
			$stmt = $this->sDbo->prepare(
			"SELECT DISTINCT MMC.ltb_id, MRC.ltm_google_id
			FROM lt_member_merchants MMC
			INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id
			{$sqlJoin}				
			{$qString} WHERE MMC.ltb_active {$wString} AND (  3959 * acos( cos( radians(:customerlat) ) * cos( radians( MRC.ltm_lat ) ) * cos( radians( MRC.ltm_long ) - radians(:customerlong) ) + sin( radians(:customerlat) ) * sin(radians(MRC.ltm_lat)) ) )  < (:raius) 
			ORDER BY {$orBy}POW(POW((:customerlat-MRC.ltm_lat),2)+(POW((:customerlong-MRC.ltm_long),2)),(1/2)) LIMIT {$moreRes} OFFSET {$this->validParamsArr['offset']}");			
			$stmt->bindValue(":raius", $this->validParamsArr['radius'], \PDO::PARAM_INT);
			$stmt->bindValue(":customerlat", $this->validParamsArr['lat'], \PDO::PARAM_STR);	
			$stmt->bindValue(":customerlong", $this->validParamsArr['long'], \PDO::PARAM_STR);			
			
			/*Setting Radius to session*/
			$this->setSession('search_range', $this->validParamsArr['radius'] * 1069);
			
			if(isset($bArray)){	  
			 
			 foreach($bArray as $keyKeyWord => $KeyWord){	  
			  $stmt->bindValue($keyKeyWord, '%'.$KeyWord.'%', \PDO::PARAM_STR);	   
			 }	  
			}	 
			$stmt->execute();
			$_i = 0;
			$this->googleIds = '';
			while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				if ($moreRes != ++$_i ) {
					array_push($this->searchReturn, new Merchant\MemberMerchant($this->sDbo, true, $resultSet['ltb_id']) );
					if (!empty($resultSet['ltm_google_id'])) $this->googleIds .= empty($this->googleIds)? '"' . $resultSet['ltm_google_id'] . '"': ',"'.$resultSet['ltm_google_id'] . '"';
				}	
				else
					$this->nextResults = true;
				
			}
			$this->prevResults = 0 < (int) $this->validParamsArr['offset'];
			
			
			/*
			echo '<pre>';
			var_dump($this->searchReturn);
			echo '</pre>';
			*/
		}	
		
		private function correctKeyWords (&$readyToURL, &$bindArray, &$queryString, &$whereString, $searchinPromos = false){
			$keyWordOk = ''; $readyToURL = ''; $queryArray = array(); $queryString = ''; $whereString='';
			if (isset($this->validParamsArr['keyword'])) {
				$searchArray=explode('-',trim(preg_replace('/\s+/', ' ', $this->validParamsArr['keyword']))); 								
				$outputArray = array_unique($searchArray);
				$keyWordOk = implode(' ',$outputArray);
				$readyToURL = implode('-',$outputArray);				
				/*Setting Keyword to session*/				
				$this->setSession('search_string', $keyWordOk);
			
				if (!empty($this->validParamsArr['keyword'])) {				
					
					$queryString.="
					 INNER JOIN tbl_m2keyword M2K ON M2K.ltb_id = MMC.ltb_id
					 INNER JOIN tbl_keywords KYW ON KYW.key_id = M2K.key_id
					";
					$bindArray=array();
					foreach ($outputArray as $i=>$keyWordVal) {
						$bindArray[':KeyWord'.$i] = $keyWordVal;
						$whereAddon='KYW.key_word LIKE :KeyWord'.$i.' OR MRC.ltm_company_name LIKE :KeyWord'.$i;
						if ($searchinPromos)
							$whereAddon.=" OR PRM.ltp_headline LIKE :KeyWord".$i;
						
						if (($temp = strlen($keyWordVal) - strlen('s')) >= 0 && strpos($keyWordVal, 's', $temp) !== false){
						 $bindArray[':KeyWords'.$i]=substr($keyWordVal, 0, -1);
						 $whereAddon.=' OR KYW.key_word LIKE :KeyWords'.$i.' OR MRC.ltm_company_name LIKE :KeyWords'.$i;
						 if ($searchinPromos)
							$whereAddon.=" OR PRM.ltp_headline LIKE :KeyWords".$i;
						}
						if (($temp = strlen($keyWordVal) - strlen('es')) >= 0 && strpos($keyWordVal, 'es', $temp) !== false){
						 $bindArray[':KeyWordes'.$i]=substr($keyWordVal, 0, -2);
						 $whereAddon.=' OR KYW.key_word LIKE :KeyWordes'.$i.' OR MRC.ltm_company_name LIKE :KeyWordes'.$i;
						 if ($searchinPromos)
							$whereAddon.=" OR PRM.ltp_headline LIKE :KeyWordes".$i;
						}     
						if (($temp = strlen($keyWordVal) - strlen('ies')) >= 0 && strpos($keyWordVal, 'ies', $temp) !== false){
						 $bindArray[':KeyWordies'.$i]=substr($keyWordVal, 0, -3).'y';
						 $whereAddon.=' OR KYW.key_word LIKE :KeyWordies' . $i . ' OR MRC.ltm_company_name LIKE :KeyWordies'.$i;
						 if ($searchinPromos)
							$whereAddon.=" OR PRM.ltp_headline LIKE :KeyWordies".$i;
						} 
						if (($temp = strlen($keyWordVal) - strlen('ves')) >= 0 && strpos($keyWordVal, 'ves', $temp) !== false){
						 $bindArray[':KeyWordvesf'.$i]=substr($keyWordVal, 0, -3).'f';
						 $bindArray[':KeyWordvesff'.$i]=substr($keyWordVal, 0, -3).'ff';
						 
						 $whereAddon.= ($searchinPromos?' OR PRM.ltp_headline LIKE :KeyWordvesf'.$i.' OR PRM.ltp_headline LIKE :KeyWordvesff'.$i:'').' OR KYW.key_word LIKE :KeyWordvesf'.$i.' OR MRC.ltm_company_name LIKE :KeyWordvesf'.$i.' OR KYW.key_word LIKE :KeyWordvesff'.$i.' OR MRC.ltm_company_name LIKE :KeyWordvesff'.$i;					 
						}
						$whereString .= ( empty($whereString)?"":" OR " ). $whereAddon;
						
					}	
					$whereString = empty($whereString)?"":" AND ({$whereString})";
				}
			}		
			return $keyWordOk;
		}
		
		//public functions
		public function searchParams($searchLocation, $searchKeyword){
			$dataToBeCleaned = array(
				'txt_loc_r'=>$searchLocation
			);
			$searchArray=explode(' ',trim(preg_replace('/\s+/', ' ', $searchKeyword))); 				
			$outputArray = array_unique($searchArray);			
			$readyToURL = implode('-',$outputArray);
			$keyWordOk = implode(' ',$outputArray);
			
			$areValidParams = $this->validData( $cleanedData, $dataToBeCleaned );
			
			$this->setSession('search_string', $keyWordOk);
			
			if ( $areValidParams ) {
				$this->setSession('search_point', $cleanedData['loc']);
			}
			
			return array ('urlKeyword'=>$readyToURL, 'searchLoction'=>$cleanedData['loc']);
		}
		
		public function getMapLayOut($siteExt, $loggedUser = false) {
			$_SESSION['user']['consumer']['search_map'] = true;
			$resultArr = array();
			if (count($this->searchReturn))
				foreach ( $this->searchReturn as $key=>$value ) {
					$mmbStore = $value->findStore($value->currentMerchantId);
					$mName = '';
					$mLat = '0.00000';
					$mLon = '0.00000';
					$storeHideAddress = true;		
					if ( $mmbStore !== null ) {
						$mmbStore->getHours($isStoreOpen, $todayHours, $value->getCurrent('tmz_name'));
						$mName = trim( $mmbStore->getCurrent( 'ltm_company_name' ) );
						$mLat = $mmbStore->getCurrent( 'ltm_lat' );
						$mLon = $mmbStore->getCurrent( 'ltm_long' );						
						$storeHideAddress = strcmp( $mmbStore->getCurrent( 'ltm_hide_address' ), '0' ) === 0? false: true;
					}
					
					if (!$storeHideAddress) {
						$outputStr = $value->buildMapLayOut($siteExt, $loggedUser);
						array_push($resultArr, array('Name'=>$mName, 'Lat'=>$mLat, 'Lon'=>$mLon , 'Layout'=>$outputStr) );					
					}	
				}
			return $resultArr;
		}
		
		public function getMerchantSearchResult ($siteExt, $loggedUser = false) {
			$outputStr='';
			if (count($this->searchReturn))
				foreach ($this->searchReturn as $key=>$value) {
					$outputStr .= $value->buildSearchLayOut($siteExt, $loggedUser);
				}
			return $outputStr;
		}	

		public function getDealsSearchResult ($siteExt, $userId) {
			$outputStr=''; $totalReturns=count($this->searchReturn);
			if ($totalReturns)
				foreach ($this->searchReturn as $key=>$value) {
					$value->setUserLocation($this->validParamsArr['lat'], $this->validParamsArr['long']);
					$outputStr .= $value->buildPromoLayouts($siteExt, $userId, array(), $totalReturns, false, true);
				}
			return (empty($outputStr)? '':'<div id="promos_div" style="width:100%;"><div class="row" style="background-color: transparent;"><div class="col-sm-12">'.$outputStr.'</div></div></div>');
		}
		
		public function getTotalResults() {
			return count( $this->searchReturn );
		}
		
		public function promoSearch(  ) {
			
			$sqlJoin = \NEW_DB_SWITCH?"
				INNER JOIN tbl_package PACK ON MMC.pk_id = PACK.pk_id
				INNER JOIN tbl_product PROD ON PACK.pk_id = PROD.prod_id
			
			": "
				INNER JOIN lt_plan_type AS PTY ON MMC.pty_id = PTY.pty_id
				INNER JOIN lt_merchant_plans AS PTM ON PTM.lmp_id = MMC.lmp_id			
			";
			$orBy = \NEW_DB_SWITCH?"": "PTY.pty_id DESC, ";
			$this->correctKeyWords ( $rToURL, $bArray, $qString, $wString, true );			
			//echo $wString;
			$moreRes=$this->validParamsArr['limit'] + 1;
			$stmt = $this->sDbo->prepare(
			"SELECT DISTINCT MMC.ltb_id, MRC.ltm_google_id, PRM.ltp_slug, PRM.ltp_id
			FROM lt_member_merchants MMC
			INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id
			{$sqlJoin}
			INNER JOIN lt_promos PRM ON PRM.ltb_id=MMC.ltb_id
			{$qString}
			WHERE MMC.ltb_active 
			AND MRC.ltm_active
			AND MRC.ltm_id <> 1
			AND (
			 (NOW() < PRM.ltp_enddate AND NOW() > PRM.ltp_startdate) 
			 OR (PRM.ltp_enddate IS NULL AND PRM.ltp_startdate IS NULL)
			)
			AND PRM.ltp_active				
			{$wString} AND (  3959 * acos( cos( radians(:customerlat) ) * cos( radians( MRC.ltm_lat ) ) * cos( radians( MRC.ltm_long ) - radians(:customerlong) ) + sin( radians(:customerlat) ) * sin(radians(MRC.ltm_lat)) ) )  < (:raius) 
			ORDER BY {$orBy}POW(POW((:customerlat-MRC.ltm_lat),2)+(POW((:customerlong-MRC.ltm_long),2)),(1/2)) LIMIT {$moreRes} OFFSET {$this->validParamsArr['offset']}");			
			$stmt->bindValue(":raius", $this->validParamsArr['radius'], \PDO::PARAM_INT);
			$stmt->bindValue(":customerlat", $this->validParamsArr['lat'], \PDO::PARAM_STR);	
			$stmt->bindValue(":customerlong", $this->validParamsArr['long'], \PDO::PARAM_STR);
			/*Setting Radius to session*/
			$this->setSession('search_range', $this->validParamsArr['radius'] * 1069);
			if(isset($bArray)){	  
			 foreach($bArray as $keyKeyWord => $KeyWord){			  
			  $stmt->bindValue($keyKeyWord, '%'.$KeyWord.'%', \PDO::PARAM_STR);	   
			 }	  
			}	 
			$stmt->execute();
			$_i = 0;
			$this->googleIds = '';
			while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
				if ($moreRes != ++$_i ) {					
					$tempMerchant = new Merchant\MemberMerchant($this->sDbo, true, $resultSet['ltb_id']) ;
					$tempMerchant->loadPromo( $resultSet['ltb_id'], $resultSet['ltp_id']);
					array_push($this->searchReturn, $tempMerchant);
					if ( !empty($resultSet['ltm_google_id']) ) $this->googleIds .= empty($this->googleIds)? '"' . $resultSet['ltm_google_id'] . '"': ',"' . $resultSet['ltm_google_id'] . '"';
				}	
				else
					$this->nextResults = true;
			}
			
			$this->prevResults = $this->validParamsArr['offset'] > 0;
			
			/*
			echo '<pre>';
			var_dump($this->searchReturn);
			echo '</pre>';
			*/
		}
		
		public function mapInUse ($isItUsed) {
			$this->setSession('search_map', $isItUsed=='1'? true: false);
		}
		
		public function nextPage () {			
			if (!isset($_SESSION["user"]["consumer"]["search_offset"])) $this->setSession('search_offset', $this->searchOffset);
			$this->setSession('search_offset', $_SESSION["user"]["consumer"]["search_offset"] + $this->searchLimit);			
		}
		
		public function prevPage () {			
			if (!isset($_SESSION["user"]["consumer"]["search_offset"])) $this->setSession('search_offset', $this->searchOffset);			
			$this->setSession('search_offset', $_SESSION["user"]["consumer"]["search_offset"] - $this->searchLimit < 0? 0: $_SESSION["user"]["consumer"]["search_offset"] - $this->searchLimit);
		}
		
		function __construct( $dbObj, $searchFor = 'merchants', $searchLimit = 10, $searchOffset = 0, $searchLocation = null, $searchKeyword = '', $loadRecords = true ) {			
			if ( $searchLocation !== null ) {
				$searchLatLong = explode(',', $searchLocation);				
				$this->searchLimit = is_numeric($searchLimit) && $searchLimit > 0? intval($searchLimit): 10;
				if (count($searchLatLong) === 2) {
					$dataToBeCleaned = array(
						'wnu2_limit_r'=>$this->searchLimit,
						'wnu11_offset_r'=>$searchOffset,
						'dec10_lat_r'=>( strlen($searchLatLong[0]) > 0? substr($searchLatLong[0], 1) :'' ),
						'dec10_long_r'=>$searchLatLong[1],
						'adn64_keyword'=>$searchKeyword
					);	
					
					$areValidParams = $this->validData( $cleanedData, $dataToBeCleaned );
					if ( $areValidParams) {
						$this->validParamsArr = $cleanedData;
						$this->validParamsArr['radius'] = 30;						
						$this->searchOffset = $cleanedData['offset'];	
						$cleanedData['for'] = ($searchFor == 'merchants' || $searchFor == 'deals'? $searchFor : 'deals');
						/*Setting Radius to session*/						
						$this->setSession('search_map', isset($_SESSION['user']['consumer']['search_map'])? $_SESSION['user']['consumer']['search_map']: false);
						$this->setSession('search_offset', !isset($_SESSION['user']['consumer']['search_for']) || $_SESSION['user']['consumer']['search_for'] != $cleanedData['for']? 0: $cleanedData['offset']);
						$this->validParamsArr['offset'] = $_SESSION['user']['consumer']['search_offset'];
						$this->setSession('search_for', $cleanedData['for']);						
						$this->setSession("csm_lat", $cleanedData['lat']); 
						$this->setSession("csm_long", $cleanedData['long']);
						$this->sDbo=$dbObj;
						if ($loadRecords)
							if ($cleanedData['for'] ==  'deals' )
								$this->promoSearch();
							else
								$this->merchantSearch();
					}
				}
			}	
		}
		
	}
}
?>