<?php
namespace App\MemberMerchant\Store{
require_once "class.consumer.php";
require_once "class.punch-card.php";
use App\MemberMerchant\Store\PunchCard as PunchCard;
use App\MemberMerchant\Store\Consumer as Consumer;

	class MerchantStore{
		
		// Private Properties		
		private $sDbo;
		
		//Private Functions
		private function getDayOfWeek($aDay, $minD = false) { 
			if (is_int($aDay) && $aDay >=1 && $aDay <= 7)
				switch ($aDay) {
					case 2:
						$Result = ($minD?'Tue':'Tuesday');
					break;
					case 3:
						$Result = ($minD?'Wed':'Wednesday');
					break;					
					case 4:
						$Result = ($minD?'Thu':'Thursday');
					break;
					case 5:
						$Result = ($minD?'Fri':'Friday');
					break;
					case 6:
						$Result = ($minD?'Sat':'Saturday');
					break;
					case 7:
						$Result = ($minD?'Sun':'Sunday');
					break;
					default: $Result = ($minD?'Mon':'Monday');
				}
			else 
				switch ($aDay){
			
					case 'Tuesday': case 'Tue':
						$Result = 2;
					break;
					case 'Wednesday': case 'Wed':
						$Result = 3;
					break;					
					case 'Thursday': case 'Thu':
						$Result = 4;
					break;
					case 'Friday': case 'Fri':
						$Result = 5;
					break;
					case 'Saturday': case 'Sat':
						$Result = 6;
					break;
					case 'Sunday': case 'Sun':
						$Result = 7;
					break;
					
					default: $Result = 1;					
				}
			return $Result;	
		}
		
		private function getTodayHours(&$openNow, $tmzName) {
			$openNow = false;
			$Result = '';
			if (!empty($this->storeRecords[$this->currentStoreId]['Hours'])){				
				$dt = new \DateTime("now", new \DateTimeZone($tmzName));				
				$weekDay = $this->getDayOfWeek($dt->format('l'));				
				$timeNow = strtotime($dt->format('m/d/Y, H:i:s')); 				
				$dateNow = $dt->format('m/d/Y');				
				
				//echo $timeNow;
				foreach ($this->storeRecords[$this->currentStoreId]['Hours'] as $key => $val) {					
					if ( intval($val['lth_start_day_num']) <= $weekDay && intval($val['lth_end_day_num']) >= $weekDay ) {	
						if ($val['lth_open'] == $val['lth_close']){
							$Result .= 'Open 24 Hours';
						}
						else {
							$Result .= date( 'g:i A', strtotime( $val['lth_open'] ) ) . ' - ' . date( 'g:i A', strtotime( $val['lth_close'] ) );
						}				
						$appointmentOnly = ($val['lth_appointment_only'] ? ' <span style="color: #00A99D;"><img style="max-width: 24px;" src="/localthanks/images/icon-appointment.png"> By Appointment Only</span>' : '');
						$Result = $Result . $appointmentOnly;
						$openNow = $openNow || ($timeNow >= strtotime($dateNow . ' ' . $val['lth_open']) && ( strtotime($dateNow . ' ' . $val['lth_open']) >= strtotime($dateNow . ' '. $val['lth_close']) || $timeNow <= strtotime($dateNow . ' '. $val['lth_close'])) );												
					}
				}
			}
			return $Result;
		}			
		
		private function format_phone_us($phone) {
		  
		  if(!isset($phone{3})) { return ''; }
		  
			  $phone = preg_replace("/[^0-9]/", "", $phone);
			  $length = strlen($phone);
			  switch($length) {
			  case 7:
				return preg_replace("/([0-9]{3})([0-9]{4})/", "$1-$2", $phone);
			  break;
			  case 10:
			   return preg_replace("/([0-9]{3})([0-9]{3})([0-9]{4})/", "($1) $2-$3", $phone);
			  break;
			  case 11:
			  return preg_replace("/([0-9]{1})([0-9]{3})([0-9]{3})([0-9]{4})/", "$1($2) $3-$4", $phone);
			  break;
			  default:
				return $phone;
			  break;
			  }
		}
		
		//protected functions
		protected function validateData(&$cleanData, &$dataErrors, $fieldsArr, $fileTypeArr=array() ){
			$cv= new \_variables($fieldsArr); // new instance
			$cv_array=$fileTypeArr; //list all varibles to be check in array
			foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
			$clean=$cv->get_cleaned_variables();
			$cleanData = array();
			$dataErrors=$cv->get_bad_variables();
			if (!count($dataErrors)) {
				$cleanData = $clean;
				return true;								
			}
			//var_dump($cleanData);
			return false;
		}
		
		// Public Properties
		public $storeRecords = array();
		public $currentStoreId = 0;
		
		// Public Methods
		// function getLocationsDropDown () {
		// 	$Result='';
		// 	foreach ($this->storeRecords as $id => $vArr) {
		// 		$Result .= '<option'.($vArr['ltm_id'] == $this->currentStoreId? ' selected ':' ').'value="'.$vArr['ltm_id'].'">'.$vArr['ltm_nickname'].'</option>';
		// 	}			
		// 	return $Result;
		// }
		
		function getCardPunches($requiredPunches, $punchCardHistory, &$whatIsNextPunch) {
			$Result = '';
			$whatIsNextPunch = 'subscribe';
			if ( is_array($punchCardHistory) && is_numeric($requiredPunches) && intval($requiredPunches) > 0 ) {
				
				$requiredPunchesOk = intval($requiredPunches);
				$totalPunches = 0;
				$totalRedeemed = 0;
				$totalSubscribed = 0;
				$lastAction = '';
				
				
				
				foreach ($punchCardHistory as $index=>$v) {					
					if ( isset($v['dph_id']) ) {
						$lastAction = $v['dph_task'];
						switch ($v['dph_task']) {
							case 'subscribe':
								$totalSubscribed++;
							break;
							case 'punch':
								$totalPunches++;
							break;
							case 'redeem':
								$totalRedeemed++;
							break;
						}
					}				
				}
				
				if ($totalSubscribed == 1) {
					$mod = $totalPunches < $requiredPunchesOk? $totalPunches : $totalPunches % $requiredPunchesOk;
					$dontCheck = ($lastAction == 'redeem' || $lastAction == 'subscribe') && $mod == 0;
										
					
					$whatIsNextPunch = $dontCheck? 'punch' : ($lastAction == 'punch' && $mod == 0? 'redeem': 'punch' );
					
					
					
					for ($i = 0; $i < $requiredPunchesOk; $i++) {						
						$Result .= $o .'<div class="dot-grid'.($dontCheck? '' : ($i < $mod || $mod ===0? ' dot-checked' :'') ).'">'.($dontCheck? '' : ($i < $mod || $mod === 0? '<img class="img-responsive" src="/localthanks/images/icon-check-shadow.png" alt="Punch checked">' : ($requiredPunchesOk === ($i + 1)?'<img class="img-responsive" src="/localthanks/images/icon-white-star.png" alt="Punch checked">':'') ) ).'</div>';
					}
				}
			}
			return $Result;
		}
		
		function loadRecords( $fieldValue, $fieldName, $fieldType = \PDO::PARAM_INT ) {
				$stmt = $this->sDbo->prepare("
				SELECT DISTINCT MRC.*, TMZ.tmz_name
				FROM lt_merchants MRC	
				INNER JOIN tbl_timezone TMZ ON MRC.tmz_id = TMZ.tmz_id
				WHERE MRC.{$fieldName}=:val ORDER BY MRC.ltm_id");				
				$stmt->bindValue(":val", $fieldValue, $fieldType);
				$stmt->execute();
				while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {					
					$this->storeRecords[$resultSet['ltm_id']] = $resultSet;
					if ($this->currentStoreId === 0)
						$this->currentStoreId = $resultSet['ltm_id'];
				}
				return $this->storeRecords;
		}
		
		function loadHours() {
				$stmt = $this->sDbo->prepare("
				SELECT DISTINCT MRH.*
				FROM lt_merchants MRC
				INNER JOIN lt_merchant_hours MRH ON MRC.ltm_id=MRH.ltm_id
				WHERE MRC.ltm_id=:id
				ORDER BY MRH.lth_start_day_num ASC");
				$stmt->bindValue(":id", $this->currentStoreId, \PDO::PARAM_INT);
				$stmt->execute();
				$this->storeRecords[$this->currentStoreId]['Hours']=array();
				while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {					
					$this->storeRecords[$this->currentStoreId]['Hours'][$resultSet['lth_id']] = $resultSet;
				}	
				//var_dump($this->storeRecords[$this->currentStoreId]['Hours']);
				return $this->storeRecords[$this->currentStoreId]['Hours'];
		}
		
		function getHours(&$storeOpenNow, &$todayHours, $tmzDiff, $ltmId=null) {			
			
			$storeOpenNow=false;
			if ($ltmId !== null) $this->currentStoreId = $ltmId;
			if (!isset($this->storeRecords[$this->currentStoreId]['Hours']))
				$this->loadHours();
			
			$todayHours = $this->getTodayHours($storeOpenNow, $tmzDiff);			
			//var_dump($this->storeRecords[$this->currentStoreId]['Hours']);
			
			return $this->storeRecords[$this->currentStoreId]['Hours'];
		}
		
		function getPunchCard($forceLoad = false) {
			if ($this->currentStoreId) {
				if (!$forceLoad && isset($this->storeRecords[$this->currentStoreId]['PunchCard'])) {
					return $this->storeRecords[$this->currentStoreId]['PunchCard'];
				}
				else {
					$stmt = $this->sDbo->prepare("
					SELECT *
					FROM tbl_punch_card
					WHERE ltm_id = :ltmId LIMIT 1");				
					$stmt->bindValue(":ltmId", $this->currentStoreId, \PDO::PARAM_INT);
					$stmt->execute();			
					if ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {
						
						$resultSet['Img_Type'] = '';					
						
						$this->storeRecords[$resultSet['ltm_id']]['PunchCard'] = $resultSet;
										
						$this->storeRecords[$resultSet['ltm_id']]['PunchCard']['Img_Type'] = $this->findImageType ($resultSet['dpc_image']);
						
					}
					return isset($this->storeRecords[$this->currentStoreId]['PunchCard'])? $this->storeRecords[$this->currentStoreId]['PunchCard']: array();	
				}	
			}
			return array();
		}		
		
		function findImageType ($dpcImageName) {
			if ( !empty($dpcImageName) ) {
				$check_img = explode('_', $dpcImageName);
				$check_img = $check_img[0];
				if ($check_img == 'unv'){
					return 'library'; // uncropped image from our universal library 
					//$img_dir = '../images/promo_library/'; 
				} else {
					return 'gallery'; // image from merchant's gallery
					//$img_dir = '../merchant-custom-files/'.$merchantDir.'/_files/img/p_600x400_';
				}
			}
			return '';
		}
		
		function applyForPunchCard($csmId = 0, $ltmId = 0, $wasHistoryLoaded = false) {
			if ($ltmId === 0) $ltmId = $this->currentStoreId;
			if (!$wasHistoryLoaded)
				$this->getPunchCardHistory($csmId, $ltmId);
			if (isset($this->storeRecords[$ltmId]['PunchCard'], $this->storeRecords[$ltmId]['PunchCard']['dpc_id']) && (!isset($this->storeRecords[$ltmId]['PunchCard']['History']) || empty($this->storeRecords[$ltmId]['PunchCard']['History']) )) {
				$stmt = $this->sDbo->prepare("
				INSERT IGNORE INTO tbl_punch_history (csm_id, dpc_id, dph_task, dph_transaction_id) VALUES (:csmId, :cardId, 'subscribe', :transId)");
				$stmt->bindValue(":csmId", $csmId, \PDO::PARAM_INT);
				$stmt->bindValue(":cardId", $this->storeRecords[$ltmId]['PunchCard']['dpc_id'], \PDO::PARAM_INT);				
				$stmt->bindValue(":transId", $this->storeRecords[$ltmId]['PunchCard']['dpc_id'] . uniqid(rand(1 , 10000), false), \PDO::PARAM_STR);
				$stmt->execute();
			}
			$tmp = $this->getPunchCardHistory($csmId, $ltmId);
			return isset($tmp['History'])? $tmp['History']: array();
		}
		
		function checkPunchCardCode($ltmId = 0, $cardId, $aCode) {
			if ($ltmId === 0) $ltmId = $this->currentStoreId;
			if (is_numeric($cardId) && intval($cardId) > 0 && !empty($aCode) ) {
				
				$stmt = $this->sDbo->prepare("
				SELECT *
				FROM tbl_punch_card
				WHERE ltm_id = :ltmId AND dpc_id = :cardId LIMIT 1");				
				$stmt->bindValue(":ltmId", $this->currentStoreId, \PDO::PARAM_INT);
				$stmt->bindValue(":cardId", $cardId, \PDO::PARAM_INT);
				$stmt->execute();			
				if ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {			
					return strcmp($resultSet['dpc_pincode'], $aCode) === 0;
				}			
			}
			
			return false;
		}
		
		function punchPunchCard($csmId = 0, $ltmId = 0, $aCode, $transactionId, $wasHistoryLoaded = false, $wasPunchCardChecked = false){
			if ($ltmId === 0) $ltmId = $this->currentStoreId;
			if (!$wasHistoryLoaded)
				$this->getPunchCardHistory($csmId, $ltmId);
			if (!empty($transactionId) && preg_match('/^[a-zA-Z0-9]{1,21}$/', $transactionId) && isset($this->storeRecords[$ltmId]['PunchCard']['dpc_id'], $this->storeRecords[$ltmId]['PunchCard']['History']) && ($wasPunchCardChecked || $this->checkPunchCardCode($ltmId, $this->storeRecords[$ltmId]['PunchCard']['dpc_id'], $aCode)) ) {
				
				$this->getCardPunches($this->storeRecords[$ltmId]['PunchCard']['dpc_required_punches'], $this->storeRecords[$ltmId]['PunchCard']['History'], $nextAction);
				
				if (!empty($nextAction) && $nextAction != 'subscribe' ) {
					$stmt = $this->sDbo->prepare("
					INSERT IGNORE INTO tbl_punch_history (csm_id, dpc_id, dph_task, dph_transaction_id) VALUES (:csmId, :cardId, :nextAction, :transId)");
					$stmt->bindValue(":csmId", $csmId, \PDO::PARAM_INT);
					$stmt->bindValue(":nextAction", $nextAction, \PDO::PARAM_STR);
					$stmt->bindValue(":transId", $this->storeRecords[$ltmId]['PunchCard']['dpc_id'] . $transactionId, \PDO::PARAM_STR);
					$stmt->bindValue(":cardId", $this->storeRecords[$ltmId]['PunchCard']['dpc_id'], \PDO::PARAM_INT);				
					$stmt->execute();
					
					$tmp = $this->getPunchCardHistory($csmId, $ltmId);
			
					return isset($tmp['History'])? $tmp['History']: array();
				}	
			}			
			
			return array();
		}
		
		function getPunchCardLayOut($merchantDir, $merchantLogo, $merchantURL, $csmId = 0, $ltmId = 0, $wasHistoryLoaded = false, $anHTMLError = '', $reducedVersion = false) {
			if ($ltmId === 0) $ltmId = $this->currentStoreId;
			if (!$wasHistoryLoaded)
				$this->getPunchCardHistory($csmId, $ltmId);
			$Result = '';
			
			if (isset($this->storeRecords[$ltmId]['PunchCard']['History'], $this->storeRecords[$ltmId]['PunchCard']['dpc_id'])) {
				$cardImage = (empty($this->storeRecords[$ltmId]['PunchCard']['dpc_image'])? '/localthanks/images/clear_pix.gif' : ($this->storeRecords[$ltmId]['PunchCard']['Img_Type']=='gallery'? '/merchant-custom-files/' . $merchantDir . '/_files/img/source_' : '/images/promo_library/') . $this->storeRecords[$ltmId]['PunchCard']['dpc_image']);
				$Result .= '
					<div class="punch_card_wrap">								    
						<div class="punch_card_details">
							<div class="card-row">
								'.($reducedVersion? '':'
								<div class="card-col-12">
									<div class="punch_card_mname_logo">
										<div class="punch_card_logo_div">
											<a href="'.$merchantURL.'"><img alt="Marchant Logo" class="punch_card_logo" src="'.$merchantLogo.'" class="img-responsive"/></a>
										</div>	
										
										<div class="punch_card_mname_div">
											<div> '.$this->getCurrent('ltm_company_name').' </div>
										</div>
									</div>
								</div>').'	
								<div class="card-col-12">	
									<div id="punchCardTitle" class="punch_card_title">
										' . (isset($this->storeRecords[$ltmId]['PunchCard']['dpc_header'])? $this->storeRecords[$ltmId]['PunchCard']['dpc_header'] : "") . '
									</div>
								</div>'.
								($reducedVersion? '':'	
								<div class="card-col-12">
									<div id="punchCardDesc" class="punch_card_desc">
										'. (isset($this->storeRecords[$ltmId]['PunchCard'])? $this->storeRecords[$ltmId]['PunchCard']['dpc_intro'] : ""). '
									</div>
								</div>
								').'	
								<div class="card-col-12">									
									'.($reducedVersion? '':'
									<div class="punch_card_image">	
										<img id="punchCardImage"  src="'.$cardImage.'" class="img-responsive"/>
									</div>
									').'
									<div id="punchCardPunches" class="punch_card_punches"> 	
										' . $this->getCardPunches($this->storeRecords[$ltmId]['PunchCard']['dpc_required_punches'], $this->storeRecords[$ltmId]['PunchCard']['History'], $nextAction) . '
									</div>
								</div>		
							</div>		
						</div>
						<div class="pin-code-div">
							'.($nextAction == 'redeem'? '<h2 class="pin-code-head">Congratulations!</h2><p class="pin-code-desc"><strong>You are ready to redeem!</strong> Please, show this at the register to claim this offer.</p>' : '<p class="pin-code-desc">Please, show to the employee at register so they can input your redemption code:</p>').'
							<form method="post">
								<input type="hidden" name="transactionId" value="' . uniqid(rand(1 , 10000), false) . '"/>
								<input autofocus class="form-control input-lg" type="password" maxlength="20" name="pinCodeInp" required id="pinCodeInp"/>
								' . $anHTMLError . '
								<input type="submit" value="Submit" class="btn btn-xs punch_card_submit"/>
							</form>
						</div>	
					</div>
					'. (!$reducedVersion && isset($this->storeRecords[$ltmId]['PunchCard']['dpc_disclaimer'])?  
						'<div class="punch_card_disclaimers-wrap">
							<div class="punch_card_disclaimers">
								<p><strong>Disclaimers: </strong><br><span id="punchCardDisclaimers">'.$this->storeRecords[$ltmId]['PunchCard']['dpc_disclaimer'].'</span></p>
							</div>	
						</div>'
					: '') . '		
				'; 
			}			
			return $Result;
		}
		
		function getPunchCardHistory($csmId = 0, $ltmId = 0) {
			
			$this->getPunchCard();
			
			if ( isset($this->storeRecords[$this->currentStoreId]['PunchCard']) ) {
				
				if ($ltmId === 0) $ltmId = $this->currentStoreId;
				
				$findConsumerPunches = is_numeric($csmId) && intval($csmId) > 0;
				$stmt = $this->sDbo->prepare("
				SELECT *
				FROM tbl_punch_card PRD
				INNER JOIN tbl_punch_history PHY ON PRD.dpc_id = PHY.dpc_id
				" . ($findConsumerPunches? "INNER JOIN tbl_consumer CSM ON CSM.csm_id = PHY.csm_id" : "") . "
				WHERE PRD.ltm_id = :ltmId" . ($findConsumerPunches? " AND CSM.csm_id = :csmId" : "") . " ORDER BY PHY.csm_id, PHY.dph_id");
				$stmt->bindValue(":ltmId", $ltmId, \PDO::PARAM_INT);
				
				if ($findConsumerPunches)
					$stmt->bindValue(":csmId", intval($csmId), \PDO::PARAM_INT);
				
				$stmt->execute();	
				
				$this->storeRecords[$ltmId]['PunchCard']['History'] = array();
				
				while ( $resultSet = $stmt->fetch( \PDO::FETCH_ASSOC ) ) {					
					array_push($this->storeRecords[$ltmId]['PunchCard']['History'], $resultSet);
				}
				
				return $this->storeRecords[$ltmId]['PunchCard'];				
			}	
			return isset($this->storeRecords[$ltmId]['PunchCard'])? $this->storeRecords[$ltmId]['PunchCard'] : array();	
		}
		
		public function getDistance($lat, $lng){
			$Result=0;
			if (isset($this->storeRecords[$ltmId]['ltm_lat'], $this->storeRecords[$ltmId]['ltm_long'])) {
			  $theta = $this->storeRecords[$ltmId]['ltm_long'] - $lng;
			  $dist = sin(deg2rad($this->storeRecords[$this->currentStoreId]['ltm_lat'])) * sin(deg2rad($lat)) +  cos(deg2rad($this->storeRecords[$this->currentStoreId]['ltm_lat'])) * cos(deg2rad($lat)) * cos(deg2rad($theta));
			  $dist = acos($dist);
			  $dist = rad2deg($dist);
			  $miles = $dist * 60 * 1.1515;
			  $Result = $miles != (int)$miles? number_format((float)$miles, 2, '.', '') :$miles;
			}
			return $Result;
		}

		// this function first pads the time with ~ then uses str_replace to replace ~ with &nbsp; since that is not possible using just str_pad
		public function padDisplayTime($the_time){
			return str_replace('~', '&nbsp;&nbsp;', str_pad(date('g:i a', strtotime($the_time)), strlen('00:00 am'), '~', STR_PAD_LEFT));
		}
		
		public function getEveryDayHours(&$storeOpenNow, $tmzName, $resultType = 'array') {
			for ($_i = 1; $_i <= 7; $_i++){
				$tempArr[$this->getDayOfWeek($_i, true)] = 'Closed';
			}
			$openNow = false;
			if ($resultType == 'array')	$Result = array(); else	$Result = '';	
			if (!empty($this->storeRecords[$this->currentStoreId]['Hours'])){
				$todayHours = $this->getTodayHours($storeOpenNow, $tmzName);				
				//echo $timeNow;
				$dt = new \DateTime("now", new \DateTimeZone($tmzName));				
				$weekDay = $this->getDayOfWeek($dt->format('l'));				
				$timeNow = strtotime($dt->format('m/d/Y, H:i:s')); 				
				$dateNow = $dt->format('m/d/Y');				
				
				foreach ( $this->storeRecords[$this->currentStoreId]['Hours'] as $key => $val ) {
					if ( intval($val['lth_start_day_num']) <= $weekDay && intval($val['lth_end_day_num']) >= $weekDay ) {					
						$openNow = $openNow || ($timeNow >= strtotime($dateNow . ' ' . $val['lth_open']) && ( strtotime($dateNow . ' ' . $val['lth_open']) >= strtotime($dateNow . ' '. $val['lth_close']) || $timeNow <= strtotime($dateNow . ' '. $val['lth_close'])) );												
					}
					for ($_i = intval($val['lth_start_day_num']); $_i <= intval($val['lth_end_day_num']); $_i++){
						$apptOnly = (bool)$val['lth_appointment_only'];
						
						// echo '<br><br><br><br><br><br><h1>'.($apptOnly == '1').'</h1>';
						
						$timeToDisplay = ($this->padDisplayTime($val['lth_open']) == $this->padDisplayTime($val['lth_close']) ? '24 Hours' 
											: $this->padDisplayTime($val['lth_open']) . ' - ' . $this->padDisplayTime($val['lth_close']));

						$hoursLabel = ($openNow ? '<span style="color: #00A99D;"> Open Now</span>': '<span style="color: #00A99D;"> Closed Now</span>');
						// $hoursLabel = ($apptOnly == '1' ? '<span style="color: #00A99D;"> By Appointment Only</span>' : $hoursLabel);
						$tempArr[$this->getDayOfWeek($_i, true)] = $timeToDisplay.($_i == $weekDay && $apptOnly == false ? $hoursLabel : ($apptOnly ? '<span style="color: #00A99D;"> By Appointment Only</span>' : ''));
					}					
				}
				
				if ( is_array($Result) ) {						
					$Result = $tempArr;
				}
				else {	
					foreach ($tempArr as $key=>$val)
						$Result .= "<span><strong style='display: inline-block; min-width: 35px;'>{$key}:</strong></span> <span style='min-width:130px;'>{$val}</span><br>";
				}
			}
			return $Result;
		}
		
		function getCurrent($storeField) {
			if (isset($this->storeRecords[$this->currentStoreId][$storeField]) && $this->storeRecords[$this->currentStoreId][$storeField] !== null) {
				if ($storeField == 'ltm_phone_number')
					return $this->format_phone_us($this->storeRecords[$this->currentStoreId][$storeField]);
				return $this->storeRecords[$this->currentStoreId][$storeField];
			}			
			return '';
		}
		
		function findStore($ltmId=null) {
			if ($ltmId !== null) $this->currentStoreId = $ltmId;			
			reset($this->storeRecords);
			$currentVal = current($this->storeRecords);
			$stopFlag = true;
			while ($currentVal && $stopFlag){
				if ($currentVal['ltm_id'] == $this->currentStoreId) {					
					$stopFlag = false;
				}
				else{
					$currentVal = next($this->storeRecords);
				}	
			}
			if (!$stopFlag)
				return $currentVal;
			return array();
		}
		
		function __construct( $dbObj, $ltmId=null ) {
			$this->sDbo=$dbObj;			
			if ($ltmId!==null && is_numeric($ltmId) && $ltmId > 0) {
				$this->loadRecords( (int) $ltmId, 'ltm_id');
			}
		}
		
	}
}
?>