<?php
include 'global.php'; // global functions, contains include to function that connects to database

/*Get bills that need to be deactivated*/
$qry = $dbo->prepare( "
SELECT BILL.ltm_id, BILL.bill_id 
FROM `lt_merchant_billing` BILL 
INNER JOIN `lt_merchant_plans` LMP ON BILL.lmp_id = LMP.lmp_id 
WHERE BILL.bill_cycleend <= CURDATE() AND BILL.bill_active = 1" );
$qry = execPDO( $qry );
$deactivate = $qry->fetchAll( PDO::FETCH_ASSOC );

if ( NEW_DB_SWITCH ) {
	require_once "class.member-merchant.php";
	$merchObj = new App\MemberMerchant\MemberMerchant( $dbo, false );
	$merchObj->bulkDeactivateBillins(  );
	$merchObj->bulkActivateBillins(  );
}
else {	
	/* Get bills that need to be activated && that bill's pty_id, lmp_id so we can update lt_member_merchants */
	$qry = $dbo->prepare( "
	SELECT BILL.ltm_id, LMP.pty_id, BILL.bill_id, BILL.lmp_id 
	FROM `lt_merchant_billing` BILL 
	INNER JOIN `lt_merchant_plans` LMP ON BILL.lmp_id = LMP.lmp_id 
	WHERE BILL.bill_cyclestart <= CURDATE() AND (BILL.bill_cycleend > CURDATE() OR BILL.bill_cycleend IS NULL) AND BILL.bill_active = 0" );
	$qry = execPDO($qry);
	$activate = $qry->fetchAll( PDO::FETCH_ASSOC );
	foreach( $deactivate as $key => $value ) {
		// deactivate bill
		$qry = $dbo->prepare("UPDATE `lt_merchant_billing` SET bill_active = 0 WHERE bill_id = :bill_id");
		$qry->bindValue(':bill_id', $value["bill_id"], PDO::PARAM_INT);
		$qry = execPDO($qry);

		// set member to 'free' for now, once we activate a bill this should correct itself - otherwise the member has canceled and stays "free"
		$qry = $dbo->prepare("UPDATE `lt_member_merchants` LTB INNER JOIN `lt_merchants` LTM ON LTB.ltb_id=LTM.ltb_id SET LTB.pty_id=1, LTB.lmp_id=1 WHERE LTM.ltm_id=:ltm_id");
		$qry->bindValue(':ltm_id', $value["ltm_id"], PDO::PARAM_INT);
		$qry = execPDO($qry);
	}

	foreach( $activate as $key => $value ) {
		//in order to activate a billing it is needed to check if it is not been canceled yet in the table transactions
		
		// activate bill
		$qry = $dbo->prepare("UPDATE `lt_merchant_billing` SET bill_active = 1 WHERE bill_id = :bill_id");
		$qry->bindValue(':bill_id', $value["bill_id"], PDO::PARAM_INT);
		$qry = execPDO($qry);

		// update member pty_id & lmp_id
		$qry = $dbo->prepare("UPDATE `lt_member_merchants` LTB INNER JOIN `lt_merchants` LTM ON LTB.ltb_id=LTM.ltb_id SET LTB.pty_id=:pty_id, LTB.lmp_id=:lmp_id WHERE LTM.ltm_id=:ltm_id");
		$qry->bindValue(':pty_id', $value["pty_id"], PDO::PARAM_INT);
		$qry->bindValue(':ltm_id', $value["ltm_id"], PDO::PARAM_INT);
		$qry->bindValue(':lmp_id', $value["lmp_id"], PDO::PARAM_INT);
		$qry = execPDO($qry);
	}
}	
?>