<?php
// this script resets all merchant's remaining values to their plan's default value each month
include 'global.php'; // global functions, contains include to function that connects to database

	// get last date of this month
	$last_date_this_month = strtotime('this month');
	$last_date_this_month = date('t', $last_date_this_month);

	// get today's date
	$todays_date = strtotime('today');
	$todays_date = date('d', $todays_date);
	
	// get bills
	$qry = $dbo->prepare( "
		SELECT DISTINCT BILL.bill_date, BILL.ltm_id, BILL.lmp_id, MMR.ltb_id , MMR.pk_id 
		FROM lt_merchant_billing BILL 
		INNER JOIN lt_merchants MER ON MER.ltm_id=BILL.ltm_id
		INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=MER.ltb_id
		WHERE BILL.bill_active = 1" );
	$qry = execPDO($qry);
	
	$bills = $qry->fetchAll(PDO::FETCH_ASSOC);
	
	if (NEW_DB_SWITCH) {
		include 'class.member-merchant.php';
		$merchObj = new App\MemberMerchant\MemberMerchant($dbo, false);
	}
	else {
		function _resetMerchantValues($lmp_id, $ltm_id, $dbo){
			$sql = "SELECT ltb_id FROM lt_merchants WHERE ltm_id=:ltm_id LIMIT 1";
			$stmt = $dbo->prepare( $sql );
			$stmt->bindValue(':ltm_id', $ltm_id, PDO::PARAM_INT);
			$stmt=execPDO($stmt);
			$stmt=$stmt->fetch(PDO::FETCH_ASSOC);
			$ltb_id = $stmt['ltb_id'];


			$sql = 'SELECT LMP.lmp_id, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
			  FROM lt_merchant_plans LMP 
			  INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
			  LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
			  WHERE LMP.lmp_id = :lmp_id AND LMP.lmp_active = 1 ORDER BY LMP.lmp_price DESC LIMIT 1';

			$qry = $dbo->prepare($sql);

			$qry->bindValue(':lmp_id', $lmp_id, PDO::PARAM_INT);

			$qry = execPDO($qry);

			$qry = $qry->fetchAll(PDO::FETCH_ASSOC);

			if($qry){
				foreach ($qry as $k => $v) {
				  if (!$results){
					$results = array(
					  'lmp_id'         => $v['lmp_id'],
					  'lmp_features'   => array(array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']))
					);
				  } 
				  else {
					$next_feature = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
					array_push($results['lmp_features'], $next_feature);
				  }
				}
				$selected_plan = $results;	
			}

			// update merchant feature counts
			foreach ($selected_plan['lmp_features'] as $k=>$v){
				switch ($v['lpf_id']){
				  case 9:  // catalog points
				  case 14: // sms texts
				  case 15: // push notifications
				  case 13: // monthly emails
						updatePlanFeatures($ltb_id, $v['lpf_id'], $v['mfc_count'], $dbo);
				  break;
				  default:
				  break;
				}
			}
		}

		function updatePlanFeatures($ltb_id, $lpf_id, $mfc_count, $dbo){
			$qry = $dbo->prepare("UPDATE `lt_feature_cnt` SET lfc_count=:count WHERE ltb_id=:ltb_id AND lpf_id=:lpf_id LIMIT 1");
			$qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);
			$qry->bindValue(':lpf_id', $lpf_id, PDO::PARAM_INT);
			$qry->bindValue(':count', $mfc_count, PDO::PARAM_INT);
			$qry = execPDO($qry);    
		}
	}
	
	foreach ( $bills as $k=>$v ) {
		// get bills date
		$bill_date = strtotime( $v['bill_date'] );
		$bill_date = date('d', $bill_date);
		// if bill date is greater than this months last day
		if ( $bill_date > $last_date_this_month ) {
			// check if today is this months last day
			if ( $todays_date == $last_date_this_month ) {
				
				//var_dump($v['ltb_id']);
				
				// reset values
				if (NEW_DB_SWITCH)
					$merchObj->resetProductCountsFromMax ( $v['ltb_id'] );
				else	
					_resetMerchantValues( $v['lmp_id'], $v['ltm_id'], $dbo );
			}
		// if bill date is equal to today's date
		} else if ( $bill_date == $todays_date ) {
			//var_dump($v['ltb_id']);
			// reset values
			if ( NEW_DB_SWITCH ) {				
				$merchObj->resetProductCountsFromMax ( $v['ltb_id'] );
			}	
			else
				_resetMerchantValues( $v['lmp_id'], $v['ltm_id'], $dbo );
		}
	}


	
?>