<?php 
/**
* This CRON will check for consumers where csm_txt_status = 2 (bulk uploaded member)
*	send them an initial text message
*		update the csm_txt_status to NULL
**/
require_once 'global.php';
require_once 'function.send-text.php'; // _appSendText($_msg, $_recipient);
$dbo = connect();

function sendBulkWelcomeText($dbo){

	// select consumers where csm_txt_status = 2 (bulk uploaded member)
	$sql = 'SELECT CSM.csm_txt_status, CSM.csm_cell_number, LTM.ltm_company_name, LTM.ltm_id FROM tbl_consumer CSM INNER JOIN lt_merchants LTM ON CSM.ltm_pick_id = LTM.ltm_id WHERE CSM.csm_txt_status = 2 ORDER BY CSM.csm_id ASC LIMIT 80';
	$qry = $dbo->prepare( $sql );
	$qry = execPDO($qry);
	$qry = $qry->fetchAll( PDO::FETCH_ASSOC );
	if (!empty($qry)){
		$group = array();
		foreach ($qry as $k=>$v){
			if (isset($group[$v['ltm_id']])){
				array_push($group[$v['ltm_id']]['numbers'], $v['csm_cell_number']);
			} else {
				$group[$v['ltm_id']] = array('ltm_company_name'=>$v['ltm_company_name'], 'numbers'=>array($v['csm_cell_number']));
			}
		}

		$_template = 'Text YES to join%%Text Alerts. Msg&data rates may apply. Reply HELP for help, STOP to cancel.';

		$name_max_len = (160 - strlen($_template)); // Max length of text msg is 160 characters.

		foreach ($group as $k=>$v){
			if (strlen($group[$k]['ltm_company_name']) > $name_max_len) {
				$group[$k]['ltm_company_name'] = substr($group[$k]['ltm_company_name'], 0, $name_max_len - 1).'.';
			}

			// add company name to msg
			$_msg = str_replace('%%', ' '.$group[$k]['ltm_company_name'].' ', $_template);

			// send welcome text
			$msgSend = _appSendText($_msg, $group[$k]['numbers']);

			if ($msgSend === 'Success'){
				foreach($group[$k]['numbers'] as $x=>$phone){
					// update csm_txt_status
					$qry = $dbo->prepare("UPDATE tbl_consumer SET csm_txt_status = NULL WHERE csm_cell_number=:phone");
					$qry->bindValue(':phone', $phone, PDO::PARAM_STR);
					$qry = execPDO($qry);
				}
			} else {
				$subject = 'CRON Failed: cron.send_bulk_welcome_txt.php has failed';
				$message = "<html><head><title>CRON Failed: cron.send_bulk_welcome_txt.php has failed</title></head><body><table><tr><td>This is an alert message generated by the CRON.send_bulk_welcome_txt.php file. Check this merchant's recent bulk upload data: ".$group[$k]['ltm_company_name']."<br>Error Message: ".$msgSend." </td></tr></table></body></html>";
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
			    $headers .= 'Cc: ' . ERROR_ALERT_EMAIL . "\r\n";	
				$headers .= 'From: ' . ERROR_ALERT_EMAIL . "\r\n";
				mail(ERROR_ALERT_EMAIL,$subject,$message,$headers);
			}
		}
		echo '<pre>';
		var_dump($group);
		echo '</pre>';
		// re-call function
		sendBulkWelcomeText($dbo);
	} else {
		exit();
	}

}

sendBulkWelcomeText($dbo);
?>