<?php 
/**
* This CRON will check for text in tbl_text_msgs txt_scheduled = 1
*	and send them 
*		update the txt_scheduled to NULL
**/

require_once 'global.php';
require_once 'function.send-text.php'; // _appSendText($_msg, $_recipient);
$dbo = connect();$_sentList=array('txt'=>array('0'), 'csm'=>array('0')); $_date = date("Y-m-d H:i:s");

function sendText($adate, $sentList, $dbo) {
	$a_sentList = $sentList;
	$sql = '
		SELECT DISTINCT CSM.csm_id, TXT.txt_id, TXT.txt_msg, CSM.csm_cell_number, LTM.ltm_company_name 
		FROM tbl_text2cust T2C
		INNER JOIN tbl_text_msgs TXT ON TXT.txt_id = T2C.txt_id 
		INNER JOIN tbl_consumer CSM ON CSM.csm_id = T2C.csm_id		
		INNER JOIN lt_member_merchants MMC ON TXT.ltb_id = MMC.ltb_id
		INNER JOIN lt_merchants LTM ON CSM.ltm_pick_id = LTM.ltm_id AND MMC.ltb_id = LTM.ltb_id
		WHERE TXT.txt_scheduled = 1 AND TIMESTAMPDIFF(MINUTE,TXT.txt_date,:txt_date)>=0 AND NOT (CSM.csm_id IN ('. implode(',', $a_sentList['csm']) .') AND TXT.txt_id IN ('. implode(',', $a_sentList['txt']) .'))
		ORDER BY CSM.csm_id ASC LIMIT 80';
	$qry = $dbo->prepare( $sql );
	$qry->bindValue(':txt_date', "{$adate}", PDO::PARAM_STR);
	$qry->execute();
	$qry = $qry->fetchAll( PDO::FETCH_ASSOC );	
	if (!empty($qry)){
		$group = array();
		foreach ($qry as $k=>$v){
			if (!in_array($v['txt_id'], $a_sentList['txt'])) {
				array_push($a_sentList['txt'], $v['txt_id']);				
			}
			if (!in_array($v['csm_id'], $a_sentList['csm'])) {
				array_push($a_sentList['csm'], $v['csm_id']);
			}
			
			if (isset($group[$v['txt_id']])){
				array_push($group[$v['txt_id']]['numbers'], $v['csm_cell_number']);
				$group[$v['txt_id']]['msg'] = $v['txt_msg'];				
			} else {
				$group[$v['txt_id']] = array('ltm_company_name'=>$v['ltm_company_name'], 'numbers'=>array($v['csm_cell_number']), 'msg'=>$v['txt_msg']);
			}
		}
		
		foreach ($group as $k=>$v){
			// send welcome text
			
			$msgSend = _appSendText($group[$k]['msg'] . ' Reply STOP to end msgs', $group[$k]['numbers']);
			if ($msgSend !== 'Success') {
				$subject = 'CRON Failed: cron.send_txt.php has failed';
				$message = "<html><head><title>CRON Failed: cron.send_bulk_welcome_txt.php has failed</title></head><body><table><tr><td>This is an alert message generated by the CRON.send_txt.php file. Check this merchant's recent scheduled message: ".$group[$k]['ltm_company_name']."<br>Error on Message: ".$msgSend." </td></tr></table></body></html>";
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
			    $headers .= 'Cc: ' . ERROR_ALERT_EMAIL . "\r\n";	
				$headers .= 'From: ' . ERROR_ALERT_EMAIL . "\r\n";
				mail(ERROR_ALERT_EMAIL,$subject,$message,$headers);
			}
		}
		echo '<pre>';
		var_dump($group);
		echo '</pre>';
		
		// re-call function
		
		sendText($adate, $a_sentList, $dbo);
	}
	else {
		$sql = 'UPDATE tbl_text_msgs SET txt_scheduled = NULL WHERE TIMESTAMPDIFF(MINUTE,txt_date,:txt_date) >= 0 AND txt_scheduled = 1';
		$qry = $dbo->prepare( $sql );
		$qry->bindValue(':txt_date', "{$adate}", PDO::PARAM_STR);
		$qry->execute();
		exit();
	}
}

sendText($_date, $_sentList, $dbo);
?>