<?php
//-----------------------------------
// function.login-reset.php
//-----------------------------------

require_once "start_session.php";

//if( !function_exists( 'connect' ) )
	require_once 'function.connect.php';
	
header( 'Content-Type: application/json; charset=utf-8' );

if( isset( $_REQUEST['email'] ) ) {
	if( !filter_var( $_REQUEST['email'], FILTER_VALIDATE_EMAIL ) ) {
		echo json_encode( array( 'error' => 'Invalid email format. Please try again.' ) );
	}
	else {
		$d = connect();
		if (strpos($_REQUEST['server'], '/mystore/login')!==false){
			 $s = 'SELECT ltb_id,ltb_email FROM `lt_member_merchants` WHERE ltb_email=:email';
			 $field = 'ltb_id';
		}	 
		elseif(strpos($_REQUEST['server'], '/start')!==false){
			 $field = 'csm_id';	
			 $s = 'SELECT csm_id,csm_email FROM `tbl_consumer` WHERE csm_email=:email';
		}
		elseif(strpos($_REQUEST['server'], '/admin/login.php')!==false){
			$s = 'SELECT adm_id,adm_email FROM `tbl_admin` WHERE adm_email=:email';
			$field = 'adm_id';
	   }	 
		else{			
		    $table = $prefix = false;
			echo json_encode( array( 'error' => 'No server set.' ) );
			exit();
		}
		
		if( $q = $d->prepare( $s ) ) {
			$q->bindValue( ':email', $_REQUEST['email'], PDO::PARAM_STR );
			$q->execute();
			$u = $q->fetchAll( PDO::FETCH_ASSOC );
			if( !empty( $u ) ) {
				include 'mail.login-reset.php';
				if (strpos($_REQUEST['server'], '/mystore/login')!==false){
					 $id = $u[0]['ltb_id'];
					 $email = $u[0]['ltb_email'];
				}	 
				elseif(strpos($_REQUEST['server'], '/start')!==false){
					 $id = $u[0]['csm_id'];
					 $email = $u[0]['csm_email'];
				}
				elseif(strpos($_REQUEST['server'], '/admin/login.php')!==false){
					$id = $u[0]['adm_id'];
					$email = $u[0]['adm_email'];
			   }
				$uid = uniqid();
				$pcl = ( isset( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] != 'off' ) ? 'https://' : 'http://';
				
				if(strpos($_REQUEST['server'], '/admin/login.php')!==false) {
					$url = "{$pcl}{$_SERVER['HTTP_HOST']}/admin/reset-password.php?reset={$uid}&id={$id}";				
				} else{
					$url = "{$pcl}{$_SERVER['HTTP_HOST']}{$_REQUEST['server']}?reset={$uid}&id={$id}&redirect=".($_REQUEST['server']=='/start'?'/':$_REQUEST['server']);				
				}
				$r = $d->prepare( "INSERT INTO `lt_member_login_reset` (llr_uid,{$field},llr_email) VALUES (:uid,:id,:email)" );
				$r->bindValue( ':uid', $uid, PDO::PARAM_STR );
				$r->bindValue( ':id', $id, PDO::PARAM_STR );
				$r->bindValue( ':email', $email, PDO::PARAM_STR );
				$r->execute();
				$data = _mailLoginReset( $_REQUEST['email'], $url );
				if( $data != '' )
					echo json_encode( array( 'error' => $data ) );
				else
					echo json_encode( array( 'success' => 'Email sent.' ) );
			}
			else {
				echo json_encode( array( 'error' => 'There is not an account for this email. Please try another email.' ) );
			}
		}
		else {
			echo json_encode( array( 'error' => 'There was an unknown error. Please try again.' ) );
		}		
	}
}

/* EOF ?> */