<?php
//------------------------------------------------------
// function-login.php
//------------------------------------------------------
// Processes the $_REQUEST array.
// Uses $GLOBALS on templates. Checks session variables.
//------------------------------------------------------
require_once 'global.php';
function _appLogin($redirect=true)
{	
	if ( $redirect ){
		//--------------------------------------------------
		// Set form action and add to globals array.
		// Uses htmlspecialchars to remove user junk.
		//--------------------------------------------------
		if( isset( $_SERVER['REDIRECT_URL'] ) )
			$GLOBALS['action'] = $_SERVER['REDIRECT_URL'];
		else
			$GLOBALS['action'] = $_SERVER['PHP_SELF'];
	 
		// Clean it up.
		$GLOBALS['action'] = htmlspecialchars( stripslashes( trim( $GLOBALS['action'] ) ) );
	}
	//--------------------------------------------------
	// If form not submitted,
	// set blank $GLOBALS to suppress errors.
	//--------------------------------------------------
	if( $_SERVER['REQUEST_METHOD'] != 'POST' ) {
		$GLOBALS['email'] = $GLOBALS['notify'] = '';
	}
	//--------------------------------------------------
	// Else, form is submitted. Verifiy user.
	//--------------------------------------------------
	else {
		//----------------------------------------------
		// Init and set arrays
		//----------------------------------------------
		
		require_once 'class.variables.php';
		$cv= new _variables();
		if (isset($_REQUEST['ema_email_r'], $_REQUEST['psw_password_r']))
			$cv_array=array('ema_email_r', 'psw_password_r');
		if (isset($_REQUEST['dec_csm_long']))
			$cv_array[]='dec_csm_long';
		if (isset($_REQUEST['dec_csm_lat']))
			$cv_array[]='dec_csm_lat';
		if (isset($_REQUEST['wnu_mall_id']))
			$cv_array[]='wnu_mall_id';
		if (isset($_REQUEST['wns_facebookID']))
			$cv_array[]='wns_facebookID';
		foreach($cv_array as $name=>$value) $cv->varible_in($value);
		$clean=$cv->get_cleaned_variables();
		$errors=$cv->get_bad_variables();	    
		//----------------------------------------------
		// Error check. Send notifications.
		//----------------------------------------------
		if( !empty( $errors ) ) {
			// hide this unless the form was submitted.
			if( isset( $_REQUEST['submit'] ) )
				$GLOBALS['notify'] = $errors;
			else
				$GLOBALS['notify'] = '';		
		}
		//----------------------------------------------
		// Else, no errors. Proceed.
		//----------------------------------------------
		else {
			//------------------------------------------
			// Where are we comming and going?
			//------------------------------------------
			if (isset($_REQUEST['submit'])){
			 $submit_Path=$_REQUEST['submit'];
			}
			
			if (isset($clean['mall_id'])){
			  //check if we have the mall registered
			  $dbo = connect();
			  $qryMall = $dbo->prepare( "SELECT mall_id FROM `tbl_mall` WHERE mall_lss_id=:id LIMIT 1" );
			  $qryMall->bindValue(':id', $clean['mall_id'], PDO::PARAM_INT);
			  $qryMall->execute();
			  if ($qryMallRes = $qryMall->fetch( PDO::FETCH_ASSOC ))
			   $_SESSION['user']['consumer']['mall_id']=$qryMallRes['mall_id'];		   
			 }
		 
			unset($_SESSION["api_key"]);
			switch( $submit_Path ) {
				case '/mystore/login.php': 
					$table    = 'lt_member_merchants';
					$prefix   = 'ltb';
					$login    = 'merchant';
					$redirect = 'mystore/';
					break;
				case '/admin/login.php':
					$table    = 'tbl_admin';
					$prefix   = 'adm';
					$login    = 'admin';
					$redirect = 'admin';
					break;
				case '/start':
					$table  = 'tbl_consumer';
					$prefix = 'csm';
					$login  = 'consumer';
					$redirect = '';
					break;
				case '/guest':
					$table  = 'tbl_consumer';
					$prefix = 'csm';
					$login  = 'consumer';
					$redirect = '';
					$clean['email']='guest@loyaltysuperstore.com';
					$clean['password']='guest';
					break;
				default:
					$table = $prefix = false;
					break;
			}
			
			//------------------------------------------
			// Database check.
			//------------------------------------------
			if( $table ) {
				$dbo = connect();
				$sql='SELECT * FROM `'.$table.'` WHERE '.$prefix.'_email LIKE :email AND '.$prefix.'_active=1 LIMIT 1';
				$qry = $dbo->prepare( $sql );
				$qry->bindValue(':email', $clean['email'], PDO::PARAM_STR);
				$qry->execute();
				$usr = $qry->fetchAll( PDO::FETCH_ASSOC );
			}
			else {
				$GLOBALS['notify'] = array( 'Please contact the web administrator.' );
			}
			//------------------------------------------
			// Did we find a user in the database?
			//------------------------------------------
			if( !isset( $usr ) || empty( $usr ) ) {
				$GLOBALS['notify'] = array( 'The email or password you have entered is invalid. Please Try Again' );
			}
			else {
				require_once 'model/crypt.php';
				$crypt   = new Crypt( $usr[0]["{$prefix}_email"] );
				$cryptck = $crypt->decode( $usr[0]["{$prefix}_password"] );
				//--------------------------------------
				// User is set, verify password.
				//--------------------------------------
				if( $clean['password'] != $cryptck ) { 
					$GLOBALS['notify'] = array( 'Invalid Password. Please Try Again' );
					//echo var_dump($cryptck);
				}
				else {
					//----------------------------------
					// Add to array.
					//----------------------------------
					$arr["{$prefix}_id"]    = $usr[0]["{$prefix}_id"];
					$arr["{$prefix}_email"] = $usr[0]["{$prefix}_email"];
					//----------------------------------
					// Merchant login. Add to array.
					//----------------------------------
					if( $login == 'merchant' ) {
												
						if ( NEW_DB_SWITCH ) { 
							require_once 'class.member-merchant.php';
							$merchantObj 				 = new App\MemberMerchant\MemberMerchant($dbo, true, $usr[0]['ltb_id'], true);
							$arr['plan'] 				 = $merchantObj->getCurrent('Plan');					
							$arr['ltm_id']               = $merchantObj->getCurrentStore('ltm_id');
							$arr['ltm_company_name']     = $merchantObj->getCurrentStore('ltm_company_name');							
							$tmpMerchantReseller         = $merchantObj->getMerchantReseller( $usr[0]['ltb_id'] );	
							$arr['res_id']               = isset($tmpMerchantReseller['res_id'])?$tmpMerchantReseller['res_id']:0;
							$arr['res_name']             = isset($tmpMerchantReseller['res_name'])?$tmpMerchantReseller['res_name']:'';
							$arr['tmp_id']             = $usr[0]['tmp_id'];
							$arr['promo_count']          = $merchantObj->getTotalActivePromos();
							$arr['date']                 = date( 'm/d/Y' );
		
						}
						else {
							$m = $dbo->prepare( 'SELECT ltm_id,ltm_company_name FROM `lt_merchants` WHERE ltb_id=:id' );
							$m->bindValue( ':id', $usr[0]['ltb_id'], PDO::PARAM_STR );
							$m->execute();
							$merchant = $m->fetchAll( PDO::FETCH_ASSOC );
							$r = $dbo->prepare( 'SELECT res_name FROM `tbl_reseller` WHERE res_id=:id' );
							$r->bindValue( ':id', $usr[0]['res_id'], PDO::PARAM_STR );
							$r->execute();
							$reseller = $r->fetchAll( PDO::FETCH_ASSOC );
							$c = $dbo->prepare( 'SELECT COUNT(ltb_id) FROM `lt_promos` WHERE ltb_id=:id' );
							$c->bindValue( ':id', $usr[0]['ltb_id'], PDO::PARAM_STR );
							$c->execute();
							$count = $c->fetchAll( PDO::FETCH_ASSOC );
							// new plan structure
							$p = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.pty_id, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
							FROM lt_merchant_plans LMP 
							INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
							LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
							WHERE LMP.lmp_id = :lmp_id AND LPF.lpf_active = 1 AND (MFC.ltb_id IS NULL OR MFC.ltb_id = :ltb_id) ORDER BY MFC.ltb_id ASC';
							$p = $dbo->prepare( $p );
							$p->bindValue(':lmp_id', $usr[0]['lmp_id'], PDO::PARAM_INT);
							$p->bindValue(':ltb_id', $usr[0]['ltb_id'], PDO::PARAM_INT);
							$p->execute();
							$p = $p->fetchAll(PDO::FETCH_ASSOC);
							foreach ($p as $k => $v) {
							  if (!$results){
								$results = array(
								  'lmp_id'                => $v['lmp_id'],
								  'pty_id'                => $v['pty_id'],
								  'lmp_name'              => $v['lmp_name']
								);
								$results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
							  } 
							  else {
								// this will overwrite the default plan values with custom merchant values 
								$results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
							  }
							}
							$arr['plan'] = $results;
							$arr['ltm_id']               = $merchant[0]['ltm_id'];
							$arr['ltm_company_name']     = $merchant[0]['ltm_company_name'];
							$arr['res_name']             = $reseller[0]['res_name'];
							$arr['res_id']               = $usr[0]['res_id'];
							$arr['tmp_id']               = $usr[0]['tmp_id'];
							$arr['promo_count']          = $count[0]['COUNT(ltb_id)'];
							$arr['date']                 = date( 'm/d/Y' );	
						}	
					}
					
					//----------------------------------
					// Consumer login. Add to array.
					//----------------------------------
					if ( $login == 'consumer' ) {
							
						if ( isset($_REQUEST['remember_me']) ) {
							setcookie("__ltrm", base64_encode ($usr[0]['csm_email']), time()+3600*24*30, '/');					
						}	
						else{
							setcookie("__ltrm", base64_encode ($usr[0]['csm_email']), time()-1, '/');		
						}	
						
						require_once $_SERVER['DOCUMENT_ROOT'].'/localthanks/app/model/set_localthanks_sessions.php';
						

						if($submit_Path=='/guest'){
			 				$_SESSION['user']['consumer']['csm_lat']=$clean['csm_lat'];			 
             				$_SESSION['user']['consumer']['csm_long']=$clean['csm_long'];
							$_SESSION["user"]["consumer"]["guestlogin"] = true;
             			}

						//facebook
						if (isset($clean['facebookID'])){
							  $dbo = connect();
							  $qryMall = $dbo->prepare( "   INSERT INTO tbl_smedia2consumer (csm_id, s2c_foreign_id, sm_id)
															SELECT * FROM
															(SELECT :id, :smid, sm_id FROM tbl_social_media WHERE sm_name LIKE 'Facebook' LIMIT 1) as temp
															WHERE NOT EXISTS ( SELECT csm_id FROM tbl_smedia2consumer WHERE csm_id=:id )" );
							  $qryMall->bindValue(':id', $arr["csm_id"], PDO::PARAM_INT);
							  $qryMall->bindValue(':smid', $clean['facebookID'], PDO::PARAM_INT);
							  $qryMall->execute();							
						}
						
						set_csm_sessions( $arr["csm_id"] );
						
						//insert into tbl_mall2cons in case the consumer does not belong to this mall yet 
						if ($stmt = $dbo->prepare(" 
							INSERT INTO tbl_mall2cons (mall_id_signup, mall_id_current, csm_id)
							SELECT * FROM (
								SELECT (CASE WHEN M2C1.mall_id_signup IS NULL THEN :mallid ELSE M2C1.mall_id_signup END) AS id1, :mallid AS a, :lssmmbid AS b 
								FROM tbl_mall MALL
								LEFT JOIN (
									SELECT mall_id_signup FROM tbl_mall2cons WHERE csm_id=:lssmmbid LIMIT 1
								) M2C1 ON M2C1.mall_id_signup = MALL.mall_id LIMIT 1								
							) tmp
							WHERE NOT EXISTS (
								SELECT csm_id FROM tbl_mall2cons WHERE mall_id_current=:mallid AND csm_id=:lssmmbid
							)")){
							$stmt->bindValue(':lssmmbid', $usr[0]['csm_id'], PDO::PARAM_INT);
							$stmt->bindValue(':mallid', $_SESSION['user']['consumer']['mall_id'], PDO::PARAM_INT);
							$stmt->execute();					
						}
						
					}

					//----------------------------------
					// Admin login. Add to array.
					//----------------------------------
					if ( $login == 'admin' ) {
						// generate random 255 number key
						$adm_key = '';
						for ($i = 0; $i < 255; $i++) {
						  $adm_key .= mt_rand(0, 9);
						}

						// update tbl_admin adm_key
						$dbo = connect();
					    $qry = $dbo->prepare( "UPDATE `tbl_admin` SET adm_key=:adm_key WHERE adm_id = :id LIMIT 1" );
					    $qry->bindValue(':id', $usr[0]['adm_id'], PDO::PARAM_STR);
					    $qry->bindValue(':adm_key', $adm_key, PDO::PARAM_STR);   
					    $qry = execPDO($qry);
					    
						$arr['adm_key'] = $adm_key;
						$arr['adm_master'] = intval($usr[0]['adm_master']);
						$arr['adm_in_house'] = intval($usr[0]['adm_in_house']);
					}

					//----------------------------------
					// Add to session.
					//----------------------------------
					
					foreach ($arr as $Key=>$Value) {	
					 $_SESSION['user'][$login][$Key] = $Value;
					}
					
					//----------------------------------
					// Update timestamp.
					//----------------------------------
					$update = $dbo->prepare( "UPDATE `{$table}` SET {$prefix}_last_login=NOW()".($table == 'tbl_admin'? ", adm_last_activity = CURRENT_TIMESTAMP":"")." WHERE {$prefix}_id=:id LIMIT 1" );
					$update->bindValue( ":id", $usr[0]["{$prefix}_id"], PDO::PARAM_STR );
					$update->execute();
					
					//----------------------------------
					// Unset global variables used.
					//----------------------------------
					unset( $GLOBALS['email'],
						   $GLOBALS['notify'],
						   $GLOBALS['action'] );
					
					//----------------------------------
					// Redirect to index.php
					//----------------------------------					
					if ( $redirect ){
						$protocol = ( isset( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] != 'off' ) ? 'https' : 'http';
						$url      = "{$protocol}://{$_SERVER['HTTP_HOST']}/{$redirect}";
						header( "Location: {$url}" );
						exit();
					}					
				}
			}
		}
	}
} 
//------------------------------------------------------
// End login function.
//------------------------------------------------------
/* EOF ?> */