<?php

/*****************************************************

 * Prism Pay Options

 * https://www.myprismpay.com/docs

 ***************************************************** 

 * USE * 

 * Set param array with key value.

	// test quicksale

	$arr = array(

		'action' => 'ns_quicksale_cc',

		'subid' => 'LOCAL', //local thanks subID

		'amount' => '2.00',

		'ccname' => 'Tony Test',

		'ccnum' => '5454545454545454',

		'cvv2' => '123',

		'expmon' => '09',

		'expyear' => '2018'

	);



	$pay = _appProcessPayment( $arr );

 *

 * PARAMETERS ****************************************

 * ATSID String(5) None 

 * 	Always ATS Merchant ID, always 5 characters long. 

 *  (atsid)

 * 

 * ATSSubID String(5) None 

 * 	ATS Merchant Sub ID, 5 characters long or empty. 

 *  (subid)

 * 

 * CCName String(32) None *1 

 * 	Credit Card Account Name. 

 *  (ccname)

 * 

 * CCNumber String(32) None * 

 * 	Credit Card Number. 

 *  (ccnum) 

 * 	

 * ExpMonth String(2) None * 

 * 	Credit Card Expiration Month. 

 *  (expmon)

 * 	

 * ExpYear String(4) None * 

 * 	Credit Card Expiration Year. 

 *  (expyear)

 * 	

 * CVV2 String(3) None 

 * 	Credit Card CVV2 Code 

 *  (cvv2)

 * 	

 * CKName String(32) None †2 

 * 	Checking Account Name. 

 *  (ckname)

 * 	

 * CKRoutingNumber String(9) None † 

 * 	Checking Account Routing (ABA) Number, always 

 *  9 digits long. 

 *  (ckaba)

 * 	

 * CKAccountNumber String(18) None † 

 * 	Checking Account Number. 

 *  (ckacct)

 * 	

 * RecurBillingCycle Short Integer 0 •3 

 * 	Billing cycle code for recurring billing. 

 *  (recur_billingcycle)	

 * 	0 = No Recurring Billing Cycle 

 * 	1 = Weekly Recurring Billing Cycle 

 * 	2 = Monthly Recurring Billing Cycle 

 * 	3 = Quarterly Recurring Billing Cycle 

 * 	4 = Semi-Annual Recurring Billing Cycle 

 * 	5 = Annual Recurring Billing Cycle 

 * 	6 = Bi-Weekly Recurring Billing Cycle 

 * 	7 = Bi-Annual Recurring Billing Cycle 

 * 	8 = Quad Weekly (28 day) Recurring Billing Cycle 

 * 	9 = One Time Recurring Billing Cycle 

 * 	10 = Daily Recurring Billing Cycle 

 * 	11 = Bi-Monthly Recurring Billing Cycle

 * 

 * RecurBillingMax Short Integer -1 •

 * 	Maximum number of billing cycles before the 

 *  recurring transaction will automatically be 

 *  deleted. A value of -1 indicates that there is 

 *  no maximum, i.e. billing continues indefinitely. 

 *  (recur_billingmax)

 * 	

 * RecurStart Short Integer -1 • 

 * 	Number of days between the initial transaction,

 *  and the start of the billing cycle. 

 *  (recur_start)

 * 	

 * RecurAmount Short Integer >= 100 0 • 

 * 	The amount that will be charged during each 

 *  recurring billing in cents, i.e. $14.95 is 

 *  specified as 1495. The minimum amount is $1.00

 *  (recur_amount)

 * 

 * Recurringflag Short Integer 0 

 * 	Online Commerce Suite™ Integration Guide Internal 

 * 	recurring billing indicator 

 *  (0 = none, 1 = active)

 * 	

 * Amount Short Integer > 0 0 

 * 	Always The amount to be charged to the credit 

 *  card in cents. 

 *  (amount)

 * 	

 * Currencyode String(3) None 

 * 	Three digit currency code 'USD' for US$ 

 *  (Refer to Appendix: D for complete list)

 * 	

 * Custom1 String(32) None

 * Custom2 String(32) None

 * Custom3 String(32) None

 * Custom4 String(32) None

 * Custom5 String(32) None

 * Custom6 String(32) None

 * 	Custom field for information to be included

 * 

 * CI_CompanyName String(64) None 

 * 	The consumer's company name. 

 *  (ci_companyname)

 * 	

 * CI_BillAddr1 String(64) None 

 * 	AVS4 The consumer's billing address. 

 *  (ci_billaddr1) 

 * 	

 * CI_BillAddr2 String(64) None 

 * 	AVS The consumer's billing address. 

 *  (ci_billaddr2)

 * 	

 * CI_BillAddr3 String(64) None 

 * 	AVS The consumer's billing address. 

 *  (ci_billaddr3)

 * 	

 * CI_BillCity String(32) None 

 * 	AVS The consumer's billing city. 

 *  (ci_billcity)

 * 	

 * CI_BillState String(32) None 

 * 	AVS The consumer's billing state. 

 *  (ci_billstate)

 * 	

 * CI_BillZip String(16) None 

 * 	AVS The consumer's billing zip code. 

 *  (ci_billzip)

 * 	

 * CI_BillCountry String(32) None 

 * 	AVS The consumer's billing country. 

 *  (ci_billcountry)

 * 	

 * CI_ShipAddr1 String(64) None 

 * 	The consumer's shipping address. 

 *  (ci_shipaddr1)

 * 	

 * CI_ShipAddr2 String(64) None 

 * 	The consumer's shipping address. 

 *  (ci_shipaddr2)

 * 	

 * CI_ShipAddr3 String(64) None 

 * 	The consumer's shipping address. 

 *  (ci_shipaddr3)

 * 	

 * CI_ShipCity String(32) None 

 * 	The consumer's shipping city. 

 *  (ci_shipcity)

 * 	

 * CI_ShipState String(32) None 

 * 	The consumer's shipping state. 

 *  (ci_shipstate)

 * 	

 * CI_ShipZip String(16) None 

 * 	The consumer's shipping zip code. 

 *  (ci_shipzip)

 * 	

 * CI_ShipCountry String(32) None 

 * 	The consumer's shipping country. 

 *  (ci_shipcountry)

 * 	

 * CI_Phone String(16) None 

 * 	The consumer's phone number. 

 *  (ci_phone)

 * 	

 * CI_Email String(64) None 

 * 	The consumer's e-mail address. 

 *  (ci_email)

 * 	

 * CI_Memo String(4096) None 

 * 	The consumer's memo. 

 *  (ci_memo)

 * 	

 * CI_DLNum String(32) None 

 * 	The consumer's Drivers License number. 

 *  (ci_dlnum) 

 * 	

 * CI_SSNum String(32) None 

 * 	The consumer's Social Security number. 

 *  (ci_ssnum) 

 * 	

 * CI_IP Address String(16) None  

 * 	The consumer's IP address. 

 *  (ci_ip address)

 * 	

 * CI_BillHouseNumber String(32) None  

 * 	Always Payers House Number 

 *

 * CI_BillStreet String(32) None 

 *  Always Payers Street 

 * 	

 * CI_BillZip4 String(16) None 

 * 	Always Payers zip code. USA ZIP+4 format 

 * 	

 * CI_FirstName String(32) None 

 * 	Always Signatory First Name 

 * 	

 * CI_LastName String(32) None 

 * 	Always Signatory Last Name 

 * 	

 * AccounttypeDesc String(18) None 

 * 	Always ACH account type description 

 * 	

 * AcctName String(32) None 

 * 	Always Consumer name as it appears on 

 *  checking account. 

 * 	

 * ACHTransactionType String(3) None 

 * 	Always SEC code for transaction 

 *

 * AuthenticationModifier Short Integer None 

 *  Authentication of the payer name and address 

 *  can be modified by this field. 

 * 	

 * CkAcctType String(1) None 

 * 	Always "P" - Personal, "B" - Business 

 * 

 * InsuranceModifier Short Integer None 

 *  Insurance that the amount will clear can be 

 *  modified by this field. 

 * 

 * RiskModifier Short Integer None 

 *  Extended risk check of the check routing 

 * 	number and account number can be modified 

 *  by this field. 

 * 	

 * SendDate String(10) None 

 * 	Always The time at which the refund check 

 *  will be printed.

 * 	

 * EmailSubject String(256) None 

 * 	The e-mail message subject of the transaction 

 * 	acknowledgement sent to the consumer. 

 *  (emailsubject) 

 * 	

 * EmailText String(4096) None 

 * 	The e-mail message text of the transaction 

 * 	acknowledgement sent to the consumer. 

 *  (emailtext) 

 * 	

 * MerchantReferrerInfo String(64) None 

 * 	The Merchant Referrer Information. 

 *  (merchantreferrerinfo)

 * 	

 * MerchantOrderNumber String(64) None 

 * 	The Merchant Order Number. If non-empty, 

 *  this must be a value that is unique for the 

 *  ATSID/ATSSubID combination. 

 * 	(merchantordernumber) 

 * 	

 * MerchantOrderType String(64) None 

 * 	The Merchant Order Type. 

 *  (merchantordertype)

 * 	

 * SwipeData String(64) None 

 * 	The swipe data from the magnetic strip on 

 *  the back of a credit or debit card. Used for 

 *  card-present transactions.

 * 	

 * SupplierRefNum String(9) None ◊5 

 * 	A mandatory reference number that helps the 

 *  merchant identify the charge in case of an 

 *  inquiry by the credit card company. 

 *  (supplierrefnum) 

 * 	

 * CardholderRefNum String(17) None ◊ 

 * 	The cardholder reference number. 

 *  (cardholderrefnum) 

 * 	

 * SalesTax Short Integer >= 0 0 ◊ 

 * 	The sales tax amount in cents. 

 *  (salestax) 

 * 	

 * ChargeDescriptor String(40) None ◊ 

 * 	A mandatory free-form field describing the charge. 

 *  (chargedescriptor) 

 * 	

 * OptionalAmountID String(1) None ◊ 

 * 	A code describing the Optional Amount value. 

 *  (optionalamountid) 

 * 	0 = Not used

 * 	1 = Local Sales Tax Amount 

 * 	2 = Tax Exempt 

 * 	

 * OptionalAmount Short Integer >= 0 None ◊ 

 * 	An optional amount as described by the 

 *  OptionalAmountID field. 

 *  (optionalamount) 

 * 	

 * POCustomerRefID String(17) None ◊ 

 * 	A purchase Order Number. 

 *  (pocustomerrefid) 

 * 	

 * ResultAccepted Read-Only Boolean TRUE 

 * 	if the transaction was approved, 

 *  FALSE if it was declined.

 * 	

 * ResultRefCode Read-Only String 

 * 	The reference code of the transaction. 

 * 	

 * ResultOrderID Read-Only String 

 * 	The ATS Order ID assigned to the transaction. 

 * 	

 * ResultTransID Read-Only String 

 * 	The ATS Transaction ID assigned to the transaction. 

 * 	

 * ResultAuthCode Read-Only String 

 * 	The authorization code of the transaction. 

 * 	

 * DevMode Boolean False 

 * 	Determines whether the SecurePost object runs in 

 *  development mode.

 * 	

 * AVSOverride Boolean False 

 * 	Overrides the Address Verification System (AVS) 

 * 	fraud protection, allowing transactions that would 

 * 	ordinarily be declined to be processed anyway.

 * 	

 * ResultErrorFlag Read-Only Short Integer 

 * 	A non-zero value indicates an error occurred during 

 *  processing. LastError Read-Only String A string 

 *  describing the error that occurred.

 * 	

 * TransactionTimeout Short Integer >= 5 & <= 600 300 

 * 	The maximum number of seconds that the SecurePost 

 *  object will wait for a response from the 

 *  authorization network. 

 * 	NOTE: If a reply is not received within the timeout 

 *  period, the SecurePost object will return an error. 

 *  However, the authorizing network may continue to 

 *  process the transaction, and eventually approve or 

 *  decline it. You can retrieve the result later using 

 *  the GetTransactionResult method.

 * 

 *****************************************************/

/** LOCAL THANKS OPTIONS *****************************/

/** SET PAYMENT PLANS ********************************

// Silver annual reoccuring

$silver = array(

	'action' => 'ns_quicksale_cc',

	'amount' => 2400,

	'ccname' => 'Tony Test',

	'ci_companyname' => 'Test Enterprises',

	'ccnum' => 5454545454545454,

	'cvv2' => 123,

	'expmon' => '09',

	'expyear' => '2018',

	'ci_billaddr1' => '123 Main Street',

	'ci_billaddr2' => 'Suite 4',

	'ci_billcity' => 'Gotham',

	'ci_billzip' => '90210',

	'ci_billcountry' => 'USA',

	'ci_email' => 'myTest@email.com',

	'recur_billingcycle' => 5,

	'recur_amount' => 2400,

	'recur_billingmax' => -1,

	'ci_email' => 'myEmail@test.com',

	'emailsubject' => '',

	'emailtext' => '',

);



// Gold annual reoccuring

$gold = array(

	'action' => 'ns_quicksale_cc',

	'amount' => 11400,

	'ccname' => 'Tony Test',

	'ci_companyname' => 'Test Enterprises',

	'ccnum' => 5454545454545454,

	'cvv2' => 123,

	'expmon' => '09',

	'expyear' => '2018',

	'ci_billaddr1' => '123 Main Street',

	'ci_billaddr2' => 'Suite 4',

	'ci_billcity' => 'Gotham',

	'ci_billzip' => '90210',

	'ci_billcountry' => 'USA',

	'ci_email' => 'myTest@email.com',

	'recur_billingcycle' => 2,

	'recur_amount' => 1900,

	'recur_billingmax' => -1,

	'recur_start' => 61,

	'ci_email' => 'myEmail@test.com',

	'emailsubject' => '',

	'emailtext' => '',

);



// Platinum annual reoccuring

$platinum = array(

	'action' => 'ns_quicksale_cc',

	'amount' => 24400,

	'ccname' => 'Tony Test',

	'ci_companyname' => 'Test Enterprises',

	'ccnum' => 5454545454545454,

	'cvv2' => 123,

	'expmon' => '09',

	'expyear' => '2018',

	'ci_billaddr1' => '123 Main Street',

	'ci_billaddr2' => 'Suite 4',

	'ci_billcity' => 'Gotham',

	'ci_billzip' => '90210',

	'ci_billcountry' => 'USA',

	'ci_email' => 'myTest@email.com',

	'recur_billingcycle' => 2,

	'recur_amount' => 4900,

	'recur_billingmax' => -1,

	'recur_start' => 61,

	'ci_email' => 'myEmail@test.com',

	'emailsubject' => '',

	'emailtext' => '',

);

******************************************************/



/*

// Platinum annual reoccuring

$platinum = array(

	'action' => 'ns_quicksale_cc',

	'amount' => 24400,

	'ccname' => 'Tony Test',

	'ci_companyname' => 'Test Enterprises',

	'ccnum' => 5454545454545454,

	'cvv2' => 123,

	'expmon' => '09',

	'expyear' => '2016',

	'ci_billaddr1' => '123 Main Street',

	'ci_billaddr2' => 'Suite 4',

	'ci_billcity' => 'Gotham',

	'ci_billzip' => '90210',

	'ci_billcountry' => 'USA',	

	'recur_billingcycle' => 2,

	'recur_amount' => 4900,

	'recur_billingmax' => -1,

	'recur_start' => 61,

	'ci_email' => 'orlando@loyaltysuperstore.com',

	'emailsubject' => '',

	'emailtext' => '',

);





echo '<pre>';

echo var_dump( _appProcessPayment( $platinum ) );

echo '</pre>';



*/

/*****************************************************

 * Function to process the payment

 *

 * Uses curl, Accepts array with key values.

 * Whereas, the array keys represent the 

 * payment gateway parameters and, the array 

 * values are from the submitted form.

 *****************************************************/

function _appProcessPayment( $arr, $debug = null )

{

	// payment gateway

	$url = 'https://trans.myprismpay.com/cgi-bin/process.cgi';

	

	// PRODUCTION ID - WILL MAKE REAL $$$ PURCHASES

	$id = array( 'acctid' => 'PYYC3' );

	include 'global.php';

	$merchantPin = array('merchantpin' => PRISMPAY_MERCHANT_PIN);

	// DEV ID - WILL MAKE FAKE/TEST PURCHASES, 

	//$id = array( 'acctid' => 'PYDMO' );
	
	//SUB ID LOCAL (localthanks)
	
	$subid = array( 'subid' => 'LOCAL' );

	// old ID from coldfusion

	//$id = array( 'acctid' => '00000' ); 



	// Lets get the IP address of the client 

	// making the purchase.

	$ip = getenv( 'HTTP_CLIENT_IP' ) ? :

		  getenv( 'HTTP_X_FORWARDED_FOR' ) ? :

	      getenv( 'HTTP_X_FORWARDED' ) ? :

	      getenv( 'HTTP_FORWARDED_FOR' ) ? :

	      getenv( 'HTTP_FORWARDED' ) ? :

	      getenv( 'REMOTE_ADDR' );

	$ip = array( 'ci_ip' => $ip );

		  

	// Add ID and IP to array

	$arr = $id + $subid + $ip + $merchantPin + $arr;

	

	// Configure URI string.

	$params = str_replace(' ', '%20',

				implode( '&',

					array_map(

						function ($v, $k) {

							return "$k=$v";

						},

						$arr,

						array_keys( $arr )

					)

				)

			);



	// debug

	if( $debug != null ) {

		return $params;

	}

	else {

		// Process payment gateway

		$ch = curl_init();

		curl_setopt( $ch, CURLOPT_POST, 1 );

		curl_setopt( $ch, CURLOPT_POSTFIELDS, $params );

		curl_setopt( $ch, CURLOPT_URL, $url );

		curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 2 );

		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );

		curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );

		$result = curl_exec( $ch );

		curl_close( $ch );



		// Return false if no result.

		if( $result == '' ) {

			return false;

		}

		// We have a result, so lets make it useful.

		else {

			// Lets clean the response so we can actually use it.

			// Strips html, trims whitespace, and removes duplicates in array.

			$result = array_unique( explode( "\n", trim( strip_tags( $result ) ) ) );

			

			// Create a key value array and remove tabs and line breaks.

			foreach( $result as $val ) {

				list( $k, $v ) = explode( '=', $val );

				$response[ strtolower( $k ) ] = preg_replace( "/\r|\n/", '', $v );

			}

			return $response;

		}

	}

} // end function



/**

 * From loyaltysuperstore.com

 * Prism Pay

 * Coldfusion params excerpt

 *

 * //begin processing credit card

 * chargeCreditCard = new http();

 * chargeCreditCard.setURL('https://trans.myprismpay.com/cgi-bin/process.cgi');

 * chargeCreditCard.setMethod('post');

 * chargeCreditCard.addParam(type='formfield', name='action',     value='ns_quicksale_cc');

 * chargeCreditCard.addParam(type='formfield', name='acctid',     value=''&prismPayID&'');

 * chargeCreditCard.addParam(type='formfield', name='amount',     value=''&numberFormat(total, '0.00')&'');

 * chargeCreditCard.addParam(type='formfield', name='ccname',     value=''&form.firstName & form.lastName&'');

 * chargeCreditCard.addParam(type='formfield', name='ccnum',      value=''&form.ccnum&'');

 * chargeCreditCard.addParam(type='formfield', name='expmon',     value=''&form.ccmon&'');

 * chargeCreditCard.addParam(type='formfield', name='expyear',    value=''&form.ccyear&'');

 * chargeCreditCard.addParam(type='formfield', name='cvv2',       value=''&form.cvv2&'');

 * chargeCreditCard.addParam(type='formfield', name='ci_billzip', value=''&form.zipCode&'');

 * chargeCreditCard = chargeCreditCard.send().getPrefix();

 * chargeCreditCard = lcase(chargeCreditCard.filecontent);

 * accepted = find("accepted",chargeCreditCard);

 * declined = '';

 */

 

/* EOF ?> */