<?php 
/**
 * class.crypt.php
 *
 * Useage:
 * $crypt = new Crypt( $salt );
 * $crypt->encode( $str );
 * $crypt->decode( $str );
 *
 */
class Crypt
{
    private $secured;
    private $iv_size;

	// Construct
	// Accepts salt
    function __construct( $salt )
    {
        $this->iv_size = mcrypt_get_iv_size(
            MCRYPT_RIJNDAEL_128,
            MCRYPT_MODE_CBC
        );
        $this->secured = hash(
            'sha256',
            $salt,
            TRUE
        );
    }

    function encode( $str )
    {
        $iv = mcrypt_create_iv( $this->iv_size );
        return base64_encode(
            $iv . mcrypt_encrypt(
                MCRYPT_RIJNDAEL_128,
                $this->secured,
                $str,
                MCRYPT_MODE_CBC,
                $iv
            )
        );
    }

    function decode( $str )
    {
        $str = base64_decode( $str );
        $iv  = substr(
             $str ,
            0,
            $this->iv_size
        );
        $cipher = substr(
            $str,
            $this->iv_size
        );
        return trim(
            mcrypt_decrypt(
                MCRYPT_RIJNDAEL_128,
                $this->secured,
                $cipher,
                MCRYPT_MODE_CBC,
                $iv
            )
        );
    }
}
// End class
/***************************************************************/
// Uncomment to add encryption manually
// Change and select database and table settings
// Add encryption
//
require_once '../function.connect.php';
//$dbo = connect();

// define variables and set to empty values
$password = $email = $passwordErr = $emailErr = $pw = $usr = '';
$table = 'tbl_consumer';
$prefix = 'csm';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
	
	$crypt = new Crypt( $_POST["email"] );

	if( empty( $_POST["password"] ) )
		$passwordErr = "Password is required";
	else
		$password = $crypt->encode( $_POST["password"] );

   
	if( empty( $_POST["email"] ) ) {
		$emailErr = "Email is required";
	} else {
		$email = $_POST["email"];
		// check if e-mail address is well-formed
		if( !filter_var( $email, FILTER_VALIDATE_EMAIL ) ) {
			$emailErr = "Invalid email format";
		}
	}

	if( $passwordErr != '' && $emailErr != '' ) {
		// update
		$update = $dbo->prepare( "UPDATE `{$table}` SET {$prefix}_password=:pw WHERE {$prefix}_email=:email LIMIT 1" );
		$update->bindValue( ":email", $email, PDO::PARAM_STR );
		$update->bindValue( ":pw", $password, PDO::PARAM_LOB );
		$update->execute();
	
		// Display
		$qry = $dbo->prepare( "SELECT * FROM `{$table}` WHERE {$prefix}_email=:email" );
		$qry->bindValue(':email', $_REQUEST['email'], PDO::PARAM_STR);
		$qry->execute();
		$usr = $qry->fetchAll( PDO::FETCH_ASSOC );
		
		if(!empty( $usr ) ) $pw = $crypt->decode( $usr[0]["{$prefix}_password"] );
	}
}
?>
<!DOCTYPE HTML> 
<html>
<body>
<form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>"> 
   E-mail:<br><input type="text" name="email" value="">
   <span class="error">* <?php echo $emailErr;?></span>
   <br><br>
   Password:<br><input type="text" name="password" value="">
   <span class="error">* <?php echo $passwordErr;?></span>
   <br><br>
   <input type="submit" name="submit" value="Submit"> 
</form>
<h3>Your Input:</h3><br><?php echo $pw; ?><hr>
<?php echo var_dump( $usr ); ?>
</body>
</html>
<?php

/* EOF ?> */