<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Video\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class CompositionOptions {
    /**
     * @param string $status The status
     * @param \DateTime $dateCreatedAfter The date_created_after
     * @param \DateTime $dateCreatedBefore The date_created_before
     * @return ReadCompositionOptions Options builder
     */
    public static function read($status = Values::NONE, $dateCreatedAfter = Values::NONE, $dateCreatedBefore = Values::NONE) {
        return new ReadCompositionOptions($status, $dateCreatedAfter, $dateCreatedBefore);
    }

    /**
     * @param string $audioSources The audio_sources
     * @param string $videoSources The video_sources
     * @param string $videoLayout The video_layout
     * @param string $resolution The resolution
     * @param string $format The format
     * @param integer $desiredBitrate The desired_bitrate
     * @param integer $desiredMaxDuration The desired_max_duration
     * @param string $statusCallback The status_callback
     * @param string $statusCallbackMethod The status_callback_method
     * @return CreateCompositionOptions Options builder
     */
    public static function create($audioSources = Values::NONE, $videoSources = Values::NONE, $videoLayout = Values::NONE, $resolution = Values::NONE, $format = Values::NONE, $desiredBitrate = Values::NONE, $desiredMaxDuration = Values::NONE, $statusCallback = Values::NONE, $statusCallbackMethod = Values::NONE) {
        return new CreateCompositionOptions($audioSources, $videoSources, $videoLayout, $resolution, $format, $desiredBitrate, $desiredMaxDuration, $statusCallback, $statusCallbackMethod);
    }
}

class ReadCompositionOptions extends Options {
    /**
     * @param string $status The status
     * @param \DateTime $dateCreatedAfter The date_created_after
     * @param \DateTime $dateCreatedBefore The date_created_before
     */
    public function __construct($status = Values::NONE, $dateCreatedAfter = Values::NONE, $dateCreatedBefore = Values::NONE) {
        $this->options['status'] = $status;
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
    }

    /**
     * The status
     * 
     * @param string $status The status
     * @return $this Fluent Builder
     */
    public function setStatus($status) {
        $this->options['status'] = $status;
        return $this;
    }

    /**
     * The date_created_after
     * 
     * @param \DateTime $dateCreatedAfter The date_created_after
     * @return $this Fluent Builder
     */
    public function setDateCreatedAfter($dateCreatedAfter) {
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        return $this;
    }

    /**
     * The date_created_before
     * 
     * @param \DateTime $dateCreatedBefore The date_created_before
     * @return $this Fluent Builder
     */
    public function setDateCreatedBefore($dateCreatedBefore) {
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Video.V1.ReadCompositionOptions ' . implode(' ', $options) . ']';
    }
}

class CreateCompositionOptions extends Options {
    /**
     * @param string $audioSources The audio_sources
     * @param string $videoSources The video_sources
     * @param string $videoLayout The video_layout
     * @param string $resolution The resolution
     * @param string $format The format
     * @param integer $desiredBitrate The desired_bitrate
     * @param integer $desiredMaxDuration The desired_max_duration
     * @param string $statusCallback The status_callback
     * @param string $statusCallbackMethod The status_callback_method
     */
    public function __construct($audioSources = Values::NONE, $videoSources = Values::NONE, $videoLayout = Values::NONE, $resolution = Values::NONE, $format = Values::NONE, $desiredBitrate = Values::NONE, $desiredMaxDuration = Values::NONE, $statusCallback = Values::NONE, $statusCallbackMethod = Values::NONE) {
        $this->options['audioSources'] = $audioSources;
        $this->options['videoSources'] = $videoSources;
        $this->options['videoLayout'] = $videoLayout;
        $this->options['resolution'] = $resolution;
        $this->options['format'] = $format;
        $this->options['desiredBitrate'] = $desiredBitrate;
        $this->options['desiredMaxDuration'] = $desiredMaxDuration;
        $this->options['statusCallback'] = $statusCallback;
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
    }

    /**
     * The audio_sources
     * 
     * @param string $audioSources The audio_sources
     * @return $this Fluent Builder
     */
    public function setAudioSources($audioSources) {
        $this->options['audioSources'] = $audioSources;
        return $this;
    }

    /**
     * The video_sources
     * 
     * @param string $videoSources The video_sources
     * @return $this Fluent Builder
     */
    public function setVideoSources($videoSources) {
        $this->options['videoSources'] = $videoSources;
        return $this;
    }

    /**
     * The video_layout
     * 
     * @param string $videoLayout The video_layout
     * @return $this Fluent Builder
     */
    public function setVideoLayout($videoLayout) {
        $this->options['videoLayout'] = $videoLayout;
        return $this;
    }

    /**
     * The resolution
     * 
     * @param string $resolution The resolution
     * @return $this Fluent Builder
     */
    public function setResolution($resolution) {
        $this->options['resolution'] = $resolution;
        return $this;
    }

    /**
     * The format
     * 
     * @param string $format The format
     * @return $this Fluent Builder
     */
    public function setFormat($format) {
        $this->options['format'] = $format;
        return $this;
    }

    /**
     * The desired_bitrate
     * 
     * @param integer $desiredBitrate The desired_bitrate
     * @return $this Fluent Builder
     */
    public function setDesiredBitrate($desiredBitrate) {
        $this->options['desiredBitrate'] = $desiredBitrate;
        return $this;
    }

    /**
     * The desired_max_duration
     * 
     * @param integer $desiredMaxDuration The desired_max_duration
     * @return $this Fluent Builder
     */
    public function setDesiredMaxDuration($desiredMaxDuration) {
        $this->options['desiredMaxDuration'] = $desiredMaxDuration;
        return $this;
    }

    /**
     * The status_callback
     * 
     * @param string $statusCallback The status_callback
     * @return $this Fluent Builder
     */
    public function setStatusCallback($statusCallback) {
        $this->options['statusCallback'] = $statusCallback;
        return $this;
    }

    /**
     * The status_callback_method
     * 
     * @param string $statusCallbackMethod The status_callback_method
     * @return $this Fluent Builder
     */
    public function setStatusCallbackMethod($statusCallbackMethod) {
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Video.V1.CreateCompositionOptions ' . implode(' ', $options) . ']';
    }
}