<?php 
include 'global.php'; // global functions, contains include to function that connects to database

/* Connect */
$dbo = connect();

function getResellerWeeklyReport($resId) {
	$Result = array(0=>array(
		'Company Name',
		'Address',
		'City',
		'State',
		'ZIP Code',
		'Date Registered',
		'Description',
		'Contact Name',
		'Contact Email',
		'Web URL',
		'Category',
		'Phones w/ Extensions',
		'Task List',
		'History'
	));
	$dbo=connect();
	$stmt = $dbo->prepare("
	SELECT DISTINCT
		DATE_FORMAT(CSRTDO.tdo_date,'%b %d %Y') AS tdo_date,
		CSRTDO.tdo_task,
		DATE_FORMAT(CSRNOT.mrh_date,'%b %d %Y') AS mrh_date,
		CSRNOT.mrh_notes,
		PHO.pho_number,
		PHO.pho_extension,
		DATE_FORMAT(CSR.csr_registerdate,'%b %d %Y %h:%i %p') AS csr_registerdate,
		CAT.cat_name,
		CSR.csr_description,
		CSR.csr_web_url,
		CSR.csr_email,
		CSR.csr_contact_name,
		CSR.csr_company_name,
		CSR.csr_id,
		CSR.csr_address,
		CSR.csr_city,
		CSR.csr_state,
		CSR.csr_zipcode 
	FROM tbl_csr_merchant CSR
	LEFT JOIN tbl_csr_phone PHO ON PHO.csr_id=CSR.csr_id
	LEFT JOIN tbl_category CAT ON CAT.cat_id=CSR.cat_id		
	LEFT JOIN
	(
		SELECT CSR1.csr_id, HIST.mrh_notes, HIST.mrh_date
		FROM tbl_csr_merchant CSR1
		INNER JOIN tbl_csr_history HIST ON HIST.csr_id=CSR1.csr_id
		WHERE DATEDIFF( NOW(), HIST.mrh_date ) <= 7
		ORDER BY HIST.mrh_date DESC
	) CSRNOT ON CSRNOT.csr_id = CSR.csr_id
	LEFT JOIN
	(
		SELECT CSR2.csr_id, TODO.tdo_task, TODO.tdo_date
		FROM tbl_csr_merchant CSR2
		INNER JOIN tbl_csr_todo TODO ON TODO.csr_id=CSR2.csr_id
		WHERE DATEDIFF( TODO.tdo_date, NOW() ) >= 0 AND DATEDIFF( TODO.tdo_date, NOW() ) <= 7
		ORDER BY TODO.tdo_date
	) CSRTDO ON CSRTDO.csr_id = CSR.csr_id		
	WHERE res_id=:resId AND CSR.csr_active AND ( CSRNOT.csr_id IS NOT NULL OR CSRTDO.csr_id IS NOT NULL OR DATEDIFF( NOW(), CSR.csr_registerdate ) <= 7 )");
	$stmt->bindValue(':resId', $resId, PDO::PARAM_INT);		
	$stmt->execute();
	while( $tmpResult = $stmt->fetch( PDO::FETCH_ASSOC )) {
		if (!isset($Result[$tmpResult['csr_id']])) {
			$Result[$tmpResult['csr_id']] = array(					
				'Company Name' => isset($tmpResult['csr_company_name'])? '"'.$tmpResult['csr_company_name'].'"' : ' ',
				'Address' => isset($tmpResult['csr_address'])? '"'.$tmpResult['csr_address'].'"' : ' ',
				'City' => isset($tmpResult['csr_city'])? $tmpResult['csr_city'] : ' ',
				'State' => isset($tmpResult['csr_state'])? $tmpResult['csr_state'] : ' ',
				'ZIP Code' => isset($tmpResult['csr_zipcode'])? $tmpResult['csr_zipcode'] : '',
				'Date Registered' => isset($tmpResult['csr_registerdate'])? $tmpResult['csr_registerdate'] : ' ',
				'Description' => isset($tmpResult['csr_description'])? '"'.$tmpResult['csr_description'].'"' : ' ',
				'Contact Name' => isset($tmpResult['csr_contact_name'])? $tmpResult['csr_contact_name'] : ' ',
				'Contact Email' => isset($tmpResult['csr_email'])? $tmpResult['csr_email'] : ' ',
				'Web URL' => isset($tmpResult['csr_web_url'])? $tmpResult['csr_web_url'] : ' ',
				'Category' => isset($tmpResult['cat_name'])? '"'.$tmpResult['cat_name'].'"' : ' ',	
				'Phones w/ Extensions' => array(),
				'Task List' => array(),
				'History' => array()
			);
		}
		
		if (isset($tmpResult['pho_number']) && !isset($Result[$tmpResult['csr_id']]['Phones w/ Extensions'][$tmpResult['pho_number']]))
			$Result[$tmpResult['csr_id']]['Phones w/ Extensions'][$tmpResult['pho_number']] = array();
						
		if ( isset( $tmpResult['pho_number'], $tmpResult['pho_extension'] ) )
			array_push($Result[$tmpResult['csr_id']]['Phones w/ Extensions'][$tmpResult['pho_number']], $tmpResult['pho_extension']);
		
		if ( isset( $tmpResult['tdo_date'], $tmpResult['tdo_task'] ) && !in_array( $tmpResult['tdo_task'] . ', Date: ' . $tmpResult['tdo_date'], $Result[$tmpResult['csr_id']]['Task List'] ) ) {
			array_push($Result[$tmpResult['csr_id']]['Task List'], $tmpResult['tdo_task'] . ', Date: ' . $tmpResult['tdo_date']);
		}
		
		if (isset($tmpResult['mrh_date'], $tmpResult['mrh_notes']) && !in_array($tmpResult['mrh_notes'] . ', Date: ' . $tmpResult['mrh_date'], $Result[$tmpResult['csr_id']]['History']) ) {
			 array_push($Result[$tmpResult['csr_id']]['History'], $tmpResult['mrh_notes'] . ', Date: ' . $tmpResult['mrh_date']);
		}
		
		
		
	}
	
	foreach ( $Result as $k => $v ) {
	
		if ( empty($v['Phones w/ Extensions']) ) {
			$Result[$k]['Phones w/ Extensions'] = ' ';
		}
		else {
			$tmpResultPhone = '';
			
			foreach ( $v['Phones w/ Extensions'] as $k1 => $v1) {
				$tmpResultPhone .= ( empty($tmpResultPhone)? '"' : "\n" ) .  "(" . substr($k1, 0, 3) . ") " . substr($k1, 3, 3) . "-" . substr($k1,6); ;
				$tmpResultExt = '';
				foreach ( $v1 as $k2 => $v2) {
					$tmpResultExt .= ( empty($tmpResultExt)? "\n" . ' Ext: ' : ', ' ) . $v2;
				}	
				$tmpResultPhone .= $tmpResultExt;
			}
			
			$Result[$k]['Phones w/ Extensions'] = $tmpResultPhone . ( empty($tmpResultPhone)? '' : '"' );	
			
		}
		
		if ( empty($v['Task List']) ) {
			$Result[$k]['Task List'] = ' ';
		}
		else {
			$tmpResultTask = '';
			
			foreach ( $v['Task List'] as $k1 => $v1) {
				$tmpResultTask .= ( empty($tmpResultTask)? '"' : "\n" ) . $v1;
			}
			
			$Result[$k]['Task List'] = $tmpResultTask . ( empty($tmpResultTask)? '': '"' );	
		}
		
		if ( empty($v['History']) ) {
			$Result[$k]['History'] = ' ';
		}
		else {
			$tmpResultHistory = '';
			
			foreach ( $v['History'] as $k1 => $v1) {
				$tmpResultHistory .= ( empty($tmpResultHistory)? '"' : "\n" ) . $v1;
			}
			$Result[$k]['History'] = $tmpResultHistory . ( empty($tmpResultHistory)? '': '"');	
		}
		
	}

	$Result = array_values($Result);
	return $Result;
}

/* Get resellers */
$qry = $dbo->prepare( 'SELECT * FROM `tbl_reseller` WHERE res_active' );
$qry=execPDO($qry);
$resellerList = $qry->fetchAll( PDO::FETCH_ASSOC );

if(!empty($resellerList)){			
	foreach ($resellerList as $value) {
	  if ( isset($value['res_email'], $value['res_id']) && !empty($value['res_email'])) {
		  $theResult = getResellerWeeklyReport($value['res_id']);
		  if ( count( $theResult ) > 1 ) {
			  $csvContent = ""; //data:text/csv;charset=utf-8,
			  foreach ($theResult as $infoArray) {
				
				$dataString = '';
				foreach ($infoArray as $v1) {
					$dataString .= (empty($dataString)? '' : ',') . ($v1? $v1 : ' ');
				}
				
				$csvContent .= empty($dataString)? '' : $dataString . "\n";
			  }
				
				/* Email Detials */
			  $mail_to = $value['res_email'];
			  $from_mail = CSR_FORM_EMAIL;
			  $from_name = "Local Thanks";
			  $reply_to = CSR_FORM_EMAIL;
			  $subject = "Weekly Local Thanks leads report - {$value['res_name']}";
			  $message = "Hello\n\nWe have attached for you the weekly Local Thanks leads report.\n\nRegards";
			 
			/* Attachment File */
			  // Attachment location
			  $fileName = 'leads.csv';
			  file_put_contents($fileName, $csvContent);
			  
			  $file_name = $fileName;
			  $path = "";
			   
			  // Read the file content
			  $file = $path.$file_name;
			  $file_size = filesize($file);
			  $handle = fopen($file, "r");
			  $content = fread($handle, $file_size);
			  fclose($handle);
			  $content = chunk_split(base64_encode($content));
			   
			/* Set the email header */
			  // Generate a boundary
			  $boundary = md5(uniqid(time()));
			   
			  // Email header
			  $header = "From: ".$from_name." <".$from_mail.">".PHP_EOL;
			  $header .= "Reply-To: ".$reply_to.PHP_EOL;
			  $header .= "MIME-Version: 1.0".PHP_EOL;
			   
			  // Multipart wraps the Email Content and Attachment
			  $header .= "Content-Type: multipart/mixed; boundary=\"".$boundary."\"".PHP_EOL;
			  $header .= "This is a multi-part message in MIME format.".PHP_EOL;
			  $header .= "--".$boundary.PHP_EOL;
			   
			  // Email content
			  // Content-type can be text/plain or text/html
			  $header .= "Content-type:text/plain; charset=iso-8859-1".PHP_EOL;
			  $header .= "Content-Transfer-Encoding: 7bit".PHP_EOL.PHP_EOL;
			  $header .= "$message".PHP_EOL;
			  $header .= "--".$boundary.PHP_EOL;
			   
			  // Attachment
			  // Edit content type for different file extensions
			  $header .= "Content-Type: application/xml; name=\"".$file_name."\"".PHP_EOL;
			  $header .= "Content-Transfer-Encoding: base64".PHP_EOL;
			  $header .= "Content-Disposition: attachment; filename=\"".$file_name."\"".PHP_EOL.PHP_EOL;
			  $header .= $content.PHP_EOL;
			  $header .= "--".$boundary."--";
			   
			  // Send email
			  if (mail($mail_to, $subject, "", $header)){}
			  unlink($fileName);	
		  }
		  
	  }
	}
}

?>