<?php
/**

*
*	This function accepts a consumer phone number + ID and returns their text message status. 
*   (1)opted-in or (0)opted-out. 
*   If our database does not match the return, we update our database.
*

**/
require_once 'function.connect.php';
require_once 'global.php';

function check_txt_status($phone,$csm_id){
	global $dbo;
	// remove any non-numeric characters
	$phone = preg_replace('/\D/', '', $phone);

	// numbers on Impact Telecoms contact list must start with a '1'
	if ($phone[0]!=='1') {
		$phone = '1'.$phone;
	}

	$email = SMS_TEXT_LOGIN;
	$pass  = SMS_TEXT_PASSWORD;
	$strURL='http://api.impacttext.com/contact_get?username='.$email.'&password='.$pass.'&ANI='.$phone;

	// Get cURL resource
	$curl = curl_init();
	// Set some options - we are passing in a useragent too here
	curl_setopt_array($curl, array(
	    CURLOPT_RETURNTRANSFER => 1,
	    CURLOPT_URL => $strURL
	));
	// Send the request & save response to $resp
	$resp = curl_exec($curl);
	// Close request to clear up some resources
	curl_close($curl);

	$json = json_decode($resp, true);
	
	if (!empty($json['apidata'])){
		$value = $json['apidata'][0];
		switch ($value['status']) {
			case 'O':
				$txt_status = 0;
				break;
			case 'A':
				$txt_status = 1;
				break;
		}
	} else {
		$txt_status = null;
	}

	// get the status we have set in our DB
	$sql = "SELECT csm_txt_status FROM tbl_consumer WHERE csm_id = :csm_id LIMIT 1";
	$stmt = $dbo->prepare($sql);
	$stmt->bindValue(":csm_id", $csm_id, PDO::PARAM_INT);
	$stmt = execPDO($stmt);
	$qry = $stmt->fetchAll(PDO::FETCH_ASSOC);

	// check if it matches the status set in Impact Telecoms list, if not - update our DB
	if ($qry[0]['csm_txt_status'] !== $txt_status){
		$sql = "UPDATE tbl_consumer SET csm_txt_status = :txt_status, csm_txt_status_date = Now() WHERE csm_id = :csm_id LIMIT 1";
		$stmt = $dbo->prepare($sql);
		$stmt->bindValue(":txt_status", $txt_status, PDO::PARAM_INT);
		$stmt->bindValue(":csm_id", $csm_id, PDO::PARAM_INT);
		$stmt = execPDO($stmt);
	}

	return $txt_status;
}
// $txt_status = check_txt_status('5613710891','7');
?>