<?php
// ios.php
// Apple Push Notification Service
//-----------------------------------
// Establish Database Connection and 
// loop thru one at time.
// that is activated via cron command
// ex. command from server
// php ~/public_html/cdn/apns/ios.php
//-----------------------------------
// Database connection
require '../function.connect.php';

$sql = "
	SELECT 
		@cnt:=@cnt+1 queue,
		msg.msg_id,
		usr.csm_id,
		msg.msg_subject,
		DATE_FORMAT(msg.msg_date,'%c/%d/%Y') msg_date,
		usr.csm_device_token
	FROM tbl_messages msg
	INNER JOIN lt_merchants mer ON mer.ltb_id=msg.ltb_id
	LEFT JOIN (
		SELECT
			csm.csm_id,
			csm.ltm_id,
			csm.csm_device_token
		FROM tbl_consumer csm
		INNER JOIN lt_merchants ltm ON ltm.ltm_id=csm.ltm_id
		WHERE csm.csm_active!='0'
	) AS usr ON msg.ltb_id
	CROSS JOIN (SELECT @cnt:=0) i
	WHERE mer.ltm_id=usr.ltm_id
	AND usr.csm_device_token IS NOT NULL 
	AND msg.msg_push IS NOT NULL";

// run the query 	
$qry = connect();
$qry->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );
$qry = $qry->prepare( $sql );
$qry->execute();
$qry = $qry->fetchAll( PDO::FETCH_OBJ );

if( empty( $qry ) ) {
	die("No Messages to Send!\n");
} else {
	// build message queue
	$queue = array();
	$complete = false;
	
	foreach( $qry as $k => $v ) {

		array_push( 
			$queue, array(
				'msg_id' => $v->msg_id,
				'msg_subject' => $v->msg_subject,
				'msg_date' => $v->msg_date,
				'csm_id' => $v->csm_id,
				'csm_device_token' => $v->csm_device_token
			) 
		);

		// iOS developer certificate
		$cert = 'Certificates.pem';
		// iOS Sound clip
		$sound = 'newMessage.wav';
		// private key's passphrase here:
		$passphrase = 'qu!z18prime33localthanks';
		// badge
		$badge = 1;
		// device token here (without spaces):
		$deviceToken = $v->csm_device_token;
		// alert
		$alert = $v->msg_subject;
		
		// open socket
		$ctx = stream_context_create();
		stream_context_set_option($ctx, 'ssl', 'local_cert', $cert);
		stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);
		// Open a connection to the APNS server
		$fp = stream_socket_client(
			'ssl://gateway.sandbox.push.apple.com:2195', 
			$err,
			$errstr, 
			60, 
			STREAM_CLIENT_CONNECT|STREAM_CLIENT_PERSISTENT, 
			$ctx
		);

		if (!$fp)
		exit("Failed to connect: $err $errstr" . PHP_EOL);

		echo 'Connected to APNS' . PHP_EOL;

		// Create the payload body
		$body['aps'] = array(
			'alert' => $alert,
			'badge' => $badge,
			'sound' => $sound
		);
		// Encode the payload as JSON
		$payload = json_encode($body);
		// Build the binary notification
		$msg = chr(0) . pack('n', 32) . pack('H*', $deviceToken) . pack('n', strlen($payload)) . $payload;
		// Send it to the server
		$result = fwrite($fp, $msg, strlen($msg));

		if (!$result)
			echo 'Error, notification not sent' . PHP_EOL . "\n";
		else
			echo 'notification sent!' . PHP_EOL . "\n";

	}
	// Close the connection to the server
	fclose($fp);

	print_r( $queue ); 
	
	if( $complete ) {
		/*
		$sql = "UPDATE";
		$qry = connect();
		$qry->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );
		$qry = $qry->prepare( $sql );
		$qry->execute();
		$qry = $qry->fetchAll( PDO::FETCH_OBJ );
		*/
	}
}


/* EOF ?> 

// device token here (without spaces):
$deviceToken = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx';

// private key's passphrase here:
$passphrase = 'myPrivateKey';

// alert message here:
$message = 'New Push Notification!';

// badge
$badge = 1;

$ctx = stream_context_create();
stream_context_set_option($ctx, 'ssl', 'local_cert', 'ck.pem');
stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);

// Open a connection to the APNS server
$fp = stream_socket_client(
    'ssl://gateway.sandbox.push.apple.com:2195', $err,
    $errstr, 60, STREAM_CLIENT_CONNECT|STREAM_CLIENT_PERSISTENT, $ctx);

if (!$fp)
exit("Failed to connect: $err $errstr" . PHP_EOL);

echo 'Connected to APNS' . PHP_EOL;

// Create the payload body
$body['aps'] = array(
    'alert' => $message,
    'badge' => $badge,
    'sound' => 'newMessage.wav'
);

// Encode the payload as JSON
$payload = json_encode($body);

// Build the binary notification
$msg = chr(0) . pack('n', 32) . pack('H*', $deviceToken) . pack('n', strlen($payload)) . $payload;

// Send it to the server
$result = fwrite($fp, $msg, strlen($msg));

if (!$result)
    echo 'Error, notification not sent' . PHP_EOL;
else
    echo 'notification sent!' . PHP_EOL;

// Close the connection to the server
fclose($fp);
*/
