<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: AutoComplete.php
 *
 * AutoComplete API Class for Localthanks
 * @param zip
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks;
 
class AutoComplete extends Utils
{	
	public $success, $notify, $params, $results;

	const RESULTS_WELCOME ='Hello world! To $_GET started, use params.';
    /*
     *  Build it in the construct
     */
    function __construct() {
    	$this->results = $this->getParams();
    	$this->params = $this->usage();
    }
    
    /*
     * Show usage on no set params.
     */
    private function usage()
    {
		return array(
			'cat' => array(
				'val' => $_REQUEST['cat'], 
				'use' => 'Search by category id. Comma string as list.'
			),
			'term' => array(
				'val' => $_REQUEST['term'], 
				'use' => 'Search term by category, names, businesess, and zip code.'
			),
			'zip' => array(
				'val' => $_REQUEST['zip'],
				'use' => 'Search by zip code.'
			),
			'place_id' => array(
				'val' => $_REQUEST['place_id'],
				'use' => 'Search for id by google place id.'
			)
		);
    }
      
    /*
     * Check params
     */
	const SQL_AUTO = "
		SELECT DISTINCT
			category.cat_id,
			REPLACE(category.cat_name,'–','-') name,
			LOWER(IF(category.cat_slug IS NULL OR category.cat_slug='',REPLACE(REPLACE(REPLACE(REPLACE(category.cat_name,',',''),' – ',' '),'&','and'),' ','-'),category.cat_slug)) slug,
			parent.cat_id parent_id
		FROM tbl_category AS category
		LEFT JOIN tbl_category AS parent 
			ON category.cat_parent_id=parent.cat_id
		WHERE  category.cat_local=1
		AND category.cat_id LIKE :id
		AND category.cat_active!=0 
		ORDER BY category.cat_name";
		
	const SQL_AUTO_MERCHANT = '
		SELECT 
			ltm_id,
			TRIM(ltm_company_name) name,
			ltm_zipcode zip,
			IFNULL(ltm_google_id,"") place_id
		FROM lt_merchants 
		WHERE ltm_active!=0 ';
	const SQL_AUTO_LIKE_NAME = 'ltm_company_name LIKE :name ';
	const SQL_AUTO_LIKE_ZIP  = 'ltm_zipcode LIKE :zip ';
	const SQL_AUTO_LIKE_PID  = 'ltm_google_id LIKE :place_id ';
				
    private function getParams()
    {
    	$dbo = static::connect();
		$results = array();

    	if( $_REQUEST['cat'] || $_REQUEST['term'] ) 
    	{				
			$cat = array();
			foreach( explode( ',', $_REQUEST['cat'] ) as $id ) {			
				$qry = $dbo->prepare( static::SQL_AUTO );
				$qry->bindValue( ':id', $id );
				$qry->execute();
				$arr = $qry->fetchAll( \PDO::FETCH_OBJ );
				if( $arr ) array_push( $cat, $arr[0] );
			}

			$c = count( $cat );
			if( $c > 0 )
				for( $i=0; $i < $c; $i++) 
					array_push( $results, $cat[$i] );
		}

		
    	if( $_REQUEST['term'] ) 
    	{
			// Category term search
			$qry = $dbo->prepare( str_replace( 'cat_id LIKE :id', 'cat_name LIKE :name', static::SQL_AUTO ) );
			$qry->bindValue( ':name', $_REQUEST['term'].'%', \PDO::PARAM_STR );
			$qry->execute();
			$cat = $qry->fetchAll( \PDO::FETCH_OBJ );
			$c   = count( $cat );
			if( $c > 0 )
				for( $i=0; $i < $c; $i++ ) 
					array_push( $results, $cat[$i] );
					
			// Merchant term search
			$qry = $dbo->prepare( static::SQL_AUTO_MERCHANT.'AND '.static::SQL_AUTO_LIKE_NAME.'OR '.static::SQL_AUTO_LIKE_ZIP );
			$qry->bindValue( ':name', '%'.$_REQUEST['term'].'%', \PDO::PARAM_STR );
			$qry->bindValue( ':zip',      $_REQUEST['term'].'%', \PDO::PARAM_STR );
			$qry->execute();
			$trm = $qry->fetchAll( \PDO::FETCH_OBJ );
			$c   = count( $trm );
			if( $c > 0 )
				for( $i=0; $i < $c; $i++ ) 
					array_push( $results, $trm[$i] );
		}
		
		if( $_REQUEST['zip'] ) 
		{			
			$qry = $dbo->prepare( static::SQL_AUTO_MERCHANT.'AND '.static::SQL_AUTO_LIKE_ZIP );
			$qry->bindValue( ':zip', $_REQUEST['zip'].'%', \PDO::PARAM_STR );
			$qry->execute();
			$zip = $qry->fetchAll( \PDO::FETCH_OBJ );
			
			$c = count( $zip );
			if( $c > 0 )
				for( $i=0; $i < $c; $i++ ) 
					array_push( $results, $zip[$i] );
		}
		
		// Get ltm_id by place_id
		if( $_REQUEST['place_id'] ) 
		{
			$qry = $dbo->prepare( static::SQL_AUTO_MERCHANT.'AND '.static::SQL_AUTO_LIKE_PID );
			$qry->bindValue( ':place_id', $_REQUEST['place_id'], \PDO::PARAM_STR );
			$qry->execute();
			$pid = $qry->fetchAll( \PDO::FETCH_OBJ );
			
			$c = count( $pid );
			if( $c > 0 )
				for( $i=0; $i < $c; $i++) 
					array_push( $results, $pid[$i] );
		}
		
		// Empty and duplicate check
		$final = array();
		$count = count( $results );
		if( $count > 0 ) {
			$this->success = true;
			$this->notify  = static::RESULTS_YES;
			
			foreach($results as $current)
    			if( !in_array($current, $final))
        			$final[] = $current;
		}
		else {
			$this->notify = ( !$GET ) ? static::RESULTS_WELCOME : static::RESULTS_NO;
		}

    	return $final;
    }
}

#EOF ?>