<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: Category.php
 *
 * Category API Class for Localthanks
 * @param cat
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks;

class Category extends Utils
{	
	public $current, $groups;
	
	const SQL_CATEGORIES = "
		SELECT DISTINCT
			cat_id id, 
			REPLACE(cat_name,'–','-') name,
			LOWER(IF(cat_slug IS NULL OR cat_slug='',REPLACE(REPLACE(REPLACE(REPLACE(cat_name,',',''),' – ',' '),'&','and'),' ','-'),cat_slug)) slug,
			cat_parent_id parent_id
		FROM tbl_category 
		WHERE cat_parent_id=:id 
		AND cat_local=1
		AND cat_active !=0
		ORDER BY cat_name";
	
    /*
     *  Build it in the construct
     */
    function __construct( $cat=null ) {
    	$this->current = static::getCurrent( $cat );
    	$this->groups  = static::getTopLevel();
    }
    
    private function getTopLevel()
    {		
    	$grp = array();
		$dbo = static::connect();
		$qry = $dbo->prepare( static::SQL_CATEGORIES );
		$qry->bindValue( ':id', 0 );
		$qry->execute();
		$cat = $qry->fetchAll( \PDO::FETCH_OBJ );

		foreach( $cat as $v ) {
			$qry = $dbo->prepare( static::SQL_CATEGORIES );
			$qry->bindValue( ':id', $v->id );
			$qry->execute();
			$all = $qry->fetchAll( \PDO::FETCH_OBJ );
				
			$str = "{$v->id}";
			foreach( $all as $id ) 
			$str.= "," . $id->id; 
				
			$arr = (object) array( 
					'id' => $v->id, 
					'name' => $v->name, 
					'slug' => $v->slug,
					'list' => $str, 
					'children' => $all 
			);
			array_push( $grp, $arr );
 		}
 		
		return $grp;
    }
    
    /*
     * Function to get category slugs from ID
     * @string = cat ID list
     */
    public function getCurrent( $cat=null )
    {
    	$cur = array();
    	$cat = explode(',', (( $cat ) ? $cat : static::getCat() ));
		$dbo = static::connect();
		$sql = str_replace('cat_parent_id=:id','cat_id=:id', static::SQL_CATEGORIES);

		foreach( $cat as $v ) {
			$qry = $dbo->prepare( $sql );
			$qry->bindValue( ':id', $v );
			$qry->execute();
			$res = $qry->fetchAll( \PDO::FETCH_OBJ );
			array_push( $cur, $res[0] );
		}

		return $cur;
	}
}

#EOF ?>