<?php

/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: Connection.php
 *
 * Database Connection Manager
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

namespace Localthanks;

class Connection
{
	// Data base object
	public function connect()
	{

		$host = 'localhost';
		$name = 'localthanks_db1';
		$user = 'localthanks_dbuser';
		$pass = 'UON)X65NTEItyTv%LU'; //x%2,Lwe(%CAltG=AqE


		// PDO Database Class
		try {
			// MS SQL Server and Sybase with PDO_DBLIB
			//$dbo = new \PDO("mssql:host=$host;dbname=$name,$user,$pass");
			//$dbo = new \PDO("sybase:host=$host;dbname=$name,$user,$pass");

			// MySQL with PDO_MYSQL
			$dbo = new \PDO("mysql:host=$host;dbname=$name;charset=utf8;", $user, $pass);

			// SQLite Database
			//$dbo = new \PDO("sqlite:my/database/path/database.db");

			// Checks for prepared statment errors
			$dbo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
			$dbo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, false);

			//echo 'Good Morning, Dave.';
			return $dbo;
		} catch (\PDOException $e) {
			$dbo = false; // empty database object
			//echo "I'm sorry, Dave. I'm afraid I can't do that.\n".$e->getMessage()."\n";
			file_put_contents('error_pdo', $e->getMessage() . "\n", FILE_APPEND);
			return false;
		}
	}

	// Routine
	// Common database return obj
	public function prepBindFetchObj($sql, $params)
	{
		$dbo = static::connect();
		$qry = $dbo->prepare($sql);
		foreach ($params as $k => $v)
			$qry->bindValue(":$k", $v);
		$qry->execute();
		return $qry->fetchAll(\PDO::FETCH_OBJ);
	}
}

# EOF 