<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: Crypt.php
 *
 * Uses ol reliable MCRYPT
 * Rijndael Encryption/Decryption Class
 *
 * Depreciation Notice:
 * "libmcrypt" is now unsupported and aging.
 *
 * If OpenSSL is installed on the server,
 * for starting a new project, start using
 * class OpenSSLCrypt. Else mcrypt would still
 * work because its everywhere. 
 * OpenSSL is better.
 *
 * Also, keep in mind that when you're dealing with 
 * hashing and/or encryption speed is not your friend.
 * 
 * The reason for that is simple: 
 * if it's fast, it's faster to crack!
 * 
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks;

// note:
// This library is unsafe because it 
// does not MAC (Message Authentication Code) 
// after encrypting.
//
// Encrypt then MAC!
//
class OpenSSLCrypt
{
	private $securekey;
	
    const METHOD = 'aes-256-cbc';
    const METHOD_ERROR = 'Needs a 256-bit key!';
    
    function __construct($textkey)
    {
        $this->securekey = hash(
        //
        // To see available on server:
		// @//devlocalthanks/public_html/cdn$ php crypt.hash.algorithms.php
		// Run...
		// foreach ( hash_algos() as $v ) { 
		//   $r = hash($v, "hello", false); 
		//   printf("%-12s %3d %s\n", $v, strlen($r), $r); 
		// } 
		// Results ==========bit=Hash of string "hello"==========
		//'md2', //           32 a9046c73e00331af68917d3804f70655
		//'md4', //           32 866437cb7a794bce2b727acc0362ee27
		//'md5', //           32 5d41402abc4b2a76b9719d911017c592
		//'sha1', //          40 aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d
		//'sha224', //        56 ea09ae9cc6768c50fcee903ed054556e5bfc8347907f12598aa24193
		
		'sha256', //        64 2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824
		
		//'sha384', //        96 59e1748777448c69de6b800d7a33bbfb9ff1b463e44354c3553bcdb9c666fa90125a3c79f90397bdf5f6a13de828684f
		//'sha512', //       128 9b71d224bd62f3785d96d46ad3ea3d73319bfbc2890caadae2dff72519673ca72323c3d99ba5c11d7c7acc6e14b8c5da0c4663475c2e5c3adef46f73bcdec043
		//'ripemd128', //     32 789d569f08ed7055e94b4289a4195012
		//'ripemd160', //     40 108f07b8382412612c048d07d13f814118445acd
		//'ripemd256', //     64 cc1d2594aece0a064b7aed75a57283d9490fd5705ed3d66bf9adfe3a58b25de5
		//'ripemd320', //     80 eb0cf45114c56a8421fbcb33430fa22e0cd607560a88bbe14ce70bdf59bf55b11a3906987c487992
		//'whirlpool', //    128 0a25f55d7308eca6b9567a7ed3bd1b46327f0f1ffdc804dd8bb5af40e88d78b88df0d002a89e2fdbd5876c523f1b67bc44e9f87047598e7548298ea1c81cfd73
		//'tiger128,3', //    32 2cfd7f6f336288a7f2741b9bf874388a
		//'tiger160,3', //    40 2cfd7f6f336288a7f2741b9bf874388a54026639
		//'tiger192,3', //    48 2cfd7f6f336288a7f2741b9bf874388a54026639cadb7bf2
		//'tiger128,4', //    32 e8e50e239f932a1c357194e5ead0f528
		//'tiger160,4', //    40 e8e50e239f932a1c357194e5ead0f528dc2aebfe
		//'tiger192,4', //    48 e8e50e239f932a1c357194e5ead0f528dc2aebfeaed01c74
		//'snefru', //        64 7c5f22b1a92d9470efea37ec6ed00b2357a4ce3c41aa6e28e3b84057465dbb56
		//'snefru256', //     64 7c5f22b1a92d9470efea37ec6ed00b2357a4ce3c41aa6e28e3b84057465dbb56
		//'gost', //          64 a7eb5d08ddf2363f1ea0317a803fcef81d33863c8b2f9f6d7d14951d229f4567
		//'adler32', //        8 062c0215
		//'crc32', //          8 3d653119
		//'crc32b', //         8 3610a686
		//'fnv132', //         8 b6fa7167
		//'fnv164', //        16 7b495389bdbdd4c7
		//'joaat', //          8 c8fd181b
		//'haval128,3', //    32 85c3e4fac0ba4d85519978fdc3d1d9be
		//'haval160,3', //    40 0e53b29ad41cea507a343cdd8b62106864f6b3fe
		//'haval192,3', //    48 bfaf81218bbb8ee51b600f5088c4b8601558ff56e2de1c4f
		//'haval224,3', //    56 92d0e3354be5d525616f217660e0f860b5d472a9cb99d6766be90b15
		//'haval256,3', //    64 26718e4fb05595cb8703a672a8ae91eea071cac5e7426173d4c25a611c4b8022
		//'haval128,4', //    32 fe10754e0b31d69d4ece9c7a46e044e5
		//'haval160,4', //    40 b9afd44b015f8afce44e4e02d8b908ed857afbd1
		//'haval192,4', //    48 ae73833a09e84691d0214f360ee5027396f12599e3618118
		//'haval224,4', //    56 e1ad67dc7a5901496b15dab92c2715de4b120af2baf661ecd9266317
		//'haval256,4', //    64 2d39577df3a6a63168826b2a10f07a65a676f5776a0772e0a877e27ec3c4c0ad
		//'haval128,5', //    32 d20e920d5be9d9d34855accb501d1987
		//'haval160,5', //    40 dac5e2024bfea142e53d1422b90c9ee2c8187cc6
		//'haval192,5', //    48 bbb99b1e989ec3174019b20792fd92dd67175c2ff6ce5965
		//'haval224,5', //    56 aa6551d75e33a9c5cd4141e9a068b1fc7b6d847f85c3ab1629578ed3
		//'haval256,5', //    64 348298791817d5088a6de6c1b6364756d404a50bd64e645035f8cd4291c482c7
        $textkey,
        TRUE
        );
    }
    public static function encode($message)
    {
        if (mb_strlen($this->securekey, '8bit') !== 32) {
            throw new Exception(static::METHOD_ERROR);
        }
        $ivsize = openssl_cipher_iv_length(self::METHOD);
        $iv = openssl_random_pseudo_bytes($ivsize);
        
        $ciphertext = openssl_encrypt(
            $message,
            self::METHOD,
            $this->securekey,
            OPENSSL_RAW_DATA,
            $iv
        );
        
        return $iv.$ciphertext;
    }

    public static function decode($message)
    {
        if (mb_strlen($this->securekey, '8bit') !== 32) {
            throw new Exception(static::METHOD_ERROR);
        }
        $ivsize = openssl_cipher_iv_length(self::METHOD);
        $iv = mb_substr($message, 0, $ivsize, '8bit');
        $ciphertext = mb_substr($message, $ivsize, null, '8bit');
        
        return openssl_decrypt(
            $ciphertext,
            self::METHOD,
            $this->securekey,
            OPENSSL_RAW_DATA,
            $iv
        );
    }
}


// Old MCRYPT

class Crypt
{
    private $securekey;
    private $iv_size;

    function __construct($textkey)
    {
        // Size
        $this->iv_size = mcrypt_get_iv_size(
        // If these settings change, please update
        // the encode() and decode() functions 
        // to reflect these settings.
        //
        // 1) Block Size:
        //
        // All variants of AES use a 128-bit block size with 
        // varying key lengths (128, 192, or 256). This means 
        // that MCRYPT_RIJNDAEL_128 is the only correct choice 
        // if you want AES.
        MCRYPT_RIJNDAEL_128,
        // The other options refer to non-standard, 
        // less-studied variants of the Rijndael block 
        // cipher that operate on larger blocks.
		//MCRYPT_RIJNDAEL_192, 
		//MCRYPT_RIJNDAEL_256,
		//
		//
        // 2) Available AES Encryption Modes:
        //
        // MCRYPT_MODE_ECB (electronic codebook) 
        // is suitable for random data, such as encrypting 
        // other keys. Since data there is short and random, 
        // the disadvantages of ECB have a favorable negative 
        // effect.
        //
        MCRYPT_MODE_CBC // (cipher block chaining)
        // is especially suitable for encrypting files where 
        // the security is increased over ECB significantly.
        //
        //MCRYPT_MODE_CFB // (cipher feedback) 
        // is the best mode for encrypting byte streams 
        // where single bytes must be encrypted.
        //
        //MCRYPT_MODE_OFB // (output feedback, in 8bit) 
        // is comparable to CFB, but can be used in applications 
        // where error propagation cannot be tolerated. It's 
        // insecure (because it operates in 8bit mode) so it 
        // is not recommended to use it.
        //
        //MCRYPT_MODE_NOFB // (output feedback, in nbit) 
        // is comparable to OFB, but more secure because it 
        // operates on the block size of the algorithm.
        // 
        //MCRYPT_MODE_STREAM // is an extra mode to include 
    	// some stream algorithms like "WAKE" or "RC4".
        //
        // Some other mode and random device constants:
        //MCRYPT_ENCRYPT     // (integer)
        //MCRYPT_DECRYPT     // (integer)
        //MCRYPT_DEV_RANDOM  // (integer)
        //MCRYPT_DEV_URANDOM // (integer)
        //MCRYPT_RAND        // (integer)
        );
        
        // Simple hash encryption layer
        $this->securekey = hash(
        //
        // To see available on server:
		// @//devlocalthanks/public_html/cdn$ php crypt.hash.algorithms.php
		// Run...
		// foreach ( hash_algos() as $v ) { 
		//   $r = hash($v, "hello", false); 
		//   printf("%-12s %3d %s\n", $v, strlen($r), $r); 
		// } 
		// Results ==========bit=Hash of string "hello"==========
		//'md2', //           32 a9046c73e00331af68917d3804f70655
		//'md4', //           32 866437cb7a794bce2b727acc0362ee27
		//'md5', //           32 5d41402abc4b2a76b9719d911017c592
		//'sha1', //          40 aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d
		//'sha224', //        56 ea09ae9cc6768c50fcee903ed054556e5bfc8347907f12598aa24193
		
		'sha256', //        64 2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824
		
		//'sha384', //        96 59e1748777448c69de6b800d7a33bbfb9ff1b463e44354c3553bcdb9c666fa90125a3c79f90397bdf5f6a13de828684f
		//'sha512', //       128 9b71d224bd62f3785d96d46ad3ea3d73319bfbc2890caadae2dff72519673ca72323c3d99ba5c11d7c7acc6e14b8c5da0c4663475c2e5c3adef46f73bcdec043
		//'ripemd128', //     32 789d569f08ed7055e94b4289a4195012
		//'ripemd160', //     40 108f07b8382412612c048d07d13f814118445acd
		//'ripemd256', //     64 cc1d2594aece0a064b7aed75a57283d9490fd5705ed3d66bf9adfe3a58b25de5
		//'ripemd320', //     80 eb0cf45114c56a8421fbcb33430fa22e0cd607560a88bbe14ce70bdf59bf55b11a3906987c487992
		//'whirlpool', //    128 0a25f55d7308eca6b9567a7ed3bd1b46327f0f1ffdc804dd8bb5af40e88d78b88df0d002a89e2fdbd5876c523f1b67bc44e9f87047598e7548298ea1c81cfd73
		//'tiger128,3', //    32 2cfd7f6f336288a7f2741b9bf874388a
		//'tiger160,3', //    40 2cfd7f6f336288a7f2741b9bf874388a54026639
		//'tiger192,3', //    48 2cfd7f6f336288a7f2741b9bf874388a54026639cadb7bf2
		//'tiger128,4', //    32 e8e50e239f932a1c357194e5ead0f528
		//'tiger160,4', //    40 e8e50e239f932a1c357194e5ead0f528dc2aebfe
		//'tiger192,4', //    48 e8e50e239f932a1c357194e5ead0f528dc2aebfeaed01c74
		//'snefru', //        64 7c5f22b1a92d9470efea37ec6ed00b2357a4ce3c41aa6e28e3b84057465dbb56
		//'snefru256', //     64 7c5f22b1a92d9470efea37ec6ed00b2357a4ce3c41aa6e28e3b84057465dbb56
		//'gost', //          64 a7eb5d08ddf2363f1ea0317a803fcef81d33863c8b2f9f6d7d14951d229f4567
		//'adler32', //        8 062c0215
		//'crc32', //          8 3d653119
		//'crc32b', //         8 3610a686
		//'fnv132', //         8 b6fa7167
		//'fnv164', //        16 7b495389bdbdd4c7
		//'joaat', //          8 c8fd181b
		//'haval128,3', //    32 85c3e4fac0ba4d85519978fdc3d1d9be
		//'haval160,3', //    40 0e53b29ad41cea507a343cdd8b62106864f6b3fe
		//'haval192,3', //    48 bfaf81218bbb8ee51b600f5088c4b8601558ff56e2de1c4f
		//'haval224,3', //    56 92d0e3354be5d525616f217660e0f860b5d472a9cb99d6766be90b15
		//'haval256,3', //    64 26718e4fb05595cb8703a672a8ae91eea071cac5e7426173d4c25a611c4b8022
		//'haval128,4', //    32 fe10754e0b31d69d4ece9c7a46e044e5
		//'haval160,4', //    40 b9afd44b015f8afce44e4e02d8b908ed857afbd1
		//'haval192,4', //    48 ae73833a09e84691d0214f360ee5027396f12599e3618118
		//'haval224,4', //    56 e1ad67dc7a5901496b15dab92c2715de4b120af2baf661ecd9266317
		//'haval256,4', //    64 2d39577df3a6a63168826b2a10f07a65a676f5776a0772e0a877e27ec3c4c0ad
		//'haval128,5', //    32 d20e920d5be9d9d34855accb501d1987
		//'haval160,5', //    40 dac5e2024bfea142e53d1422b90c9ee2c8187cc6
		//'haval192,5', //    48 bbb99b1e989ec3174019b20792fd92dd67175c2ff6ce5965
		//'haval224,5', //    56 aa6551d75e33a9c5cd4141e9a068b1fc7b6d847f85c3ab1629578ed3
		//'haval256,5', //    64 348298791817d5088a6de6c1b6364756d404a50bd64e645035f8cd4291c482c7
        $textkey,
        TRUE
        );
    }

    function encode($input)
    {
        $iv = mcrypt_create_iv($this->iv_size);
        return base64_encode(
            $iv . mcrypt_encrypt(
                MCRYPT_RIJNDAEL_128,
                $this->securekey,
                $input,
                MCRYPT_MODE_CBC,
                $iv
            )
        );
    }

    function decode($input)
    {
        $input = base64_decode($input);
        $iv = substr(
            $input,
            0,
            $this->iv_size
        );
        $cipher = substr(
            $input,
            $this->iv_size
        );
        return trim(
            mcrypt_decrypt(
                MCRYPT_RIJNDAEL_128,
                $this->securekey,
                $cipher,
                MCRYPT_MODE_CBC,
                $iv
            )
        );
    }
}

# EOF ?>