<?php

namespace Localthanks;

interface DatabaseOptions
{
	public function query($query);
	public function execute();
	public function bind($param, $val, $type = null);
	public function result($arr = null);
	public function single($arr = null);
	public function rowCount();
	public function lastInsertId();
	public function beginTransaction();
	public function endTransaction();
	public function cancelTransaction();
	public function debugDumpParams();
}

class Database implements DatabaseOptions
{
	private $dbh, $error, $stmt;

	public function __construct()
	{
		// Production
		$HOST = 'localhost';
		$NAME = 'localthanks_db1';
		$USER = 'localthanks_dbuser';
		$PASS = 'UON)X65NTEItyTv%LU'; //x%2,Lwe(%CAltG=AqE

		// Set DSN
		$dsn = "mysql:host=$HOST;dbname=$NAME;port=3306;charset=utf8;";

		// Set options
		$options = array(
			\PDO::ATTR_PERSISTENT                => 1,
			//\PDO::ATTR_EMULATE_PREPARES        =>1,  // try not to use, its ok but could open a door in certain situations
			\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY  => 1,
			//\PDO::MYSQL_ATTR_INIT_COMMAND      =>'SET CHARACTER SET utf8, NAMES utf8',
			//\PDO::ATTR_DEFAULT_FETCH_MODE      =>\PDO::FETCH_NUM,
			\PDO::ATTR_ERRMODE                   => \PDO::ERRMODE_EXCEPTION  // common error 
		);
		// Create a new PDO instanace
		try {
			$this->dbh = new \PDO($dsn, $USER, $PASS, $options);
		}
		// Catch any errors
		catch (\PDOException $e) {
			$this->error = $e->getMessage();
		}
	}

	public function query($query)
	{
		$this->stmt = $this->dbh->prepare($query);
	}
	public function execute()
	{
		return $this->stmt->execute();
	}

	public function bind($param, $val, $type = null)
	{
		if (is_null($type)) {
			switch (true) {
				case is_int($val):
					$type = \PDO::PARAM_INT;
					break;
				case is_bool($val):
					$type = \PDO::PARAM_BOOL;
					break;
				case is_null($val):
					$type = \PDO::PARAM_NULL;
					break;
				default:
					$type = \PDO::PARAM_STR;
			}
		}
		$this->stmt->bindValue($param, $val, $type);
	}

	public function result($arr = null)
	{
		$this->execute();
		$type = (is_null($arr)) ? \PDO::FETCH_OBJ : \PDO::FETCH_ASSOC;
		return $this->stmt->fetchAll($type);
	}

	public function single($arr = null)
	{
		$this->execute();
		$type = (is_null($arr)) ? \PDO::FETCH_OBJ : \PDO::FETCH_ASSOC;
		return $this->stmt->fetch($type);
	}

	public function rowCount()
	{
		return $this->stmt->rowCount();
	}
	public function lastInsertId()
	{
		return $this->dbh->lastInsertId();
	}
	public function beginTransaction()
	{
		return $this->dbh->beginTransaction();
	}
	public function endTransaction()
	{
		return $this->dbh->commit();
	}
	public function cancelTransaction()
	{
		return $this->dbh->rollBack();
	}
	public function debugDumpParams()
	{
		return $this->stmt->debugDumpParams();
	}
}
