<?php
namespace Localthanks;

use Localthanks\Key;

interface Path
{
	const SERVER='67.227.191.89'; // Default server IP
	public function info();       // Returns environment path on the server
	public function ip();         // Returns client info, IP
}

class Env implements Path
{
	// Path Functions
	// return domain environment from the application server
	public function info() {
		return ((empty($_SERVER['REQUEST_SCHEME'])) ? 
					 (($_SERVER['HTTPS']==='on') ? 'https': 'http'): 
					   $_SERVER['REQUEST_SCHEME']).'://'.
			   ((empty($_SERVER['HTTP_HOST'])) ? 
			   ((empty($_SERVER['SERVER_NAME'])) ? 'localhost': 
			   		   $_SERVER['SERVER_NAME']): 
			   		   $_SERVER['HTTP_HOST']).
			   ((empty($_SERVER['CONTEXT_PREFIX'])) ? '': 
					   $_SERVER['CONTEXT_PREFIX']);
	}
	// Determine client IP address
	public function ip() {
   		if    ($_SERVER['HTTP_CLIENT_IP'])       $ip=$_SERVER['HTTP_CLIENT_IP'];
    	elseif($_SERVER['HTTP_X_FORWARDED_FOR']) $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
    	elseif($_SERVER['HTTP_X_FORWARDED'])     $ip=$_SERVER['HTTP_X_FORWARDED'];
    	elseif($_SERVER['HTTP_FORWARDED_FOR'])   $ip=$_SERVER['HTTP_FORWARDED_FOR'];
    	elseif($_SERVER['HTTP_FORWARDED'])       $ip=$_SERVER['HTTP_FORWARDED'];
    	elseif($_SERVER['REMOTE_ADDR'])          $ip=$_SERVER['REMOTE_ADDR'];
        if ($ip=='::1' or !filter_var($ip, FILTER_VALIDATE_IP)) $ip=self::SERVER;
		$_REQUEST[Key::DEVICE_IP]=$ip;                         // client ip
		$_REQUEST[Key::DEVICE_UA]=$_SERVER['HTTP_USER_AGENT']; // client user agent
		return $ip;
	}
}