<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: Favorites.php
 *
 * Favorites Class
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks; 

class Favorites extends Utils
{
	// User object
	public $list, $promo_list;

	const SQL_FAV_LIST = "
		SELECT ltm_id 
		FROM lt_favorites 
		WHERE csm_id=:id 
		ORDER BY lfv_order";
		
	const SQL_FAV_PROMOTION_LIST = "
		SELECT lt_promos.ltp_id 
		FROM lt_promos
		INNER JOIN lt_merchants
			ON lt_merchants.ltb_id=lt_promos.ltb_id
		WHERE ltm_id=:id 
		AND lt_promos.ltp_active!=0 
		AND NOW() BETWEEN lt_promos.ltp_startdate AND lt_promos.ltp_enddate
		ORDER BY lt_promos.ltp_enddate";
		
    /*
     *  Build it in the construct
     */
    function  __construct( $id ) {
    	static::processID( $id );
    }

	private function processID( $id )
	{
		$ids = $promos = array();
		$dbo = static::connect();
		$qry = $dbo->prepare( static::SQL_FAV_LIST );
		$qry->bindValue( ':id', $id );
		$qry->execute();
		$fav = $qry->fetchAll( \PDO::FETCH_OBJ );	
		
		foreach( $fav as $k => $v ) {
			$str = static::promotionList( $v->ltm_id );
			if( !empty( $str ) && $str != '' ) 
			array_push( $promos,  $str );
			array_push( $ids, $v->ltm_id );
		}

		$this->list       = implode(',',$ids);
		$this->promo_list = implode(',',$promos);
    }
    
    /*
     * Promotion List
     */
    private function promotionList( $id )
    {		
    	$ids = array();	 
		$dbo = static::connect();
		$qry = $dbo->prepare( static::SQL_FAV_PROMOTION_LIST );
		$qry->bindValue( ':id', $id );
		$qry->execute();
		$fav = $qry->fetchAll( \PDO::FETCH_OBJ );
	
		foreach( $fav as $k => $v )
		array_push( $ids, $v->ltp_id );

		return implode(',',$ids);
    }
}

# EOF ?>