<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: GooglePlaces.php
 *
 * Google Places Class for Localthanks
 * @param place_id
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks;
 
class GooglePlaces extends Utils 
{
	// Data object
	// List item results and map
	protected $success, $notify; 
	public $status, $count, $request_uri, $results;

	/*
     *  Build it in the construct
     */
    function __construct() {
    	static::googlePlaces();
    }

	// SQL check for known Google Places
	const SQL_PLACE_ID_CHECK = '
		SELECT ltm_google_id 
		FROM lt_merchants 
		WHERE ltm_active!=0
		AND ltm_google_id LIKE :id';
	/*
	 * Process google request
	 */
	private function googlePlaces()
	{
		$lat  = static::getLat();
		$lng  = static::getLng();
		$cat  = static::getCat();
		$term = static::getTerm();
		$ll   = implode(',',array($lat, $lng));
		
		// Build google URI
		$google['location'] = $ll;
		$google['key']      = static::GOOGLE_API_KEY_SERVER;

		// Google likes categories to 
		// the types parameter and multiple 
		// is separated by a pipe '|'
		if( $cat ) {
			$c   = new Category( $cat );
			$arr = $ar2 = array();
			foreach( $c as $k => $v ) array_push( $arr, $v );
			foreach( $arr[0]  as $v ) array_push( $ar2, $v->slug);
			$google['types']   = implode('|',$ar2);
		}
		if( $term ) 
			$google['keyword'] = $term;
		if( $cat || $term ) 
			$google['rankby']  = 'distance';
		else 			    
			$google['radius']  = static::getRadius();

		// Since Google is an API, 
		// and other sources are falable..
		// Suppress the error, and 
		// check if it is active.
		$this->request_uri = static::GOOGLE_URL_PLACES.http_build_query( $google );
		$google            = json_decode(@file_get_contents( $this->request_uri ));
		$this->results     = $google->results;
		$this->status      = $google->status;
 
		switch( $this->status ) 
		{
			case 'OK' :
				$this->success = 1;
				$this->notify  = static::RESULTS_YES;
				break;
							
			// UNKNOWN_ERROR indicates a server side issue. 
			// Re-run the function to request again.
			case 'UNKNOWN_ERROR' :
				static::googlePlaces();
				return;

			default :
				$this->success = 0;
				$this->notify  = static::RESULTS_NO.' '.ucwords(str_replace('_',' ',strtolower($google->status)));
				break;
		}
		
		// check for recorded place IDs 
		$dbo     = static::connect();
		$results = array();
		foreach( $this->results as $v ) 
		{
			$qry = $dbo->prepare( static::SQL_PLACE_ID_CHECK );
			$qry->bindValue(':id', $v->place_id, \PDO::PARAM_STR );
			$qry->execute();
			$pid = $qry->fetchAll( \PDO::FETCH_OBJ );
				
			// If place ID found in db, 
			// break here and continue the loop
			if( !empty( $pid ) ) continue; 
 				
 			// Set fields
			$v->google_id    = $v->id;
			$v->id           = implode('_',array('google',$v->place_id));
		   	$v->phone_number = static::NOTICE_MERCHANT_SIGNUP;
		   	$v->ltm_lat      = $v->geometry->location->lat;
		   	$v->ltm_long     = $v->geometry->location->lng;
		   	$v->url          = static::GOOGLE_URL_DIRECTIONS.http_build_query(array('ll'=>$ll));
		   	
		   	// images
		   	$v->thumbnail = $this->environment() . static::DIR_LOGO;
		   	if( $v->photos[0]->photo_reference ) {
		   		$image['photoreference'] = $v->photos[0]->photo_reference;
		   		$image['maxwidth']       = static::IMG_MAX_WIDTH;
		   		$image['key']            = static::GOOGLE_API_KEY_CLIENT;
		   		$v->thumbnail            = static::GOOGLE_URL_PHOTOS.http_build_query( $image );
			}
				
			// distance and map
			$v->distance = static::distance( $lat, $lng, $v->ltm_lat, $v->ltm_long ).' '.static::distanceUnit();
		   	$v->geometry = new MapObject( $v->id, $v->name, $v->ltm_lat, $v->ltm_long, $v->url, $v->thumbnail );
					
 			// clean up and add to array
 			unset( $v->photos, $v->icon, $v->geometry->viewport, $v->ltm_lat, $v->ltm_long, $v->reference );
			array_push( $results, $v );
		} // end foreach
			
		$this->results = $results;
		$this->count = count( $this->results );
	} // end function
}

# EOF ?>