<?php

namespace Localthanks2;

interface ProjectSettings {
	const PROJECT_NAME  ='Local Thanks';
	const PROJECT_EMAIL ='info@localthanks.com';
}

interface ContactSettings {
	const CONTACT_NAME  ='Michael Hayden';
	const CONTACT_EMAIL ='mike@loyaltysuperstore.com';
}
interface ContactMethods
	public function htmlHeaders($subject=null,$Cc=null,$Bcc=null)
}

class Contact implements ProjectSettings, ContactSettings, ContactMethods
{
	// Mail system functions
	// optionals: $Cc $Bcc
	// To send HTML mail, 
	// the Content-type header must be set
	public function htmlHeaders($subject=null,$Cc=null,$Bcc=null) {
		if(!$subject)
		$subject  ='Greetings from '.self::PROJECT_NAME;
		$headers  =array();
		$headers[]='MIME-Version: 1.0';
		$headers[]='Content-type: text/html; charset=iso-8859-1';
		$headers[]='From: '.self::PROJECT_NAME.' <'.self::PROJECT_EMAIL.'>';
		if( $Cc )
		$headers[]="Cc: $Cc";
		if( $Bcc )
		$headers[]="Bcc: $Bcc";
		$headers[]='Reply-To: '.self::PROJECT_NAME.' <'.self::PROJECT_EMAIL.'>';
		$headers[]="Subject: $subject";
		$headers[]='X-Mailer: PHP/'.phpversion();
		$headers  =implode("\r\n", $headers);
		return $headers;
	}
}

interface ImageSettings {
	const IMG_MAX_WIDTH  = 600;
	const IMG_MAX_HEIGHT = 400;
}


interface PathSettings {
	const DIR_CDN          ='/cdn';
	const DIR_LOGO         ='/cdn/images/logo.png';
	const DIR_IMG_MERCHANT ='/images/merchants';
	const DIR_IMG_LIBRARY  ='/images/promo_library';
	const DIR_IMG_DEFAULT  ='/images/promo_defaults/promo-default_';
}

interface Environment
{
	public function env($str=null);
	public function cdn();
}

class Path implements PathSettings, Environment
{
	// Path Functions
	// return domain environment from the application server
	//
	// option: Add string to replace :tags
	public function env($str=null) 
	{
		$env=((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']!='off') ? 'https':'http').'://'.$_SERVER['HTTP_HOST'];
		if($str) {
			$replace = array(
				':env'           => $env,
				':earth'         => Distance::earthRadius(),
				':cdn'           => self::cdn(),
				':img_merchants' => self::DIR_IMG_MERCHANT,
				':img_library'   => self::DIR_IMG_LIBRARY,
				':img_default'   => self::DIR_IMG_DEFAULT,
				':img_logo'      => self::DIR_LOGO
			);
			foreach($replace as $k=>$v)
				$str=str_replace($k,$v,$str);

			$env=$str; // last
		}
		return $env;
	}

	// return content delivery network path
	public  function cdn() {
		return self::env().self::DIR_CDN;
	}
}

interface Notifications
{
	const NOTICE_MERCHANT_SIGNUP = 'Is this your business? Add promotions via Local Thanks!';
	
	// User notifications
	const USR_SESSION  ='Session found.';
	const USR_EXPIRED  ='Session expired.';
    const USR_ACTIVE   ='Logged in.';
    const USR_INACTIVE ='Account inactive.';
    const USR_LOGOUT   ='Logged out.';
    const USR_LOGIN    ='Please login.';
    const USR_NONE     ='No user found.';
    const USR_SIGNUP   ='Signup now!';
    const USR_WELCOME  ='Registration success. Welome! You are now logged in.';
    const USR_PASS_ERROR  ='Passwords do not match.';
 	const USR_PASS_FORMAT ='Password does not match required format.';
 	const USR_RESET            ='Enter account email.';
	const USR_RESET_SENT       ='Email sent. Please verify.';
	const USR_RESET_ERROR      ='Unknown error. Please contact the administrator.';
	const USR_RESET_ERROR_MAIL ='Mail error. Try again or contact the administrator.';  
	const USR_RESET_VERIFIED   ='Verified. Enter new credentials.';
	const USR_RESET_COMPLETE   ='Success! Password is now changed.';
	const USR_EMAIL_INVALID ='Invalid email address format.';
	const USR_EMAIL_IN_USE  ='Email is already in use. Please login.';
	const USR_EMPTY_FIELDS  ='Please fill out all fields.';
	const USR_API_CRYPT_KEY ='hwzLgqR1vcoVVU9AQfrXet1zHGuLNHFwSXSz6UUlB6o4iedWW1BARtZIdIGgRqyD';
}







interface GoogleAPI
{
	const GOOGLE_ANALYTICS_ID  ='UA-69987455-1';
	const GOOGLE_API_KEY_SERVER='AIzaSyBpkTgztTfHpEZ-8KNZ6XgMuv0M9G1ASlI';
	const GOOGLE_API_KEY_CLIENT='AIzaSyCtEgdiaxHP7pF9NJp060I84QzyvS2q_iI';
	const GOOGLE_URL_PHOTOS    ='https://maps.googleapis.com/maps/api/place/photo?';
	const GOOGLE_URL_PLACES    ='https://maps.googleapis.com/maps/api/place/nearbysearch/json?';	
	const GOOGLE_URL_GEOCODE   ='https://maps.google.com/maps/api/geocode/json?';
	const GOOGLE_URL_DIRECTIONS='https://maps.google.com/?'; // ?q=param
	
	// SQL id check for known Google Places
	const GOOGLE_SQL_SELECT_PLACE_ID = '
		SELECT ltm_google_id 
		FROM lt_merchants 
		WHERE ltm_active!=0
		AND ltm_google_id LIKE :place_id';
}

interface GoogleMethods extends GoogleAPI
{
	public $status, $count, $request_uri, $results;
	public function googlePlaces();
}




class Google implements GoogleMethods, ImageSettings, Notifications
{
	public $status, $count, $request_uri, $results;
		
	// Google Places
	// Returns google places based on latitude and longitude except 
	// if a result is already found in our database.
	// Remember that this is supplimental. 
	public function googlePlaces()
	{
		$lat =Parameters::getLat();
		$lng =Parameters::getLng();
		$cat =Parameters::getCat();
		$term=Parameters::getTerm();
		$ll  =implode(',',array($lat,$lng));
		
		// Build google URI
		$google['location']=$ll;
		$google['key']     =self::GOOGLE_API_KEY_SERVER;

		// Google likes categories to 
		// the types parameter and multiple 
		// is separated by a pipe '|'
		if( $cat ) {
			$c  =new Category( $cat );
			$arr=$ar2=array();
			foreach($c as  $k=>$v) array_push($arr,$v);
			foreach($arr[0] as $v) array_push($ar2,$v->slug);
			$google['types']      =implode('|',$ar2);
		}
		if( $term ) 
			$google['keyword']=$term;
		if( $cat || $term ) 
			$google['rankby'] ='distance';
		else 			    
			$google['radius'] =Parameters::getRadius();

		// Since Google is an API, 
		// and other sources are falable..
		// Suppress the error, and 
		// check if it is active.
		$this->request_uri=self::GOOGLE_URL_PLACES.http_build_query($google);
		$google           =json_decode(@file_get_contents($this->request_uri));

		// check for recorded place IDs 
		$results=array();
		foreach($google->results as $v) 
		{
			$sql=self::GOOGLE_SQL_SELECT_PLACE_ID;
			$prm=array(':place_id',$v->place_id);
			$pid=Database::fetchObject($sql,$prm);
					
			// If place ID found in db, 
			// break here and continue the loop
			if(!empty($pid)) continue; 
 				
 			// Set fields
			$v->google_id    = $v->id;
			$v->id           = implode('_',array('google',$v->place_id));
		   	$v->phone_number = self::NOTICE_MERCHANT_SIGNUP;
		   	$v->ltm_lat      = $v->geometry->location->lat;
		   	$v->ltm_long     = $v->geometry->location->lng;
		   	$v->url          = self::GOOGLE_URL_DIRECTIONS.http_build_query(array('ll'=>$ll));
		   	
		   	// images
		   	$v->thumbnail = Path::env().Path::DIR_LOGO;
		   	if( $v->photos[0]->photo_reference ) {
		   		$image['photoreference'] = $v->photos[0]->photo_reference;
		   		$image['maxwidth']       = self::IMG_MAX_WIDTH;
		   		$image['key']            = self::GOOGLE_API_KEY_CLIENT;
		   		$v->thumbnail            = self::GOOGLE_URL_PHOTOS.http_build_query( $image );
			}
				
			// distance and map
			$v->distance=Distance::distance($lat,$lng,$v->ltm_lat,$v->ltm_long);
		   	$v->geometry=new MapObject($v->id,$v->name,$v->ltm_lat,$v->ltm_long,$v->url,$v->thumbnail);
					
 			// clean up and add to array
 			unset($v->photos,$v->icon,$v->geometry->viewport,$v->ltm_lat,$v->ltm_long,$v->reference);
			array_push( $results, $v );
		} // end foreach
			
		$this->results = $results;
		$this->count = count( $this->results );
	} // end function
}







interface SqootAPI
{
	const SQOOT_API_KEY     ='dx2afn';
	const SQOOT_URL_DEALS   ='http://api.sqoot.com/v2/deals?';
	const SQOOT_URL_COUPONS ='http://api.sqoot.com/v2/coupons?';
}










interface DistanceInfo
{
	// Earth radius, various systems
	const RAD_KEY     ='distance_unit';
	const RAD_EARTH_MI=3959;
	const RAD_TEXT_MI =' mi';
	const RAD_EARTH_KM=6372.795477598;
	const RAD_TEXT_KM =' km';
	const RAD_EARTH_NM=3440;
	const RAD_TEXT_NM =' nm';
	
	public static function earthRadius();
	public static function distance($lat1,$lon1,$lat2,$lon2,$decimal=2);
	public static function distanceUnit();
	public static function midpoint($lat1,$lon1,$lat2,$lon2);
	public static function bounds($lat,$lng,$radius,$str=null);
	
}

class Distance implements DistanceInfo
{
	// get earth radius 
	public static function earthRadius() 
	{
		switch ( self::distanceUnit() ) {
			case self::RAD_TEXT_KM: return self::RAD_EARTH_KM;
			case self::RAD_TEXT_NM: return self::RAD_EARTH_NM;
			case self::RAD_TEXT_MI:
			default               : return self::RAD_EARTH_MI;
		}
	}
	
	// check for distance measurement unit
	public static function distanceUnit() 
	{
		$unit = strtolower( $_REQUEST[self::RAD_KEY] );
		switch ( $unit ) {
			case in_array($unit,array(self::RAD_TEXT_KM,'kilometer','kilometers','km','k',' km')): 
				return self::RAD_TEXT_KM;
			case in_array($unit,array(self::RAD_TEXT_NM,'nautical','nmi','nm','n',' nm')): 
				return self::RAD_TEXT_NM;
			case in_array($unit,array(self::RAD_TEXT_MI,'mile','miles','mi','m',' mi')): default:
				return self::RAD_TEXT_MI;
		}
	}
 
	// Lat Long Geometry
	
	// Determines distance between two points on a sphere
	public static function distance($lat1,$lon1,$lat2,$lon2,$decimal=2) 
	{
		$dlng = $lon1 - $lon2; // longitude theta
		$dist = acos(
					sin(deg2rad($lat1)) * 
					sin(deg2rad($lat2)) + 
					cos(deg2rad($lat1)) * 
					cos(deg2rad($lat2)) * 
					cos(deg2rad($dlng))
				 );
		$dist = rad2deg($dist) * 60 * 1.1515; // miles
 
		switch ( self::distanceUnit() ) {
			case self::RAD_TEXT_KM: 		 
				return round(($dist * 1.609344), $decimal).self::RAD_TEXT_KM;
			case self::RAD_TEXT_NM:  		 
				return round(($dist * 0.8684), $decimal).self::RAD_TEXT_NM;
			case self::RAD_TEXT_MI: default: 
				return round($dist, $decimal).self::RAD_TEXT_MI;
		}
	}
 
	// Determines midpoint between two points on a sphere
	// -needs work
	public static function midpoint($lat1,$lon1,$lat2,$lon2)
	{
    	$lat1 = deg2rad($lat1);
    	$lon1 = deg2rad($lon1);
    	$lat2 = deg2rad($lat2);
    	$lon2 = deg2rad($lon2);
    	$dlng = $lon2 - $lon1; // longitude theta
    	$Bx   = cos($lat2) * cos($dlng);
    	$By   = cos($lat2) * sin($dlng);
    	$pi   = pi();   	
    	$lat  = (atan2( 
    				sin($lat1) + sin($lat2),
    				sqrt(
    					(cos($lat1) + $Bx) * 
    					(cos($lat1) + $Bx) + $By * $By
    				)
    			) * 180 ) / $pi;
    	$lon = ($lng1 + atan2($By, (cos($lat1) + $Bx)) * 180) / $pi;

    	return $lat.','.$lon;
	}
	
	// Min-Max, bounding box
	// Returns object array.
	//
	// Optional as return string
	// when the $str option is used.
	// Will replace string with 
	// bound :tags if used.
	public static function bounds($lat,$lng,$radius,$str=null) 
	{
		$earth =self::earthRadius();
		$center=implode(',',array($lat,$lng));
		$device=$_REQUEST['ll'];
		$minlat=$lat-rad2deg($radius/$earth);
		$maxlat=$lat+rad2deg($radius/$earth);
		$minlng=$lng-rad2deg($radius/$earth/cos(deg2rad($lat)));
		$maxlng=$lng+rad2deg($radius/$earth/cos(deg2rad($lat)));
		$bounds=(object) array(
			'lat'       => $lat,
			'lng'       => $lng,
			'radius'    => $radius,
			'center'    => $center,
			'device'    => $device,
			'minlat'    => $minlat,
			'maxlat'    => $maxlat,
			'minlng'    => $minlng,
			'maxlng'    => $maxlng,
            'northeast' => array( 
            	'lat'   => $maxlat,
                'lng'   => $maxlng
             ),
            'southwest' => array(
				'lat'   => $minlat,
                'lng'   => $minlng
             )
		);

		if($str)
			foreach($bounds as $k=>$v)
				$str=str_replace(":$k",$v,$str);
		
		return ($str) ? $str: $bounds;
	}
}










interface Utilities
{
	const FORMAT_DATE = 'M d Y h:i A';
	public function getIP();
	public function dateFormat($date);
	public function getZipCode($str);
	public static function capitilize($name);
	public static function keygen($length=5,$max=26);
	public static function object_to_array($data);
	public static function sanitize($data);
	public static function sanitizeHTML($text);
	public static function phoneFormat($phone,$str=null);
}


class Util implements Utilities
{
	// Useful functions 
	
	public function getIP() {
   		if    (getenv('HTTP_CLIENT_IP'))
        	$ip = getenv('HTTP_CLIENT_IP');
    	elseif(getenv('HTTP_X_FORWARDED_FOR'))
        	$ip = getenv('HTTP_X_FORWARDED_FOR');
    	elseif(getenv('HTTP_X_FORWARDED'))
        	$ip = getenv('HTTP_X_FORWARDED');
    	elseif(getenv('HTTP_FORWARDED_FOR'))
        	$ip = getenv('HTTP_FORWARDED_FOR');
    	elseif(getenv('HTTP_FORWARDED'))
        	$ip = getenv('HTTP_FORWARDED');
    	elseif(getenv('REMOTE_ADDR'))
        	$ip = getenv('REMOTE_ADDR');
    	else
        	$ip = false;	
		
		return filter_var( $ip, FILTER_VALIDATE_IP );
	}
 
	// Sanitize data
	// clean up data types.
	public static function sanitize($data) 
	{
		if( is_array($data) ) :         // array
	   		foreach ($data as $k => $v) 
			$data[$k] = self::sanitize($v);
		elseif( is_float($data) ) : 	// float
			$data = floatval($data);
		elseif( is_int($data) ) :    	// int
			$data = intval($data);
		else :                          // string
			$data = self::sanitizeHTML( $data );
		endif;
		return $data;
	}
 
 	// Remove HTML tags, including invisible text such as style and
 	// script code, and embedded objects.  Add line breaks around
 	// block-level tags to prevent word joining after tag removal
	public static function sanitizeHTML($text)
	{
		$text = urldecode( $text );
		// .              a single character
		// \s             a whitespace character (space, tab, newline)
		// \S             non-whitespace character
		// \d             a digit (0-9)
		// \D             a non-digit
		// \w             a word character (a-z, A-Z, 0-9, _)
		// \W             a non-word character
		// [aeiou]        matches a single character in the given set
		// [^aeiou]       matches a single character outside the given set
		// (foo|bar|baz)  matches any of the alternatives specified
		
    	$text = preg_replace(
		  array(
          // Remove invisible or error content
        	'@<head[^>]*?>.*?</head>@siu',
            '@<style[^>]*?>.*?</style>@siu',
            '@<script[^>]*?.*?</script>@siu',
            '@<object[^>]*?.*?</object>@siu',
            '@<embed[^>]*?.*?</embed>@siu',
            '@<applet[^>]*?.*?</applet>@siu',
            '@<noframes[^>]*?.*?</noframes>@siu',
            '@<noscript[^>]*?.*?</noscript>@siu',
            '@<noembed[^>]*?.*?</noembed>@siu',
            '@(\s\s|--)@siu',
          // Add line breaks before and after blocks
            '@</?((address)|(blockquote)|(center)|(del))@iu',
            '@</?((div)|(h[1-9])|(ins)|(isindex)|(p)|(pre))@iu',
            '@</?((dir)|(dl)|(dt)|(dd)|(li)|(menu)|(ol)|(ul))@iu',
            '@</?((table)|(th)|(td)|(caption))@iu',
            '@</?((form)|(button)|(fieldset)|(legend)|(input))@iu',
            '@</?((label)|(select)|(optgroup)|(option)|(textarea))@iu',
            '@</?((frameset)|(frame)|(iframe))@iu',
		  // Custom
		  	'@([^\s]$|$\s$|$$)@siu',
          ),
          array(
            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
            "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0",
            "\n\$0", "\n\$0",
            ' $',
          ),
          $text 
        );
		$text = strip_tags( $text );
 
		return trim(preg_replace('/(?:(?:\r\n|\r|\n)\s*){2}/s',"\n\n",$text));
	}

	// generate a random key
	public static function keygen($length=5,$max=26) {
		return substr(md5(microtime()),rand(0,$max),$length);
	}
	
	// cheap php object to array converter
	public static function object_to_array($data) {
		return json_decode(json_encode($data),true);
	}
	
	// lets make nice names
	public static function capitilize($name) {
		return ucwords(strtolower($name));
	}
	
	// format phone number
	// optional adds string after and inserts linebreak.
	public static function phoneFormat($phone,$str=null) 
	{
		$phone = preg_replace('/\D/', '', $phone);
		switch(strlen($phone)) {
			case  7:  $phone = preg_replace('/^(\d{3})(\d{4})$/i', '$1-$2 ', $phone);
			case 10:  $phone = preg_replace('/^(\d{3})(\d{3})(\d{4})$/i', '($1) $2-$3 ', $phone);
			case 11:  $phone = preg_replace('/^(\d{1})(\d{3})(\d{3})(\d{4})$/i', '$1 ($2) $3-$4 ', $phone);
			case 20:  $phone = preg_replace('/^(\d{3})(\d{3})(\d{4})(\d{3})(\d{3})(\d{4})$/i', '($1) $2-$3 or ($4) $5-$6 ', $phone);
			case 22:  $phone = preg_replace('/^(\d{1})(\d{3})(\d{3})(\d{4})(\d{1})(\d{3})(\d{3})(\d{4})$/i', '$1 ($2) $3-$4 or $5 ($6) $7-$8 ', $phone);
		}
		return ($str) ? ($phone.((!empty($phone)) ? "\n":'').$str): $phone; 
	}
	
	// format date
	public function dateFormat($date) {
		$date = new \DateTime($date);
		return $date->format(self::FORMAT_DATE);
	}
 
	// Extract ZipCode from string
	public function getZipCode($str) {
    	$zip = preg_match( "/\b\d{5}(-\d{4})?\b/", $str, $matches );
    	return $matches[0];
	}	
}









interface ParamDefaults
{
	const DEFAULT_LIMIT =10;
	const DEFAULT_MODE  =0;
	const DEFAULT_SORT  =0;
	const DEFAULT_RADIUS=50;
}

interface ParamMethods
{
	public function getLimit();
	public function getMode();
	public function getOffset();
	public function getSort();
	public function getCat();
	public function getTerm();
	public function getRadius();
	public function getLat();
	public function getLng();
	public function getLatLng();
    public function getLocality($loc=null);
}
	
class Parameters implements ParamDefaults, ParamMethods, GoogleAPI
{
    // Request API param variable functions
    // Sets defaults
    	
	// @param $_REQUEST['limit']
	// Data Request Limit
	public function getLimit() {
		return ($_REQUEST['limit']) ? intval($_REQUEST['limit']): self::DEFAULT_LIMIT;
	}
	
	// @param $_REQUEST['mode']
	// 0 = Promotions, default or 1 = Merchants
	public function getMode() {
		return ($_REQUEST['mode']) ? intval($_REQUEST['mode']): self::DEFAULT_MODE;
	}
	
	// @param $_REQUEST['offset']
	// Data Request Offset
	public function getOffset() {
		return ($_REQUEST['offset']) ? intval($_REQUEST['offset']): 0;
	}
	
	// @param $_REQUEST['sort']
	// Sort by 0 = Distance, default or 1 = Best Match
	public function getSort() {
		return ($_REQUEST['sort']) ? intval($_REQUEST['sort']): self::DEFAULT_SORT;
	}
	
	// @param $_REQUEST['cat']
	// Search by (cat)egory
	public function getCat() {
		return ($_REQUEST['cat']) ? urldecode($_REQUEST['cat']): '';
	}
	
	// @param $_REQUEST['term']
	// Get ltm_id's by keyword or (term)s
	public function getTerm() {
		return ($_REQUEST['term']) ? urldecode($_REQUEST['term']): '';
	}

	// @param $_REQUEST['radius']
	// Radius in kilometers
	public function getRadius() {
		return ($_REQUEST['radius']) ? intval($_REQUEST['radius']): self::DEFAULT_RADIUS;
	}
	
	// User location functions

	// @param $_REQUEST['lat']
	// Latitude Point
	public function getLat() {
		return $_REQUEST['lat'];
	}
	
	// @param $_REQUEST['lng']
	// Longitude Point
	public function getLng() {
		return $_REQUEST['lng'];
	}
	
	// @param $_REQUEST['ll']
	// Longitude Point
	public function getLatLng() {
		return $_REQUEST['ll'];
	}
	
	// Search by Locality
    // @param $_REQUEST['locality']
    // Check location by Google maps API
    public function getLocality( $loc=null ) {
    	if ($google['address']=(($loc) ? $loc:$_REQUEST['locality'])) {
			$google=self::GOOGLE_URL_GEOCODE.http_build_query( $google );
			$google=json_decode(@file_get_contents( $google ));
			switch( $google->status ) {
				case            'OK': 
					$_REQUEST['lat']=$google->results[0]->geometry->location->lat;
					$_REQUEST['lng']=$google->results[0]->geometry->location->lng;
					break;
				case 'UNKNOWN_ERROR': 
					self::getLocality($loc); 
					break;
			}
			return $google;
		}
		return '';
	}	
}
	
	
	
	
	
	
interface SQLFields
{
    const SQL_FIELDS_TBL_CONSUMER = "
    	CONCAT('csm_',tbl_consumer.csm_id) id,
    	tbl_consumer.csm_id,
    	tbl_consumer.csm_key,
    	tbl_consumer.csm_lat,
    	tbl_consumer.csm_long,
    	tbl_consumer.csm_zip,
    	tbl_consumer.csm_password,
    	tbl_consumer.csm_active,
    	TRIM(tbl_consumer.csm_first_name) csm_first_name,
    	TRIM(tbl_consumer.csm_last_name) csm_last_name,
    	TRIM(tbl_consumer.csm_email) csm_email,
		DATE_FORMAT(csm_add_date,'%c/%d/%Y') csm_add_date";
		
	const SQL_FIELDS_LT_MERCHANTS = "
		CONCAT('ltm_',lt_merchants.ltm_id,'_ltb_',lt_merchants.ltb_id) id,
		lt_merchants.ltm_id,
		lt_merchants.ltm_google_id place_id,
		TRIM(lt_merchants.ltm_company_name) name,
		CONCAT(lt_merchants.ltm_lat,',',lt_merchants.ltm_long) location,
		lt_merchants.ltm_lat,
		lt_merchants.ltm_long,
		CONCAT(
			IFNULL(CONCAT(lt_merchants.ltm_address,' ','\n'),''),
			IFNULL(CONCAT(lt_merchants.ltm_city,' '),''),
			IFNULL(CONCAT(lt_merchants.ltm_state,', '),''),
			IFNULL(lt_merchants.ltm_zipcode,''),'\n'
		) vicinity,
		TRIM(lt_merchants.ltm_address) address,
		TRIM(lt_merchants.ltm_city) city,
		TRIM(lt_merchants.ltm_state) state,
		TRIM(lt_merchants.ltm_zipcode) zip,
		TRIM(lt_merchants.ltm_phone_number) phone_number,
		CONCAT(':env:cdn/merchants?id=',lt_merchants.ltm_id) ltm_url,
		DATE_FORMAT(lt_merchants.ltm_registerdate,'%c/%d/%Y') ltm_registerdate,
		ROUND(
			ACOS(
				SIN(RADIANS(:sinlat)) * 
				SIN(RADIANS(lt_merchants.ltm_lat)) +
				COS(RADIANS(:coslat)) *
				COS(RADIANS(lt_merchants.ltm_lat)) *
				COS(RADIANS(lt_merchants.ltm_long) - RADIANS(:coslng))
		) * :earth, 2 ) distance";
		
	const SQL_FIELDS_LT_MEMBER_MERCHANTS = "
		lt_member_merchants.ltb_id,
		TRIM(lt_member_merchants.ltb_description) ltb_description,
		TRIM(lt_member_merchants.ltb_web_url) ltb_web_url,
		IFNULL(CONCAT(':env:img_merchants/',lt_member_merchants.ltb_id,'/h_600x600_',lt_member_merchants.ltb_header_image),':env:img_logo') ltb_thumbnail,
		IFNULL(CONCAT(':env:img_merchants/',lt_member_merchants.ltb_id,'/h_250w_',lt_member_merchants.ltb_header_image),':env:img_logo') ltb_image";

    const SQL_FIELDS_LT_PROMOS = "
    	lt_promos.ltp_id,
		TRIM(REPLACE(UPPER(CONCAT(IFNULL(lt_promos.ltp_headline,''),' ')),'  ',' ')) title,
		TRIM(REPLACE(REPLACE(REPLACE(REPLACE(lt_promos.ltp_description,'\n',' '),'\r',' '),'   ',' '),'  ',' ')) description,
		DATE_FORMAT(lt_promos.ltp_startdate,'%b %d %Y %h:%i %p') start_date,
		DATE_FORMAT(lt_promos.ltp_enddate,'%b %d %Y %h:%i %p') end_date,
		lt_promos.ltp_promo_code promo_code,
		CAST(lt_promos.ltp_promo_type AS UNSIGNED) type,
		TIME_FORMAT(lt_promos.ltp_time_start,'%h:%i %p') start_time,
		TIME_FORMAT(lt_promos.ltp_time_end,'%h:%i %p') end_time,
		TRIM(TRAILING ', ' FROM REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(lt_promos.ltp_weekday,1,'Mon, '),2,'Tue, '),3,'Wed, '),4,'Thurs, '),5,'Fri, '),6,'Sat, '),7,'Sun, '),'Mon, Tue, Wed, Thurs, Fri, Sat, Sun','Everyday!'),', Tue, Wed, ',' thru '),' thru Thurs, F',' thru F')) weekday,
		IFNULL(
			CONCAT(':env', IF(lt_promos.ltp_image LIKE 'unv%',':img_library/',':img_merchants/'), lt_promos.ltb_id, IF(lt_promos.ltp_image LIKE 'unv%','/','/p_120x120_'), lt_promos.ltp_image),
			CONCAT(':env:img_default',lt_promos.ltp_promo_type,'.jpg')
		) thumbnail,
		IFNULL(
			CONCAT(':env', IF(lt_promos.ltp_image LIKE 'unv%',':img_library/',':img_merchants/'), lt_promos.ltb_id, IF(lt_promos.ltp_image LIKE 'unv%','/','/p_600x400_'), lt_promos.ltp_image),
			CONCAT(':env:img_default',lt_promos.ltp_promo_type,'.jpg')
		) image,
		CONCAT(':cdn/promotions?id=',lt_promos.ltp_id) AS url";
}	


interface SQLMethods
{
	public function selectMerchantsByID(); // SQL Merchants By ltm_id (comma delimited)
	private function replaceSQL($sql);     // Replace SQL string for replacing :tags
}

class Data extends Database implements SQLMethods
{
	// Add SQL string to replace :tags
	private function replaceSQL( $sql ) {
		// Rendered fields
		$replace=array(
			':lt_member_merchants' => self::memberFields(),
			':lt_member_merchants' => self::memberFields(),
			':lt_merchants'        => self::merchantFields(),
			':lt_promos'           => self::promoFields(),
			':tbl_consumer'        => self::consumerFields()
		);
		foreach($replace as $k=>$v)
			$sql=str_replace($k,$v,$sql);
 
		// Data Sorting
		switch( Parameters::getSort() ) {
			case 3 : $order = 'lt_merchants.ltm_company_name DESC'; break;
			case 2 : $order = 'lt_merchants.ltm_company_name ASC'; break;
			case 1 : $order = 'distance DESC'; break;
			case 0 :
			default: $order = 'distance ASC'; break;
		}

		return  str_replace(':sort',$order,$sql);
	}
 
		
	// SQL Merchants By ltm_id (comma delimited)
	// @params :ltm_id, :limit, :offset
	// @fields :lt_merchants, :lt_member_merchants, :sort
	public function selectMerchantsByID() {
		return self::replaceSQL(self::SQL_SELECT_MERCHANT_BY_ID);
	}
    const SQL_SELECT_MERCHANT_BY_ID = '
		SELECT 
			:lt_merchants,
			:lt_member_merchants
		FROM lt_merchants
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		AND lt_merchants.ltm_id IN (:ltm_id)
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';
 
	
	// SQL Merchants By location
	// @params :ltm_id, :limit, :offset
	// @fields :lt_merchants, :lt_member_merchants, :sort
	// @bounds :minlat, :maxlat, :minlng, :maxlng
	public function selectMerchantsByLocation( $ltm_id ) {
		return static::replaceSQL( static::SQL_SELECT_MERCHANT_BY_LOCATION );
	}
	const SQL_SELECT_MERCHANT_BY_LOCATION = '
		SELECT 
			:lt_merchants,
			:lt_member_merchants
		FROM lt_merchants
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		AND lt_merchants.ltm_lat  
			BETWEEN :minlat AND :maxlat
		AND lt_merchants.ltm_long 
			BETWEEN :minlng AND :maxlng
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';

	/*
	 * SQL Merchant Promotions By ltm_id (comma delimited)
	 *
	 * @params :ltm_id, :limit, :offset
	 * @fields :lt_merchants, :lt_member_merchants, :lt_promos, :sort
	 */
	public function selectMerchantPromotionsByID( $ltm_id ) {
		return static::replaceSQL( static::SQL_SELECT_MERCHANT_PROMOS_BY_ID );
	}
    const SQL_SELECT_MERCHANT_PROMOS_BY_ID = '
    	SELECT 
			:lt_merchants,
			:lt_member_merchants,
			:lt_promos
		FROM lt_promos 
		INNER JOIN lt_merchants 
			ON lt_promos.ltb_id=lt_merchants.ltb_id 
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		AND lt_merchants.ltm_id IN (:ltm_id)
		AND NOW() 
			BETWEEN lt_promos.ltp_startdate AND lt_promos.ltp_enddate
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';
    
	/*
	 * SQL Promotions By ltp_id (comma delimited)
	 *
	 * @params :ltp_id, :limit, :offset
	 * @fields :lt_merchants, :lt_member_merchants, :lt_promos, :sort
	 */
	public function selectPromotionsByID( $ltp_id ) {
		return static::replaceSQL( static::SQL_SELECT_PROMOS_BY_ID );
	}
	const SQL_SELECT_PROMOS_BY_ID = '
		SELECT 
			:lt_merchants,
			:lt_member_merchants,
			:lt_promos
		FROM lt_promos 
		INNER JOIN lt_merchants 
			ON lt_promos.ltb_id=lt_merchants.ltb_id 
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		AND lt_promos.ltp_id IN (:ltp_id)
		AND NOW() 
			BETWEEN lt_promos.ltp_startdate AND lt_promos.ltp_enddate
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';
		
	/*
	 * SQL Merchant Promotions By location
	 *
	 * @params :ltm_id, :limit, :offset
	 * @fields :lt_merchants, :lt_member_merchants, :sort
	 * @bounds :minlat, :maxlat, :minlng, :maxlng
	 */
	public function selectMerchantPromotionsByLocation( $ltm_id ) {
		return self::replaceSQL( static::SQL_SELECT_MERCHANT_PROMOS_BY_LOCATION );
	}
	const SQL_SELECT_MERCHANT_PROMOS_BY_LOCATION = '
		SELECT 
			:lt_merchants,
			:lt_member_merchants,
			:lt_promos
		FROM lt_promos 
		INNER JOIN lt_merchants 
			ON lt_promos.ltb_id=lt_merchants.ltb_id 
		INNER JOIN lt_member_merchants 
			ON lt_member_merchants.ltb_id=lt_merchants.ltb_id 
		WHERE lt_merchants.ltm_active!=0
		AND NOW() 
			BETWEEN lt_promos.ltp_startdate AND lt_promos.ltp_enddate
		AND lt_merchants.ltm_lat  
			BETWEEN :minlat AND :maxlat
		AND lt_merchants.ltm_long 
			BETWEEN :minlng AND :maxlng
		ORDER BY :sort 
		LIMIT :limit 
		OFFSET :offset';
	
	  
	// Common queried fields
	
    /*
     * SQL Consumer fields
     */
    public function consumerFields() {
    	return static::SQL_FIELDS_TBL_CONSUMER;
	}

	/*
	 * SQL Promotion Queried fields
	 */
    public function promoFields() {
    	return static::environment( static::SQL_FIELDS_LT_PROMOS );
	}

	
	/*
	 * SQL Merchants Queried fields
	 *
	 * @params :sinlat, :coslat, :lng
	 * @fields :earth
	 */
    public function merchantFields() {
    	return static::environment( static::SQL_FIELDS_LT_MERCHANTS );
	}

	/*
	 * SQL Member Merchant Queried fields
	 */
	public function memberFields() {
    	return static::environment( static::SQL_FIELDS_LT_MEMBER_MERCHANTS );
	}

 } // end class














interface Connection
{	
	public function connect();
	public function fetchObject($sql,$params=array());
}


class Database implements Connection
{
	// Connect function
	public function connect()
	{
		// PDO Database Class
		try {
			// Credentials
			$host='localhost';
			$name='devlocal_db1'; 
			$user='devlocal_dbuser'; 
			$pass='8kvomeh0Um!0*vy_iemUUoy397mvOe';
			
			// MS SQL Server and Sybase with PDO_DBLIB
			#$dbo=new \PDO("mssql:host=$host;dbname=$name,$user,$pass");
			#$dbo=new \PDO("sybase:host=$host;dbname=$name,$user,$pass");

			// MySQL with PDO_MYSQL
			$dbo=new \PDO("mysql:host=$host;dbname=$name;charset=utf8;",$user,$pass);

			// SQLite Database
			#$dbo=new \PDO("sqlite:my/database/path/database.db");

			// Checks for prepared statment errors
			$dbo->setAttribute(\PDO::ATTR_ERRMODE,\PDO::ERRMODE_EXCEPTION);
			$dbo->setAttribute(\PDO::ATTR_EMULATE_PREPARES,false);
 
			return $dbo;
		}
		// Error handling
		catch(\PDOException $e) {
			unset($dbo,$host,$name,$user,$pass);
			file_put_contents('error_pdo',$e->getMessage()."\n",FILE_APPEND);
			return false;
		}
	}
	
	// Routine
	// Common database return obj
	public function fetchObject($sql,$params=array()) 
	{
		$dbo=self::connect();
		$qry=$dbo->prepare($sql);
		foreach($params as $k=>$v)
		$qry->bindValue($k,$v);
		$qry->execute();
		return $qry->fetchAll(\PDO::FETCH_OBJ);
	}
}
 
#EOF?>