<?php
namespace Localthanks;

interface Key
{
	// Search
	const UID        ='uid';           // user emails or ids, comma delimited
	const MID        ='mid';           // member ids, comma delimited
	const INVOICE    ='inv';           // member invoice ids, comma delimited
	const PRODUCT    ='pid';           // product ids, comma delimited
	const ORDER      ='oid';           // order ids, comma delimited

	// Additional search requests
	const CAT        ='cat';           // category slugs or ids, comma delimited
	const TERM       ='term';          // keyword terms

	// Location requests
	const RADIUS     ='radius';        // search location area radius
	const DIST_UNIT  ='distance_unit'; // distance unit of measurement
	const SEARCH_LAT ='lat';           // search latitude
	const SEARCH_LNG ='lng';           // search longitude
	const DEVICE_LAT ='device_lat';    // device latitude
	const DEVICE_LNG ='device_lng';    // device longitude
	const DEVICE_IP  ='device_ip';     // device ip address
	const DEVICE_UA  ='user_agent';    // device user agent
	const IPADDR_LAT ='ip_lat';        // ip latitude
	const IPADDR_LNG ='ip_lng';        // ip longitude
	const IPADDR_LOC ='ip_loc';        // ip location data from api's
	const POSTCODE   ='post_code';     // post code / zip
	const LOCATION   ='location';      // location information

	// Authentication
	const TOKEN      ='token';         // token

	// Database modifiers
	const ORDER_BY   ='order';         // database sorting options (if available)
	const LIMIT      ='limit';         // database limit	
	const OFFSET     ='offset';        // database offset
}