<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: MapObject.php
 * SessionManager Class
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks;

class MapObject extends Utils
{
	public $location;
	
	// Icons
	const ICON_USER   = '/cdn/images/map/map_redstar.png';
	const ICON_GUEST  = '/cdn/images/map/map_redstar.png';
	const ICON_1      = '/cdn/images/map/icon_platinum_pin.png';
	const ICON_2      = '/cdn/images/map/icon_free_pin.png';
	const ICON_SQOOT  = '/cdn/images/map/icon_google_pin.png';
	const ICON_GOOGLE = '/cdn/images/map/icon_google_pin.png';
	
    /*
     *  Build it in the construct
     */
    function __construct($id, $txt=null, $lat=null, $lng=null, $url=null, $img=null, $promos=null) {
    	$this->location = static::mapObject($id, $txt, $lat, $lng, $url, $img, $promos);
    }
 
    /*
     * Simple Map object
     */
    private function mapObject($id, $txt, $lat, $lng, $url, $img, $promos)
    {	
    	$env       = static::environment();
    	$latitude  = static::getLat();
    	$longitude = static::getLng();
    	
    	// Build object array
		$obj['id']  = $id;
		$obj['txt'] = ($txt) ? ucwords(trim(htmlspecialchars($txt, ENT_QUOTES, 'UTF-8'))): static::NOTICE_YOU_ARE_HERE;
		$obj['lat'] = ($lat) ? $lat: $latitude;
		$obj['lng'] = ($lng) ? $lng: $longitude;
		$obj['url'] = ($url) ? $url: static::USR_URL_LOGIN;
		$obj['img'] = $img;
		
		// Handle promotion count
		$obj['promotions'] = ($promos > 0) ? $promos: null;
 		
 		// Check user location 'll'
		$loc = (isset($_REQUEST['ll'])) ? explode(',',$_REQUEST['ll']) : array($latitude,$longitude);	
		$obj['distance'] = static::distance( $loc[0], $loc[1], $lat, $lng ).' '.static::distanceUnit();
 
    	// Set an icon url
		if    ( strpos($id,'csm') !== false ) :
			$obj['icon'] = $env.static::ICON_USER;
			$obj['distance'] = null;
		elseif( strpos($id,'guest') !== false ) :
			$obj['icon'] = $env.static::ICON_GUEST;
    	elseif( strpos($id,'ltm') !== false ) :
    		$obj['icon'] = ( $promos > 0 ) ? $env.static::ICON_1: $env.static::ICON_2;
    	elseif( strpos($id,'google') !== false ) :
    		$obj['icon'] = $env.static::ICON_GOOGLE;
    	elseif( strpos($id,'sqoot') !== false ) :
    		$obj['icon'] = $env.static::ICON_SQOOT;
    	else :
    		$obj['icon'] = $env.static::ICON_1;
    	endif;

    	return (object) array_filter( $obj );
    }
}

# EOF ?>