<?php
// Merchant Interface
//
// Includes SQL statements and methods that
// describe the UI of a merchant's place of
// business in the Local Thanks program.
//
//  -------------------------------------------
namespace Localthanks;
interface Merchant {
	const SQL="
SELECT

--  --Token Vars-------------------------------

    MD5(CONCAT(
      @env:=     :env,
      @uid:=     :uid,
      @lat:=     :lat,
      @lng:=     :lng,
      @distUnit:=:distUnit,
      @radius:=  :radius,
      @minlat:=  :minlat,
      @maxlat:=  :maxlat,
      @minlng:=  :minlng,
      @maxlng:=  :maxlng,

      @mid:= merchant.ltm_id,
      @mem:= merchant.ltb_id,
      @id:=  CONCAT('ltm',@mid,'-','ltb',@mem),
      @now:=NOW(),
      @time:=CURTIME(),
      @dn:=(WEEKDAY(@now)+1),
      @df:='%c/%d/%Y',
      @d1:='Monday',   
      @d2:='Tuesday',
      @d3:='Wednesday', 
      @d4:='Thursday',
      @d5:='Friday',
      @d6:='Saturday', 
      @d7:='Sunday',
      @tf:='%l:%i %p',
      @logo:=CONCAT(@env,'/cdn/images/logo.png'),
      @murl:=CONCAT(@env,'/cdn/search?mid=',@mid),
      @imgDir:=CONCAT_WS('/',
        @env,'merchant-custom-files', 
        NULLIF(SUBSTR(@mem,1,2),''),
        NULLIF(SUBSTR(@mem,3,2),''),
        NULLIF(SUBSTR(@mem,5,2),''),
        NULLIF(SUBSTR(@mem,7,2),''),
        NULLIF(SUBSTR(@mem,9,2),''),
        NULLIF(SUBSTR(@mem,11,2),''),
        '_files/img'),
      @mfix:=CONCAT(@imgDir,'/h_600w_'),
      @addr:= TRIM(merchant.ltm_address),
      @city:= TRIM(merchant.ltm_city),
      @state:=TRIM(merchant.ltm_state),
      @zip:=  TRIM(merchant.ltm_zipcode)
    ))                               
    AS nonce,
    
    merchant.ltm_active AS active,
    
--  --ID---------------------------------------

    @id  AS id,
    @mid AS mid,
    @mem AS mem,
    @mid AS ltm_id,
    @dn  AS daynum,

--  --Member-----------------------------------
 	
    member.ltb_id                   AS ltb_id,
    TRIM(member.ltb_slug)           AS member_slug,
    TRIM(member.ltb_description)    AS member_description,
    	
--  --Address----------------------------------
 
    TRIM(merchant.ltm_company_name) AS merchant_name,
    TRIM(merchant.ltm_google_id)    AS place_id,
    
    @addr   AS address,
    @city   AS city,
    @state  AS state,
    @zip    AS post_code,
	
    @vicinity:=CONCAT_WS('\n',@addr,
      CONCAT_WS(' ',@city,@state,@zip)
    )							
    AS vicinity,
    
    CONCAT('https://maps.google.com/?q=',
      REPLACE(REPLACE(REPLACE(@vicinity,'\n',' '),'.',''),' ','+')
    )
    AS get_directions,
    
--  --Category and Keywords--------------------
    
    keyword.name   AS keywords,
    category.list  AS category_list,
    category.slugs AS category_slug,
    category.names AS category,
       
--  --Favorite---------------------------------
    
    IF(LENGTH(favorite.ltm_id),1,0) 
    AS favorite,

--  --Products---------------------------------
	
	''                  AS products,
 	product.list        AS product_list,
 	product.count       AS product_count,
 	
--  --Meta-------------------------------------
 
    IF(LOCATE('http',@web:=member.ltb_web_url)>0,
      @web,IF(LENGTH(@web),CONCAT('http://',@web),NULL)
    )
    AS merchant_website,
    
    @murl          AS merchant_url,
    store.hours    AS merchant_hours_of_operation,
    store.status   AS merchant_status,
 
    COALESCE(
      IF(LENGTH(@ph:=merchant.ltm_phone_number)=11,
        CONCAT('+1 (',
          SUBSTR(@ph,2,3),') ',
          SUBSTR(@ph,5,3),'-',
          SUBSTR(@ph,8,4)),
        NULL
      ), 
      IF(LENGTH(@ph)=10,
        CONCAT('(',
          SUBSTR(@ph,1,3),') ',
          SUBSTR(@ph,4,3),'-',
          SUBSTR(@ph,7,4)),
        NULL
      ), 
      IF(LENGTH(@ph)=7,
        CONCAT(
          SUBSTR(@ph,1,3),'-',
          SUBSTR(@ph,4,4)),
        NULL
      )
    ) 
    AS merchant_phone_number,
	
    DATE_FORMAT(merchant.ltm_registerdate,@df)
    AS merchant_register_date,
	
--  --Images-----------------------------------

    # Works on that db field max is 
    # 11 chars (unsigned int 11).
    @imgDir 
    AS merchant_imgdir,
 
    IF(LENGTH(@mh:=member.ltb_header_image)>0,
      CONCAT (@mfix,@mh),@logo)
    AS merchant_image,
    
--  --Distance---------------------------------
		
    @mlat:=merchant.ltm_lat  AS merchant_lat, 	
    @mlng:=merchant.ltm_long AS merchant_lng,
    ''    AS geometry, 
    
    @dist:=CONCAT_WS(' ',ROUND(
      ACOS(
        SIN(RADIANS(@lat)) * 
        SIN(RADIANS(@mlat)) +
        COS(RADIANS(@lat)) * 
        COS(RADIANS(@mlat)) *
        COS(RADIANS(@mlng) -     
            RADIANS(@lng)
        )
      ) * @earthRadius:=CASE 
          WHEN @distUnit ='nm' 
          THEN 3440 
          WHEN @distUnit ='km' 
          THEN 6372.795477598
          ELSE 3959 END, 
      2 ),@distUnit
    ) 			
    AS distance,
    
    CONCAT_WS(', ',
      COALESCE(
        NULLIF(@city,''),
        NULLIF(@zip,'')),
      UCASE(@state)
    )
    AS locality

--  -------------------------------------------

FROM lt_merchants AS merchant
	
--  --Member Info------------------------------

INNER JOIN lt_member_merchants AS member 
  ON member.ltb_id=merchant.ltb_id
 
--  --Favorites--------------------------------

LEFT JOIN lt_favorites AS favorite 
  ON  favorite.csm_id=@uid  
  AND favorite.ltm_id=@mid
  
--  --Keywords---------------------------------

LEFT JOIN (
  SELECT m2k.ltb_id, kw.key_word AS name
  FROM tbl_m2keyword AS m2k
  INNER JOIN tbl_keywords AS kw 
    ON m2k.key_id=kw.key_id
  GROUP BY m2k.key_id
) AS keyword
  ON merchant.ltb_id=keyword.ltb_id
		
--  --Category---------------------------------

LEFT JOIN (
  SELECT 
    m2c.ltb_id,
    GROUP_CONCAT(DISTINCT m2c.cat_id   
      SEPARATOR ',')   AS list,
    GROUP_CONCAT(DISTINCT cat.cat_slug 
      SEPARATOR ',')   AS slugs,
    GROUP_CONCAT(DISTINCT cat.cat_name 
      SEPARATOR ', ')  AS names
  FROM lt_m2cat AS m2c 
  INNER JOIN tbl_category AS cat 
    ON m2c.cat_id=cat.cat_id
  GROUP BY m2c.cat_id
) AS category 
  ON merchant.ltb_id=category.ltb_id
	
--  --Store Hours------------------------------

LEFT JOIN (
  SELECT t.ltm_id,
    GROUP_CONCAT( 
      IF (@dn>=t.lth_start_day_num
      AND @dn<=t.lth_end_day_num, CASE 
        WHEN ((@o:=t.lth_open)=(@c:=t.lth_close))
        THEN 'Closed today.'
        WHEN (@o<@time AND @c>@time) 
        THEN CONCAT('Open until ',TIME_FORMAT(@c,@tf),'.')   
        ELSE 'Currently closed.' END, NULL
      ) 
    ) AS status,
    GROUP_CONCAT(
      CONCAT_WS(' ', 
        IF(t.lth_open=t.lth_close, 'Closed',
          CONCAT_WS(' - ',
            TIME_FORMAT(t.lth_open, @tf),
            TIME_FORMAT(t.lth_close,@tf))
        ),
        CONCAT_WS(' - ',
          IF(LENGTH(@s:=t.lth_start_day_num), CASE 
            WHEN @s=1 THEN @d1   
            WHEN @s=2 THEN @d2 
            WHEN @s=3 THEN @d3 
            WHEN @s=4 THEN @d4 
            WHEN @s=5 THEN @d5  
            WHEN @s=6 THEN @d6 
            WHEN @s=7 THEN @d7 
            ELSE NULL END, NULL
          ),
          IF(LENGTH(@e:=t.lth_end_day_num), CASE 
            WHEN @s=@e THEN NULL 
            WHEN @e=1 THEN @d1 
            WHEN @e=2 THEN @d2 
            WHEN @e=3 THEN @d3 
            WHEN @e=4 THEN @d4 
            WHEN @e=5 THEN @d5 
            WHEN @e=6 THEN @d6 
            WHEN @e=7 THEN @d7 
            ELSE NULL END, NULL
          )
        )
      ) SEPARATOR '\n'
    ) AS hours 
  FROM lt_merchant_hours AS t 
  GROUP BY t.ltm_id
  
) AS store 
  ON merchant.ltm_id=store.ltm_id
  
--  --Product list-----------------------------

LEFT JOIN (
  SELECT 
    p.ltb_id, COUNT(p.ltb_id)            AS count,
    GROUP_CONCAT(p.ltp_id SEPARATOR ',') AS list
  FROM lt_promos AS p 
  WHERE p.ltp_active=1 
  AND ((@now < p.ltp_enddate AND @now > p.ltp_startdate) 
    OR (p.ltp_enddate IS NULL AND p.ltp_startdate IS NULL)
  )
  GROUP BY p.ltb_id
) AS product 
  ON merchant.ltb_id=product.ltb_id
 
--  --Delimiters-------------------------------

"; // end SQL
}