<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: Message.php
 *
 * Message Class
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks; 

class Messages extends Utils
{
	// User object
	public $list, $badge, $unread;
	
	const SQL_MESSAGES = "
		SELECT DISTINCT
			tbl_messages.msg_id id,
			TRIM(tbl_messages.msg_subject) subject,
			TRIM(tbl_messages.msg_msg) msg,
			DATE_FORMAT(tbl_messages.msg_date,'%c/%d/%Y %h:%i %p') date,
			IFNULL(tbl_messages.ltb_id, 1) ltb_id,
			TRIM(lt_merchants.ltm_company_name) sender,
			CAST(IFNULL(tbl_msg_read.msg_id, 0) AS UNSIGNED) status,
			(NOW() - INTERVAL 1 WEEK) cutoff
		FROM tbl_messages 
    	INNER JOIN lt_merchants
    	ON lt_merchants.ltb_id=tbl_messages.ltb_id 
    	INNER JOIN tbl_consumer
    	ON tbl_consumer.ltm_id=lt_merchants.ltm_id
    	LEFT JOIN tbl_msg_read
    	ON tbl_msg_read.msg_id=tbl_messages.msg_id
    	WHERE tbl_consumer.csm_id=:id
    	AND tbl_consumer.csm_add_date < tbl_messages.msg_date
    	ORDER BY tbl_messages.msg_date
    	DESC LIMIT 50";
 
	/*
     *  Build it in the construct
     */
    function  __construct( $id ) {
    	static::processID( $id );
    }

	private function processID( $id )
	{		
		$unread = $badge = 0;	 
		$dbo = static::connect();
		$qry = $dbo->prepare( static::SQL_MESSAGES );
		$qry->bindValue( ':id', $id );
		$qry->execute();
		$usr = $qry->fetchAll( \PDO::FETCH_OBJ );	
			
		if( !empty( $usr ) ) {
			foreach( $usr as $k => $v ) {
				if ( $v->status > 0 ) $usr[$k]->status = 1;
				else $unread++;
				if ( new \DateTime( $v->cutoff ) < new \DateTime( $v->date ) ) $badge++;
				unset( $v->cutoff );
			}
		}
		$this->list = $usr;
		$this->badge = $badge;
		$this->unread = $unread;
	}

	/*
	 * Toggle message read status
	 *
	private function updateMessageStatus( $msg_id, $csm_id )
	{
		// check if msg was read
		$sql = '
		SELECT msg_id 
		FROM tbl_msg_read 
		WHERE msg_id=:msg_id 
		AND csm_id=:csm_id';
		
		$dbo = $this->connect();
		
		$qry = $dbo->prepare( $sql );
		$qry->bindValue( ':msg_id', $msg_id );
		$qry->bindValue( ':csm_id', $csm_id );
		$qry->execute();
		$qry = $qry->fetchAll( \PDO::FETCH_OBJ );
		
		$sql = (empty($qry)) ? # ternary operation
			   'INSERT INTO tbl_msg_read (msg_id,csm_id) 
			    VALUES (:msg_id,:csm_id)' :
			   'DELETE FROM tbl_msg_read 
			    WHERE msg_id=:msg_id 
			    AND csm_id=:csm_id';
		$qry = $dbo->prepare( $sql );
		$qry->bindValue( ':msg_id', $msg_id );
		$qry->bindValue( ':csm_id', $csm_id );
		$qry->execute();
		
		$this->success = true; 
		$this->message = self::MGS_STATUS_CHG;
	} 

	else { 
		# msg_id is not set, so we must be 
		# asking for the list of available messages.
		if(empty($usr[0]->ltm_id)) {
			$ltm[0]->ltb_id = 0;
			$ltm[0]->ltm_company_name = 'Local Thanks!';
		} else {
			$qry = $dbo->prepare('SELECT ltb_id,ltm_company_name FROM lt_merchants WHERE ltm_id=:ltm_id');
			$qry->bindValue(':ltm_id',$usr[0]->ltm_id,PDO::PARAM_INT);
			$qry->execute();
			$ltm = $qry->fetchAll(PDO::FETCH_OBJ);
		}
		
		$qry = $dbo->prepare("
				SELECT msg_id,msg_subject,msg_msg,DATE_FORMAT(msg_date,'%c/%d/%Y %h:%i %p') msg_date,ltb_id 
				FROM tbl_messages 
				WHERE (ltb_id=:ltb_id OR ltb_id=0) 
				AND msg_date>=:csm_join_date 
				ORDER BY msg_id DESC LIMIT 60");
		$qry->bindValue(':ltb_id',$ltm[0]->ltb_id,PDO::PARAM_INT);
		$qry->bindValue(':csm_join_date',$usr[0]->csm_add_date,PDO::PARAM_STR);
		$qry->execute();
		$msg = $qry->fetchAll(PDO::FETCH_OBJ);
		
		if(empty($msg)) {
			$data['message'] = 'No Messages Were Found.';
		}
		else {
			$i = 0;
			$data['success'] = 1;
			$data['message'] = 'Messages Available.';
			foreach( $msg as $k => $v ) {
				$data['list'][$k]['id']      = $v->msg_id;
				$data['list'][$k]['global']  =($v->ltb_id== 0)?true:false;
				$data['list'][$k]['date']    = $v->msg_date;
				$data['list'][$k]['from']    =($data['list'][$k]['global'])?'Local Thanks!':$ltm[0]->ltm_company_name;
				$data['list'][$k]['subject'] = strip_tags( $v->msg_subject );
				$data['list'][$k]['body']    = strip_tags( $v->msg_msg );
	
				# Check if message has been read before
				$qry = $dbo->prepare('SELECT msg_id FROM tbl_msg_read WHERE msg_id=:msg_id AND csm_id=:csm_id');
				$qry->bindValue(':msg_id',$v->msg_id,PDO::PARAM_INT);
				$qry->bindValue(':csm_id',$csm_id,PDO::PARAM_INT);
				$qry->execute();
				$qry = $qry->fetchAll(PDO::FETCH_OBJ);
				if(empty($qry)) $i++;
				$data['list'][$k]['unread']  =(empty($qry))?true:false;
			}
			$data['badge']   = $i;
		}
	}

	# display the data header format
	$data = $utils->data_format($data, $_GET['format']);
	echo $data;
	*/
    
}

# EOF ?>