<?php
// Product Interface
//
//  -------------------------------------------
namespace Localthanks;
interface Product {
	const SQL="
SELECT

--  --Token Vars-------------------------------

    MD5(CONCAT(
      @env:=    :env,
      @uid:=    :uid,
      @ide:=    :ide,

      @pid:=product.ltp_id,
      @mem:=product.ltb_id,
      @id:=CONCAT(@ide,'-','ltp',@pid),
      @now:=NOW(),
      @df:='%c/%d/%Y',
      @tf:='%l:%i %p',
      @pdef:=CONCAT(@env,'/images/promo_defaults/promo_default_'),
      @imgDir:=CONCAT_WS('/',
        @env,'merchant-custom-files', 
        NULLIF(SUBSTR(@mem,1,2),''),
        NULLIF(SUBSTR(@mem,3,2),''),
        NULLIF(SUBSTR(@mem,5,2),''),
        NULLIF(SUBSTR(@mem,7,2),''),
        NULLIF(SUBSTR(@mem,9,2),''),
        NULLIF(SUBSTR(@mem,11,2),''),
        '_files/img'),
      @pfix:=CONCAT(@imgDir,'/p_600x400_')
    ))                               
    AS track,
    
--  --ID---------------------------------------

    @id  AS id,
    @pid AS pid,

--  --Details----------------------------------

    COUNT(product.ltp_id)         AS count,
    product.ltp_active            AS active,
    @type:=product.ltp_promo_type AS type,
    product.ltp_headline          AS title,
    product.ltp_description       AS description,
    
    CONCAT_WS('/',
      @env, member.ltb_slug,
      'deals', product.ltp_slug
    ) 
    AS url,
    
    IF(LENGTH(@img:=product.ltp_image),
      CONCAT(@pfix,@img),
      CONCAT(@pdef,@type,'.jpg')
    )   
    AS image,
    
    DATE_FORMAT(product.ltp_startdate,@df)           
    AS start_date,
    
    DATE_FORMAT(product.ltp_enddate,@df)           
    AS expires,
    
    CONCAT('-',DATEDIFF(product.ltp_enddate,@now)) 
	AS dayexp,
	
	CONCAT_WS('-',@uid,@pid,COUNT(redemption.csm_id))
	AS voucher_id,
	
    @maxGlobal:=product.ltp_max_redemptions_global 
    AS max_global,
    
    @maxUser:=product.ltp_max_redemptions_user   
    AS max_user,
	
--  --Meta-------------------------------------

    tracking.views,
    tracking.shares,
    tracking.impressions,
    tracking.scratched,
    COUNT(redemption.ltp_id) AS cr,
    IF(LENGTH(redemption.ltp_id),1,0) 
    AS used

--  -------------------------------------------
      
FROM lt_promos AS product
	
--  --Member Info------------------------------

INNER JOIN lt_member_merchants AS member 
  ON member.ltb_id=product.ltb_id
  
--  --Redemption-------------------------------

LEFT JOIN lt_promo_redemptions AS redemption
  ON  redemption.csm_id=@uid  
  AND redemption.ltp_id=@pid
  
--  -Tracking----------------------------------

LEFT JOIN (
  SELECT 
    t.ltp_id,
    SUM(t.lpk_views)       AS views,
    SUM(t.lpk_shares)      AS shares,
    SUM(t.lpk_impressions) AS impressions,
    SUM(t.lpk_scratched)   AS scratched
  FROM lt_promo_tracking   AS t 
  GROUP BY t.ltp_id
) AS tracking 
  ON product.ltp_id=tracking.ltp_id
  
--  --Delimiters-------------------------------

"; // end SQL
}