<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: SessionManager.php
 * SessionManager Class
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks;

class SessionManager extends Utils
{
	// User object
	//public $user;

	// Search result object
	public $search;
 
	// Directory params
	public $env, $cdn, $logo;

	// Datetime
	public $date, $time;
	
	// Load time 
	public $response;
	
    /*
     *  Build it in the construct
     */
    function __construct( $ip=null )
    {	
		// Create user object
		//$this->user = new User;
		
		// Create search object
		$this->search = new Search( $ip );

		// Directory params n stuff
		$this->env  = static::environment();
		$this->cdn  = $this->env.self::DIR_CDN;
		$this->logo = $this->env.self::DIR_LOGO;
		$this->date = date( 'Y-m-d h:i:s' );
		$this->time = time();
    }
}

# EOF ?>