<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: Sqoot.php
 *
 * Sqoot API Class
 * @param mode
 * @param limit
 * @param offset
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace Localthanks;

class Sqoot extends Utils
{
	// Data object
	// List item results and map
	public $success, $notify, $count, $results;

    /*
     *  Build it in the construct
     */
    function __construct( $userLocation=false ) {
    	static::sqoot( $userLocation );
    }

	/*
	 * Process sqoot request
	 */
	private function sqoot( $userLocation )
	{
		$slug   = new Category;
		$data   = $list = array();
		$lat    = static::getLat();
		$lng    = static::getLng();
		$limit  = static::getLimit();
		$offset = static::getOffset();
		$term   = static::getTerm();
		
		foreach( $slug->getCurrent() as $k => $v )
			array_push( $list, $v->slug );

		// Build sqoot URI
		$sqoot['api_key']        = static::SQOOT_API_KEY;
		$sqoot['location']       = implode( ',', array($lat, $lng) );
		$sqoot['per_page']       = $limit;
		$sqoot['page']           = (( $offset / $limit ) + 1 );
		$sqoot['category_slugs'] = implode( ',', $list );
		$sqoot['query']          = ($term) ? $term : '';
		$sqoot['radius']         = static::getRadius();
 
		// Since Sqoot is an API, 
		// and other sources are falable..
		// Suppress the error, and 
		// check if it is active.
		//$coupons = @file_get_contents( static::SQOOT_URL_COUPONS.http_build_query( $sqoot ) );
		$deals = @file_get_contents( static::SQOOT_URL_DEALS.http_build_query( $sqoot ) );
	
		if( $deals ) {
			$sqoot = json_decode( $deals );
			
			// Next 2 foreach creates a key to eliminate 
			// duplications of imagery and attempts to 
			// loop them up into a variation array.
			$chk = $var = array();
			foreach( $sqoot->deals as $k => $v ) {
				$k = preg_replace('/[^A-Za-z0-9\-]/', '', "{$v->deal->merchant->postal_code}{$v->deal->provider_name}{$v->deal->title}");
				if( !in_array ( $k, $chk ) ) {
					array_push( $chk, $k );
					$var[$k] = array( static::sqootObject( $v, $data ) );
				}
				else {
					array_push( $var[$k], static::sqootObject( $v, $data ) );
				}
			}
		
			$chk = array();
			foreach( $sqoot->deals as $k => $v ) {
				$k = preg_replace('/[^A-Za-z0-9\-]/', '', "{$v->deal->merchant->postal_code}{$v->deal->provider_name}{$v->deal->title}");
				if( !in_array ( $k, $chk ) ) {
					array_push( $chk, $k );
					array_push( $data, static::sqootObject( $v, $data, $var[$k] ) );
				}
			}
		}
		// results
		$this->success = (empty( $data )) ? false : true;
		$this->notify  = (empty( $data )) ? static::RESULTS_NO : static::RESULTS_YES;
		$this->count   =  count( $data );
		$this->results =  $data;
	} // end function

	
	/*
	 * Function to format Sqoot to match 
	 * Local Thanks(sm). Adds Sqoot 
	 * specifics to return an array.
	 */
	private function sqootObject( $v, $data, $var=array() ) 
	{
		setlocale( LC_MONETARY, 'en_US.UTF-8' );
	
		// Create vicinity object
		$vicinity = '';
		if( !empty( $v->deal->merchant->address ) )
		$vicinity.= $v->deal->merchant->address."\n";
		if( !empty( $v->deal->merchant->locality ) )
		$vicinity.= $v->deal->merchant->locality.' ';
		if( !empty( $v->deal->merchant->region ) )
		$vicinity.= $v->deal->merchant->region.', ';
		if( !empty( $v->deal->merchant->postal_code ) )
		$vicinity.= $v->deal->merchant->postal_code."\n";
		else
		$vicinity.= "\n";
 
		// Create the center map object
		$id  = implode('_', array('sqoot', $v->deal->id));
		$txt = static::sanitize($v->deal->merchant->name);
		$lat = $v->deal->merchant->latitude;
		$lng = $v->deal->merchant->longitude;
		$url = $v->deal->url;
		$thm = $v->deal->image_url.'&geometry='.static::IMG_MAX_WIDTH.'x'.static::IMG_MAX_HEIGHT.'C';
		$img = $v->deal->image_url.'&geometry='.static::IMG_MAX_WIDTH.'x';
	 	$cnt = count($var);
		$map = new MapObject($id,$txt,$lat,$lng,$url,$img,$cnt);
 
		// Create distance object
		$distance = static::distance(static::getLat(),static::getLng(),$lat,$lng).' '.static::distanceUnit();
	
		// Create return array
		$results = array(
		'id' => $id,
		'title' => strtoupper(static::sanitize($v->deal->title)),
		'description' => static::sanitize($v->deal->description),
		'start_date' => static::dateFormat( $v->deal->created_at ),
		'end_date' => static::dateFormat( $v->deal->expires_at ),
      	'sqoot_id' => $v->deal->id,
      	'sqoot_merchant_id' => $v->deal->merchant->id,
		'name' => $txt,
		'vicinity' => $vicinity,
      	//'address' => trim($v->deal->merchant->address),
		'city' => trim($v->deal->merchant->locality),
		//'state' => trim($v->deal->merchant->region),
		'zip' => trim($v->deal->merchant->postal_code),
		'country' => trim($v->deal->merchant->country),
		'country_code' => $v->deal->merchant->country_code,
		'phone_number' => static::phoneFormat($v->deal->merchant->phone_number, static::NOTICE_MERCHANT_SIGNUP),
		//'fine_print' => static::sanitize($v->deal->fine_print),
		'number_sold' => $v->deal->number_sold,
		'price' => money_format('%.2n', $v->deal->price),
		'value' => money_format('%.2n', $v->deal->value),
		'discount_amount' => money_format('%.2n', $v->deal->discount_amount),
		'discount_percentage' => ($v->deal->discount_percentage * 100). '%',
		'commission' => $v->deal->commission,
		'provider' => trim($v->deal->provider_name),
		'category' => $v->deal->category_name,
		'online' => $v->deal->online,
		//'variations' => $var,
		'thumbnail' => $thm,
		'image' => $img,
		'url' => $url,
		'distance' => $distance,
		'geometry' => $map
		);
 
		return (object) array_filter( $results );
	} // end function

}

#EOF ?>