<?php
/** 
 * Copyright 2015 Local Thanks(sm), Inc.
 *
 * File: User.php
 * Localthanks User Class
 * @author Michael W Hayden
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * 
 */
namespace Localthanks;

class User extends Utils
{
	// Object response
	public $success = 0;
	public $notify;
	
	// User id arrays
	public $consumer = false;
	public $merchant = false;

	// Map object
	public $geometry;

	// IP address
	public $ip;
    
	// Client detail
	//public $user_agent;
	
	// Request params
	//public $request_url, $request;

	// Facebook
	//public $facebook;
	
	// Form params
	private $logout, $reset;
	private $first_name, $last_name, $zip;
	private $email, $password, $confirm;
    private $agreement, $lat, $lng;
    private $token, $device_token;
    
    protected $request;
		
    /*
     *  Build it in the construct
     */
	function __construct()
    {
    
    /*
		// Form params
	    $this->logout = $_REQUEST['logout'];
	    $this->reset = $_REQUEST['reset'];
	    $this->email = $_REQUEST['email']; 
 	    $this->first_name = $_REQUEST['first_name'];
        $this->last_name = $_REQUEST['last_name'];
        $this->zip = $_REQUEST['zip'];
        $this->email = $_REQUEST['email'];
        $this->password = $_REQUEST['password'];
        $this->confirm = $_REQUEST['confirm'];
        $this->agreement = $_REQUEST['agreement'];
	    $this->lat = $_REQUEST['lat'];
	    $this->lng = $_REQUEST['lng'];
		$this->token = $_REQUEST['token'];
	    $this->device_token = $_REQUEST['device_token'];
    */
    
		// Run login status check
		static::loginStatus();
    }
	
	/*
	 * Login Status Check 
	 */
    private function loginStatus() 
    {
    	// Get the IP
    	$this->ip = static::getIP();
    	
		// Establish user location 	
    	parent::userLocation( $this->ip );
    	
    	// Add request to the object
    	$this->request = $_REQUEST;
    	
 		// Create the anonymous user map object
 		// Once logged in success, this is updated.
		$this->geometry = new MapObject( 'csm_user' );
		
    	// Logout 
		if( isset( $_REQUEST['logout'] ) ) 
			return static::userLogout();
		// Reset
		if( isset( $_REQUEST['reset'] ) )
			return static::userReset();
		// Sign up
		if( isset( $_REQUEST['email'] ) &&
	    	!filter_var( $_REQUEST['email'], FILTER_VALIDATE_EMAIL ) ) :
			$this->notify = static::USR_EMAIL_INVALID;
 		elseif   ( 
 			isset( $_REQUEST['first_name'] ) &&
            isset( $_REQUEST['last_name'] ) &&
            isset( $_REQUEST['zip'] ) &&
            isset( $_REQUEST['email'] ) &&
            isset( $_REQUEST['password'] ) &&
            isset( $_REQUEST['confirm'] ) &&
            isset( $_REQUEST['agreement'] ) ) :
      		static::userNew();
      	// Login
		elseif   ( 
			isset( $_REQUEST['email'] ) && 
			isset( $_REQUEST['password'] ) ) :
			static::userVerify();
		// Token
		elseif   ( 
			isset( $_REQUEST['token'] ) ) :
			static::userVerify();
		// No user. 
		else :
			$this->notify = ($_REQUEST['agreement']) ? static::USR_SIGNUP: static::USR_NONE;
		endif;
		
		return;
	}

    /*
     * New USER
     *
     * Build user profile by
     * form submitted data. 
     * Sets defaults. 
     */
    const SQL_SELECT_ID_BY_EMAIL  = '
    	SELECT csm_id,csm_first_name,csm_last_name 
    	FROM tbl_consumer 
    	WHERE csm_email=:email';
	const SQL_INSERT_TBL_CONSUMER = 'INSERT INTO tbl_consumer (:field) VALUES (:value)';
	
    private function userNew()
    {
    	// Encrypt and clean up
		$crypt    = new Crypt ( trim( $_REQUEST['email'] ) );
		$_REQUEST = static::sanitize( $_REQUEST );
		
		// Database field array
		$params = array(
			'csm_first_name'  => static::capitilize($_REQUEST['first_name']),
			'csm_last_name'   => static::capitilize($_REQUEST['last_name']),
			'csm_key'         => static::keygen(),
			'csm_cell_number' => $_REQUEST['cell_number'],
			'csm_zip'         => $_REQUEST['zip'],
			'csm_email'       => $_REQUEST['email'],
			'csm_lat'         => $_REQUEST['lat'],
			'csm_long'        => $_REQUEST['lng'],
			'csm_device_token'=> $_REQUEST['device_token'],
			'csm_password'    => $crypt->encode($_REQUEST['password']),
			'csm_add_date'    => date('Y-m-d H:i:s'),
			'csm_last_login'  => date('Y-m-d H:i:s'),
			'ltm_id'          => 1,
			'ltm_pick_id'     => 1
		);
		$params = array_filter( $params );
		
		// database object check
		$dbo = static::connect();
		$qry = $dbo->prepare( static::SQL_SELECT_ID_BY_EMAIL );
		$qry->bindValue( ':email', $params['csm_email'], \PDO::PARAM_STR );
		$qry->execute();
		$usr = $qry->fetchAll( \PDO::FETCH_OBJ );
	
		// Check Credentials 
		if( !empty( $usr ) ) {
			$this->notify = static::USR_EMAIL_IN_USE;
		}
		else {
			$sql = static::SQL_INSERT_TBL_CONSUMER;
			$sql = str_replace(':field', implode(',',array_keys( $params )), $sql);
			$sql = str_replace(':value', ':'.implode(',:',array_keys( $params )), $sql);

			// run insert query
			$qry = $dbo->prepare( $sql );
			foreach( $params as $k => $v )
			$qry->bindValue( ":$k",  $v );
			$qry->execute();
 
 			// Todo:: send welcome email here?

			// send response
			$id = $dbo->lastInsertId();
			static::userVerify( $id  );
		}
    }

    /*
     * Verify USER
     * 
     * @class User selectUserByID
     * @class Crypt encode, decode
     */
    private function userVerify( $csm_id=null ) 
    {
    	// Lets check token, then email, then csm_id
    	if( is_numeric($csm_id) )
    		$id = $csm_id;
    	else
    		$id = ($_REQUEST['token']) ? $_REQUEST['token'] : $_REQUEST['email'];
    	
    	// Check encryption salt
    	$crypt = new Crypt( trim( $_REQUEST['email'] ) );
		
		// facebook $_REQUEST id
		//$fb = false;
		//foreach($_COOKIE as $k => $v)
		//	if(substr($k, 0, 5) == 'fbsr_') $fb = $k;
		
		
		//echo var_dump( static::selectUserByID( $id ) );
		
		// database search
		$dbo = static::connect();
		$qry = $dbo->prepare( static::selectUserByID( $id ) );
		$qry->bindValue( ':id',     $id );
		$qry->execute();
		$usr = $qry->fetchAll( \PDO::FETCH_OBJ );
		
		
		
		if ( empty( $usr ) ) :
    		$this->notify = static::USR_NOT_FOUND;
    	// Todo:: add token security
    	//elseif ( $_REQUEST['token'] == $usr[0]->csm_key ) :
    		//static::userSuccess( $usr );
 		elseif ( $_REQUEST['password'] != $crypt->decode( $usr[0]->csm_password ) && $csm_id == null ) :
    		$this->notify = static::USR_PASS_ERROR;
 		elseif ( $usr[0]->csm_active == 0 ) :
    		$this->notify = static::USR_INACTIVE;
    	// Todo:: add facebook user 
    	//elseif ( $fb ) :
    		//$this->FBUser( $email, $usr );
		else : 
			static::userSuccess( $usr, $csm_id );
		endif;
    }
    


    /*
     * USER succesfully logged in
     */
    private function userSuccess( $usr, $csm_id=null )
    {
    	$this->success   = 1;
		$this->notify    = ($_REQUEST['agreement']) ? static::USR_SIGNUP_WELCOME: static::USR_LOGIN;
    	$this->messages  = new Messages(  $usr[0]->csm_id );
    	$this->favorites = new Favorites( $usr[0]->csm_id );

    	// Phone Format
		if( $usr[0]->phone_number )
			$usr[0]->phone_number  = static::phoneFormat( $usr[0]->phone_number );
		// search and replace merchant directory
		if( $usr[0]->ltb_thumbnail )
			$usr[0]->ltb_thumbnail = static::dynamicImgDir($usr[0]->ltb_thumbnail);
		if( $usr[0]->ltb_image )
			$usr[0]->ltb_image     = static::dynamicImgDir($usr[0]->ltb_image);
		if( $usr[0]->thumbnail )
			$usr[0]->thumbnail     = static::dynamicImgDir($usr[0]->thumbnail);
		if( $usr[0]->image )
			$usr[0]->image         = static::dynamicImgDir($usr[0]->image);

		// MMdeals
		if( $usr[0]->ltb_id ) {
		 	// database search
		 	//echo var_dump(static::selectMemberMerchantPromotionsByCSMID());
		 	
		 	$sql = static::bounds(self::getLat(),self::getLng(),self::getRadius(),static::selectMemberMerchantPromotionsByCSMID());
		 	//echo var_dump($sql);
			$dbo = static::connect();
			$qry = $dbo->prepare( $sql );
			$qry->bindValue( ':csm_id', $usr[0]->csm_id );
			$qry->bindValue( ':sinlat', $usr[0]->geometry->location->lat );
		    $qry->bindValue( ':coslat', $usr[0]->geometry->location->lat );
		    $qry->bindValue( ':coslng', $usr[0]->geometry->location->lng );
			$qry->execute();
			$usr[0]->ltb_id = $qry->fetchAll( \PDO::FETCH_OBJ );
			foreach($usr[0]->ltb_id as $key => $val) {
				if( $val->ltb_thumbnail )
					$usr[0]->ltb_id[$key]->ltb_thumbnail = static::dynamicImgDir($val->ltb_thumbnail);
				if( $val->ltb_image )
					$usr[0]->ltb_id[$key]->ltb_image     = static::dynamicImgDir($val->ltb_image);
				if( $val->thumbnail )
					$usr[0]->ltb_id[$key]->thumbnail     = static::dynamicImgDir($val->thumbnail);
				if( $val->image )
					$usr[0]->ltb_id[$key]->image         = static::dynamicImgDir($val->image);
			}
		}


        //$usr[0]->ltb_id = array('success' => true, 'ltb_id' => $usr[0]->ltb_id );
        
        
		// Create the center map object
		$id  = $usr[0]->id;
		$txt = "Hello {$usr[0]->csm_first_name}!";
		$lat = $usr[0]->csm_lat;
		$lng = $usr[0]->csm_long;
		$lnk = '#';
		$img = $usr[0]->ltb_thumbnail;
		$this->geometry = new MapObject($id,$txt,$lat,$lng,$lnk,$img);
 	 	
 	 	
 	 	// unset
    	// ? check my store admin
    	$this->merchant = static::userMerchant( $usr ); 
    	
		// Uncomment to block, 
		// comment to send to response.
		unset(
    		//$usr[0]->csm_id,
    		//$usr[0]->csm_key,
    		$usr[0]->csm_lat,
    		$usr[0]->csm_long,
    		//$usr[0]->csm_zip,
    		$usr[0]->csm_password,
    		$usr[0]->csm_active,
    		//$usr[0]->csm_first_name,
    		//$usr[0]->csm_last_name,
    		$usr[0]->csm_email,
			$usr[0]->csm_add_date,
			//$usr[0]->ltm_id,
			//$usr[0]->place_id,
			//$usr[0]->name,
			$usr[0]->ltm_lat,
			$usr[0]->ltm_long,
			$usr[0]->address,
			$usr[0]->city,
			$usr[0]->state,
			$usr[0]->zip,
			//$usr[0]->phone_number,
			//$usr[0]->ltm_url,
			$usr[0]->ltm_registerdate,
			//$usr[0]->ltb_id,
			$usr[0]->ltb_description
			//$usr[0]->ltb_thumbnail,
			//$usr[0]->ltb_image
		);
		
		// add to consumer array
		$this->consumer = $usr[0];
		static::updateUser();
    }


    /*
     * Update USER 
     */
    const SQL_UPDATE_TBL_CONSUMER = '
    	UPDATE tbl_consumer 
    	SET :values WHERE csm_id=:id';
    	
    private function updateUser() 
    {
		$params = array(
			'csm_device_token' => $_REQUEST['device_token'],
			'csm_lat'          => $_REQUEST['lat'],
			'csm_long'         => $_REQUEST['lng'],
			'csm_last_login'   => date('Y-m-d H:i:s')
		);
		$params = array_filter( $params );		
		
		$sql = '';
		foreach ( $params as $k => $v )
		$sql.= implode('=',array( $k, ":$k," ));
		$sql = str_replace(':values', rtrim( $sql,',' ),static::SQL_UPDATE_TBL_CONSUMER);
 	
		$dbo = static::connect();
		$qry = $dbo->prepare( $sql );
		foreach ( $params as $k => $v )
		$qry->bindValue(":$k", $v);
		$qry->bindValue(':id', $this->consumer->csm_id);
		$qry->execute();
		
		
		/*
		$params[':email'] = $email;
		$sql = static::SQL_SELECT_ID_BY_EMAIL;
		$usr = static::preBindFetchObj( $sql, $params );
		
		*/
		
		return $usr;
	}

    /*
     * Logout USER
     */
    private function userLogout() {
		// unset facebook $_REQUEST cookie...if you can
		foreach($_COOKIE as $k => $v) {
			if( substr($k, 0, 5) == 'fbsr_') {
				setcookie($k,'',-1);
				unset( $_REQUEST[$k] );
			}
		}
    	$this->notify = static::USR_LOGOUT;
    }
 
    /*
     * Reset User Password
     *
     * @param reset
     * Checks if reset is an email, 
     * or a token sent to user email.
     */
    const SQL_INSERT_RESET_CODE = '
    	INSERT INTO lt_member_login_reset (llr_uid,csm_id,llr_email,llr_timestamp) 
    	VALUES (:llr_uid,:csm_id,:llr_email,:llr_timestamp)';
    const SQL_DELETE_RESET_CODE = '
    	DELETE FROM lt_member_login_reset 
    	WHERE llr_email=:llr_email';
    const SQL_SELECT_RESET_CODE = '
        SELECT *
    	FROM lt_member_login_reset
    	WHERE llr_uid=:code';
    const SQL_UPDATE_PASSWORD = '
    	UPDATE tbl_consumer
		SET csm_password=:pass,
		WHERE csm_email=:email';
    	
    private function userReset() { 
    	if( isset( $_REQUEST['reset'] ) )
    		if   ( filter_var( $_REQUEST['reset'], FILTER_VALIDATE_EMAIL ) ) 
				static::userResetEmail( $_REQUEST['reset'] );
			else
				static::userResetToken( $_REQUEST['reset'], $_REQUEST['code'] );
    	else
    		$this->notify = static::USR_RESET;
    }
  
    /*
     * Handle reset token
     *
     * Token is decoded to derive Access Code
     * From email. If reset_code is set, and 
     * is a match, proceed with password
     * changes.
     */    	
	private function userResetToken( $token, $code=null )
	{
		if(!$code) {
			$reset = explode(static::URI_SEPARATOR, $token);
			$crypt = new Crypt( $reset[0] );
			$code  = $crypt->decode( $reset[1] );
		}
    	
		$dbo = static::connect();
		$qry = $dbo->prepare( static::SQL_SELECT_RESET_CODE );
		$qry->bindValue( ':code', $code );
		$qry->execute();
		$usr = $qry->fetchAll( \PDO::FETCH_OBJ );
		
		if( empty( $usr ) ) :
			$this->notify = static::USR_NOT_FOUND;
		elseif ( 
			isset( $_REQUEST['password'] ) &&
			isset( $_REQUEST['confirm'] ) ) :
			if   ( $_REQUEST['password'] != $_REQUEST['confirm'] ) {
				$this->notify  = static::USR_PASS_ERROR;
			}
			else {
				$crypt = new Crypt( $usr[0]->llr_email );
				$qry = $dbo->prepare( static::SQL_UPDATE_PASSWORD );
				$qry->bindValue( ':pass', $crypt->encode( $_REQUEST['password'] ) );
				$qry->bindValue( ':email', $usr[0]->llr_email );
				$qry->execute();
				// Delete old values from reset table
				$qry = $dbo->prepare( static::SQL_DELETE_RESET_CODE );
				$qry->bindValue( ':llr_email', $usr[0]->llr_email );
				$qry->execute();
				
				$this->success = 1;
				$this->notify = self::USR_RESET_COMPLETE;
			}
		else :
			$this->success = 1;
			$this->notify  = static::USR_RESET_VERIFIED;
		endif;
	}
	
    /*
     * Check if email being reset exists
     */
	private function userResetEmail( $email )
	{
		$dbo = static::connect();
		$qry = $dbo->prepare( static::SQL_SELECT_ID_BY_EMAIL );
		$qry->bindValue( ':email', $email );
		$qry->execute();
		$usr = $qry->fetchAll( \PDO::FETCH_OBJ );
		
		if( empty( $usr ) ) :
			$this->notify = self::USR_NOT_FOUND;
		else :
			// Create code key
			$code  = static::codegen(5);
			$crypt = new Crypt( $email );
			$token = $crypt->encode( $code );
			$reset = array('reset' => implode(static::URI_SEPARATOR, array($email, $token)));
 
			// test
			$reset = static::environment().'/cdn/tmpl/default/reset.html?'.http_build_query($reset);
			
			// Build mail
			$to      = $email;
			$subject = 'Account Reset '.static::PROJECT_NAME;
			$message = "<html><head><title>$subject</title></head><body><p>Dear {$usr[0]->csm_first_name} {$usr[0]->csm_last_name},</p><p>Please enter the code or click the following link to reset your password.</p><p>Code:<br /><a href='$reset' style='font:700 18px arial;text-decoration:none;margin:0'><h1>$code</h1></a></p><br /><p>Sincerely,<p><p><b>~ ".static::PROJECT_NAME." Dev Team</b></p></body></html>";
			$headers = static::emailHeaders();
			
			// Send email and save reset info
			if( mail($to, $subject, $message, $headers) ) {
				$this->success = 1;
				$this->notify  = self::USR_RESET_SENT;
				$qry = $dbo->prepare( static::SQL_INSERT_RESET_CODE );
				$qry->bindValue( ':llr_uid',       $code );
				$qry->bindValue( ':csm_id',        $usr[0]->csm_id );
				$qry->bindValue( ':llr_email',     $email );
				$qry->bindValue( ':llr_timestamp', date('Y-m-d H:i:s') );
				$qry->execute();
			}
			else {
				$this->notify = self::USR_RESET_ERROR_MAIL;
			}
		endif;
	}

	
    /*
     * Reset Password Table cleanup 
     *
     * MySQL Event ON
	 * SET GLOBAL event_scheduler = ON;
	 * SET @@global.event_scheduler = ON;
	 * SET GLOBAL event_scheduler = 1;
	 * SET @@global.event_scheduler = 1;
	 *
	 * MySQL Event OFF
	 * SET GLOBAL event_scheduler = OFF;
	 * SET @@global.event_scheduler = OFF;
	 * SET GLOBAL event_scheduler = 0;
	 * SET @@global.event_scheduler = 0;
	 */
    const  SQL_EVENT_CLEAN_RESET_TABLE = '
		CREATE EVENT cleanResetTable
    	ON 
    		SCHEDULE AT CURRENT_TIMESTAMP + INTERVAL 1 HOUR
    	DO
    		DELETE FROM lt_member_login_reset 
    		WHERE llr_timestamp < NOW() - INTERVAL 7 DAY';
 
	/*
	 * MyStore user merchant array
	 */
	const SQL_MYSTORE_MERCHANT = '
		SELECT 
			lt_member_merchants.ltb_id,
			lt_member_merchants.res_id,
			lt_member_merchants.lmp_id,
			lt_member_merchants.pty_id,
			lt_member_merchants.tmp_id,
			lt_merchants.ltm_id,
			TRIM(lt_merchants.ltm_company_name) ltm_company_name,
			TRIM(tbl_reseller.res_name) res_name,
			lt_merchant_plans.lmp_id,
			TRIM(lt_merchant_plans.lmp_name) lmp_name,
			COUNT(lt_promos.ltb_id) promo_count 
		FROM lt_member_merchants
		INNER JOIN lt_merchants
			ON lt_merchants.ltb_id=lt_member_merchants.ltb_id
		INNER JOIN tbl_reseller
			ON tbl_reseller.res_id=lt_member_merchants.res_id
		INNER JOIN lt_promos
			ON lt_promos.ltb_id=lt_member_merchants.ltb_id
		INNER JOIN lt_merchant_plans
			ON lt_merchant_plans.lmp_id=lt_member_merchants.lmp_id
		WHERE lt_member_merchants.ltb_email=:email';
		
	private function userMerchant( $usr )
	{
		$dbo = $this->connect();
		$qry = $dbo->prepare( static::SQL_MYSTORE_MERCHANT );
		$qry->bindValue( ':email', $usr[0]->csm_email, \PDO::PARAM_STR );
		$qry->execute();
		$usr = $qry->fetchAll( \PDO::FETCH_OBJ );
		
		return ( $usr[0]->ltb_id ) ? $usr[0] : false;
	}

	/*
	 * SQL Consumer by Identifier
	 *
	 * @fields :lt_merchants, :lt_member_merchants, :tbl_consumer
	 * @request :csm_field
	 */
	const SQL_SELECT_USER ='
    	SELECT 
    		:tbl_consumer,
    		lt_member_merchants.ltb_id ltb_id
    	FROM tbl_consumer
    	INNER JOIN lt_merchants 
    		ON lt_merchants.ltm_id=tbl_consumer.ltm_id 
    	INNER JOIN lt_member_merchants 
    		ON lt_member_merchants.ltb_id=lt_merchants.ltb_id
    	WHERE tbl_consumer.:csm_field=:id';
    	
	private function selectUserByID( $csm_id=null ) {
    	if( is_numeric( $csm_id ) )
    		$field = 'csm_id';
    	else
    		$field =  ($_REQUEST['token']) ? 'csm_key': 'csm_email';
		return static::replaceSQL( str_replace(':csm_field', $field, static::SQL_SELECT_USER) );
	}
	
 
 
 
  
  
  
  
	/*
	 * Facebook User
	 * add / update / signup with facebook credentials.
	 */
	private function FBUser( $email, $usr )
	{ 
	    /*
    	$sql = "
    	SELECT 
    		tbl_consumer.csm_id,
    		tbl_consumer.csm_email,
    		/tbl_facebook.fb_email,
    		tbl_facebook.csm_id cid
    	FROM tbl_consumer
    	LEFT JOIN tbl_facebook 
    		ON tbl_facebook.csm_id=tbl_consumer.csm_id
    	WHERE tbl_consumer.csm_email=:email";
    	*/
    	$sql = "
    	SELECT 
    		tbl_consumer.csm_id,
    		tbl_consumer.csm_email
    	FROM tbl_consumer
    	LEFT JOIN tbl_facebook 
    		ON tbl_facebook.csm_id=tbl_consumer.csm_id
    	WHERE tbl_consumer.csm_email=:email";
    	
		$dbo = $this->connect();
		$qry = $dbo->prepare( $sql );
		$qry->bindValue( ':email', $email );
		$qry->execute();
		$usr = $qry->fetchAll( \PDO::FETCH_OBJ );
		/*
		if ( empty( $usr ) ) :
			$this->FBuser( $usr, $email );
		elseif( is_null( $usr[0]->cid ) ) :
			$bool = ( is_null( $usr[0]->fb_email ) ) ? false : true;
			$this->FBuser( $usr, $email, $bool );
		else :
			$this->userVerify( $email, true );
		endif;
		*/
		
	/*
		$sql = ( !empty( $usr ) ) ? "
		UPDATE tbl_facebook 
		SET fb_email=:email,fb_first_name=:first_name,fb_last_name=:last_name,fb_full_name=:full_name,fb_gender=:gender,fb_user_id=:id,fb_page_link=:link,fb_local=:locale,fb_timezone=:timezone,fb_updated_time=:updated_time,fb_verified=:verified,fb_timestamp=NOW()
		WHERE csm_id=:csm_id
		" : "
		INSERT INTO tbl_facebook 
		(csm_id,fb_email,fb_first_name,fb_last_name,fb_full_name,fb_gender,fb_user_id,fb_page_link,fb_local,fb_timezone,fb_updated_time,fb_verified,fb_timestamp)
		VALUES
		(:csm_id,:email,:first_name,:last_name,:full_name,:gender,:id,:link,:locale,:timezone,:updated_time,:verified,NOW())";
	*/
	
	/*
		$dbo = $this->connect();
		$qry = $dbo->prepare( $sql );
		$qry->bindValue( ':csm_id', $csm_id );
		$qry->bindValue( ':email', $email );
		$qry->bindValue( ':first_name', $_REQUEST['first_name'] );
		$qry->bindValue( ':last_name', $_REQUEST['last_name'] );
		$qry->bindValue( ':full_name', $_REQUEST['full_name'] );
		$qry->bindValue( ':gender', $_REQUEST['gender'] );
		$qry->bindValue( ':id', $_REQUEST['id'] );
		$qry->bindValue( ':link', $_REQUEST['link'] );
		$qry->bindValue( ':locale', $_REQUEST['locale'] );
		$qry->bindValue( ':timezone', $_REQUEST['timezone'] );
		$qry->bindValue( ':updated_time', $_REQUEST['updated_time'] );
		$qry->bindValue( ':verified', $_REQUEST['verified'] );
		$qry->execute();
	*/

		//$this->userVerify( $email, true );
	}
} // end class

# EOF ?>